/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.gradients;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ContourGradientPaint
implements Paint {
    private static final float INT_TO_FLOAT_CONST = 0.003921569f;
    private final Rectangle2D BOUNDS;
    private final Float[] FRACTIONS;
    private final Color[] COLORS;
    private final List<Color> COLOR_LOOKUP = new ArrayList<Color>(256);

    public ContourGradientPaint(Rectangle2D GIVEN_BOUNDS, float[] GIVEN_FRACTIONS, Color[] GIVEN_COLORS) throws IllegalArgumentException {
        this.BOUNDS = GIVEN_BOUNDS;
        if (GIVEN_FRACTIONS.length != GIVEN_COLORS.length) {
            throw new IllegalArgumentException("Fractions and colors must be equal in size");
        }
        ArrayList<Float> FRACTION_LIST = new ArrayList<Float>(GIVEN_FRACTIONS.length);
        for (float fraction : GIVEN_FRACTIONS) {
            FRACTION_LIST.add(Float.valueOf(fraction));
        }
        ArrayList<Color> COLOR_LIST = new ArrayList<Color>(GIVEN_COLORS.length);
        COLOR_LIST.addAll(Arrays.asList(GIVEN_COLORS));
        if (((Float)FRACTION_LIST.get(0)).floatValue() != 0.0f) {
            FRACTION_LIST.add(0, Float.valueOf(0.0f));
            Color TMP_COLOR = (Color)COLOR_LIST.get(0);
            COLOR_LIST.add(0, TMP_COLOR);
        }
        if (((Float)FRACTION_LIST.get(FRACTION_LIST.size() - 1)).floatValue() != 1.0f) {
            FRACTION_LIST.add(Float.valueOf(1.0f));
            COLOR_LIST.add(GIVEN_COLORS[0]);
        }
        this.COLORS = new Color[COLOR_LIST.size()];
        this.FRACTIONS = new Float[FRACTION_LIST.size()];
        COLOR_LIST.toArray(this.COLORS);
        FRACTION_LIST.toArray(this.FRACTIONS);
        this.COLOR_LOOKUP.clear();
        this.COLOR_LOOKUP.addAll(this.prepareColorLookup());
    }

    private Color getColorFromFraction(Color SOURCE_COLOR, Color DESTINATION_COLOR, int RANGE, int CURRENT_FRACTION) {
        float SOURCE_RED = (float)SOURCE_COLOR.getRed() * 0.003921569f;
        float SOURCE_GREEN = (float)SOURCE_COLOR.getGreen() * 0.003921569f;
        float SOURCE_BLUE = (float)SOURCE_COLOR.getBlue() * 0.003921569f;
        float SOURCE_ALPHA = (float)SOURCE_COLOR.getAlpha() * 0.003921569f;
        float DESTINATION_RED = (float)DESTINATION_COLOR.getRed() * 0.003921569f;
        float DESTINATION_GREEN = (float)DESTINATION_COLOR.getGreen() * 0.003921569f;
        float DESTINATION_BLUE = (float)DESTINATION_COLOR.getBlue() * 0.003921569f;
        float DESTINATION_ALPHA = (float)DESTINATION_COLOR.getAlpha() * 0.003921569f;
        float RED_DELTA = DESTINATION_RED - SOURCE_RED;
        float GREEN_DELTA = DESTINATION_GREEN - SOURCE_GREEN;
        float BLUE_DELTA = DESTINATION_BLUE - SOURCE_BLUE;
        float ALPHA_DELTA = DESTINATION_ALPHA - SOURCE_ALPHA;
        float RED_FRACTION = RED_DELTA / (float)RANGE;
        float GREEN_FRACTION = GREEN_DELTA / (float)RANGE;
        float BLUE_FRACTION = BLUE_DELTA / (float)RANGE;
        float ALPHA_FRACTION = ALPHA_DELTA / (float)RANGE;
        return new Color(SOURCE_RED + RED_FRACTION * (float)CURRENT_FRACTION, SOURCE_GREEN + GREEN_FRACTION * (float)CURRENT_FRACTION, SOURCE_BLUE + BLUE_FRACTION * (float)CURRENT_FRACTION, SOURCE_ALPHA + ALPHA_FRACTION * (float)CURRENT_FRACTION);
    }

    private List<Color> prepareColorLookup() {
        int SIZE = this.BOUNDS.getWidth() <= this.BOUNDS.getHeight() ? (int)(this.BOUNDS.getWidth() / 2.0) : (int)(this.BOUNDS.getHeight() / 2.0);
        ArrayList<Color> TMP_COLOR_LOOKUP = new ArrayList<Color>(SIZE);
        for (int colorIndex = 0; colorIndex < this.COLORS.length - 1; ++colorIndex) {
            int relativeValue = 0;
            for (int value = (int)(this.FRACTIONS[colorIndex].floatValue() * (float)SIZE); value < (int)(this.FRACTIONS[colorIndex + 1].floatValue() * (float)SIZE); ++value) {
                TMP_COLOR_LOOKUP.add(this.getColorFromFraction(this.COLORS[colorIndex], this.COLORS[colorIndex + 1], (int)((this.FRACTIONS[colorIndex + 1].floatValue() - this.FRACTIONS[colorIndex].floatValue()) * (float)SIZE), relativeValue));
                ++relativeValue;
            }
        }
        return TMP_COLOR_LOOKUP;
    }

    @Override
    public PaintContext createContext(ColorModel COLOR_MODEL, Rectangle DEVICE_BOUNDS, Rectangle2D USER_BOUNDS, AffineTransform TRANSFORM, RenderingHints HINTS) {
        return new DiamondGradientPaintContext();
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    public String toString() {
        return "ContourGradientPaint";
    }

    private final class DiamondGradientPaintContext
    implements PaintContext {
        private final Point2D P1;
        private final Point2D P2;
        final GeneralPath SECTOR_A = new GeneralPath();
        final GeneralPath SECTOR_B = new GeneralPath();
        final GeneralPath SECTOR_C = new GeneralPath();
        final GeneralPath SECTOR_D = new GeneralPath();

        public DiamondGradientPaintContext() {
            if (ContourGradientPaint.this.BOUNDS.getWidth() > ContourGradientPaint.this.BOUNDS.getHeight()) {
                this.P1 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getX() + ContourGradientPaint.this.BOUNDS.getHeight() / 2.0, ContourGradientPaint.this.BOUNDS.getY() + ContourGradientPaint.this.BOUNDS.getHeight() / 2.0);
                this.P2 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getMaxX() - ContourGradientPaint.this.BOUNDS.getHeight() / 2.0, ContourGradientPaint.this.BOUNDS.getMinY() + ContourGradientPaint.this.BOUNDS.getHeight() / 2.0);
            } else if (ContourGradientPaint.this.BOUNDS.getWidth() < ContourGradientPaint.this.BOUNDS.getHeight()) {
                this.P1 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getX() + ContourGradientPaint.this.BOUNDS.getWidth() / 2.0, ContourGradientPaint.this.BOUNDS.getY() + ContourGradientPaint.this.BOUNDS.getWidth() / 2.0);
                this.P2 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getX() + ContourGradientPaint.this.BOUNDS.getWidth() / 2.0, ContourGradientPaint.this.BOUNDS.getMaxY() - ContourGradientPaint.this.BOUNDS.getWidth() / 2.0);
            } else {
                this.P2 = this.P1 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getX() + ContourGradientPaint.this.BOUNDS.getWidth() / 2.0, ContourGradientPaint.this.BOUNDS.getY() + ContourGradientPaint.this.BOUNDS.getHeight() / 2.0);
            }
            this.SECTOR_A.moveTo(ContourGradientPaint.this.BOUNDS.getMinX(), ContourGradientPaint.this.BOUNDS.getMaxY());
            this.SECTOR_A.lineTo(this.P1.getX(), this.P2.getY());
            this.SECTOR_A.lineTo(this.P1.getX(), this.P1.getY());
            this.SECTOR_A.lineTo(ContourGradientPaint.this.BOUNDS.getMinX(), ContourGradientPaint.this.BOUNDS.getMinY());
            this.SECTOR_A.closePath();
            this.SECTOR_B.moveTo(ContourGradientPaint.this.BOUNDS.getMinX(), ContourGradientPaint.this.BOUNDS.getMinY());
            this.SECTOR_B.lineTo(this.P1.getX(), this.P1.getY());
            this.SECTOR_B.lineTo(this.P2.getX(), this.P1.getY());
            this.SECTOR_B.lineTo(ContourGradientPaint.this.BOUNDS.getMaxX(), ContourGradientPaint.this.BOUNDS.getMinY());
            this.SECTOR_B.closePath();
            this.SECTOR_C.moveTo(ContourGradientPaint.this.BOUNDS.getMaxX(), ContourGradientPaint.this.BOUNDS.getMinY());
            this.SECTOR_C.lineTo(this.P2.getX(), this.P1.getY());
            this.SECTOR_C.lineTo(this.P2.getX(), this.P2.getY());
            this.SECTOR_C.lineTo(ContourGradientPaint.this.BOUNDS.getMaxX(), ContourGradientPaint.this.BOUNDS.getMaxY());
            this.SECTOR_C.closePath();
            this.SECTOR_D.moveTo(ContourGradientPaint.this.BOUNDS.getMaxX(), ContourGradientPaint.this.BOUNDS.getMaxY());
            this.SECTOR_D.lineTo(this.P2.getX(), this.P2.getY());
            this.SECTOR_D.lineTo(this.P1.getX(), this.P2.getY());
            this.SECTOR_D.lineTo(ContourGradientPaint.this.BOUNDS.getMinX(), ContourGradientPaint.this.BOUNDS.getMaxY());
            this.SECTOR_D.closePath();
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int X, int Y, int TILE_WIDTH, int TILE_HEIGHT) {
            Point P = new Point(0, 0);
            WritableRaster RASTER = this.getColorModel().createCompatibleWritableRaster(TILE_WIDTH, TILE_HEIGHT);
            int[] data = new int[TILE_WIDTH * TILE_HEIGHT * 4];
            Color currentColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
            int currentRed = 0;
            int currentGreen = 0;
            int currentBlue = 0;
            int currentAlpha = 0;
            for (int tileY = 0; tileY < TILE_HEIGHT; ++tileY) {
                for (int tileX = 0; tileX < TILE_WIDTH; ++tileX) {
                    P.setLocation(X + tileX, Y + tileY);
                    if (this.SECTOR_A.contains(P) && X + tileX - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().x < ContourGradientPaint.this.COLOR_LOOKUP.size()) {
                        currentColor = (Color)ContourGradientPaint.this.COLOR_LOOKUP.get(X + tileX - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().x);
                    }
                    if (this.SECTOR_B.contains(P) && Y + tileY - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().y < ContourGradientPaint.this.COLOR_LOOKUP.size()) {
                        currentColor = (Color)ContourGradientPaint.this.COLOR_LOOKUP.get(Y + tileY - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().y);
                    }
                    if (this.SECTOR_C.contains(P) && ContourGradientPaint.this.COLOR_LOOKUP.size() - (X + tileX - this.SECTOR_A.getBounds().width - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().x - ((int)this.P2.getX() - (int)this.P1.getX())) < ContourGradientPaint.this.COLOR_LOOKUP.size()) {
                        currentColor = (Color)ContourGradientPaint.this.COLOR_LOOKUP.get(ContourGradientPaint.this.COLOR_LOOKUP.size() - (X + tileX - this.SECTOR_A.getBounds().width - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().x - ((int)this.P2.getX() - (int)this.P1.getX())));
                    }
                    if (this.SECTOR_D.contains(P) && ContourGradientPaint.this.COLOR_LOOKUP.size() - (Y + tileY - this.SECTOR_B.getBounds().height - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().y - ((int)this.P2.getY() - (int)this.P1.getY())) < ContourGradientPaint.this.COLOR_LOOKUP.size()) {
                        currentColor = (Color)ContourGradientPaint.this.COLOR_LOOKUP.get(ContourGradientPaint.this.COLOR_LOOKUP.size() - (Y + tileY - this.SECTOR_B.getBounds().height - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().y - ((int)this.P2.getY() - (int)this.P1.getY())));
                    }
                    currentRed = currentColor.getRed();
                    currentGreen = currentColor.getGreen();
                    currentBlue = currentColor.getBlue();
                    currentAlpha = currentColor.getAlpha();
                    int BASE = (tileY * TILE_WIDTH + tileX) * 4;
                    data[BASE + 0] = currentRed;
                    data[BASE + 1] = currentGreen;
                    data[BASE + 2] = currentBlue;
                    data[BASE + 3] = currentAlpha;
                }
            }
            RASTER.setPixels(0, 0, TILE_WIDTH, TILE_HEIGHT, data);
            return RASTER;
        }
    }
}

