/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.gradients;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public final class ConicalGradientPaint
implements Paint {
    private final Point2D CENTER;
    private final double[] FRACTION_ANGLES;
    private final double[] RED_STEP_LOOKUP;
    private final double[] GREEN_STEP_LOOKUP;
    private final double[] BLUE_STEP_LOOKUP;
    private final double[] ALPHA_STEP_LOOKUP;
    private final Color[] COLORS;
    private static final float INT_TO_FLOAT_CONST = 0.003921569f;

    public ConicalGradientPaint(Point2D CENTER, float[] GIVEN_FRACTIONS, Color[] GIVEN_COLORS) throws IllegalArgumentException {
        this(false, CENTER, 0.0f, GIVEN_FRACTIONS, GIVEN_COLORS);
    }

    public ConicalGradientPaint(boolean USE_DEGREES, Point2D CENTER, float GIVEN_OFFSET, float[] GIVEN_FRACTIONS, Color[] GIVEN_COLORS) throws IllegalArgumentException {
        int i;
        float OFFSET;
        if (GIVEN_FRACTIONS.length != GIVEN_COLORS.length) {
            throw new IllegalArgumentException("Fractions and colors must be equal in size");
        }
        ArrayList<Float> FRACTION_LIST = new ArrayList<Float>(GIVEN_FRACTIONS.length);
        if (USE_DEGREES) {
            double DEG_FRACTION = 0.0027777778450399637;
            OFFSET = Double.compare((double)GIVEN_OFFSET * 0.0027777778450399637, -0.5) == 0 ? -0.5f : (Double.compare((double)GIVEN_OFFSET * 0.0027777778450399637, 0.5) == 0 ? 0.5f : (float)((double)GIVEN_OFFSET * 0.0027777778450399637));
            for (float fraction : GIVEN_FRACTIONS) {
                FRACTION_LIST.add(Float.valueOf((float)((double)fraction * 0.0027777778450399637)));
            }
        } else {
            OFFSET = GIVEN_OFFSET;
            for (float fraction : GIVEN_FRACTIONS) {
                FRACTION_LIST.add(Float.valueOf(fraction));
            }
        }
        if (OFFSET > 0.5f || OFFSET < -0.5f) {
            throw new IllegalArgumentException("Offset has to be in the range of -0.5 to 0.5");
        }
        ArrayList<Color> COLOR_LIST = new ArrayList<Color>(GIVEN_COLORS.length);
        COLOR_LIST.addAll(Arrays.asList(GIVEN_COLORS));
        if (((Float)FRACTION_LIST.get(0)).floatValue() != 0.0f) {
            FRACTION_LIST.add(0, Float.valueOf(0.0f));
            Color TMP_COLOR = (Color)COLOR_LIST.get(0);
            COLOR_LIST.add(0, TMP_COLOR);
        }
        if (((Float)FRACTION_LIST.get(FRACTION_LIST.size() - 1)).floatValue() != 1.0f) {
            FRACTION_LIST.add(Float.valueOf(1.0f));
            COLOR_LIST.add(GIVEN_COLORS[0]);
        }
        HashMap<Float, Color> FRACTION_COLORS = this.recalculate(FRACTION_LIST, COLOR_LIST, OFFSET);
        FRACTION_LIST.clear();
        COLOR_LIST.clear();
        TreeSet SORTED_FRACTIONS = new TreeSet(FRACTION_COLORS.keySet());
        Iterator ITERATOR = SORTED_FRACTIONS.iterator();
        while (ITERATOR.hasNext()) {
            float CURRENT_FRACTION = ((Float)ITERATOR.next()).floatValue();
            FRACTION_LIST.add(Float.valueOf(CURRENT_FRACTION));
            COLOR_LIST.add((Color)FRACTION_COLORS.get(Float.valueOf(CURRENT_FRACTION)));
        }
        this.CENTER = CENTER;
        this.COLORS = COLOR_LIST.toArray(new Color[0]);
        int MAX_FRACTIONS = FRACTION_LIST.size();
        this.FRACTION_ANGLES = new double[MAX_FRACTIONS];
        for (i = 0; i < MAX_FRACTIONS; ++i) {
            this.FRACTION_ANGLES[i] = ((Float)FRACTION_LIST.get(i)).floatValue() * 360.0f;
        }
        this.RED_STEP_LOOKUP = new double[this.COLORS.length];
        this.GREEN_STEP_LOOKUP = new double[this.COLORS.length];
        this.BLUE_STEP_LOOKUP = new double[this.COLORS.length];
        this.ALPHA_STEP_LOOKUP = new double[this.COLORS.length];
        for (i = 0; i < this.COLORS.length - 1; ++i) {
            this.RED_STEP_LOOKUP[i] = (double)((float)(this.COLORS[i + 1].getRed() - this.COLORS[i].getRed()) * 0.003921569f) / (this.FRACTION_ANGLES[i + 1] - this.FRACTION_ANGLES[i]);
            this.GREEN_STEP_LOOKUP[i] = (double)((float)(this.COLORS[i + 1].getGreen() - this.COLORS[i].getGreen()) * 0.003921569f) / (this.FRACTION_ANGLES[i + 1] - this.FRACTION_ANGLES[i]);
            this.BLUE_STEP_LOOKUP[i] = (double)((float)(this.COLORS[i + 1].getBlue() - this.COLORS[i].getBlue()) * 0.003921569f) / (this.FRACTION_ANGLES[i + 1] - this.FRACTION_ANGLES[i]);
            this.ALPHA_STEP_LOOKUP[i] = (double)((float)(this.COLORS[i + 1].getAlpha() - this.COLORS[i].getAlpha()) * 0.003921569f) / (this.FRACTION_ANGLES[i + 1] - this.FRACTION_ANGLES[i]);
        }
    }

    private HashMap<Float, Color> recalculate(List<Float> FRACTION_LIST, List<Color> COLOR_LIST, float OFFSET) {
        int MAX_FRACTIONS = FRACTION_LIST.size();
        HashMap<Float, Color> FRACTION_COLORS = new HashMap<Float, Color>(MAX_FRACTIONS);
        for (int i = 0; i < MAX_FRACTIONS; ++i) {
            Color NEW_FRACTION_COLOR;
            float TMP_FRACTION = FRACTION_LIST.get(i).floatValue() + OFFSET;
            Color TMP_COLOR = COLOR_LIST.get(i);
            if (TMP_FRACTION <= 0.0f) {
                Color NEXT_COLOR;
                float NEXT_FRACTION;
                FRACTION_COLORS.put(Float.valueOf(1.0f + TMP_FRACTION + 1.0E-4f), TMP_COLOR);
                if (i < MAX_FRACTIONS - 1) {
                    NEXT_FRACTION = FRACTION_LIST.get(i + 1).floatValue() + OFFSET;
                    NEXT_COLOR = COLOR_LIST.get(i + 1);
                } else {
                    NEXT_FRACTION = 1.0f - FRACTION_LIST.get(0).floatValue() + OFFSET;
                    NEXT_COLOR = COLOR_LIST.get(0);
                }
                if (!(NEXT_FRACTION > 0.0f)) continue;
                NEW_FRACTION_COLOR = this.getColorFromFraction(TMP_COLOR, NEXT_COLOR, (int)((NEXT_FRACTION - TMP_FRACTION) * 10000.0f), (int)(-TMP_FRACTION * 10000.0f));
                FRACTION_COLORS.put(Float.valueOf(0.0f), NEW_FRACTION_COLOR);
                FRACTION_COLORS.put(Float.valueOf(1.0f), NEW_FRACTION_COLOR);
                continue;
            }
            if (TMP_FRACTION >= 1.0f) {
                Color PREVIOUS_COLOR;
                float PREVIOUS_FRACTION;
                FRACTION_COLORS.put(Float.valueOf(TMP_FRACTION - 1.0f - 1.0E-4f), TMP_COLOR);
                if (i > 0) {
                    PREVIOUS_FRACTION = FRACTION_LIST.get(i - 1).floatValue() + OFFSET;
                    PREVIOUS_COLOR = COLOR_LIST.get(i - 1);
                } else {
                    PREVIOUS_FRACTION = FRACTION_LIST.get(MAX_FRACTIONS - 1).floatValue() + OFFSET;
                    PREVIOUS_COLOR = COLOR_LIST.get(MAX_FRACTIONS - 1);
                }
                if (!(PREVIOUS_FRACTION < 1.0f)) continue;
                NEW_FRACTION_COLOR = this.getColorFromFraction(TMP_COLOR, PREVIOUS_COLOR, (int)((TMP_FRACTION - PREVIOUS_FRACTION) * 10000.0f), (int)(TMP_FRACTION - 1.0f) * 10000);
                FRACTION_COLORS.put(Float.valueOf(1.0f), NEW_FRACTION_COLOR);
                FRACTION_COLORS.put(Float.valueOf(0.0f), NEW_FRACTION_COLOR);
                continue;
            }
            FRACTION_COLORS.put(Float.valueOf(TMP_FRACTION), TMP_COLOR);
        }
        FRACTION_LIST.clear();
        COLOR_LIST.clear();
        return FRACTION_COLORS;
    }

    public Color getColorFromFraction(Color START_COLOR, Color DESTINATION_COLOR, int RANGE, int VALUE) {
        float SOURCE_RED = (float)START_COLOR.getRed() * 0.003921569f;
        float SOURCE_GREEN = (float)START_COLOR.getGreen() * 0.003921569f;
        float SOURCE_BLUE = (float)START_COLOR.getBlue() * 0.003921569f;
        float SOURCE_ALPHA = (float)START_COLOR.getAlpha() * 0.003921569f;
        float DESTINATION_RED = (float)DESTINATION_COLOR.getRed() * 0.003921569f;
        float DESTINATION_GREEN = (float)DESTINATION_COLOR.getGreen() * 0.003921569f;
        float DESTINATION_BLUE = (float)DESTINATION_COLOR.getBlue() * 0.003921569f;
        float DESTINATION_ALPHA = (float)DESTINATION_COLOR.getAlpha() * 0.003921569f;
        float RED_DELTA = DESTINATION_RED - SOURCE_RED;
        float GREEN_DELTA = DESTINATION_GREEN - SOURCE_GREEN;
        float BLUE_DELTA = DESTINATION_BLUE - SOURCE_BLUE;
        float ALPHA_DELTA = DESTINATION_ALPHA - SOURCE_ALPHA;
        float RED_FRACTION = RED_DELTA / (float)RANGE;
        float GREEN_FRACTION = GREEN_DELTA / (float)RANGE;
        float BLUE_FRACTION = BLUE_DELTA / (float)RANGE;
        float ALPHA_FRACTION = ALPHA_DELTA / (float)RANGE;
        float red = SOURCE_RED + RED_FRACTION * (float)VALUE;
        float green = SOURCE_GREEN + GREEN_FRACTION * (float)VALUE;
        float blue = SOURCE_BLUE + BLUE_FRACTION * (float)VALUE;
        float alpha = SOURCE_ALPHA + ALPHA_FRACTION * (float)VALUE;
        red = Math.min(red, 0.0f);
        red = Math.max(red, 1.0f);
        green = Math.min(green, 0.0f);
        green = Math.max(green, 1.0f);
        blue = Math.min(blue, 0.0f);
        blue = Math.max(blue, 1.0f);
        alpha = Math.min(alpha, 0.0f);
        alpha = Math.max(alpha, 1.0f);
        return new Color(red, green, blue, alpha);
    }

    @Override
    public PaintContext createContext(ColorModel COLOR_MODEL, Rectangle DEVICE_BOUNDS, Rectangle2D USER_BOUNDS, AffineTransform TRANSFORM, RenderingHints HINTS) {
        Point2D TRANSFORMED_CENTER = TRANSFORM.transform(this.CENTER, null);
        return new ConicalGradientPaintContext(TRANSFORMED_CENTER);
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    private final class ConicalGradientPaintContext
    implements PaintContext {
        private final Point2D CENTER;

        public ConicalGradientPaintContext(Point2D CENTER) {
            this.CENTER = new Point2D.Double(CENTER.getX(), CENTER.getY());
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int X, int Y, int TILE_WIDTH, int TILE_HEIGHT) {
            double ROTATION_CENTER_X = (double)(-X) + this.CENTER.getX();
            double ROTATION_CENTER_Y = (double)(-Y) + this.CENTER.getY();
            int MAX = ConicalGradientPaint.this.FRACTION_ANGLES.length;
            WritableRaster RASTER = this.getColorModel().createCompatibleWritableRaster(TILE_WIDTH, TILE_HEIGHT);
            int[] data = new int[TILE_WIDTH * TILE_HEIGHT * 4];
            double currentRed = 0.0;
            double currentGreen = 0.0;
            double currentBlue = 0.0;
            double currentAlpha = 0.0;
            for (int tileY = 0; tileY < TILE_HEIGHT; ++tileY) {
                for (int tileX = 0; tileX < TILE_WIDTH; ++tileX) {
                    double dx = (double)tileX - ROTATION_CENTER_X;
                    double dy = (double)tileY - ROTATION_CENTER_Y;
                    double distance = Math.sqrt(dx * dx + dy * dy);
                    if (distance == 0.0) {
                        distance = 1.0;
                    }
                    double angle = Math.abs(Math.toDegrees(Math.acos(dx / distance)));
                    if (dx >= 0.0 && dy <= 0.0) {
                        angle = 90.0 - angle;
                    } else if (dx >= 0.0 && dy >= 0.0) {
                        angle += 90.0;
                    } else if (dx <= 0.0 && dy >= 0.0) {
                        angle += 90.0;
                    } else if (dx <= 0.0 && dy <= 0.0) {
                        angle = 450.0 - angle;
                    }
                    for (int i = 0; i < MAX - 1; ++i) {
                        if (!(angle >= ConicalGradientPaint.this.FRACTION_ANGLES[i])) continue;
                        currentRed = (double)((float)ConicalGradientPaint.this.COLORS[i].getRed() * 0.003921569f) + (angle - ConicalGradientPaint.this.FRACTION_ANGLES[i]) * ConicalGradientPaint.this.RED_STEP_LOOKUP[i];
                        currentGreen = (double)((float)ConicalGradientPaint.this.COLORS[i].getGreen() * 0.003921569f) + (angle - ConicalGradientPaint.this.FRACTION_ANGLES[i]) * ConicalGradientPaint.this.GREEN_STEP_LOOKUP[i];
                        currentBlue = (double)((float)ConicalGradientPaint.this.COLORS[i].getBlue() * 0.003921569f) + (angle - ConicalGradientPaint.this.FRACTION_ANGLES[i]) * ConicalGradientPaint.this.BLUE_STEP_LOOKUP[i];
                        currentAlpha = (double)((float)ConicalGradientPaint.this.COLORS[i].getAlpha() * 0.003921569f) + (angle - ConicalGradientPaint.this.FRACTION_ANGLES[i]) * ConicalGradientPaint.this.ALPHA_STEP_LOOKUP[i];
                    }
                    int BASE = (tileY * TILE_WIDTH + tileX) * 4;
                    data[BASE + 0] = (int)(currentRed * 255.0);
                    data[BASE + 1] = (int)(currentGreen * 255.0);
                    data[BASE + 2] = (int)(currentBlue * 255.0);
                    data[BASE + 3] = (int)(currentAlpha * 255.0);
                }
            }
            RASTER.setPixels(0, 0, TILE_WIDTH, TILE_HEIGHT, data);
            return RASTER;
        }
    }
}

