/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.gradients;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public final class BiLinearGradientPaint
implements Paint {
    private static final float INT_TO_FLOAT_CONST = 0.003921569f;
    private final Rectangle BOUNDS;
    private final Color COLOR_00;
    private final Color COLOR_10;
    private final Color COLOR_01;
    private final Color COLOR_11;
    private final float FRACTION_X_STEPSIZE;
    private final float FRACTION_Y_STEPSIZE;
    private int titleBarHeight;

    public BiLinearGradientPaint(Shape SHAPE, Color COLOR_00, Color COLOR_10, Color COLOR_01, Color COLOR_11) throws IllegalArgumentException {
        this.BOUNDS = SHAPE.getBounds();
        this.COLOR_00 = COLOR_00;
        this.COLOR_10 = COLOR_10;
        this.COLOR_01 = COLOR_01;
        this.COLOR_11 = COLOR_11;
        this.FRACTION_X_STEPSIZE = 1.0f / (float)this.BOUNDS.getBounds().width;
        this.FRACTION_Y_STEPSIZE = 1.0f / (float)this.BOUNDS.getBounds().height;
        this.titleBarHeight = -1;
    }

    @Override
    public PaintContext createContext(ColorModel COLOR_MODEL, Rectangle DEVICE_BOUNDS, Rectangle2D USER_BOUNDS, AffineTransform TRANSFORM, RenderingHints HINTS) {
        return new BiLinearGradientPaintContext();
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    public String toString() {
        return "BiLinearGradientPaint";
    }

    private final class BiLinearGradientPaintContext
    implements PaintContext {
        private Color interpolateColor(Color COLOR1, Color COLOR2, float fraction) {
            fraction = Math.min(fraction, 1.0f);
            fraction = Math.max(fraction, 0.0f);
            float RED1 = (float)COLOR1.getRed() * 0.003921569f;
            float GREEN1 = (float)COLOR1.getGreen() * 0.003921569f;
            float BLUE1 = (float)COLOR1.getBlue() * 0.003921569f;
            float ALPHA1 = (float)COLOR1.getAlpha() * 0.003921569f;
            float RED2 = (float)COLOR2.getRed() * 0.003921569f;
            float GREEN2 = (float)COLOR2.getGreen() * 0.003921569f;
            float BLUE2 = (float)COLOR2.getBlue() * 0.003921569f;
            float ALPHA2 = (float)COLOR2.getAlpha() * 0.003921569f;
            float DELTA_RED = RED2 - RED1;
            float DELTA_GREEN = GREEN2 - GREEN1;
            float DELTA_BLUE = BLUE2 - BLUE1;
            float DELTA_ALPHA = ALPHA2 - ALPHA1;
            float red = RED1 + DELTA_RED * fraction;
            float green = GREEN1 + DELTA_GREEN * fraction;
            float blue = BLUE1 + DELTA_BLUE * fraction;
            float alpha = ALPHA1 + DELTA_ALPHA * fraction;
            red = Math.min(red, 1.0f);
            red = Math.max(red, 0.0f);
            green = Math.min(green, 1.0f);
            green = Math.max(green, 0.0f);
            blue = Math.min(blue, 1.0f);
            blue = Math.max(blue, 0.0f);
            alpha = Math.min(alpha, 1.0f);
            alpha = Math.max(alpha, 0.0f);
            return new Color(red, green, blue, alpha);
        }

        private Color bilinearInterpolateColor(Color COLOR_00, Color COLOR_10, Color COLOR_01, Color COLOR_11, float FRACTION_X, float FRACTION_Y) {
            Color INTERPOLATED_COLOR_X1 = this.interpolateColor(COLOR_00, COLOR_10, FRACTION_X);
            Color INTERPOLATED_COLOR_X2 = this.interpolateColor(COLOR_01, COLOR_11, FRACTION_X);
            return this.interpolateColor(INTERPOLATED_COLOR_X1, INTERPOLATED_COLOR_X2, FRACTION_Y);
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int X, int Y, int TILE_WIDTH, int TILE_HEIGHT) {
            if (BiLinearGradientPaint.this.titleBarHeight == -1) {
                BiLinearGradientPaint.this.titleBarHeight = Y;
            }
            WritableRaster RASTER = this.getColorModel().createCompatibleWritableRaster(TILE_WIDTH, TILE_HEIGHT);
            int[] DATA = new int[TILE_WIDTH * TILE_HEIGHT * 4];
            float fraction_x = (float)(X - ((BiLinearGradientPaint)BiLinearGradientPaint.this).BOUNDS.x) * BiLinearGradientPaint.this.FRACTION_X_STEPSIZE;
            float fraction_y = (float)(Y - ((BiLinearGradientPaint)BiLinearGradientPaint.this).BOUNDS.y - BiLinearGradientPaint.this.titleBarHeight) * BiLinearGradientPaint.this.FRACTION_Y_STEPSIZE;
            fraction_x = Math.min(fraction_x, 1.0f);
            fraction_y = Math.min(fraction_y, 1.0f);
            for (int tileY = 0; tileY < TILE_HEIGHT; ++tileY) {
                for (int tileX = 0; tileX < TILE_WIDTH; ++tileX) {
                    Color currentColor = this.bilinearInterpolateColor(BiLinearGradientPaint.this.COLOR_00, BiLinearGradientPaint.this.COLOR_10, BiLinearGradientPaint.this.COLOR_01, BiLinearGradientPaint.this.COLOR_11, fraction_x, fraction_y);
                    fraction_x += BiLinearGradientPaint.this.FRACTION_X_STEPSIZE;
                    fraction_x = Math.min(fraction_x, 1.0f);
                    int BASE = (tileY * TILE_WIDTH + tileX) * 4;
                    DATA[BASE + 0] = currentColor.getRed();
                    DATA[BASE + 1] = currentColor.getGreen();
                    DATA[BASE + 2] = currentColor.getBlue();
                    DATA[BASE + 3] = currentColor.getAlpha();
                }
                fraction_x = (float)(X - ((BiLinearGradientPaint)BiLinearGradientPaint.this).BOUNDS.x) * BiLinearGradientPaint.this.FRACTION_X_STEPSIZE;
                fraction_y += BiLinearGradientPaint.this.FRACTION_Y_STEPSIZE;
                fraction_y = Math.min(fraction_y, 1.0f);
            }
            RASTER.setPixels(0, 0, TILE_WIDTH, TILE_HEIGHT, DATA);
            return RASTER;
        }
    }
}

