/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Random;
import javax.swing.JComponent;

public class Semaphore
extends JComponent {
    public static final String RED_PROPERTY = "red";
    public static final String YELLOW_PROPERTY = "yellow";
    public static final String GREEN_PROPERTY = "green";
    private static final BufferedImage HATCH_TEXTURE = Semaphore.createHatchTexture();
    private boolean redOn;
    private boolean yellowOn;
    private boolean greenOn;
    private PropertyChangeSupport propertySupport;
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 98, 278);
    private final Point2D CENTER;
    private BufferedImage housingImage;
    private BufferedImage greenImage;
    private BufferedImage greenOnImage;
    private BufferedImage greenOffImage;
    private BufferedImage yellowImage;
    private BufferedImage yellowOnImage;
    private BufferedImage yellowOffImage;
    private BufferedImage redImage;
    private BufferedImage redOnImage;
    private BufferedImage redOffImage;
    private boolean square;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            int SIZE = Semaphore.this.getWidth() <= Semaphore.this.getHeight() ? Semaphore.this.getWidth() : Semaphore.this.getHeight();
            Container parent = Semaphore.this.getParent();
            if (parent != null && parent.getLayout() == null) {
                if (SIZE < Semaphore.this.getMinimumSize().width || SIZE < Semaphore.this.getMinimumSize().height) {
                    Semaphore.this.setSize(Semaphore.this.getMinimumSize());
                } else if (Semaphore.this.square) {
                    Semaphore.this.setSize(SIZE, SIZE);
                } else {
                    Semaphore.this.setSize(Semaphore.this.getWidth(), Semaphore.this.getHeight());
                }
            } else if (SIZE < Semaphore.this.getMinimumSize().width || SIZE < Semaphore.this.getMinimumSize().height) {
                Semaphore.this.setPreferredSize(Semaphore.this.getMinimumSize());
            } else if (Semaphore.this.square) {
                Semaphore.this.setPreferredSize(new Dimension(SIZE, SIZE));
            } else {
                Semaphore.this.setPreferredSize(new Dimension(Semaphore.this.getWidth(), Semaphore.this.getHeight()));
            }
            Semaphore.this.calcInnerBounds();
            Semaphore.this.init(((Semaphore)Semaphore.this).getInnerBounds().width, ((Semaphore)Semaphore.this).getInnerBounds().height);
        }
    };

    public Semaphore() {
        this.addComponentListener(this.COMPONENT_LISTENER);
        this.propertySupport = new PropertyChangeSupport(this);
        this.CENTER = new Point2D.Double();
        this.housingImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.greenImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.greenOnImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.greenOffImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.yellowImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.yellowOnImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.yellowOffImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.redImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.redOnImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.redOffImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.redOn = false;
        this.yellowOn = false;
        this.greenOn = false;
        this.square = false;
    }

    public final void init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return;
        }
        if (this.housingImage != null) {
            this.housingImage.flush();
        }
        this.housingImage = this.createHousingImage(WIDTH, HEIGHT);
        if (this.greenImage != null) {
            this.greenImage.flush();
        }
        this.greenImage = this.createGreenLightImage(WIDTH, HEIGHT);
        if (this.greenOnImage != null) {
            this.greenOnImage.flush();
        }
        this.greenOnImage = this.createGreenOnImage(WIDTH, HEIGHT);
        if (this.greenOffImage != null) {
            this.greenOffImage.flush();
        }
        this.greenOffImage = this.createGreenOffImage(WIDTH, HEIGHT);
        if (this.yellowImage != null) {
            this.yellowImage.flush();
        }
        this.yellowImage = this.createYellowLightImage(WIDTH, HEIGHT);
        if (this.yellowOnImage != null) {
            this.yellowOnImage.flush();
        }
        this.yellowOnImage = this.createYellowOnImage(WIDTH, HEIGHT);
        if (this.yellowOffImage != null) {
            this.yellowOffImage.flush();
        }
        this.yellowOffImage = this.createYellowOffImage(WIDTH, HEIGHT);
        if (this.redImage != null) {
            this.redImage.flush();
        }
        this.redImage = this.createRedLightImage(WIDTH, HEIGHT);
        if (this.redOnImage != null) {
            this.redOnImage.flush();
        }
        this.redOnImage = this.createRedOnImage(WIDTH, HEIGHT);
        if (this.redOffImage != null) {
            this.redOffImage.flush();
        }
        this.redOffImage = this.createRedOffImage(WIDTH, HEIGHT);
        this.CENTER.setLocation((double)WIDTH / 2.0, (double)HEIGHT / 2.0);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        G2.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        G2.drawImage((Image)this.housingImage, 0, 0, null);
        G2.drawImage((Image)this.greenImage, 0, 0, null);
        if (this.greenOn) {
            G2.drawImage((Image)this.greenOnImage, 0, 0, null);
        }
        G2.drawImage((Image)this.greenOffImage, 0, 0, null);
        G2.drawImage((Image)this.yellowImage, 0, 0, null);
        if (this.yellowOn) {
            G2.drawImage((Image)this.yellowOnImage, 0, 0, null);
        }
        G2.drawImage((Image)this.yellowOffImage, 0, 0, null);
        G2.drawImage((Image)this.redImage, 0, 0, null);
        if (this.redOn) {
            G2.drawImage((Image)this.redOnImage, 0, 0, null);
        }
        G2.drawImage((Image)this.redOffImage, 0, 0, null);
        G2.dispose();
    }

    public boolean isRedOn() {
        return this.redOn;
    }

    public void setRedOn(boolean RED_ON) {
        boolean oldRedOn = this.redOn;
        this.redOn = RED_ON;
        this.propertySupport.firePropertyChange(RED_PROPERTY, oldRedOn, this.redOn);
        this.repaint(this.getInnerBounds());
    }

    public boolean isYellowOn() {
        return this.yellowOn;
    }

    public void setYellowOn(boolean YELLOW_ON) {
        boolean oldYellowOn = this.yellowOn;
        this.yellowOn = YELLOW_ON;
        this.propertySupport.firePropertyChange(YELLOW_PROPERTY, oldYellowOn, this.yellowOn);
        this.repaint(this.getInnerBounds());
    }

    public boolean isGreenOn() {
        return this.greenOn;
    }

    public void setGreenOn(boolean GREEN_ON) {
        boolean oldGreenOn = this.greenOn;
        this.greenOn = GREEN_ON;
        this.propertySupport.firePropertyChange(GREEN_PROPERTY, oldGreenOn, this.greenOn);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener LISTENER) {
        if (this.isShowing()) {
            this.propertySupport.addPropertyChangeListener(LISTENER);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener LISTENER) {
        this.propertySupport.removePropertyChangeListener(LISTENER);
    }

    private void calcInnerBounds() {
        Insets INSETS = this.getInsets();
        this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, this.getWidth() - INSETS.left - INSETS.right, this.getHeight() - INSETS.top - INSETS.bottom);
    }

    private Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(98, 278);
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        int SIZE;
        int n = SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        if (this.square) {
            super.setPreferredSize(new Dimension(SIZE, SIZE));
        } else {
            super.setPreferredSize(DIM);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        int SIZE;
        int n = SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        if (this.square) {
            super.setSize(SIZE, SIZE);
        } else {
            super.setSize(WIDTH, HEIGHT);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(Dimension DIM) {
        int SIZE;
        int n = SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        if (this.square) {
            super.setSize(new Dimension(SIZE, SIZE));
        } else {
            super.setSize(DIM);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        int SIZE;
        int n = SIZE = BOUNDS.width <= BOUNDS.height ? BOUNDS.width : BOUNDS.height;
        if (this.square) {
            super.setBounds(BOUNDS.x, BOUNDS.y, SIZE, SIZE);
        } else {
            super.setBounds(BOUNDS);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        int SIZE;
        int n = SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        if (this.square) {
            super.setBounds(X, Y, SIZE, SIZE);
        } else {
            super.setBounds(X, Y, WIDTH, HEIGHT);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    private BufferedImage createImage(int WIDTH, int HEIGHT, int TRANSPARENCY) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, TRANSPARENCY);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, TRANSPARENCY);
        return IMAGE;
    }

    public BufferedImage createHousingImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        RoundRectangle2D.Double HOUSING_BACK = new RoundRectangle2D.Double(0.0 * (double)IMAGE_WIDTH, 0.0 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 0.21428571428571427 * (double)IMAGE_WIDTH, 0.07553956834532374 * (double)IMAGE_HEIGHT);
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.04081632653061224 * (double)IMAGE_WIDTH, 0.007194244604316547 * (double)IMAGE_HEIGHT), new Point2D.Double(0.9521011364730593 * (double)IMAGE_WIDTH, 0.9958824935586308 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.01f, 0.09f, 0.24f, 0.55f, 0.78f, 0.98f, 1.0f}, new Color[]{new Color(0.59607846f, 0.59607846f, 0.6039216f, 1.0f), new Color(0.59607846f, 0.59607846f, 0.6039216f, 1.0f), new Color(0.2f, 0.2f, 0.2f, 1.0f), new Color(0.59607846f, 0.59607846f, 0.6039216f, 1.0f), new Color(0.12156863f, 0.12156863f, 0.12156863f, 1.0f), new Color(0.21176471f, 0.21176471f, 0.21176471f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
        G2.fill(HOUSING_BACK);
        RoundRectangle2D.Double HOUSING_FRONT = new RoundRectangle2D.Double(0.030612244897959183 * (double)IMAGE_WIDTH, 0.01079136690647482 * (double)IMAGE_HEIGHT, 0.9387755102040817 * (double)IMAGE_WIDTH, 0.9784172661870504 * (double)IMAGE_HEIGHT, 0.1683673469387755 * (double)IMAGE_WIDTH, 0.05935251798561151 * (double)IMAGE_HEIGHT);
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(-0.1326530612244898 * (double)IMAGE_WIDTH, -0.0539568345323741 * (double)IMAGE_HEIGHT), new Point2D.Double(2.0614080436330213 * (double)IMAGE_WIDTH, 0.6672932297063833 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.01f, 0.16f, 0.31f, 0.44f, 0.65f, 0.87f, 0.98f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.21568628f, 0.21568628f, 0.20784314f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.1882353f, 0.1882353f, 0.1882353f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.21176471f, 0.21176471f, 0.21176471f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
        G2.fill(HOUSING_FRONT);
        Random BW_RND = new Random();
        Random ALPHA_RND = new Random();
        G2.setClip(HOUSING_FRONT);
        Color DARK_NOISE = new Color(0.2f, 0.2f, 0.2f);
        Color BRIGHT_NOISE = new Color(0.8f, 0.8f, 0.8f);
        int y = 0;
        while ((double)y < ((RectangularShape)HOUSING_FRONT).getHeight()) {
            int x = 0;
            while ((double)x < ((RectangularShape)HOUSING_FRONT).getWidth()) {
                Color noiseColor = BW_RND.nextBoolean() ? BRIGHT_NOISE : DARK_NOISE;
                int noiseAlpha = 10 + ALPHA_RND.nextInt(10) - 5;
                G2.setColor(new Color(noiseColor.getRed(), noiseColor.getGreen(), noiseColor.getBlue(), noiseAlpha));
                G2.drawLine((int)((double)x + HOUSING_FRONT.getMinX()), (int)((double)y + HOUSING_FRONT.getMinY()), (int)((double)x + HOUSING_FRONT.getMinX()), (int)((double)y + HOUSING_FRONT.getMinY()));
                ++x;
            }
            ++y;
        }
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createGreenLightImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double FRAME = new Ellipse2D.Double(0.10204081632653061 * (double)IMAGE_WIDTH, 0.6654676258992805 * (double)IMAGE_HEIGHT, 0.7959183673469388 * (double)IMAGE_WIDTH, 0.2805755395683453 * (double)IMAGE_HEIGHT);
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.6654676258992805 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5000000000000001 * (double)IMAGE_WIDTH, 0.9460431654676259 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.05f, 0.1f, 0.17f, 0.27f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(0.8f, 0.8f, 0.8f, 1.0f), new Color(0.6f, 0.6f, 0.6f, 1.0f), new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.2f, 0.2f, 0.2f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        G2.fill(FRAME);
        Ellipse2D.Double INNER_CLIP = new Ellipse2D.Double(0.10204081632653061 * (double)IMAGE_WIDTH, 0.6870503597122302 * (double)IMAGE_HEIGHT, 0.7959183673469388 * (double)IMAGE_WIDTH, 0.2589928057553957 * (double)IMAGE_HEIGHT);
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.6870503597122302 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5000000000000001 * (double)IMAGE_WIDTH, 0.9460431654676259 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.35f, 0.66f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.015686274f, 0.015686274f, 0.015686274f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        G2.fill(INNER_CLIP);
        Ellipse2D.Double LIGHT_EFFECT = new Ellipse2D.Double(0.14285714285714285 * (double)IMAGE_WIDTH, 0.6834532374100719 * (double)IMAGE_HEIGHT, 0.7142857142857143 * (double)IMAGE_WIDTH, 0.2517985611510791 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.8093525179856115 * (double)IMAGE_HEIGHT), 0.3622449f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.88f, 0.95f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.36862746f, 0.36862746f, 0.36862746f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        G2.fill(LIGHT_EFFECT);
        Ellipse2D.Double INNER_SHADOW = new Ellipse2D.Double(0.14285714285714285 * (double)IMAGE_WIDTH, 0.6834532374100719 * (double)IMAGE_HEIGHT, 0.7142857142857143 * (double)IMAGE_WIDTH, 0.2517985611510791 * (double)IMAGE_HEIGHT);
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.6870503597122302 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5000000000000001 * (double)IMAGE_WIDTH, 0.9172661870503597 * (double)IMAGE_HEIGHT), new float[]{0.0f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f)}));
        G2.fill(INNER_SHADOW);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createGreenOnImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double LIGHT_ON = new Ellipse2D.Double(0.17346938775510204 * (double)IMAGE_WIDTH, 0.6942446043165468 * (double)IMAGE_HEIGHT, 0.6530612244897959 * (double)IMAGE_WIDTH, 0.2302158273381295 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.8093525179856115 * (double)IMAGE_HEIGHT), 0.3265306f * (float)IMAGE_WIDTH, new float[]{0.0f, 1.0f}, new Color[]{new Color(0.33333334f, 0.7254902f, 0.48235294f, 1.0f), new Color(0.0f, 0.12156863f, 0.0f, 1.0f)}));
        G2.fill(LIGHT_ON);
        GeneralPath GLOW = new GeneralPath();
        GLOW.setWindingRule(0);
        GLOW.moveTo(0.0 * (double)IMAGE_WIDTH, 0.8129496402877698 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.0 * (double)IMAGE_WIDTH, 0.9100719424460432 * (double)IMAGE_HEIGHT, 0.22448979591836735 * (double)IMAGE_WIDTH, 0.9892086330935251 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.9892086330935251 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.7755102040816326 * (double)IMAGE_WIDTH, 0.9892086330935251 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.9100719424460432 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.8093525179856115 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.9081632653061225 * (double)IMAGE_WIDTH, 0.7517985611510791 * (double)IMAGE_HEIGHT, 0.7040816326530612 * (double)IMAGE_WIDTH, 0.6870503597122302 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.6870503597122302 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.2857142857142857 * (double)IMAGE_WIDTH, 0.6870503597122302 * (double)IMAGE_HEIGHT, 0.08163265306122448 * (double)IMAGE_WIDTH, 0.7517985611510791 * (double)IMAGE_HEIGHT, 0.0 * (double)IMAGE_WIDTH, 0.8129496402877698 * (double)IMAGE_HEIGHT);
        GLOW.closePath();
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.8093525179856115 * (double)IMAGE_HEIGHT), 0.5153061f * (float)IMAGE_WIDTH, new float[]{0.0f, 1.0f}, new Color[]{new Color(0.25490198f, 0.73333335f, 0.49411765f, 1.0f), new Color(0.015686274f, 0.14509805f, 0.031372547f, 0.0f)}));
        G2.fill(GLOW);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createGreenOffImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double LIGHT_OFF = new Ellipse2D.Double(0.17346938775510204 * (double)IMAGE_WIDTH, 0.6942446043165468 * (double)IMAGE_HEIGHT, 0.6530612244897959 * (double)IMAGE_WIDTH, 0.2302158273381295 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.8093525179856115 * (double)IMAGE_HEIGHT), 0.3265306f * (float)IMAGE_WIDTH, new float[]{0.0f, 1.0f}, new Color[]{new Color(0.0f, 1.0f, 0.0f, 0.24705882f), new Color(0.0f, 1.0f, 0.0f, 0.047058824f)}));
        G2.fill(LIGHT_OFF);
        Ellipse2D.Double INNER_SHADOW = new Ellipse2D.Double(0.17346938775510204 * (double)IMAGE_WIDTH, 0.6942446043165468 * (double)IMAGE_HEIGHT, 0.6530612244897959 * (double)IMAGE_WIDTH, 0.2302158273381295 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.8093525179856115 * (double)IMAGE_HEIGHT), 0.3265306f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        G2.fill(INNER_SHADOW);
        TexturePaint HATCH_PAINT = new TexturePaint(HATCH_TEXTURE, new Rectangle(0, 0, 2, 2));
        G2.setPaint(HATCH_PAINT);
        G2.fill(INNER_SHADOW);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createYellowLightImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double FRAME = new Ellipse2D.Double(0.10204081632653061 * (double)IMAGE_WIDTH, 0.35611510791366907 * (double)IMAGE_HEIGHT, 0.7959183673469388 * (double)IMAGE_WIDTH, 0.2805755395683453 * (double)IMAGE_HEIGHT);
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.35611510791366907 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5000000000000001 * (double)IMAGE_WIDTH, 0.6366906474820144 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.05f, 0.1f, 0.17f, 0.27f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(0.8f, 0.8f, 0.8f, 1.0f), new Color(0.6f, 0.6f, 0.6f, 1.0f), new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.2f, 0.2f, 0.2f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        G2.fill(FRAME);
        Ellipse2D.Double INNER_CLIP = new Ellipse2D.Double(0.10204081632653061 * (double)IMAGE_WIDTH, 0.3776978417266187 * (double)IMAGE_HEIGHT, 0.7959183673469388 * (double)IMAGE_WIDTH, 0.2589928057553957 * (double)IMAGE_HEIGHT);
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.3776978417266187 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5000000000000001 * (double)IMAGE_WIDTH, 0.6366906474820144 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.35f, 0.66f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.015686274f, 0.015686274f, 0.015686274f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        G2.fill(INNER_CLIP);
        Ellipse2D.Double LIGHT_EFFECT = new Ellipse2D.Double(0.14285714285714285 * (double)IMAGE_WIDTH, 0.37410071942446044 * (double)IMAGE_HEIGHT, 0.7142857142857143 * (double)IMAGE_WIDTH, 0.2517985611510791 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT), 0.3622449f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.88f, 0.95f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.36862746f, 0.36862746f, 0.36862746f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        G2.fill(LIGHT_EFFECT);
        Ellipse2D.Double INNER_SHADOW = new Ellipse2D.Double(0.14285714285714285 * (double)IMAGE_WIDTH, 0.37410071942446044 * (double)IMAGE_HEIGHT, 0.7142857142857143 * (double)IMAGE_WIDTH, 0.2517985611510791 * (double)IMAGE_HEIGHT);
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.3776978417266187 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5000000000000001 * (double)IMAGE_WIDTH, 0.6079136690647482 * (double)IMAGE_HEIGHT), new float[]{0.0f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f)}));
        G2.fill(INNER_SHADOW);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createYellowOnImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double LIGHT_ON = new Ellipse2D.Double(0.17346938775510204 * (double)IMAGE_WIDTH, 0.38489208633093525 * (double)IMAGE_HEIGHT, 0.6530612244897959 * (double)IMAGE_WIDTH, 0.2302158273381295 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT), 0.3265306f * (float)IMAGE_WIDTH, new float[]{0.0f, 1.0f}, new Color[]{new Color(0.99607843f, 0.83137256f, 0.20392157f, 1.0f), new Color(0.50980395f, 0.2f, 0.047058824f, 1.0f)}));
        G2.fill(LIGHT_ON);
        GeneralPath GLOW = new GeneralPath();
        GLOW.setWindingRule(0);
        GLOW.moveTo(0.0 * (double)IMAGE_WIDTH, 0.5035971223021583 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.0 * (double)IMAGE_WIDTH, 0.6007194244604317 * (double)IMAGE_HEIGHT, 0.22448979591836735 * (double)IMAGE_WIDTH, 0.6798561151079137 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.6798561151079137 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.7755102040816326 * (double)IMAGE_WIDTH, 0.6798561151079137 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.6007194244604317 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.9081632653061225 * (double)IMAGE_WIDTH, 0.44244604316546765 * (double)IMAGE_HEIGHT, 0.7040816326530612 * (double)IMAGE_WIDTH, 0.3776978417266187 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.3776978417266187 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.2857142857142857 * (double)IMAGE_WIDTH, 0.3776978417266187 * (double)IMAGE_HEIGHT, 0.08163265306122448 * (double)IMAGE_WIDTH, 0.44244604316546765 * (double)IMAGE_HEIGHT, 0.0 * (double)IMAGE_WIDTH, 0.5035971223021583 * (double)IMAGE_HEIGHT);
        GLOW.closePath();
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT), 0.5153061f * (float)IMAGE_WIDTH, new float[]{0.0f, 1.0f}, new Color[]{new Color(0.99607843f, 0.83137256f, 0.20392157f, 1.0f), new Color(0.50980395f, 0.2f, 0.047058824f, 0.0f)}));
        G2.fill(GLOW);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createYellowOffImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double LIGHT_OFF = new Ellipse2D.Double(0.17346938775510204 * (double)IMAGE_WIDTH, 0.38489208633093525 * (double)IMAGE_HEIGHT, 0.6530612244897959 * (double)IMAGE_WIDTH, 0.2302158273381295 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT), 0.3265306f * (float)IMAGE_WIDTH, new float[]{0.0f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 0.0f, 0.24705882f), new Color(1.0f, 1.0f, 0.0f, 0.047058824f)}));
        G2.fill(LIGHT_OFF);
        Ellipse2D.Double INNER_SHADOW = new Ellipse2D.Double(0.17346938775510204 * (double)IMAGE_WIDTH, 0.38489208633093525 * (double)IMAGE_HEIGHT, 0.6530612244897959 * (double)IMAGE_WIDTH, 0.2302158273381295 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT), 0.3265306f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        G2.fill(INNER_SHADOW);
        TexturePaint HATCH_PAINT = new TexturePaint(HATCH_TEXTURE, new Rectangle(0, 0, 2, 2));
        G2.setPaint(HATCH_PAINT);
        G2.fill(INNER_SHADOW);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createRedLightImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double FRAME = new Ellipse2D.Double(0.10204081632653061 * (double)IMAGE_WIDTH, 0.046762589928057555 * (double)IMAGE_HEIGHT, 0.7959183673469388 * (double)IMAGE_WIDTH, 0.2805755395683453 * (double)IMAGE_HEIGHT);
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.046762589928057555 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5000000000000001 * (double)IMAGE_WIDTH, 0.3273381294964029 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.05f, 0.1f, 0.17f, 0.27f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(0.8f, 0.8f, 0.8f, 1.0f), new Color(0.6f, 0.6f, 0.6f, 1.0f), new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.2f, 0.2f, 0.2f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        G2.fill(FRAME);
        Ellipse2D.Double INNER_CLIP = new Ellipse2D.Double(0.10204081632653061 * (double)IMAGE_WIDTH, 0.0683453237410072 * (double)IMAGE_HEIGHT, 0.7959183673469388 * (double)IMAGE_WIDTH, 0.2589928057553957 * (double)IMAGE_HEIGHT);
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.0683453237410072 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5000000000000001 * (double)IMAGE_WIDTH, 0.3273381294964029 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.35f, 0.66f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.015686274f, 0.015686274f, 0.015686274f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        G2.fill(INNER_CLIP);
        Ellipse2D.Double LIGHT_EFFECT = new Ellipse2D.Double(0.14285714285714285 * (double)IMAGE_WIDTH, 0.06474820143884892 * (double)IMAGE_HEIGHT, 0.7142857142857143 * (double)IMAGE_WIDTH, 0.2517985611510791 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.1906474820143885 * (double)IMAGE_HEIGHT), 0.3622449f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.88f, 0.95f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.36862746f, 0.36862746f, 0.36862746f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f)}));
        G2.fill(LIGHT_EFFECT);
        Ellipse2D.Double INNER_SHADOW = new Ellipse2D.Double(0.14285714285714285 * (double)IMAGE_WIDTH, 0.06474820143884892 * (double)IMAGE_HEIGHT, 0.7142857142857143 * (double)IMAGE_WIDTH, 0.2517985611510791 * (double)IMAGE_HEIGHT);
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.0683453237410072 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5000000000000001 * (double)IMAGE_WIDTH, 0.29856115107913667 * (double)IMAGE_HEIGHT), new float[]{0.0f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f)}));
        G2.fill(INNER_SHADOW);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createRedOnImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double LIGHT_ON = new Ellipse2D.Double(0.17346938775510204 * (double)IMAGE_WIDTH, 0.07553956834532374 * (double)IMAGE_HEIGHT, 0.6530612244897959 * (double)IMAGE_WIDTH, 0.2302158273381295 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.1906474820143885 * (double)IMAGE_HEIGHT), 0.3265306f * (float)IMAGE_WIDTH, new float[]{0.0f, 1.0f}, new Color[]{new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(0.25490198f, 0.0f, 0.015686274f, 1.0f)}));
        G2.fill(LIGHT_ON);
        GeneralPath GLOW = new GeneralPath();
        GLOW.setWindingRule(0);
        GLOW.moveTo(0.0 * (double)IMAGE_WIDTH, 0.19424460431654678 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.0 * (double)IMAGE_WIDTH, 0.29136690647482016 * (double)IMAGE_HEIGHT, 0.22448979591836735 * (double)IMAGE_WIDTH, 0.37050359712230213 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.37050359712230213 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.7755102040816326 * (double)IMAGE_WIDTH, 0.37050359712230213 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.29136690647482016 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.1906474820143885 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.9081632653061225 * (double)IMAGE_WIDTH, 0.13309352517985612 * (double)IMAGE_HEIGHT, 0.7040816326530612 * (double)IMAGE_WIDTH, 0.0683453237410072 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.0683453237410072 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.2857142857142857 * (double)IMAGE_WIDTH, 0.0683453237410072 * (double)IMAGE_HEIGHT, 0.08163265306122448 * (double)IMAGE_WIDTH, 0.13309352517985612 * (double)IMAGE_HEIGHT, 0.0 * (double)IMAGE_WIDTH, 0.19424460431654678 * (double)IMAGE_HEIGHT);
        GLOW.closePath();
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.1906474820143885 * (double)IMAGE_HEIGHT), 0.5153061f * (float)IMAGE_WIDTH, new float[]{0.0f, 1.0f}, new Color[]{new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(0.4627451f, 0.019607844f, 0.0039215684f, 0.0f)}));
        G2.fill(GLOW);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createRedOffImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Ellipse2D.Double LIGHT_OFF = new Ellipse2D.Double(0.17346938775510204 * (double)IMAGE_WIDTH, 0.07553956834532374 * (double)IMAGE_HEIGHT, 0.6530612244897959 * (double)IMAGE_WIDTH, 0.2302158273381295 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.1906474820143885 * (double)IMAGE_HEIGHT), 0.3265306f * (float)IMAGE_WIDTH, new float[]{0.0f, 1.0f}, new Color[]{new Color(1.0f, 0.0f, 0.0f, 0.24705882f), new Color(1.0f, 0.0f, 0.0f, 0.047058824f)}));
        G2.fill(LIGHT_OFF);
        Ellipse2D.Double INNER_SHADOW = new Ellipse2D.Double(0.17346938775510204 * (double)IMAGE_WIDTH, 0.07553956834532374 * (double)IMAGE_HEIGHT, 0.6530612244897959 * (double)IMAGE_WIDTH, 0.2302158273381295 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.1906474820143885 * (double)IMAGE_HEIGHT), 0.3265306f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        G2.fill(INNER_SHADOW);
        TexturePaint HATCH_PAINT = new TexturePaint(HATCH_TEXTURE, new Rectangle(0, 0, 2, 2));
        G2.setPaint(HATCH_PAINT);
        G2.fill(INNER_SHADOW);
        G2.dispose();
        return IMAGE;
    }

    private static BufferedImage createHatchTexture() {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(2, 2, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        G2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.1f));
        G2.drawLine(0, 0, 1, 0);
        G2.drawLine(0, 1, 0, 1);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public String toString() {
        return "Trafficlight";
    }
}

