/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import eu.hansolo.custom.FlipImages;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class BackgroundPanel
extends JPanel {
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 148, 100);
    private BufferedImage backgroundImage;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            boolean SQUARE = BackgroundPanel.this.getWidth() == BackgroundPanel.this.getHeight();
            int SIZE = BackgroundPanel.this.getWidth() <= BackgroundPanel.this.getHeight() ? BackgroundPanel.this.getWidth() : BackgroundPanel.this.getHeight();
            Container parent = BackgroundPanel.this.getParent();
            if (parent != null && parent.getLayout() == null) {
                if (SIZE < BackgroundPanel.this.getMinimumSize().width || SIZE < BackgroundPanel.this.getMinimumSize().height) {
                    BackgroundPanel.this.setSize(BackgroundPanel.this.getMinimumSize().width, BackgroundPanel.this.getMinimumSize().height);
                } else if (SQUARE) {
                    BackgroundPanel.this.setSize(SIZE, SIZE);
                } else {
                    BackgroundPanel.this.setSize(BackgroundPanel.this.getWidth(), BackgroundPanel.this.getHeight());
                }
            } else if (SIZE < BackgroundPanel.this.getMinimumSize().width || SIZE < BackgroundPanel.this.getMinimumSize().height) {
                BackgroundPanel.this.setPreferredSize(BackgroundPanel.this.getMinimumSize());
            } else if (SQUARE) {
                BackgroundPanel.this.setPreferredSize(new Dimension(SIZE, SIZE));
            } else {
                BackgroundPanel.this.setPreferredSize(new Dimension(BackgroundPanel.this.getWidth(), BackgroundPanel.this.getHeight()));
            }
            BackgroundPanel.this.calcInnerBounds();
            if (SQUARE) {
                BackgroundPanel.this.init(((BackgroundPanel)BackgroundPanel.this).INNER_BOUNDS.width, ((BackgroundPanel)BackgroundPanel.this).INNER_BOUNDS.width);
            } else {
                BackgroundPanel.this.init(((BackgroundPanel)BackgroundPanel.this).INNER_BOUNDS.width, ((BackgroundPanel)BackgroundPanel.this).INNER_BOUNDS.height);
            }
            FlipImages.INSTANCE.recreateImages(BackgroundPanel.this.getWidth(), BackgroundPanel.this.getHeight());
            BackgroundPanel.this.revalidate();
            BackgroundPanel.this.repaint(BackgroundPanel.this.INNER_BOUNDS);
        }
    };

    public BackgroundPanel() {
        this.addComponentListener(this.COMPONENT_LISTENER);
        this.setOpaque(false);
        this.init(this.getMinimumSize().width, this.getMinimumSize().height);
    }

    private void init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return;
        }
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
        }
        this.backgroundImage = this.createBackgroundImage(WIDTH, HEIGHT);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.backgroundImage, 0, 0, null);
    }

    private void calcInnerBounds() {
        Insets INSETS = this.getInsets();
        this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, this.getWidth() - INSETS.left - INSETS.right, this.getHeight() - INSETS.top - INSETS.bottom);
    }

    private Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(148, 100);
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        super.setPreferredSize(DIM);
        this.calcInnerBounds();
        this.init(DIM.width, DIM.height);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        super.setSize(WIDTH, HEIGHT);
        this.calcInnerBounds();
        this.init(WIDTH, HEIGHT);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setSize(Dimension DIM) {
        super.setSize(DIM);
        this.calcInnerBounds();
        this.init(DIM.width, DIM.height);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        super.setBounds(BOUNDS);
        this.calcInnerBounds();
        this.init(BOUNDS.width, BOUNDS.height);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        super.setBounds(X, Y, WIDTH, HEIGHT);
        this.calcInnerBounds();
        this.init(WIDTH, HEIGHT);
        this.revalidate();
        this.repaint();
    }

    private BufferedImage createBackgroundImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point2D.Double BACKGROUND_START = new Point2D.Double(0.0, 0.0);
        Point2D.Double BACKGROUND_STOP = new Point2D.Double(0.0, HEIGHT);
        float[] BACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] BACKGROUND_COLORS = new Color[]{new Color(5264978), new Color(3751482)};
        RoundRectangle2D.Double BACKGROUND = new RoundRectangle2D.Double(0.0, 0.0, WIDTH, HEIGHT, 5.0, 5.0);
        LinearGradientPaint BACKGROUND_GRADIENT = new LinearGradientPaint(BACKGROUND_START, BACKGROUND_STOP, BACKGROUND_FRACTIONS, BACKGROUND_COLORS);
        G2.setPaint(BACKGROUND_GRADIENT);
        G2.fill(BACKGROUND);
        Point2D.Double INNER_BACKGROUND_START = new Point2D.Double(0.0, 10.0);
        Point2D.Double INNER_BACKGROUND_STOP = new Point2D.Double(0.0, HEIGHT - 10);
        float[] INNER_BACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] INNER_BACKGROUND_COLORS = new Color[]{new Color(5068369), new Color(3751482)};
        RoundRectangle2D.Double INNER_BACKGROUND = new RoundRectangle2D.Double(10.0, 10.0, WIDTH - 20, HEIGHT - 20, 5.0, 5.0);
        LinearGradientPaint INNER_BACKGROUND_GRADIENT = new LinearGradientPaint(INNER_BACKGROUND_START, INNER_BACKGROUND_STOP, INNER_BACKGROUND_FRACTIONS, INNER_BACKGROUND_COLORS);
        G2.setPaint(INNER_BACKGROUND_GRADIENT);
        G2.fill(INNER_BACKGROUND);
        G2.setColor(new Color(3094062));
        G2.drawLine(10, 10, 10, HEIGHT - 10);
        G2.drawLine(WIDTH - 10, 10, WIDTH - 10, HEIGHT - 10);
        G2.drawLine(10, 10, WIDTH - 10, 10);
        G2.setColor(new Color(7041383));
        G2.drawLine(10, HEIGHT - 10, WIDTH - 10, HEIGHT - 10);
        G2.dispose();
        return IMAGE;
    }
}

