/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.Timer;

public class AnimatedProgress
extends JComponent
implements ActionListener {
    private int barWidth;
    private int barHeight;
    private int cornerRadius;
    private boolean roundedCorners;
    private double maxValue;
    private double value;
    private double percentage;
    private boolean valueVisible;
    private boolean percentageVisible;
    private boolean tilted;
    private boolean infinite;
    private String infiniteText;
    private boolean infiniteTextVisible;
    private Color infiniteTextColor;
    private double factor;
    private float posX;
    private float posY;
    private float PERIOD;
    private float cyclePosX;
    private Color color;
    private Color cycleFirstColor;
    private Color cycleSecondColor;
    private Color[] cycleColors;
    private Shape roundRectVariableBar;
    private Shape roundRectFixedBar;
    private Area variableBar;
    private Area fixedBar;
    private Line2D upperDarkLine;
    private Color OUTER_SHADOW_1_COLOR;
    private Color FRAME_COLOR;
    private float[] DIST_TOP_LIGHTS;
    private Color[] COLORS_TOP_LIGHTS;
    private LinearGradientPaint topLightGradient;
    private float[] DIST_BOTTOM_LIGHTS;
    private Color[] COLORS_BOTTOM_LIGHTS;
    private LinearGradientPaint bottomLightGradient;
    private float[] DIST_CENTER_SHADOW;
    private Color[] COLORS_CENTER_SHADOW;
    private LinearGradientPaint centerShadowGradient;
    private LinearGradientPaint cyclicJava6;
    private float[] DIST_STANDARD;
    private float[] DIST_TILTED;
    private float[] DIST_FINISHED;
    private Point2D startPoint;
    private Point2D endPoint;
    private Area topLightArea;
    private Area bottomLightArea;
    private Shape centerShadowRoundedRect;
    private Font STD_FONT;
    private Color foregroundColor;
    private Rectangle2D textBoundary;
    private FontMetrics metrics;
    private final Timer CYCLE_TIMER;
    private int x = 0;
    private double cycleLimit;
    private boolean fadeOut = true;
    private int alpha = 255;
    private final transient ComponentAdapter COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            AnimatedProgress.this.barWidth = AnimatedProgress.this.getSize().width - 2;
            AnimatedProgress.this.barHeight = AnimatedProgress.this.getSize().height - 6;
            AnimatedProgress.this.setBarWidth(AnimatedProgress.this.getSize().width);
            AnimatedProgress.this.recalc();
            AnimatedProgress.this.prepareForms();
        }
    };

    public AnimatedProgress() {
        this.addComponentListener(this.COMPONENT_LISTENER);
        this.CYCLE_TIMER = new Timer(40, this);
        this.initComponents();
        this.prepareForms();
    }

    private void initComponents() {
        this.barWidth = 100;
        this.barHeight = 16;
        this.cornerRadius = 0;
        this.roundedCorners = false;
        this.maxValue = 100.0;
        this.value = 0.0;
        this.percentage = 0.0;
        this.valueVisible = false;
        this.percentageVisible = false;
        this.tilted = false;
        this.infinite = false;
        this.infiniteText = "";
        this.infiniteTextVisible = false;
        this.infiniteTextColor = new Color(100, 100, 100, 255);
        this.factor = 1.0;
        this.posX = 2.0f;
        this.posY = 2.0f;
        this.PERIOD = 10.0f;
        this.cyclePosX = this.posX;
        this.color = new Color(88, 154, 227, 225);
        this.cycleFirstColor = new Color(88, 154, 227, 255);
        this.cycleSecondColor = new Color(50, 130, 222, 255);
        this.cycleColors = new Color[]{this.cycleFirstColor, this.cycleFirstColor, this.cycleSecondColor, this.cycleSecondColor};
        this.OUTER_SHADOW_1_COLOR = new Color(0, 0, 0, 50);
        this.FRAME_COLOR = Color.GRAY;
        this.DIST_TOP_LIGHTS = new float[]{0.0f, 0.01f, 0.45f, 0.55f, 0.95f, 1.0f};
        this.COLORS_TOP_LIGHTS = new Color[]{new Color(200, 200, 200, 50), new Color(255, 255, 255, 50), new Color(255, 255, 255, 100), new Color(255, 255, 255, 100), new Color(255, 255, 255, 50), new Color(255, 255, 255, 0)};
        this.DIST_BOTTOM_LIGHTS = new float[]{0.0f, 0.5f, 0.99f, 1.0f};
        this.COLORS_BOTTOM_LIGHTS = new Color[]{new Color(255, 255, 255, 0), new Color(255, 255, 255, 75), new Color(255, 255, 255, 100), new Color(255, 255, 255, 150)};
        this.DIST_CENTER_SHADOW = new float[]{0.0f, 0.3f, 0.5f, 1.0f};
        this.COLORS_CENTER_SHADOW = new Color[]{new Color(50, 50, 50, 0), new Color(70, 70, 70, 50), new Color(70, 70, 70, 30), new Color(50, 50, 50, 0)};
        this.DIST_STANDARD = new float[]{0.0f, 0.01f, 0.99f, 1.0f};
        this.DIST_TILTED = new float[]{0.0f, 0.4f, 0.5f, 1.0f};
        this.DIST_FINISHED = new float[]{0.0f, 0.1f, 0.9f, 1.0f};
        this.STD_FONT = new Font("SansSerif", 0, (int)((double)this.barHeight - (double)this.barHeight * 0.3));
        this.foregroundColor = Color.DARK_GRAY;
        this.foregroundColor = this.getGrayScaleIntensity(this.cycleFirstColor) > 128 ? Color.DARK_GRAY : Color.WHITE;
        this.startPoint = new Point2D.Float(0.0f, 0.0f);
        this.endPoint = new Point2D.Float(0.0f, 0.0f);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.CYCLE_TIMER.isRunning()) {
            if (this.tilted) {
                this.startPoint.setLocation(this.cyclePosX, this.posY);
                this.endPoint.setLocation((double)this.cyclePosX + (double)this.PERIOD * 1.4142135624, (double)this.posY + (double)(this.PERIOD / 2.0f) / 1.4142135624);
                this.cyclicJava6 = new LinearGradientPaint(this.startPoint, this.endPoint, this.DIST_TILTED, this.cycleColors, MultipleGradientPaint.CycleMethod.REFLECT);
            } else {
                this.startPoint.setLocation(this.cyclePosX, this.posY);
                this.endPoint.setLocation(this.cyclePosX + this.PERIOD, this.posY);
                this.cyclicJava6 = new LinearGradientPaint(this.startPoint, this.endPoint, this.DIST_STANDARD, this.cycleColors, MultipleGradientPaint.CycleMethod.REFLECT);
            }
        } else {
            this.startPoint.setLocation(this.posX, this.posY);
            this.endPoint.setLocation(this.posX, this.posY + (float)this.barHeight);
            this.cyclicJava6 = new LinearGradientPaint(this.startPoint, this.endPoint, this.DIST_FINISHED, this.cycleColors, MultipleGradientPaint.CycleMethod.REFLECT);
        }
        G2.setPaint(this.cyclicJava6);
        this.roundRectVariableBar = new RoundRectangle2D.Double(this.posX, this.posY, this.value / this.maxValue * (double)this.barWidth, this.barHeight, this.cornerRadius, this.cornerRadius);
        this.variableBar = new Area(this.roundRectVariableBar);
        this.fixedBar = new Area(this.roundRectFixedBar);
        this.fixedBar.intersect(this.variableBar);
        G2.fill(this.fixedBar);
        G2.setColor(this.OUTER_SHADOW_1_COLOR);
        G2.draw(this.fixedBar);
        G2.setPaint(this.centerShadowGradient);
        G2.fill(this.centerShadowRoundedRect);
        G2.setPaint(this.topLightGradient);
        G2.fill(this.topLightArea);
        G2.setPaint(this.bottomLightGradient);
        G2.fill(this.bottomLightArea);
        G2.setColor(this.FRAME_COLOR);
        G2.draw(this.roundRectFixedBar);
        G2.setColor(this.OUTER_SHADOW_1_COLOR);
        G2.draw(this.upperDarkLine);
        if (this.valueVisible) {
            G2.setColor(this.foregroundColor);
            G2.setFont(this.STD_FONT);
            this.metrics = G2.getFontMetrics();
            this.textBoundary = this.metrics.getStringBounds(Integer.toString((int)this.value), G2);
            G2.drawString(Integer.toString((int)this.value), (int)((double)this.posX + ((double)this.barWidth - this.textBoundary.getWidth()) / 2.0), (int)((double)this.posY + ((double)this.barHeight - this.textBoundary.getHeight()) / 2.0 + this.textBoundary.getHeight()));
        }
        if (this.percentageVisible) {
            G2.setColor(this.foregroundColor);
            G2.setFont(this.STD_FONT);
            this.metrics = G2.getFontMetrics();
            this.textBoundary = this.metrics.getStringBounds(Integer.toString((int)(this.percentage * 100.0)) + " %", G2);
            G2.drawString(Integer.toString((int)(this.percentage * 100.0)) + " %", (int)((double)this.posX + ((double)this.barWidth - this.textBoundary.getWidth()) / 2.0), (int)((double)this.posY + ((double)this.barHeight - this.textBoundary.getHeight()) / 2.0 + this.textBoundary.getHeight()));
        }
        if (this.infinite && this.infiniteTextVisible) {
            G2.setColor(this.infiniteTextColor);
            G2.setFont(this.STD_FONT);
            this.metrics = G2.getFontMetrics();
            this.textBoundary = this.metrics.getStringBounds(this.infiniteText, G2);
            G2.drawString(this.infiniteText, (int)((double)this.posX + ((double)this.barWidth - this.textBoundary.getWidth()) / 2.0), (int)((double)this.posY + ((double)this.barHeight - this.textBoundary.getHeight()) / 2.0 + this.textBoundary.getHeight()));
        }
        G2.dispose();
    }

    public void setValue(double VALUE) {
        if (!this.infinite) {
            this.value = VALUE >= this.maxValue ? this.maxValue : (VALUE < 0.0 ? 0.0 : VALUE);
            this.percentage = this.value / this.maxValue;
            if (!this.CYCLE_TIMER.isRunning()) {
                this.CYCLE_TIMER.start();
            } else if (Double.compare(this.value, this.maxValue) >= 0) {
                this.CYCLE_TIMER.stop();
            }
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setMaxValue(double MAX_VALUE) {
        this.maxValue = MAX_VALUE <= 0.0 ? 1.0 : MAX_VALUE;
        this.factor = this.calcFactor();
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void reset() {
        this.setValue(0.0);
        this.CYCLE_TIMER.stop();
        this.prepareForms();
    }

    public void setTilted(boolean tilted) {
        this.tilted = tilted;
    }

    public boolean isTilted() {
        return this.tilted;
    }

    public void setInfinite(boolean INFINITE) {
        if (INFINITE) {
            this.setValueVisible(false);
            this.setPercentageVisible(false);
            this.setMaxValue(100.0);
            this.setValue(100.0);
            this.CYCLE_TIMER.start();
        } else {
            this.CYCLE_TIMER.stop();
            this.reset();
        }
        this.infinite = INFINITE;
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public String getInfiniteText() {
        return this.infiniteText;
    }

    public void setInfiniteText(String INFINITE_TEXT) {
        this.infiniteText = INFINITE_TEXT;
    }

    public void setInfiniteTextVisible(boolean INFINITE_TEXT_VISIBLE) {
        this.infiniteTextVisible = INFINITE_TEXT_VISIBLE;
    }

    public boolean isInfiniteTextVisible() {
        return this.infiniteTextVisible;
    }

    public void setValueVisible(boolean VALUE_VISIBLE) {
        this.percentageVisible = false;
        this.valueVisible = VALUE_VISIBLE;
    }

    public boolean isValueVisible() {
        return this.valueVisible;
    }

    public void setPercentageVisible(boolean PERCENTAGE_VISIBLE) {
        this.valueVisible = false;
        this.percentageVisible = PERCENTAGE_VISIBLE;
    }

    public boolean isPercentageVisible() {
        return this.percentageVisible;
    }

    public void setPercentage(double PERCENTAGE) {
        this.value = PERCENTAGE >= 1.0 ? this.maxValue / 100.0 * this.factor : (PERCENTAGE < 0.0 ? 0.0 : PERCENTAGE * this.maxValue * this.factor);
        this.percentage = this.value * this.factor / this.maxValue;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setCornerRadius(int CORNER_RADIUS) {
        this.cornerRadius = CORNER_RADIUS;
        if (this.cornerRadius != this.barHeight) {
            this.roundedCorners = false;
        }
        this.prepareForms();
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    public void setRoundedCorners(boolean ROUNDED_CORNERS) {
        this.roundedCorners = ROUNDED_CORNERS;
        if (ROUNDED_CORNERS) {
            this.setCornerRadius(this.barHeight);
        } else {
            this.setCornerRadius(0);
        }
    }

    public boolean isRoundedCorners() {
        return this.roundedCorners;
    }

    public void setCycleFirstColor(Color CYCLE_FIRST_COLOR) {
        this.cycleColors[0] = CYCLE_FIRST_COLOR;
        this.cycleColors[1] = CYCLE_FIRST_COLOR;
    }

    public Color getCycleFirstColor() {
        return this.cycleFirstColor;
    }

    public void setCycleSecondColor(Color CYCLE_SECOND_COLOR) {
        this.cycleColors[2] = CYCLE_SECOND_COLOR;
        this.cycleColors[3] = CYCLE_SECOND_COLOR;
    }

    public Color getCycleSecondColor() {
        return this.cycleSecondColor;
    }

    public void setColor(Color COLOR) {
        this.color = COLOR;
        this.cycleColors[0] = COLOR.darker();
        this.cycleColors[1] = COLOR.darker();
        this.cycleColors[2] = COLOR;
        this.cycleColors[3] = COLOR;
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void setForegroundColor(Color FOREGROUND_COLOR) {
        this.foregroundColor = FOREGROUND_COLOR;
        this.repaint();
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setInfiniteTextColor(Color INFINITE_TEXT_COLOR) {
        this.infiniteTextColor = INFINITE_TEXT_COLOR;
        this.repaint();
    }

    public Color getInfiniteTextColor() {
        return this.infiniteTextColor;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(102, 22);
    }

    private void setBarWidth(int BAR_WIDTH) {
        this.barWidth = BAR_WIDTH;
        this.setPreferredSize(new Dimension(BAR_WIDTH + 2, this.barHeight + 4));
        this.prepareForms();
    }

    private void prepareForms() {
        int border = 4;
        this.centerShadowGradient = new LinearGradientPaint(new Point2D.Float(this.posX, this.posY + (float)((int)((double)this.barHeight * 0.2))), new Point2D.Float(this.posX, this.posY + (float)((int)((double)this.barHeight * 0.8))), this.DIST_CENTER_SHADOW, this.COLORS_CENTER_SHADOW);
        this.centerShadowRoundedRect = new RoundRectangle2D.Double(this.posX + 1.0f, (int)((double)this.posY + (double)this.barHeight * 0.2), this.barWidth - border - 2, (double)this.barHeight * 0.5, this.cornerRadius, this.cornerRadius);
        this.topLightGradient = new LinearGradientPaint(new Point2D.Float(this.posX, this.posY + 1.0f), new Point2D.Float(this.posX, this.posY + (float)((int)((float)this.barHeight / 2.2f))), this.DIST_TOP_LIGHTS, this.COLORS_TOP_LIGHTS);
        RoundRectangle2D.Double s1 = new RoundRectangle2D.Double(this.posX, this.posY + 1.0f, this.barWidth - border, this.barHeight, this.cornerRadius, this.cornerRadius);
        Rectangle2D.Double s2 = new Rectangle2D.Double(this.posX, (double)this.posY + (double)this.barHeight / 2.0 + 1.0, this.barWidth - border, (double)this.barHeight / 2.0);
        this.topLightArea = new Area(s1);
        Area area2 = new Area(s2);
        this.topLightArea.subtract(area2);
        this.bottomLightGradient = new LinearGradientPaint(new Point2D.Float(this.posX, this.posY + (float)((int)((double)this.barHeight * 0.7))), new Point2D.Float(this.posX, this.posY + (float)this.barHeight), this.DIST_BOTTOM_LIGHTS, this.COLORS_BOTTOM_LIGHTS);
        RoundRectangle2D.Double s3 = new RoundRectangle2D.Double(this.posX, this.posY, this.barWidth - border, this.barHeight, this.cornerRadius, this.cornerRadius);
        Rectangle2D.Double s4 = new Rectangle2D.Double(this.posX, this.posY, this.barWidth - border, (double)this.barHeight / 2.0);
        this.bottomLightArea = new Area(s3);
        Area area3 = new Area(s4);
        this.bottomLightArea.subtract(area3);
        this.roundRectVariableBar = new RoundRectangle2D.Double(this.posX, this.posY, this.value / this.maxValue * (double)this.barWidth, this.barHeight, this.cornerRadius, this.cornerRadius);
        this.roundRectFixedBar = new RoundRectangle2D.Double(this.posX, this.posY, this.barWidth - border, this.barHeight, this.cornerRadius, this.cornerRadius);
        this.variableBar = new Area(this.roundRectVariableBar);
        this.fixedBar = new Area(this.roundRectFixedBar);
        this.upperDarkLine = new Line2D.Double((double)this.posX + (double)this.cornerRadius / 2.0, this.posY, (double)(this.posX + (float)this.barWidth) - (double)this.cornerRadius / 2.0 - (double)border, this.posY);
        this.factor = (double)this.barWidth / this.maxValue;
        this.repaint();
    }

    private double calcFactor() {
        return (double)this.barWidth / this.maxValue;
    }

    private void recalc() {
        double unscaledValue = this.value / this.factor;
        this.factor = this.calcFactor();
        this.setValue(unscaledValue);
    }

    private void setCyclicStart(float CYCLE_POS_X) {
        this.cyclePosX = CYCLE_POS_X;
        this.repaint();
    }

    private int getGrayScaleIntensity(Color COLOR) {
        int red = COLOR.getRed();
        int green = COLOR.getGreen();
        int blue = COLOR.getBlue();
        int grayScaleIntensity = (int)(0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue + 0.5);
        return grayScaleIntensity;
    }

    @Override
    public void actionPerformed(ActionEvent EVENT) {
        this.cycleLimit = this.tilted ? (double)this.PERIOD * 2.8284271247 : (double)(this.PERIOD * 2.0f);
        this.setCyclicStart(this.PERIOD - (float)this.x);
        ++this.x;
        if ((double)this.x >= this.cycleLimit) {
            this.x = 0;
        }
        if (this.infinite && this.infiniteTextVisible) {
            this.alpha = this.fadeOut ? (this.alpha -= 4) : (this.alpha += 4);
            if (this.alpha < 0) {
                this.fadeOut = false;
                this.alpha = 0;
            }
            if (this.alpha >= 255) {
                this.fadeOut = true;
                this.alpha = 255;
            }
            this.infiniteTextColor = new Color(this.infiniteTextColor.getRed(), this.infiniteTextColor.getGreen(), this.infiniteTextColor.getBlue(), this.alpha);
        }
        this.repaint();
    }

    @Override
    public String toString() {
        return "ProgressBar: " + this.value;
    }
}

