/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import eu.hansolo.custom.RangeSlider;
import eu.hansolo.gradients.ConicalGradientPaint;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;

class RangeSliderUI
extends BasicSliderUI {
    private static final Color INDICATOR_COLOR = new Color(0.3f, 0.3f, 0.3f, 0.9f);
    private static final float[] TRACK_FRAME_FRACTIONS = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
    private static final float[] BRIGHT_TRACK_FRACTIONS = new float[]{0.0f, 0.96f, 1.0f};
    private static final float[] DARK_TRACK_FRACTIONS = new float[]{0.0f, 0.3f, 0.75f, 1.0f};
    private static final float[] RANGE_FRACTIONS = new float[]{0.0f, 0.3f, 0.94f, 1.0f};
    private static final Color[] TRACK_FRAME_COLORS = new Color[]{UIManager.getColor("control").darker().darker().darker(), UIManager.getColor("control").darker().darker(), UIManager.getColor("control").darker().darker(), UIManager.getColor("control").brighter()};
    private static final Color[] BRIGHT_TRACK_COLORS = new Color[]{UIManager.getColor("control").darker().darker(), UIManager.getColor("control").darker(), UIManager.getColor("control").darker().darker()};
    private static final Color[] DARK_TRACK_COLORS = new Color[]{new Color(0x131313), new Color(0x242424), new Color(0x242424), new Color(0x1E1E1E)};
    private Rectangle upperThumbRect;
    private boolean upperThumbSelected;
    private boolean lowerDragging;
    private boolean upperDragging;
    private boolean rangeDragging;
    private int formerExtent;
    private RangeSlider.ThumbShape thumbShape = RangeSlider.ThumbShape.ROUND;
    private RangeSlider.ThumbDesign thumbDesign = RangeSlider.ThumbDesign.BRIGHT;
    private BufferedImage thumbImage;
    private BufferedImage hoveredThumbImage;
    private BufferedImage lowerIndicatorImage;
    private BufferedImage upperIndicatorImage;
    private boolean lowerThumbHover;
    private boolean upperThumbHover;
    private final RoundRectangle2D TRACK_FRAME;
    private final RoundRectangle2D TRACK;
    private final RoundRectangle2D RANGE;
    private Color[] rangeColors;
    private boolean darkTrack;
    private boolean indicatorsVisible;

    public RangeSliderUI(RangeSlider RANGE_SLIDER) {
        super(RANGE_SLIDER);
        this.thumbImage = this.createThumbImage(this.getThumbSize().width, this.getThumbSize().height, false);
        this.hoveredThumbImage = this.createThumbImage(this.getThumbSize().width, this.getThumbSize().height, true);
        this.lowerIndicatorImage = this.createIndicatorImage(this.getThumbSize().width, this.getThumbSize().height, INDICATOR_COLOR, true, true);
        this.upperIndicatorImage = this.createIndicatorImage(this.getThumbSize().width, this.getThumbSize().height, INDICATOR_COLOR, false, true);
        this.thumbShape = RANGE_SLIDER.getThumbShape() != null ? RANGE_SLIDER.getThumbShape() : RangeSlider.ThumbShape.ROUND;
        this.thumbDesign = RANGE_SLIDER.getThumbDesign() != null ? RANGE_SLIDER.getThumbDesign() : RangeSlider.ThumbDesign.DARK;
        Color RANGE_COLOR = RANGE_SLIDER.getRangeColor() != null ? RANGE_SLIDER.getRangeColor() : new Color(51, 204, 255);
        int RED = RANGE_COLOR.getRed();
        int GREEN = RANGE_COLOR.getGreen();
        int BLUE = RANGE_COLOR.getBlue();
        if (RED == GREEN && GREEN == BLUE) {
            this.rangeColors = new Color[]{new Color(Color.HSBtoRGB(0.0f, 0.0f, 0.95f)), new Color(Color.HSBtoRGB(0.0f, 0.0f, 0.88f)), new Color(Color.HSBtoRGB(0.0f, 0.0f, 0.67f)), new Color(Color.HSBtoRGB(0.0f, 0.0f, 0.49f))};
        } else {
            float RANGE_COLOR_HUE = Color.RGBtoHSB(RED, GREEN, BLUE, null)[0];
            this.rangeColors = new Color[]{new Color(Color.HSBtoRGB(RANGE_COLOR_HUE, 0.85f, 0.95f)), new Color(Color.HSBtoRGB(RANGE_COLOR_HUE, 0.85f, 0.88f)), new Color(Color.HSBtoRGB(RANGE_COLOR_HUE, 0.85f, 0.67f)), new Color(Color.HSBtoRGB(RANGE_COLOR_HUE, 0.85f, 0.49f))};
        }
        this.darkTrack = RANGE_SLIDER.isDarkTrack();
        this.slider = RANGE_SLIDER;
        this.initThumbs();
        this.lowerThumbHover = false;
        this.upperThumbHover = false;
        this.TRACK_FRAME = new RoundRectangle2D.Double();
        this.TRACK = new RoundRectangle2D.Double();
        this.RANGE = new RoundRectangle2D.Double();
        switch (this.thumbShape) {
            case ROUND: {
                this.indicatorsVisible = true;
                break;
            }
            case SQUARE: {
                this.indicatorsVisible = true;
                break;
            }
            default: {
                this.indicatorsVisible = false;
            }
        }
    }

    private void initThumbs() {
        int thumbResize = 0;
        if (((RangeSlider)this.slider).getTrackWidth() == RangeSlider.TrackWidth.THICK) {
            thumbResize = 0;
        }
        if (this.thumbImage != null) {
            this.thumbImage.flush();
        }
        this.thumbImage = this.createThumbImage(this.getThumbSize().width - thumbResize, this.getThumbSize().height - thumbResize, false);
        if (this.hoveredThumbImage != null) {
            this.hoveredThumbImage.flush();
        }
        this.hoveredThumbImage = this.createThumbImage(this.getThumbSize().width - thumbResize, this.getThumbSize().height - thumbResize, true);
        if (this.lowerIndicatorImage != null) {
            this.lowerIndicatorImage.flush();
        }
        this.lowerIndicatorImage = this.createIndicatorImage(this.getThumbSize().width, this.getThumbSize().height, INDICATOR_COLOR, true, ((RangeSlider)this.slider).getOrientation() == 0);
        if (this.upperIndicatorImage != null) {
            this.upperIndicatorImage.flush();
        }
        this.upperIndicatorImage = this.createIndicatorImage(this.getThumbSize().width, this.getThumbSize().height, INDICATOR_COLOR, false, ((RangeSlider)this.slider).getOrientation() == 0);
    }

    @Override
    public void installUI(JComponent COMPONENT) {
        this.upperThumbRect = new Rectangle();
        super.installUI(COMPONENT);
    }

    @Override
    public void paint(Graphics G, JComponent COMPONENT) {
        super.paint(G, COMPONENT);
        Rectangle clipRect = G.getClipBounds();
        if (((RangeSlider)this.slider).isRangeSelectionEnabled()) {
            if (this.upperThumbSelected) {
                if (clipRect.intersects(this.thumbRect)) {
                    this.paintLowerThumb(G);
                }
                if (clipRect.intersects(this.upperThumbRect)) {
                    this.paintUpperThumb(G);
                }
            } else {
                if (clipRect.intersects(this.upperThumbRect)) {
                    this.paintUpperThumb(G);
                }
                if (clipRect.intersects(this.thumbRect)) {
                    this.paintLowerThumb(G);
                }
            }
        } else if (clipRect.intersects(this.thumbRect)) {
            this.paintLowerThumb(G);
        }
    }

    @Override
    public void paintTrack(Graphics G) {
        double cornerRadius;
        int trackDesignFactor;
        int distanceFromBorder;
        Graphics2D G2 = (Graphics2D)G.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        switch (((RangeSlider)this.slider).getTrackWidth()) {
            case MEDIUM: {
                distanceFromBorder = 3;
                trackDesignFactor = 0;
                break;
            }
            case THICK: {
                distanceFromBorder = 0;
                trackDesignFactor = 1;
                break;
            }
            default: {
                distanceFromBorder = 5;
                trackDesignFactor = 0;
            }
        }
        int trackExtension = 0;
        switch (((RangeSlider)this.slider).getThumbShape()) {
            case RECTANGULAR: {
                trackExtension = this.thumbRect.width / 4 * trackDesignFactor;
                cornerRadius = 0.25 * (double)this.thumbRect.height;
                break;
            }
            case SQUARE: {
                trackExtension = this.thumbRect.width / 2 * trackDesignFactor + trackDesignFactor;
                cornerRadius = 0.5 * (double)this.thumbRect.height;
                break;
            }
            case DROP: {
                trackExtension = 0;
                cornerRadius = 0.25 * (double)this.thumbRect.height;
                break;
            }
            default: {
                trackExtension = this.thumbRect.width / 2 * trackDesignFactor + trackDesignFactor;
                cornerRadius = this.thumbRect.height - 2 * distanceFromBorder;
            }
        }
        if (this.slider.getOrientation() == 0) {
            this.TRACK_FRAME.setRoundRect(this.trackRect.x - trackExtension, this.trackRect.y + distanceFromBorder, this.trackRect.width - 1 + 2 * trackExtension, this.trackRect.height - 2 * distanceFromBorder, cornerRadius, cornerRadius);
            G2.setPaint(new LinearGradientPaint(0.0f, (float)this.TRACK_FRAME.getMinY(), 0.0f, (float)this.TRACK_FRAME.getMaxY(), TRACK_FRAME_FRACTIONS, TRACK_FRAME_COLORS));
            G2.fill(this.TRACK_FRAME);
            this.TRACK.setRoundRect(this.TRACK_FRAME.getMinX() + 1.0, this.TRACK_FRAME.getY() + 1.0, this.TRACK_FRAME.getWidth() - 2.0, this.TRACK_FRAME.getHeight() - 2.0, this.TRACK_FRAME.getArcWidth() - 0.5, this.TRACK_FRAME.getArcHeight() - 0.5);
            if (this.darkTrack) {
                G2.setPaint(new LinearGradientPaint(0.0f, (float)this.TRACK.getMinY(), 0.0f, (float)this.TRACK.getMaxY(), DARK_TRACK_FRACTIONS, DARK_TRACK_COLORS));
            } else {
                G2.setPaint(new LinearGradientPaint(0.0f, (float)this.TRACK.getMinY(), 0.0f, (float)this.TRACK.getMaxY(), BRIGHT_TRACK_FRACTIONS, BRIGHT_TRACK_COLORS));
            }
            G2.fill(this.TRACK);
        } else {
            this.TRACK_FRAME.setRoundRect(this.trackRect.x + distanceFromBorder, this.trackRect.y - trackExtension, this.trackRect.width - 2 * distanceFromBorder, this.trackRect.height - 1 + 2 * trackExtension, cornerRadius, cornerRadius);
            G2.setPaint(new LinearGradientPaint((float)this.TRACK_FRAME.getMinX(), 0.0f, (float)this.TRACK_FRAME.getMaxX(), 0.0f, TRACK_FRAME_FRACTIONS, TRACK_FRAME_COLORS));
            G2.fill(this.TRACK_FRAME);
            this.TRACK.setRoundRect(this.TRACK_FRAME.getX() + 1.0, this.TRACK_FRAME.getMinY() + 1.0, this.TRACK_FRAME.getWidth() - 2.0, this.TRACK_FRAME.getHeight() - 2.0, this.TRACK_FRAME.getArcWidth() - 0.5, this.TRACK_FRAME.getArcHeight() - 0.5);
            if (this.darkTrack) {
                G2.setPaint(new LinearGradientPaint((float)this.TRACK.getMinX(), 0.0f, (float)this.TRACK.getMaxX(), 0.0f, DARK_TRACK_FRACTIONS, DARK_TRACK_COLORS));
            } else {
                G2.setPaint(new LinearGradientPaint((float)this.TRACK.getMinX(), 0.0f, (float)this.TRACK.getMaxX(), 0.0f, BRIGHT_TRACK_FRACTIONS, BRIGHT_TRACK_COLORS));
            }
            G2.fill(this.TRACK);
        }
        if (this.slider.getOrientation() == 0) {
            int UPPER_X;
            int LOWER_X;
            if (((RangeSlider)this.slider).isRangeSelectionEnabled()) {
                LOWER_X = this.thumbRect.x + this.thumbRect.width / 2;
                UPPER_X = this.upperThumbRect.x + this.upperThumbRect.width / 2;
            } else {
                LOWER_X = this.slider.getInverted() ? this.trackRect.x + this.trackRect.width : this.trackRect.x;
                UPPER_X = this.thumbRect.x + this.thumbRect.width / 2;
            }
            Paint OLD_PAINT = G2.getPaint();
            if (this.slider.getInverted()) {
                this.RANGE.setRoundRect(UPPER_X - trackExtension + 1, this.TRACK_FRAME.getY() + 1.0, LOWER_X - UPPER_X + 2 * trackExtension - 2, this.TRACK_FRAME.getHeight() - 2.0, this.TRACK_FRAME.getArcWidth() - 0.5, this.TRACK_FRAME.getArcHeight() - 0.5);
            } else {
                this.RANGE.setRoundRect(LOWER_X - trackExtension + 1, this.TRACK_FRAME.getY() + 1.0, UPPER_X - LOWER_X + 2 * trackExtension - 2, this.TRACK_FRAME.getHeight() - 2.0, this.TRACK_FRAME.getArcWidth() - 0.5, this.TRACK_FRAME.getArcHeight() - 0.5);
            }
            G2.setPaint(new LinearGradientPaint(0.0f, (float)this.RANGE.getMinY(), 0.0f, (float)this.RANGE.getMaxY(), RANGE_FRACTIONS, this.rangeColors));
            if (((RangeSlider)this.slider).isRangeVisible()) {
                G2.fill(this.RANGE);
            }
            G2.setPaint(OLD_PAINT);
        } else {
            int UPPER_Y;
            int LOWER_Y;
            if (((RangeSlider)this.slider).isRangeSelectionEnabled()) {
                LOWER_Y = this.thumbRect.y + this.thumbRect.height / 2;
                UPPER_Y = this.upperThumbRect.y + this.upperThumbRect.height / 2;
            } else {
                LOWER_Y = this.slider.getInverted() ? this.trackRect.y : this.trackRect.y + this.trackRect.height;
                UPPER_Y = this.thumbRect.y + this.thumbRect.height / 2;
            }
            Paint OLD_PAINT = G2.getPaint();
            if (this.slider.getInverted()) {
                this.RANGE.setRoundRect(this.TRACK_FRAME.getX() + 1.0, LOWER_Y - trackExtension + 1, this.TRACK_FRAME.getWidth() - 2.0, UPPER_Y - LOWER_Y + 2 * trackExtension - 2, this.TRACK_FRAME.getArcWidth() - 0.5, this.TRACK_FRAME.getArcHeight() - 0.5);
            } else {
                this.RANGE.setRoundRect(this.TRACK_FRAME.getX() + 1.0, UPPER_Y - trackExtension + 1, this.TRACK_FRAME.getWidth() - 2.0, LOWER_Y - UPPER_Y + 2 * trackExtension - 2, this.TRACK_FRAME.getArcWidth() - 0.5, this.TRACK_FRAME.getArcHeight() - 0.5);
            }
            G2.setPaint(new LinearGradientPaint((float)this.RANGE.getMinX(), 0.0f, (float)this.RANGE.getMaxX(), 0.0f, RANGE_FRACTIONS, this.rangeColors));
            if (((RangeSlider)this.slider).isRangeVisible()) {
                G2.fill(this.RANGE);
            }
            G2.setPaint(OLD_PAINT);
        }
        G2.dispose();
    }

    @Override
    public void paintThumb(Graphics G) {
    }

    private void paintLowerThumb(Graphics G) {
        Graphics2D G2 = (Graphics2D)G.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.lowerThumbHover) {
            G2.drawImage((Image)this.hoveredThumbImage, this.thumbRect.x, this.thumbRect.y, null);
            this.slider.setToolTipText("Lower: " + Integer.toString(this.slider.getValue()));
        } else {
            G2.drawImage((Image)this.thumbImage, this.thumbRect.x, this.thumbRect.y, null);
        }
        if (this.indicatorsVisible) {
            if (!((RangeSlider)this.slider).isRangeSelectionEnabled()) {
                if (this.slider.getInverted()) {
                    G2.drawImage((Image)this.lowerIndicatorImage, this.thumbRect.x, this.thumbRect.y, null);
                } else {
                    G2.drawImage((Image)this.upperIndicatorImage, this.thumbRect.x, this.thumbRect.y, null);
                }
            } else if (this.slider.getInverted()) {
                G2.drawImage((Image)this.upperIndicatorImage, this.thumbRect.x, this.thumbRect.y, null);
            } else {
                G2.drawImage((Image)this.lowerIndicatorImage, this.thumbRect.x, this.thumbRect.y, null);
            }
        }
        G2.dispose();
    }

    private void paintUpperThumb(Graphics G) {
        Graphics2D G2 = (Graphics2D)G.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.upperThumbHover) {
            G2.drawImage((Image)this.hoveredThumbImage, this.upperThumbRect.x, this.upperThumbRect.y, null);
            this.slider.setToolTipText("Upper: " + Integer.toString(this.slider.getValue() + this.slider.getExtent()));
        } else {
            G2.drawImage((Image)this.thumbImage, this.upperThumbRect.x, this.upperThumbRect.y, null);
        }
        if (this.indicatorsVisible) {
            if (this.slider.getInverted()) {
                G2.drawImage((Image)this.lowerIndicatorImage, this.upperThumbRect.x, this.upperThumbRect.y, null);
            } else {
                G2.drawImage((Image)this.upperIndicatorImage, this.upperThumbRect.x, this.upperThumbRect.y, null);
            }
        }
        G2.dispose();
    }

    @Override
    public void paintFocus(Graphics G) {
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider SLIDER) {
        return new RangeTrackListener();
    }

    @Override
    protected ChangeListener createChangeListener(JSlider SLIDER) {
        return new ChangeHandler();
    }

    @Override
    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.upperThumbRect.setSize(this.thumbRect.width, this.thumbRect.height);
    }

    @Override
    protected void calculateThumbLocation() {
        this.calculateLowerThumbLocation();
        this.calculateUpperThumbLocation();
    }

    protected void calculateLowerThumbLocation() {
        int valuePosition;
        if (this.slider.getSnapToTicks()) {
            int sliderValue;
            int snappedValue = sliderValue = this.slider.getValue();
            int majorTickSpacing = this.slider.getMajorTickSpacing();
            int minorTickSpacing = this.slider.getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                if ((sliderValue - this.slider.getMinimum()) % tickSpacing != 0) {
                    float temp = (float)(sliderValue - this.slider.getMinimum()) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                }
                if (snappedValue != sliderValue) {
                    this.slider.setValue(snappedValue);
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            valuePosition = this.xPositionForValue(this.slider.getValue());
            this.thumbRect.x = valuePosition - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y;
        } else {
            valuePosition = this.yPositionForValue(this.slider.getValue());
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = valuePosition - this.thumbRect.height / 2;
        }
    }

    protected void calculateUpperThumbLocation() {
        int valuePosition;
        if (this.slider.getSnapToTicks()) {
            int sliderValue;
            int snappedValue = sliderValue = this.slider.getValue();
            int majorTickSpacing = this.slider.getMajorTickSpacing();
            int minorTickSpacing = this.slider.getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                if ((sliderValue - this.slider.getMinimum()) % tickSpacing != 0) {
                    float temp = (float)(sliderValue - this.slider.getMinimum()) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = this.slider.getMinimum() + whichTick * tickSpacing;
                }
                if (snappedValue != sliderValue) {
                    this.slider.setValue(snappedValue);
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            valuePosition = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.upperThumbRect.x = valuePosition - this.upperThumbRect.width / 2;
            this.upperThumbRect.y = this.trackRect.y;
        } else {
            valuePosition = this.yPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.upperThumbRect.x = this.trackRect.x;
            this.upperThumbRect.y = valuePosition - this.upperThumbRect.height / 2;
        }
    }

    private void setUpperThumbLocation(int X, int Y) {
        Rectangle upperUnionRect = new Rectangle();
        upperUnionRect.setBounds(this.upperThumbRect);
        this.upperThumbRect.setLocation(X, Y);
        SwingUtilities.computeUnion(this.upperThumbRect.x, this.upperThumbRect.y, this.upperThumbRect.width, this.upperThumbRect.height, upperUnionRect);
        this.slider.repaint(upperUnionRect.x, upperUnionRect.y, upperUnionRect.width, upperUnionRect.height);
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(16, 16);
    }

    private BufferedImage createThumbImage(int WIDTH, int HEIGHT, boolean HOVER) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.thumbShape != RangeSlider.ThumbShape.NONE) {
            LinearGradientPaint FOREGROUND_PAINT;
            Paint INNER_FRAME_PAINT;
            LinearGradientPaint BACKGROUND_PAINT;
            Shape STANDARD;
            Shape INNER_FRAME;
            Shape BACKGROUND;
            int IMAGE_WIDTH = IMAGE.getWidth();
            int IMAGE_HEIGHT = IMAGE.getHeight();
            Point2D.Double CENTER = new Point2D.Double();
            switch (this.thumbShape) {
                case DROP: {
                    GeneralPath BACKGROUND_PATH = new GeneralPath();
                    GeneralPath INNER_FRAME_PATH = new GeneralPath();
                    GeneralPath STANDARD_PATH = new GeneralPath();
                    switch (this.slider.getOrientation()) {
                        case 1: {
                            BACKGROUND_PATH.setWindingRule(0);
                            BACKGROUND_PATH.moveTo(0.375 * (double)IMAGE_WIDTH, 0.0625 * (double)IMAGE_HEIGHT);
                            BACKGROUND_PATH.curveTo(0.5 * (double)IMAGE_WIDTH, 0.0625 * (double)IMAGE_HEIGHT, (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                            BACKGROUND_PATH.curveTo((double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT, 0.375 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
                            BACKGROUND_PATH.curveTo(0.1875 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT, 0.0, 0.75 * (double)IMAGE_HEIGHT, 0.0, 0.5 * (double)IMAGE_HEIGHT);
                            BACKGROUND_PATH.curveTo(0.0, 0.25 * (double)IMAGE_HEIGHT, 0.25 * (double)IMAGE_WIDTH, 0.0625 * (double)IMAGE_HEIGHT, 0.375 * (double)IMAGE_WIDTH, 0.0625 * (double)IMAGE_HEIGHT);
                            BACKGROUND_PATH.closePath();
                            INNER_FRAME_PATH.setWindingRule(0);
                            INNER_FRAME_PATH.moveTo(0.375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
                            INNER_FRAME_PATH.curveTo(0.5 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT, 0.9375 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.9375 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                            INNER_FRAME_PATH.curveTo(0.9375 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.875 * (double)IMAGE_HEIGHT, 0.375 * (double)IMAGE_WIDTH, 0.875 * (double)IMAGE_HEIGHT);
                            INNER_FRAME_PATH.curveTo(0.25 * (double)IMAGE_WIDTH, 0.875 * (double)IMAGE_HEIGHT, 0.0625 * (double)IMAGE_WIDTH, 0.75 * (double)IMAGE_HEIGHT, 0.0625 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                            INNER_FRAME_PATH.curveTo(0.0625 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT, 0.25 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT, 0.375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
                            INNER_FRAME_PATH.closePath();
                            STANDARD_PATH.setWindingRule(0);
                            STANDARD_PATH.moveTo(0.375 * (double)IMAGE_WIDTH, 0.1875 * (double)IMAGE_HEIGHT);
                            STANDARD_PATH.curveTo(0.5 * (double)IMAGE_WIDTH, 0.1875 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                            STANDARD_PATH.curveTo(0.875 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.375 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT);
                            STANDARD_PATH.curveTo(0.25 * (double)IMAGE_WIDTH, 0.8125 * (double)IMAGE_HEIGHT, 0.125 * (double)IMAGE_WIDTH, 0.6875 * (double)IMAGE_HEIGHT, 0.125 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                            STANDARD_PATH.curveTo(0.125 * (double)IMAGE_WIDTH, 0.3125 * (double)IMAGE_HEIGHT, 0.3125 * (double)IMAGE_WIDTH, 0.1875 * (double)IMAGE_HEIGHT, 0.375 * (double)IMAGE_WIDTH, 0.1875 * (double)IMAGE_HEIGHT);
                            STANDARD_PATH.closePath();
                            ((Point2D)CENTER).setLocation(BACKGROUND_PATH.getBounds2D().getWidth() * 0.375, BACKGROUND_PATH.getBounds2D().getCenterY());
                            break;
                        }
                        default: {
                            BACKGROUND_PATH.setWindingRule(0);
                            BACKGROUND_PATH.moveTo(0.0625 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT);
                            BACKGROUND_PATH.curveTo(0.0625 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, (double)IMAGE_HEIGHT);
                            BACKGROUND_PATH.curveTo(0.5 * (double)IMAGE_WIDTH, (double)IMAGE_HEIGHT, 0.9375 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.9375 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT);
                            BACKGROUND_PATH.curveTo(0.9375 * (double)IMAGE_WIDTH, 0.1875 * (double)IMAGE_HEIGHT, 0.75 * (double)IMAGE_WIDTH, 0.0, 0.5 * (double)IMAGE_WIDTH, 0.0);
                            BACKGROUND_PATH.curveTo(0.25 * (double)IMAGE_WIDTH, 0.0, 0.0625 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT, 0.0625 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT);
                            BACKGROUND_PATH.closePath();
                            INNER_FRAME_PATH.setWindingRule(0);
                            INNER_FRAME_PATH.moveTo(0.125 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT);
                            INNER_FRAME_PATH.curveTo(0.125 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT);
                            INNER_FRAME_PATH.curveTo(0.5 * (double)IMAGE_WIDTH, 0.9375 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT);
                            INNER_FRAME_PATH.curveTo(0.875 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT, 0.75 * (double)IMAGE_WIDTH, 0.0625 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.0625 * (double)IMAGE_HEIGHT);
                            INNER_FRAME_PATH.curveTo(0.25 * (double)IMAGE_WIDTH, 0.0625 * (double)IMAGE_HEIGHT, 0.125 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT, 0.125 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT);
                            INNER_FRAME_PATH.closePath();
                            STANDARD_PATH.setWindingRule(0);
                            STANDARD_PATH.moveTo(0.1875 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT);
                            STANDARD_PATH.curveTo(0.1875 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.875 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.875 * (double)IMAGE_HEIGHT);
                            STANDARD_PATH.curveTo(0.5 * (double)IMAGE_WIDTH, 0.875 * (double)IMAGE_HEIGHT, 0.8125 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.8125 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT);
                            STANDARD_PATH.curveTo(0.8125 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT, 0.6875 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
                            STANDARD_PATH.curveTo(0.3125 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT, 0.1875 * (double)IMAGE_WIDTH, 0.3125 * (double)IMAGE_HEIGHT, 0.1875 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT);
                            STANDARD_PATH.closePath();
                            ((Point2D)CENTER).setLocation(BACKGROUND_PATH.getBounds2D().getCenterX(), BACKGROUND_PATH.getBounds2D().getHeight() * 0.375);
                        }
                    }
                    BACKGROUND = BACKGROUND_PATH;
                    INNER_FRAME = INNER_FRAME_PATH;
                    STANDARD = STANDARD_PATH;
                    break;
                }
                case RECTANGULAR: {
                    switch (this.slider.getOrientation()) {
                        case 1: {
                            BACKGROUND = new RoundRectangle2D.Double(0.0 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT, 0.25 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
                            INNER_FRAME = new RoundRectangle2D.Double(0.0625 * (double)IMAGE_WIDTH, 0.3125 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT, 0.1875 * (double)IMAGE_WIDTH, 0.1875 * (double)IMAGE_HEIGHT);
                            STANDARD = new RoundRectangle2D.Double(0.125 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT, 0.75 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT, 0.125 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
                            break;
                        }
                        default: {
                            BACKGROUND = new RoundRectangle2D.Double(0.25 * (double)IMAGE_WIDTH, 0.0 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 0.25 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
                            INNER_FRAME = new RoundRectangle2D.Double(0.3125 * (double)IMAGE_WIDTH, 0.0625 * (double)IMAGE_HEIGHT, 0.375 * (double)IMAGE_WIDTH, 0.875 * (double)IMAGE_HEIGHT, 0.1875 * (double)IMAGE_WIDTH, 0.1875 * (double)IMAGE_HEIGHT);
                            STANDARD = new RoundRectangle2D.Double(0.375 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT, 0.25 * (double)IMAGE_WIDTH, 0.75 * (double)IMAGE_HEIGHT, 0.125 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT);
                        }
                    }
                    ((Point2D)CENTER).setLocation(BACKGROUND.getBounds2D().getCenterX(), BACKGROUND.getBounds2D().getCenterY());
                    break;
                }
                case SQUARE: {
                    BACKGROUND = new RoundRectangle2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                    INNER_FRAME = new RoundRectangle2D.Double(0.0625 * (double)IMAGE_WIDTH, 0.0625 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.875 * (double)IMAGE_HEIGHT, 0.4375 * (double)IMAGE_WIDTH, 0.4375 * (double)IMAGE_HEIGHT);
                    STANDARD = new RoundRectangle2D.Double(0.125 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT, 0.75 * (double)IMAGE_WIDTH, 0.75 * (double)IMAGE_HEIGHT, 0.375 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT);
                    ((Point2D)CENTER).setLocation(BACKGROUND.getBounds2D().getCenterX(), BACKGROUND.getBounds2D().getCenterY());
                    break;
                }
                default: {
                    BACKGROUND = new Ellipse2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT);
                    INNER_FRAME = new Ellipse2D.Double(0.0625 * (double)IMAGE_WIDTH, 0.0625 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.875 * (double)IMAGE_HEIGHT);
                    STANDARD = new Ellipse2D.Double(0.125 * (double)IMAGE_WIDTH, 0.125 * (double)IMAGE_HEIGHT, 0.75 * (double)IMAGE_WIDTH, 0.75 * (double)IMAGE_HEIGHT);
                    ((Point2D)CENTER).setLocation(BACKGROUND.getBounds2D().getCenterX(), BACKGROUND.getBounds2D().getCenterY());
                }
            }
            switch (this.thumbDesign) {
                case DARK: {
                    float[] BACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] BACKGROUND_COLORS = new Color[]{UIManager.getColor("control").darker().darker(), UIManager.getColor("control").darker().darker().darker()};
                    float[] INNER_FRAME_FRACTIONS = new float[]{0.0f, 0.39f, 1.0f};
                    Color[] INNER_FRAME_COLORS = new Color[]{UIManager.getColor("control"), UIManager.getColor("control").darker(), UIManager.getColor("control").brighter()};
                    float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] FOREGROUND_COLORS = HOVER ? new Color[]{UIManager.getColor("control"), UIManager.getColor("control").brighter()} : new Color[]{UIManager.getColor("control").darker(), UIManager.getColor("control")};
                    BACKGROUND_PAINT = new LinearGradientPaint(new Point2D.Double(0.0, BACKGROUND.getBounds2D().getMinY()), new Point2D.Double(0.0, BACKGROUND.getBounds2D().getMaxY()), BACKGROUND_FRACTIONS, BACKGROUND_COLORS);
                    INNER_FRAME_PAINT = new LinearGradientPaint(new Point2D.Double(0.0, INNER_FRAME.getBounds2D().getMinY()), new Point2D.Double(0.0, INNER_FRAME.getBounds2D().getMaxY()), INNER_FRAME_FRACTIONS, INNER_FRAME_COLORS);
                    FOREGROUND_PAINT = new LinearGradientPaint(new Point2D.Double(0.0, STANDARD.getBounds2D().getMinY()), new Point2D.Double(0.0, STANDARD.getBounds2D().getMaxY()), FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
                    break;
                }
                case STAINLESS: {
                    float[] BACKGROUND_FRACTIONS = new float[]{0.0f, 0.25f, 0.51f, 0.76f, 1.0f};
                    Color[] BACKGROUND_COLORS = new Color[]{new Color(90, 91, 92, 255), new Color(127, 127, 128, 255), new Color(81, 82, 83, 255), new Color(104, 105, 105, 255), new Color(63, 64, 65, 255)};
                    float[] INNER_FRAME_FRACTIONS = new float[]{0.0f, 40.0f, 90.0f, 140.0f, 220.0f, 270.0f, 320.0f};
                    Color[] INNER_FRAME_COLORS = HOVER ? new Color[]{new Color(0xC2C2C2), new Color(7501432), new Color(0xC2C2C2), new Color(7501432), new Color(0xC2C2C2), new Color(7501432), new Color(0xC2C2C2)} : new Color[]{new Color(0xF2F2F2), new Color(9409430), new Color(0xF2F2F2), new Color(9409430), new Color(0xF2F2F2), new Color(9409430), new Color(0xF2F2F2)};
                    float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] FOREGROUND_COLORS = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(1.0f, 1.0f, 1.0f, 0.0f)};
                    BACKGROUND_PAINT = new LinearGradientPaint(new Point2D.Double(0.0, BACKGROUND.getBounds2D().getMinY()), new Point2D.Double(0.0, BACKGROUND.getBounds2D().getMaxY()), BACKGROUND_FRACTIONS, BACKGROUND_COLORS);
                    INNER_FRAME_PAINT = new ConicalGradientPaint(true, CENTER, 0.0f, INNER_FRAME_FRACTIONS, INNER_FRAME_COLORS);
                    FOREGROUND_PAINT = new LinearGradientPaint(new Point2D.Double(0.0, STANDARD.getBounds2D().getMinY()), new Point2D.Double(0.0, STANDARD.getBounds2D().getMaxY()), FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
                    break;
                }
                case DARK_STAINLESS: {
                    float[] BACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] BACKGROUND_COLORS = new Color[]{new Color(1.0f, 1.0f, 1.0f), new Color(0.1f, 0.1f, 0.1f)};
                    float[] INNER_FRAME_FRACTIONS = new float[]{0.0f, 40.0f, 90.0f, 140.0f, 220.0f, 270.0f, 320.0f};
                    Color[] INNER_FRAME_COLORS = HOVER ? new Color[]{new Color(0xC2C2C2), new Color(7501432), new Color(0xC2C2C2), new Color(7501432), new Color(0xC2C2C2), new Color(7501432), new Color(0xC2C2C2)} : new Color[]{new Color(0xAAACAD), new Color(0x424242), new Color(0x85888A), new Color(0x474848), new Color(10397095), new Color(0x4D4F4F), new Color(0xAAACAD)};
                    float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] FOREGROUND_COLORS = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(1.0f, 1.0f, 1.0f, 0.0f)};
                    BACKGROUND_PAINT = new LinearGradientPaint(new Point2D.Double(0.0, BACKGROUND.getBounds2D().getMinY()), new Point2D.Double(0.0, BACKGROUND.getBounds2D().getMaxY()), BACKGROUND_FRACTIONS, BACKGROUND_COLORS);
                    INNER_FRAME_PAINT = new ConicalGradientPaint(true, CENTER, 0.0f, INNER_FRAME_FRACTIONS, INNER_FRAME_COLORS);
                    FOREGROUND_PAINT = new LinearGradientPaint(new Point2D.Double(0.0, STANDARD.getBounds2D().getMinY()), new Point2D.Double(0.0, STANDARD.getBounds2D().getMaxY()), FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
                    break;
                }
                default: {
                    float[] BACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] BACKGROUND_COLORS = new Color[]{UIManager.getColor("control").darker(), UIManager.getColor("control").darker().darker()};
                    float[] INNER_FRAME_FRACTIONS = new float[]{0.0f, 0.39f, 1.0f};
                    Color[] INNER_FRAME_COLORS = new Color[]{UIManager.getColor("control").brighter(), UIManager.getColor("control"), UIManager.getColor("control").brighter().brighter()};
                    float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
                    Color[] FOREGROUND_COLORS = HOVER ? new Color[]{UIManager.getColor("control").brighter(), UIManager.getColor("control").brighter().brighter()} : new Color[]{UIManager.getColor("control"), UIManager.getColor("control").brighter()};
                    BACKGROUND_PAINT = new LinearGradientPaint(new Point2D.Double(0.0, BACKGROUND.getBounds2D().getMinY()), new Point2D.Double(0.0, BACKGROUND.getBounds2D().getMaxY()), BACKGROUND_FRACTIONS, BACKGROUND_COLORS);
                    INNER_FRAME_PAINT = new LinearGradientPaint(new Point2D.Double(0.0, INNER_FRAME.getBounds2D().getMinY()), new Point2D.Double(0.0, INNER_FRAME.getBounds2D().getMaxY()), INNER_FRAME_FRACTIONS, INNER_FRAME_COLORS);
                    FOREGROUND_PAINT = new LinearGradientPaint(new Point2D.Double(0.0, STANDARD.getBounds2D().getMinY()), new Point2D.Double(0.0, STANDARD.getBounds2D().getMaxY()), FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
                }
            }
            G2.setPaint(BACKGROUND_PAINT);
            G2.fill(BACKGROUND);
            G2.setPaint(INNER_FRAME_PAINT);
            G2.fill(INNER_FRAME);
            G2.setPaint(FOREGROUND_PAINT);
            G2.fill(STANDARD);
        }
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createIndicatorImage(int WIDTH, int HEIGHT, Color COLOR, boolean LOWER, boolean HORIZONTAL) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (COLOR == null) {
            G2.setPaint(new Color(0.4f, 0.4f, 0.4f, 1.0f));
        } else {
            G2.setPaint(COLOR);
        }
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath INDICATOR = new GeneralPath();
        INDICATOR.setWindingRule(0);
        if (HORIZONTAL) {
            if (LOWER) {
                INDICATOR.moveTo(0.625 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
                INDICATOR.lineTo(0.3125 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                INDICATOR.lineTo(0.625 * (double)IMAGE_WIDTH, 0.75 * (double)IMAGE_HEIGHT);
                INDICATOR.lineTo(0.625 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
                INDICATOR.closePath();
            } else {
                INDICATOR.moveTo(0.375 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
                INDICATOR.lineTo(0.6875 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
                INDICATOR.lineTo(0.375 * (double)IMAGE_WIDTH, 0.75 * (double)IMAGE_HEIGHT);
                INDICATOR.lineTo(0.375 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
                INDICATOR.closePath();
            }
        } else if (LOWER) {
            INDICATOR.moveTo(0.75 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT);
            INDICATOR.lineTo(0.5 * (double)IMAGE_WIDTH, 0.6875 * (double)IMAGE_HEIGHT);
            INDICATOR.lineTo(0.25 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT);
            INDICATOR.lineTo(0.75 * (double)IMAGE_WIDTH, 0.375 * (double)IMAGE_HEIGHT);
            INDICATOR.closePath();
        } else {
            INDICATOR.moveTo(0.75 * (double)IMAGE_WIDTH, 0.625 * (double)IMAGE_HEIGHT);
            INDICATOR.lineTo(0.5 * (double)IMAGE_WIDTH, 0.3125 * (double)IMAGE_HEIGHT);
            INDICATOR.lineTo(0.25 * (double)IMAGE_WIDTH, 0.625 * (double)IMAGE_HEIGHT);
            INDICATOR.lineTo(0.75 * (double)IMAGE_WIDTH, 0.625 * (double)IMAGE_HEIGHT);
            INDICATOR.closePath();
        }
        G2.fill(INDICATOR);
        G2.dispose();
        return IMAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByBlock(int DIRECTION) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int blockIncrement = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (blockIncrement <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                blockIncrement = 1;
            }
            int delta = blockIncrement * (DIRECTION > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int oldValue = ((RangeSlider)this.slider).getUpperValue();
                ((RangeSlider)this.slider).setUpperValue(oldValue + delta);
            } else {
                int oldValue = this.slider.getValue();
                this.slider.setValue(oldValue + delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByUnit(int DIRECTION) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int delta = 1 * (DIRECTION > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int oldValue = ((RangeSlider)this.slider).getUpperValue();
                ((RangeSlider)this.slider).setUpperValue(oldValue + delta);
            } else {
                int oldValue = this.slider.getValue();
                this.slider.setValue(oldValue + delta);
            }
        }
    }

    private class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        private RangeTrackListener() {
            super(RangeSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent EVENT) {
            if (!RangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = EVENT.getX();
            this.currentMouseY = EVENT.getY();
            if (RangeSliderUI.this.slider.isRequestFocusEnabled()) {
                RangeSliderUI.this.slider.requestFocus();
            }
            boolean lowerPressed = false;
            boolean upperPressed = false;
            if (((RangeSlider)RangeSliderUI.this.slider).isRangeSelectionEnabled()) {
                if (RangeSliderUI.this.upperThumbSelected) {
                    if (RangeSliderUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                        upperPressed = true;
                    } else if (RangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                        lowerPressed = true;
                    }
                } else if (RangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    lowerPressed = true;
                } else if (RangeSliderUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    upperPressed = true;
                }
            } else if (RangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                lowerPressed = true;
            }
            if (lowerPressed) {
                switch (RangeSliderUI.this.slider.getOrientation()) {
                    case 0: {
                        this.offset = this.currentMouseX - ((RangeSliderUI)RangeSliderUI.this).thumbRect.x;
                        break;
                    }
                    case 1: {
                        this.offset = this.currentMouseY - ((RangeSliderUI)RangeSliderUI.this).thumbRect.y;
                    }
                }
                RangeSliderUI.this.upperThumbSelected = false;
                RangeSliderUI.this.lowerDragging = true;
                return;
            }
            RangeSliderUI.this.lowerDragging = false;
            if (upperPressed) {
                switch (RangeSliderUI.this.slider.getOrientation()) {
                    case 0: {
                        this.offset = this.currentMouseX - ((RangeSliderUI)RangeSliderUI.this).upperThumbRect.x;
                        break;
                    }
                    case 1: {
                        this.offset = this.currentMouseY - ((RangeSliderUI)RangeSliderUI.this).upperThumbRect.y;
                    }
                }
                RangeSliderUI.this.upperThumbSelected = true;
                RangeSliderUI.this.upperDragging = true;
                return;
            }
            RangeSliderUI.this.upperDragging = false;
            if (((RangeSlider)RangeSliderUI.this.slider).isRangeSelectionEnabled() && RangeSliderUI.this.RANGE.contains(EVENT.getPoint())) {
                RangeSliderUI.this.rangeDragging = true;
                RangeSliderUI.this.formerExtent = RangeSliderUI.this.slider.getExtent();
                switch (RangeSliderUI.this.slider.getOrientation()) {
                    case 0: {
                        this.offset = this.currentMouseX - (int)RangeSliderUI.this.RANGE.getMinX() + ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
                        break;
                    }
                    case 1: {
                        this.offset = RangeSliderUI.this.slider.getInverted() ? this.currentMouseY - (int)RangeSliderUI.this.RANGE.getMinY() + ((RangeSliderUI)RangeSliderUI.this).thumbRect.height / 2 : this.currentMouseY - (int)RangeSliderUI.this.RANGE.getMaxY() + ((RangeSliderUI)RangeSliderUI.this).thumbRect.height / 2;
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent EVENT) {
            RangeSliderUI.this.lowerDragging = false;
            RangeSliderUI.this.upperDragging = false;
            RangeSliderUI.this.rangeDragging = false;
            RangeSliderUI.this.slider.setValueIsAdjusting(false);
            super.mouseReleased(EVENT);
        }

        @Override
        public void mouseDragged(MouseEvent EVENT) {
            if (!RangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = EVENT.getX();
            this.currentMouseY = EVENT.getY();
            if (RangeSliderUI.this.lowerDragging) {
                RangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveLowerThumb(0);
            } else if (RangeSliderUI.this.upperDragging) {
                RangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveUpperThumb(0);
            } else if (RangeSliderUI.this.rangeDragging) {
                RangeSliderUI.this.slider.setValueIsAdjusting(true);
                if (RangeSliderUI.this.slider.getInverted()) {
                    this.moveUpperThumb(0);
                    if (RangeSliderUI.this.slider.getOrientation() == 0) {
                        this.moveLowerThumb((int)RangeSliderUI.this.RANGE.getWidth());
                    } else {
                        this.moveLowerThumb(0);
                    }
                } else {
                    this.moveLowerThumb(0);
                    if (RangeSliderUI.this.slider.getOrientation() == 0) {
                        this.moveUpperThumb((int)RangeSliderUI.this.RANGE.getWidth());
                    } else {
                        this.moveUpperThumb((int)RangeSliderUI.this.RANGE.getHeight());
                    }
                }
                RangeSliderUI.this.slider.setExtent(RangeSliderUI.this.formerExtent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent EVENT) {
            if (RangeSliderUI.this.thumbRect.contains(EVENT.getPoint())) {
                RangeSliderUI.this.lowerThumbHover = true;
                RangeSliderUI.this.slider.repaint(RangeSliderUI.this.thumbRect);
            } else {
                RangeSliderUI.this.lowerThumbHover = false;
                RangeSliderUI.this.slider.repaint(RangeSliderUI.this.thumbRect);
            }
            if (RangeSliderUI.this.upperThumbRect.contains(EVENT.getPoint())) {
                RangeSliderUI.this.upperThumbHover = true;
                RangeSliderUI.this.slider.repaint(RangeSliderUI.this.upperThumbRect);
            } else {
                RangeSliderUI.this.upperThumbHover = false;
                RangeSliderUI.this.slider.repaint(RangeSliderUI.this.upperThumbRect);
            }
            if (((RangeSlider)RangeSliderUI.this.slider).isRangeSelectionEnabled() && RangeSliderUI.this.RANGE.contains(EVENT.getPoint())) {
                RangeSliderUI.this.slider.setToolTipText("Range: " + Integer.toString(RangeSliderUI.this.slider.getExtent()));
            }
        }

        @Override
        public boolean shouldScroll(int DIRECTION) {
            return false;
        }

        private void moveLowerThumb(int ADDITIONAL_OFFSET) {
            int thumbMiddle = 0;
            switch (RangeSliderUI.this.slider.getOrientation()) {
                case 0: {
                    int halfThumbWidth = ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = this.currentMouseX - this.offset + ADDITIONAL_OFFSET;
                    int trackLeft = ((RangeSliderUI)RangeSliderUI.this).trackRect.x;
                    int trackRight = ((RangeSliderUI)RangeSliderUI.this).trackRect.x + (((RangeSliderUI)RangeSliderUI.this).trackRect.width - 1);
                    int hMax = ((RangeSlider)RangeSliderUI.this.slider).isRangeSelectionEnabled() ? RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.slider.getValue() + RangeSliderUI.this.slider.getExtent()) : RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.slider.getMaximum());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackLeft = hMax;
                    } else {
                        trackRight = hMax;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    RangeSliderUI.this.setThumbLocation(thumbLeft, ((RangeSliderUI)RangeSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    RangeSliderUI.this.slider.setValue(RangeSliderUI.this.valueForXPosition(thumbMiddle));
                    break;
                }
                case 1: {
                    int halfThumbHeight = ((RangeSliderUI)RangeSliderUI.this).thumbRect.height / 2;
                    int thumbTop = this.currentMouseY - this.offset + ADDITIONAL_OFFSET;
                    int trackTop = ((RangeSliderUI)RangeSliderUI.this).trackRect.y;
                    int trackBottom = ((RangeSliderUI)RangeSliderUI.this).trackRect.y + (((RangeSliderUI)RangeSliderUI.this).trackRect.height - 1);
                    int vMax = ((RangeSlider)RangeSliderUI.this.slider).isRangeSelectionEnabled() ? RangeSliderUI.this.yPositionForValue(RangeSliderUI.this.slider.getValue() + RangeSliderUI.this.slider.getExtent()) : RangeSliderUI.this.yPositionForValue(RangeSliderUI.this.slider.getMaximum());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackBottom = vMax;
                    } else {
                        trackTop = vMax;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    RangeSliderUI.this.setThumbLocation(((RangeSliderUI)RangeSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    RangeSliderUI.this.slider.setValue(RangeSliderUI.this.valueForYPosition(thumbMiddle));
                    break;
                }
                default: {
                    return;
                }
            }
        }

        private void moveUpperThumb(int ADDITIONAL_OFFSET) {
            int thumbMiddle = 0;
            switch (RangeSliderUI.this.slider.getOrientation()) {
                case 0: {
                    int halfThumbWidth = ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = this.currentMouseX - this.offset + ADDITIONAL_OFFSET;
                    int trackLeft = ((RangeSliderUI)RangeSliderUI.this).trackRect.x;
                    int trackRight = ((RangeSliderUI)RangeSliderUI.this).trackRect.x + (((RangeSliderUI)RangeSliderUI.this).trackRect.width - 1);
                    int hMin = RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.slider.getValue());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackRight = hMin;
                    } else {
                        trackLeft = hMin;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    RangeSliderUI.this.setUpperThumbLocation(thumbLeft, ((RangeSliderUI)RangeSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    RangeSliderUI.this.slider.setExtent(RangeSliderUI.this.valueForXPosition(thumbMiddle) - RangeSliderUI.this.slider.getValue());
                    break;
                }
                case 1: {
                    int halfThumbHeight = ((RangeSliderUI)RangeSliderUI.this).thumbRect.height / 2;
                    int thumbTop = this.currentMouseY - this.offset + ADDITIONAL_OFFSET;
                    int trackTop = ((RangeSliderUI)RangeSliderUI.this).trackRect.y;
                    int trackBottom = ((RangeSliderUI)RangeSliderUI.this).trackRect.y + (((RangeSliderUI)RangeSliderUI.this).trackRect.height - 1);
                    int vMin = RangeSliderUI.this.yPositionForValue(RangeSliderUI.this.slider.getValue());
                    if (RangeSliderUI.this.drawInverted()) {
                        trackTop = vMin;
                    } else {
                        trackBottom = vMin;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    RangeSliderUI.this.setUpperThumbLocation(((RangeSliderUI)RangeSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    RangeSliderUI.this.slider.setExtent(RangeSliderUI.this.valueForYPosition(thumbMiddle) - RangeSliderUI.this.slider.getValue());
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        private ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent EVENT) {
            if (!RangeSliderUI.this.lowerDragging && !RangeSliderUI.this.upperDragging) {
                RangeSliderUI.this.calculateThumbLocation();
                RangeSliderUI.this.slider.repaint();
            }
        }
    }
}

