/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JEditorPane;

public final class Note
extends JComponent {
    public static final String TEXT_PROPERTY = "text";
    private Color noteColor;
    private Font handwritingFont;
    private Font textFont;
    private Font customFont;
    private boolean handwritingFontEnabled;
    private boolean customFontEnabled;
    private JEditorPane notePane;
    private PropertyChangeSupport propertySupport;
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 245, 245);
    private final Point2D CENTER;
    private BufferedImage noteImage;
    private BufferedImage pushPinImage;
    private boolean pushPinVisible;
    private boolean square;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            int SIZE = Note.this.getWidth() <= Note.this.getHeight() ? Note.this.getWidth() : Note.this.getHeight();
            Container parent = Note.this.getParent();
            if (parent != null && parent.getLayout() == null) {
                if (SIZE < Note.this.getMinimumSize().width || SIZE < Note.this.getMinimumSize().height) {
                    Note.this.setSize(Note.this.getMinimumSize());
                } else if (Note.this.square) {
                    Note.this.setSize(SIZE, SIZE);
                } else {
                    Note.this.setSize(Note.this.getWidth(), Note.this.getHeight());
                }
            } else if (SIZE < Note.this.getMinimumSize().width || SIZE < Note.this.getMinimumSize().height) {
                Note.this.setPreferredSize(Note.this.getMinimumSize());
            } else if (Note.this.square) {
                Note.this.setPreferredSize(new Dimension(SIZE, SIZE));
            } else {
                Note.this.setPreferredSize(new Dimension(Note.this.getWidth(), Note.this.getHeight()));
            }
            Note.this.calcInnerBounds();
            Note.this.init(((Note)Note.this).getInnerBounds().width, ((Note)Note.this).getInnerBounds().height);
        }
    };

    public Note() {
        this.textFont = new Font("Verdana", 0, (int)(0.065 * (double)this.INNER_BOUNDS.width));
        try {
            this.handwritingFont = Font.createFont(0, this.getClass().getResourceAsStream("schoolbell.ttf"));
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(this.handwritingFont);
            this.handwritingFont = this.handwritingFont.deriveFont(0.065f * (float)this.INNER_BOUNDS.width).deriveFont(0);
            this.handwritingFontEnabled = true;
        }
        catch (FontFormatException exception) {
            this.handwritingFont = this.textFont;
            this.handwritingFontEnabled = false;
        }
        catch (IOException exception) {
            this.handwritingFont = this.textFont;
            this.handwritingFontEnabled = false;
        }
        this.customFont = this.textFont;
        this.noteColor = new Color(15857089);
        this.propertySupport = new PropertyChangeSupport(this);
        this.CENTER = new Point2D.Double();
        this.noteImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.pushPinImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.notePane = new JEditorPane();
        this.notePane.setBounds((int)(0.15918367346938775 * (double)this.INNER_BOUNDS.width), (int)(0.09387755102040816 * (double)this.INNER_BOUNDS.height), (int)(0.6530612244897959 * (double)this.INNER_BOUNDS.width), (int)(0.6530612244897959 * (double)this.INNER_BOUNDS.height));
        this.notePane.setOpaque(false);
        this.notePane.setBackground(new Color(0, 0, 0, 0));
        this.notePane.setForeground(new Color(51, 51, 51));
        this.notePane.setEditable(true);
        if (this.handwritingFontEnabled) {
            this.notePane.setFont(this.handwritingFont);
        } else {
            this.notePane.setFont(this.textFont);
        }
        this.add(this.notePane);
        this.pushPinVisible = false;
        this.square = true;
        this.setPreferredSize(new Dimension(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height));
        this.addComponentListener(this.COMPONENT_LISTENER);
    }

    public final void init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return;
        }
        if (this.noteImage != null) {
            this.noteImage.flush();
        }
        this.noteImage = this.createNoteImage(WIDTH, HEIGHT);
        if (this.pushPinImage != null) {
            this.pushPinImage.flush();
        }
        this.pushPinImage = this.createPushPinImage(WIDTH, HEIGHT);
        this.CENTER.setLocation((double)WIDTH / 2.0, (double)HEIGHT / 2.0);
        this.textFont = this.textFont.deriveFont(0.065f * (float)this.INNER_BOUNDS.width).deriveFont(0);
        this.handwritingFont = this.handwritingFont.deriveFont(0.065f * (float)this.INNER_BOUNDS.width).deriveFont(0);
        this.customFont = this.customFont.deriveFont(0.065f * (float)this.INNER_BOUNDS.width).deriveFont(0);
        this.notePane.setBounds((int)(0.15918367346938775 * (double)this.noteImage.getWidth()), (int)(0.09387755102040816 * (double)this.noteImage.getHeight()), (int)(0.6530612244897959 * (double)this.noteImage.getWidth()), (int)(0.6530612244897959 * (double)this.noteImage.getHeight()));
        if (this.customFontEnabled) {
            this.notePane.setFont(this.customFont);
        } else if (this.handwritingFontEnabled) {
            this.notePane.setFont(this.handwritingFont);
        } else {
            this.notePane.setFont(this.textFont);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        G2.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        G2.drawImage((Image)this.noteImage, 0, 0, null);
        if (this.pushPinVisible) {
            G2.drawImage((Image)this.pushPinImage, 0, 0, null);
        }
        G2.dispose();
    }

    public String getText() {
        return this.notePane.getText();
    }

    public void setText(String TEXT) {
        String oldText = this.notePane.getText();
        this.notePane.setText(TEXT);
        this.propertySupport.firePropertyChange(TEXT_PROPERTY, oldText, TEXT);
        this.repaint(this.getInnerBounds());
    }

    public Color getTextColor() {
        return this.notePane.getForeground();
    }

    public void setTextColor(Color TEXT_COLOR) {
        this.notePane.setForeground(TEXT_COLOR);
        this.repaint(this.getInnerBounds());
    }

    public Color getNoteColor() {
        return this.noteColor;
    }

    public void setNoteColor(Color NOTE_COLOR) {
        this.noteColor = NOTE_COLOR;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isHandwritingFontEnabled() {
        return this.handwritingFontEnabled;
    }

    public void setHandwritingFontEnabled(boolean HANDWRITING_FONT_ENABLED) {
        this.handwritingFontEnabled = HANDWRITING_FONT_ENABLED;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isCustomFontEnabled() {
        return this.customFontEnabled;
    }

    public void setCustomFontEnabled(boolean CUSTOM_FONT_ENABLED) {
        this.customFontEnabled = CUSTOM_FONT_ENABLED;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Font getCustomFont() {
        return this.customFont;
    }

    public void setCustomFont(Font CUSTOM_FONT) {
        this.customFont = CUSTOM_FONT;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isPushPinVisible() {
        return this.pushPinVisible;
    }

    public void setPushPinVisible(boolean PUSHPIN_VISIBLE) {
        this.pushPinVisible = PUSHPIN_VISIBLE;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener LISTENER) {
        if (this.isShowing()) {
            this.propertySupport.addPropertyChangeListener(LISTENER);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener LISTENER) {
        this.propertySupport.removePropertyChangeListener(LISTENER);
    }

    private void calcInnerBounds() {
        Insets INSETS = this.getInsets();
        this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, this.getWidth() - INSETS.left - INSETS.right, this.getHeight() - INSETS.top - INSETS.bottom);
    }

    private Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(245, 245);
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        int SIZE;
        int n = SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        if (this.square) {
            super.setPreferredSize(new Dimension(SIZE, SIZE));
        } else {
            super.setPreferredSize(DIM);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        int SIZE;
        int n = SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        if (this.square) {
            super.setSize(SIZE, SIZE);
        } else {
            super.setSize(WIDTH, HEIGHT);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(Dimension DIM) {
        int SIZE;
        int n = SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        if (this.square) {
            super.setSize(new Dimension(SIZE, SIZE));
        } else {
            super.setSize(DIM);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        int SIZE;
        int n = SIZE = BOUNDS.width <= BOUNDS.height ? BOUNDS.width : BOUNDS.height;
        if (this.square) {
            super.setBounds(BOUNDS.x, BOUNDS.y, SIZE, SIZE);
        } else {
            super.setBounds(BOUNDS);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        int SIZE;
        int n = SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        if (this.square) {
            super.setBounds(X, Y, SIZE, SIZE);
        } else {
            super.setBounds(X, Y, WIDTH, HEIGHT);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    private BufferedImage createImage(int WIDTH, int HEIGHT, int TRANSPARENCY) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, TRANSPARENCY);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, TRANSPARENCY);
        return IMAGE;
    }

    public BufferedImage createNoteImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath SHADOW = new GeneralPath();
        SHADOW.setWindingRule(0);
        SHADOW.moveTo(0.04897959183673469 * (double)IMAGE_WIDTH, 0.09387755102040816 * (double)IMAGE_HEIGHT);
        SHADOW.lineTo(0.8448979591836735 * (double)IMAGE_WIDTH, 0.061224489795918366 * (double)IMAGE_HEIGHT);
        SHADOW.curveTo(0.8448979591836735 * (double)IMAGE_WIDTH, 0.061224489795918366 * (double)IMAGE_HEIGHT, 0.8448979591836735 * (double)IMAGE_WIDTH, 0.24897959183673468 * (double)IMAGE_HEIGHT, 0.8693877551020408 * (double)IMAGE_WIDTH, 0.44081632653061226 * (double)IMAGE_HEIGHT);
        SHADOW.curveTo(0.8979591836734694 * (double)IMAGE_WIDTH, 0.6408163265306123 * (double)IMAGE_HEIGHT, 0.9591836734693877 * (double)IMAGE_WIDTH, 0.7918367346938775 * (double)IMAGE_HEIGHT, 0.9591836734693877 * (double)IMAGE_WIDTH, 0.7918367346938775 * (double)IMAGE_HEIGHT);
        SHADOW.curveTo(0.9591836734693877 * (double)IMAGE_WIDTH, 0.7918367346938775 * (double)IMAGE_HEIGHT, 0.7836734693877551 * (double)IMAGE_WIDTH, 0.8816326530612245 * (double)IMAGE_HEIGHT, 0.5510204081632653 * (double)IMAGE_WIDTH, 0.8938775510204081 * (double)IMAGE_HEIGHT);
        SHADOW.curveTo(0.31020408163265306 * (double)IMAGE_WIDTH, 0.9061224489795918 * (double)IMAGE_HEIGHT, 0.10612244897959183 * (double)IMAGE_WIDTH, 0.8693877551020408 * (double)IMAGE_HEIGHT, 0.10612244897959183 * (double)IMAGE_WIDTH, 0.8693877551020408 * (double)IMAGE_HEIGHT);
        SHADOW.curveTo(0.10612244897959183 * (double)IMAGE_WIDTH, 0.8693877551020408 * (double)IMAGE_HEIGHT, 0.08163265306122448 * (double)IMAGE_WIDTH, 0.673469387755102 * (double)IMAGE_HEIGHT, 0.0653061224489796 * (double)IMAGE_WIDTH, 0.4775510204081633 * (double)IMAGE_HEIGHT);
        SHADOW.curveTo(0.04897959183673469 * (double)IMAGE_WIDTH, 0.2938775510204082 * (double)IMAGE_HEIGHT, 0.04897959183673469 * (double)IMAGE_WIDTH, 0.09387755102040816 * (double)IMAGE_HEIGHT, 0.04897959183673469 * (double)IMAGE_WIDTH, 0.09387755102040816 * (double)IMAGE_HEIGHT);
        SHADOW.closePath();
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.563265306122449 * (double)IMAGE_WIDTH, 0.37142857142857144 * (double)IMAGE_HEIGHT), new Point2D.Double(0.08976347809529568 * (double)IMAGE_WIDTH, 0.8617540679859377 * (double)IMAGE_HEIGHT), new float[]{0.0f, 1.0f}, new Color[]{new Color(0.2f, 0.2f, 0.2f, 0.7490196f), new Color(0.0f, 0.0f, 0.0f, 0.0f)}));
        G2.fill(SHADOW);
        float NOTE_COLOR_HUE = Color.RGBtoHSB(this.noteColor.getRed(), this.noteColor.getGreen(), this.noteColor.getBlue(), null)[0];
        Color[] COLORS = new Color[]{new Color(Color.HSBtoRGB(NOTE_COLOR_HUE, 0.23f, 0.91f)), new Color(Color.HSBtoRGB(NOTE_COLOR_HUE, 0.15f, 0.96f)), new Color(Color.HSBtoRGB(NOTE_COLOR_HUE, 0.15f, 0.96f)), new Color(Color.HSBtoRGB(NOTE_COLOR_HUE, 0.32f, 0.81f))};
        GeneralPath NOTE = new GeneralPath();
        NOTE.setWindingRule(0);
        NOTE.moveTo(0.05714285714285714 * (double)IMAGE_WIDTH, 0.061224489795918366 * (double)IMAGE_HEIGHT);
        NOTE.lineTo(0.8448979591836735 * (double)IMAGE_WIDTH, 0.061224489795918366 * (double)IMAGE_HEIGHT);
        NOTE.curveTo(0.8448979591836735 * (double)IMAGE_WIDTH, 0.061224489795918366 * (double)IMAGE_HEIGHT, 0.8448979591836735 * (double)IMAGE_WIDTH, 0.24897959183673468 * (double)IMAGE_HEIGHT, 0.8693877551020408 * (double)IMAGE_WIDTH, 0.44081632653061226 * (double)IMAGE_HEIGHT);
        NOTE.curveTo(0.8979591836734694 * (double)IMAGE_WIDTH, 0.6408163265306123 * (double)IMAGE_HEIGHT, 0.9591836734693877 * (double)IMAGE_WIDTH, 0.7918367346938775 * (double)IMAGE_HEIGHT, 0.9591836734693877 * (double)IMAGE_WIDTH, 0.7918367346938775 * (double)IMAGE_HEIGHT);
        NOTE.curveTo(0.9591836734693877 * (double)IMAGE_WIDTH, 0.7918367346938775 * (double)IMAGE_HEIGHT, 0.7224489795918367 * (double)IMAGE_WIDTH, 0.8448979591836735 * (double)IMAGE_HEIGHT, 0.49387755102040815 * (double)IMAGE_WIDTH, 0.8571428571428571 * (double)IMAGE_HEIGHT);
        NOTE.curveTo(0.2530612244897959 * (double)IMAGE_WIDTH, 0.8693877551020408 * (double)IMAGE_HEIGHT, 0.1469387755102041 * (double)IMAGE_WIDTH, 0.7836734693877551 * (double)IMAGE_HEIGHT, 0.1469387755102041 * (double)IMAGE_WIDTH, 0.7836734693877551 * (double)IMAGE_HEIGHT);
        NOTE.curveTo(0.1469387755102041 * (double)IMAGE_WIDTH, 0.7836734693877551 * (double)IMAGE_HEIGHT, 0.10204081632653061 * (double)IMAGE_WIDTH, 0.673469387755102 * (double)IMAGE_HEIGHT, 0.08571428571428572 * (double)IMAGE_WIDTH, 0.4775510204081633 * (double)IMAGE_HEIGHT);
        NOTE.curveTo(0.06938775510204082 * (double)IMAGE_WIDTH, 0.2938775510204082 * (double)IMAGE_HEIGHT, 0.05714285714285714 * (double)IMAGE_WIDTH, 0.061224489795918366 * (double)IMAGE_HEIGHT, 0.05714285714285714 * (double)IMAGE_WIDTH, 0.061224489795918366 * (double)IMAGE_HEIGHT);
        NOTE.closePath();
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.7387755102040816 * (double)IMAGE_WIDTH, 0.08571428571428572 * (double)IMAGE_HEIGHT), new Point2D.Double(0.15895485003785634 * (double)IMAGE_WIDTH, 0.7767176405277312 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.33f, 0.67f, 1.0f}, COLORS));
        G2.fill(NOTE);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createPushPinImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath SHADOW = new GeneralPath();
        SHADOW.setWindingRule(1);
        SHADOW.moveTo(0.7877551020408163 * (double)IMAGE_WIDTH, 0.1510204081632653 * (double)IMAGE_HEIGHT);
        SHADOW.curveTo(0.7673469387755102 * (double)IMAGE_WIDTH, 0.1469387755102041 * (double)IMAGE_HEIGHT, 0.7551020408163265 * (double)IMAGE_WIDTH, 0.12653061224489795 * (double)IMAGE_HEIGHT, 0.7591836734693878 * (double)IMAGE_WIDTH, 0.10204081632653061 * (double)IMAGE_HEIGHT);
        SHADOW.curveTo(0.763265306122449 * (double)IMAGE_WIDTH, 0.08163265306122448 * (double)IMAGE_HEIGHT, 0.7836734693877551 * (double)IMAGE_WIDTH, 0.0653061224489796 * (double)IMAGE_HEIGHT, 0.8040816326530612 * (double)IMAGE_WIDTH, 0.06938775510204082 * (double)IMAGE_HEIGHT);
        SHADOW.curveTo(0.8244897959183674 * (double)IMAGE_WIDTH, 0.07346938775510205 * (double)IMAGE_HEIGHT, 0.8367346938775511 * (double)IMAGE_WIDTH, 0.09387755102040816 * (double)IMAGE_HEIGHT, 0.8326530612244898 * (double)IMAGE_WIDTH, 0.11836734693877551 * (double)IMAGE_HEIGHT);
        SHADOW.curveTo(0.8285714285714286 * (double)IMAGE_WIDTH, 0.13877551020408163 * (double)IMAGE_HEIGHT, 0.8081632653061225 * (double)IMAGE_WIDTH, 0.15510204081632653 * (double)IMAGE_HEIGHT, 0.7877551020408163 * (double)IMAGE_WIDTH, 0.1510204081632653 * (double)IMAGE_HEIGHT);
        SHADOW.closePath();
        G2.setPaint(new Color(0.0f, 0.0f, 0.0f, 0.2f));
        G2.fill(SHADOW);
        GeneralPath NEEDLE = new GeneralPath();
        NEEDLE.setWindingRule(1);
        NEEDLE.moveTo(0.7877551020408163 * (double)IMAGE_WIDTH, 0.12244897959183673 * (double)IMAGE_HEIGHT);
        NEEDLE.curveTo(0.7959183673469388 * (double)IMAGE_WIDTH, 0.10612244897959183 * (double)IMAGE_HEIGHT, 0.8040816326530612 * (double)IMAGE_WIDTH, 0.08571428571428572 * (double)IMAGE_HEIGHT, 0.8081632653061225 * (double)IMAGE_WIDTH, 0.06938775510204082 * (double)IMAGE_HEIGHT);
        NEEDLE.curveTo(0.8081632653061225 * (double)IMAGE_WIDTH, 0.06938775510204082 * (double)IMAGE_HEIGHT, 0.8081632653061225 * (double)IMAGE_WIDTH, 0.07346938775510205 * (double)IMAGE_HEIGHT, 0.8122448979591836 * (double)IMAGE_WIDTH, 0.07346938775510205 * (double)IMAGE_HEIGHT);
        NEEDLE.curveTo(0.8122448979591836 * (double)IMAGE_WIDTH, 0.07346938775510205 * (double)IMAGE_HEIGHT, 0.8163265306122449 * (double)IMAGE_WIDTH, 0.07346938775510205 * (double)IMAGE_HEIGHT, 0.8163265306122449 * (double)IMAGE_WIDTH, 0.07346938775510205 * (double)IMAGE_HEIGHT);
        NEEDLE.curveTo(0.8163265306122449 * (double)IMAGE_WIDTH, 0.07346938775510205 * (double)IMAGE_HEIGHT, 0.8163265306122449 * (double)IMAGE_WIDTH, 0.07346938775510205 * (double)IMAGE_HEIGHT, 0.8163265306122449 * (double)IMAGE_WIDTH, 0.07346938775510205 * (double)IMAGE_HEIGHT);
        NEEDLE.curveTo(0.8163265306122449 * (double)IMAGE_WIDTH, 0.07346938775510205 * (double)IMAGE_HEIGHT, 0.7918367346938775 * (double)IMAGE_WIDTH, 0.12244897959183673 * (double)IMAGE_HEIGHT, 0.7918367346938775 * (double)IMAGE_WIDTH, 0.12244897959183673 * (double)IMAGE_HEIGHT);
        NEEDLE.curveTo(0.7918367346938775 * (double)IMAGE_WIDTH, 0.12244897959183673 * (double)IMAGE_HEIGHT, 0.7918367346938775 * (double)IMAGE_WIDTH, 0.12244897959183673 * (double)IMAGE_HEIGHT, 0.7918367346938775 * (double)IMAGE_WIDTH, 0.12244897959183673 * (double)IMAGE_HEIGHT);
        NEEDLE.curveTo(0.7918367346938775 * (double)IMAGE_WIDTH, 0.12653061224489795 * (double)IMAGE_HEIGHT, 0.7918367346938775 * (double)IMAGE_WIDTH, 0.12653061224489795 * (double)IMAGE_HEIGHT, 0.7877551020408163 * (double)IMAGE_WIDTH, 0.12653061224489795 * (double)IMAGE_HEIGHT);
        NEEDLE.curveTo(0.7877551020408163 * (double)IMAGE_WIDTH, 0.12244897959183673 * (double)IMAGE_HEIGHT, 0.7877551020408163 * (double)IMAGE_WIDTH, 0.12244897959183673 * (double)IMAGE_HEIGHT, 0.7877551020408163 * (double)IMAGE_WIDTH, 0.12244897959183673 * (double)IMAGE_HEIGHT);
        NEEDLE.closePath();
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.7959183673469388 * (double)IMAGE_WIDTH, 0.10612244897959183 * (double)IMAGE_HEIGHT), new Point2D.Double(0.7994531649134059 * (double)IMAGE_WIDTH, 0.10816326530612246 * (double)IMAGE_HEIGHT), new float[]{0.0f, 1.0f}, new Color[]{new Color(0.2f, 0.2f, 0.2f, 1.0f), new Color(0.6f, 0.6f, 0.6f, 1.0f)}));
        G2.fill(NEEDLE);
        GeneralPath BASE = new GeneralPath();
        BASE.setWindingRule(0);
        BASE.moveTo(0.7755102040816326 * (double)IMAGE_WIDTH, 0.07346938775510205 * (double)IMAGE_HEIGHT);
        BASE.curveTo(0.7795918367346939 * (double)IMAGE_WIDTH, 0.05714285714285714 * (double)IMAGE_HEIGHT, 0.8 * (double)IMAGE_WIDTH, 0.04897959183673469 * (double)IMAGE_HEIGHT, 0.8163265306122449 * (double)IMAGE_WIDTH, 0.05714285714285714 * (double)IMAGE_HEIGHT);
        BASE.curveTo(0.8326530612244898 * (double)IMAGE_WIDTH, 0.0653061224489796 * (double)IMAGE_HEIGHT, 0.8448979591836735 * (double)IMAGE_WIDTH, 0.08163265306122448 * (double)IMAGE_HEIGHT, 0.8408163265306122 * (double)IMAGE_WIDTH, 0.09795918367346938 * (double)IMAGE_HEIGHT);
        BASE.curveTo(0.8326530612244898 * (double)IMAGE_WIDTH, 0.11020408163265306 * (double)IMAGE_HEIGHT, 0.8122448979591836 * (double)IMAGE_WIDTH, 0.11836734693877551 * (double)IMAGE_HEIGHT, 0.7959183673469388 * (double)IMAGE_WIDTH, 0.11020408163265306 * (double)IMAGE_HEIGHT);
        BASE.curveTo(0.7795918367346939 * (double)IMAGE_WIDTH, 0.10204081632653061 * (double)IMAGE_HEIGHT, 0.7673469387755102 * (double)IMAGE_WIDTH, 0.08571428571428572 * (double)IMAGE_HEIGHT, 0.7755102040816326 * (double)IMAGE_WIDTH, 0.07346938775510205 * (double)IMAGE_HEIGHT);
        BASE.closePath();
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.8122448979591836 * (double)IMAGE_WIDTH, 0.08163265306122448 * (double)IMAGE_HEIGHT), 0.03265306f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.26f, 0.27f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(0.5294118f, 0.5294118f, 0.5294118f, 1.0f)}));
        G2.fill(BASE);
        GeneralPath HANDLE = new GeneralPath();
        HANDLE.setWindingRule(0);
        HANDLE.moveTo(0.8 * (double)IMAGE_WIDTH, 0.036734693877551024 * (double)IMAGE_HEIGHT);
        HANDLE.curveTo(0.8040816326530612 * (double)IMAGE_WIDTH, 0.04081632653061224 * (double)IMAGE_HEIGHT, 0.8081632653061225 * (double)IMAGE_WIDTH, 0.04897959183673469 * (double)IMAGE_HEIGHT, 0.8081632653061225 * (double)IMAGE_WIDTH, 0.04897959183673469 * (double)IMAGE_HEIGHT);
        HANDLE.curveTo(0.8081632653061225 * (double)IMAGE_WIDTH, 0.04897959183673469 * (double)IMAGE_HEIGHT, 0.8081632653061225 * (double)IMAGE_WIDTH, 0.053061224489795916 * (double)IMAGE_HEIGHT, 0.8040816326530612 * (double)IMAGE_WIDTH, 0.05714285714285714 * (double)IMAGE_HEIGHT);
        HANDLE.curveTo(0.8 * (double)IMAGE_WIDTH, 0.0653061224489796 * (double)IMAGE_HEIGHT, 0.7959183673469388 * (double)IMAGE_WIDTH, 0.0653061224489796 * (double)IMAGE_HEIGHT, 0.7959183673469388 * (double)IMAGE_WIDTH, 0.0653061224489796 * (double)IMAGE_HEIGHT);
        HANDLE.curveTo(0.7959183673469388 * (double)IMAGE_WIDTH, 0.0653061224489796 * (double)IMAGE_HEIGHT, 0.7959183673469388 * (double)IMAGE_WIDTH, 0.06938775510204082 * (double)IMAGE_HEIGHT, 0.7959183673469388 * (double)IMAGE_WIDTH, 0.07755102040816327 * (double)IMAGE_HEIGHT);
        HANDLE.curveTo(0.8 * (double)IMAGE_WIDTH, 0.08163265306122448 * (double)IMAGE_HEIGHT, 0.8040816326530612 * (double)IMAGE_WIDTH, 0.08163265306122448 * (double)IMAGE_HEIGHT, 0.8081632653061225 * (double)IMAGE_WIDTH, 0.08571428571428572 * (double)IMAGE_HEIGHT);
        HANDLE.curveTo(0.8122448979591836 * (double)IMAGE_WIDTH, 0.08571428571428572 * (double)IMAGE_HEIGHT, 0.8163265306122449 * (double)IMAGE_WIDTH, 0.08571428571428572 * (double)IMAGE_HEIGHT, 0.8204081632653061 * (double)IMAGE_WIDTH, 0.08571428571428572 * (double)IMAGE_HEIGHT);
        HANDLE.curveTo(0.8244897959183674 * (double)IMAGE_WIDTH, 0.08571428571428572 * (double)IMAGE_HEIGHT, 0.8285714285714286 * (double)IMAGE_WIDTH, 0.08163265306122448 * (double)IMAGE_HEIGHT, 0.8285714285714286 * (double)IMAGE_WIDTH, 0.08163265306122448 * (double)IMAGE_HEIGHT);
        HANDLE.curveTo(0.8285714285714286 * (double)IMAGE_WIDTH, 0.08163265306122448 * (double)IMAGE_HEIGHT, 0.8244897959183674 * (double)IMAGE_WIDTH, 0.07346938775510205 * (double)IMAGE_HEIGHT, 0.8285714285714286 * (double)IMAGE_WIDTH, 0.0653061224489796 * (double)IMAGE_HEIGHT);
        HANDLE.curveTo(0.8326530612244898 * (double)IMAGE_WIDTH, 0.061224489795918366 * (double)IMAGE_HEIGHT, 0.8367346938775511 * (double)IMAGE_WIDTH, 0.05714285714285714 * (double)IMAGE_HEIGHT, 0.8367346938775511 * (double)IMAGE_WIDTH, 0.05714285714285714 * (double)IMAGE_HEIGHT);
        HANDLE.lineTo(0.8408163265306122 * (double)IMAGE_WIDTH, 0.053061224489795916 * (double)IMAGE_HEIGHT);
        HANDLE.lineTo(0.8448979591836735 * (double)IMAGE_WIDTH, 0.04897959183673469 * (double)IMAGE_HEIGHT);
        HANDLE.lineTo(0.8040816326530612 * (double)IMAGE_WIDTH, 0.02857142857142857 * (double)IMAGE_HEIGHT);
        HANDLE.curveTo(0.8040816326530612 * (double)IMAGE_WIDTH, 0.02857142857142857 * (double)IMAGE_HEIGHT, 0.8 * (double)IMAGE_WIDTH, 0.036734693877551024 * (double)IMAGE_HEIGHT, 0.8 * (double)IMAGE_WIDTH, 0.036734693877551024 * (double)IMAGE_HEIGHT);
        HANDLE.closePath();
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.8040816326530612 * (double)IMAGE_WIDTH, 0.05714285714285714 * (double)IMAGE_HEIGHT), new Point2D.Double(0.82645417447288 * (double)IMAGE_WIDTH, 0.06710375452430532 * (double)IMAGE_HEIGHT), new float[]{0.0f, 1.0f}, new Color[]{new Color(0.52156866f, 0.52156866f, 0.52156866f, 1.0f), new Color(0.7137255f, 0.7137255f, 0.7137255f, 1.0f)}));
        G2.fill(HANDLE);
        GeneralPath TOP_FRAME = new GeneralPath();
        TOP_FRAME.setWindingRule(0);
        TOP_FRAME.moveTo(0.8 * (double)IMAGE_WIDTH, 0.024489795918367346 * (double)IMAGE_HEIGHT);
        TOP_FRAME.curveTo(0.8040816326530612 * (double)IMAGE_WIDTH, 0.0163265306122449 * (double)IMAGE_HEIGHT, 0.8204081632653061 * (double)IMAGE_WIDTH, 0.012244897959183673 * (double)IMAGE_HEIGHT, 0.8367346938775511 * (double)IMAGE_WIDTH, 0.02040816326530612 * (double)IMAGE_HEIGHT);
        TOP_FRAME.curveTo(0.8489795918367347 * (double)IMAGE_WIDTH, 0.02857142857142857 * (double)IMAGE_HEIGHT, 0.8612244897959184 * (double)IMAGE_WIDTH, 0.04081632653061224 * (double)IMAGE_HEIGHT, 0.8571428571428571 * (double)IMAGE_WIDTH, 0.053061224489795916 * (double)IMAGE_HEIGHT);
        TOP_FRAME.curveTo(0.8530612244897959 * (double)IMAGE_WIDTH, 0.061224489795918366 * (double)IMAGE_HEIGHT, 0.8367346938775511 * (double)IMAGE_WIDTH, 0.0653061224489796 * (double)IMAGE_HEIGHT, 0.8204081632653061 * (double)IMAGE_WIDTH, 0.05714285714285714 * (double)IMAGE_HEIGHT);
        TOP_FRAME.curveTo(0.8040816326530612 * (double)IMAGE_WIDTH, 0.04897959183673469 * (double)IMAGE_HEIGHT, 0.7959183673469388 * (double)IMAGE_WIDTH, 0.0326530612244898 * (double)IMAGE_HEIGHT, 0.8 * (double)IMAGE_WIDTH, 0.024489795918367346 * (double)IMAGE_HEIGHT);
        TOP_FRAME.closePath();
        G2.setPaint(new Color(0.54901963f, 0.54901963f, 0.54901963f, 1.0f));
        G2.fill(TOP_FRAME);
        GeneralPath TOP = new GeneralPath();
        TOP.setWindingRule(0);
        TOP.moveTo(0.8040816326530612 * (double)IMAGE_WIDTH, 0.024489795918367346 * (double)IMAGE_HEIGHT);
        TOP.curveTo(0.8081632653061225 * (double)IMAGE_WIDTH, 0.0163265306122449 * (double)IMAGE_HEIGHT, 0.8204081632653061 * (double)IMAGE_WIDTH, 0.0163265306122449 * (double)IMAGE_HEIGHT, 0.8326530612244898 * (double)IMAGE_WIDTH, 0.02040816326530612 * (double)IMAGE_HEIGHT);
        TOP.curveTo(0.8489795918367347 * (double)IMAGE_WIDTH, 0.02857142857142857 * (double)IMAGE_HEIGHT, 0.8571428571428571 * (double)IMAGE_WIDTH, 0.04081632653061224 * (double)IMAGE_HEIGHT, 0.8530612244897959 * (double)IMAGE_WIDTH, 0.04897959183673469 * (double)IMAGE_HEIGHT);
        TOP.curveTo(0.8489795918367347 * (double)IMAGE_WIDTH, 0.061224489795918366 * (double)IMAGE_HEIGHT, 0.8326530612244898 * (double)IMAGE_WIDTH, 0.061224489795918366 * (double)IMAGE_HEIGHT, 0.8204081632653061 * (double)IMAGE_WIDTH, 0.053061224489795916 * (double)IMAGE_HEIGHT);
        TOP.curveTo(0.8081632653061225 * (double)IMAGE_WIDTH, 0.044897959183673466 * (double)IMAGE_HEIGHT, 0.8 * (double)IMAGE_WIDTH, 0.0326530612244898 * (double)IMAGE_HEIGHT, 0.8040816326530612 * (double)IMAGE_WIDTH, 0.024489795918367346 * (double)IMAGE_HEIGHT);
        TOP.closePath();
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.8367346938775511 * (double)IMAGE_WIDTH, 0.05714285714285714 * (double)IMAGE_HEIGHT), new Point2D.Double(0.8184730486782295 * (double)IMAGE_WIDTH, 0.016126530473189345 * (double)IMAGE_HEIGHT), new float[]{0.0f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(0.8784314f, 0.8784314f, 0.8784314f, 1.0f)}));
        G2.fill(TOP);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public String toString() {
        return "StickyNote2";
    }
}

