/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;

public class NixieNumber
extends JComponent
implements ComponentListener {
    private int number;
    private BufferedImage[] numberStack = new BufferedImage[10];
    private final float[] GLOW_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
    private final Color[] GLOW_COLORS = new Color[]{new Color(0.647f, 0.3137f, 0.0588f, 0.2f), new Color(0.9882f, 0.5921f, 0.0f, 0.3f), new Color(0.647f, 0.3137f, 0.0588f, 0.2f)};
    private LinearGradientPaint glowGradient;
    private Rectangle2D glowBox;
    private static final Color[] COLOR_ARRAY = new Color[]{new Color(1.0f, 0.6f, 0.0f, 0.9f), new Color(1.0f, 0.4f, 0.0f, 0.8f), new Color(1.0f, 0.4f, 0.0f, 0.4f), new Color(1.0f, 0.4f, 0.0f, 0.15f), new Color(1.0f, 0.4f, 0.0f, 0.1f), new Color(1.0f, 0.4f, 0.0f, 0.05f)};
    private final ArrayList<BufferedImage> INACTIVE_NUMBER_ARRAY = new ArrayList(10);
    private final ArrayList<BufferedImage> ACTIVE_NUMBER_ARRAY = new ArrayList(10);

    public NixieNumber() {
        this.addComponentListener(this);
        this.number = -1;
        this.setPreferredSize(new Dimension(43, 73));
        this.init();
    }

    private void init() {
        this.glowGradient = this.createGlowGradient(this.getPreferredSize().width);
        this.glowBox = this.createGlowBox(this.getPreferredSize().width);
        this.createAllNumbers();
        this.createNumberStack();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.number > -1) {
            g2.setPaint(this.glowGradient);
            g2.fill(this.glowBox);
        }
        for (int i = 0; i < 10; ++i) {
            g2.drawImage((Image)this.numberStack[i], (int)((double)this.getWidth() * -0.06), 0, null);
        }
        g2.drawImage((Image)this.createHatchImage(this.getPreferredSize().width), 0, 0, null);
        g2.drawImage((Image)this.createBackgroundImage(this.getPreferredSize().width), 0, 0, null);
        g2.dispose();
    }

    private BufferedImage createBackgroundImage(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, (int)(1.697674418604651 * (double)WIDTH), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath TUBE = new GeneralPath();
        TUBE.setWindingRule(0);
        TUBE.moveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.3493150684931507);
        TUBE.curveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.3493150684931507, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.636986301369863, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.636986301369863);
        TUBE.lineTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.6986301369863014);
        TUBE.curveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.6986301369863014, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.8767123287671232, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.8767123287671232);
        TUBE.curveTo((double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.9452054794520548, (double)IMAGE_WIDTH * 0.09302325581395349, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.20930232558139536, (double)IMAGE_HEIGHT * 1.0);
        TUBE.curveTo((double)IMAGE_WIDTH * 0.20930232558139536, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.8023255813953488, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 0.8023255813953488, (double)IMAGE_HEIGHT * 1.0);
        TUBE.curveTo((double)IMAGE_WIDTH * 0.9069767441860465, (double)IMAGE_HEIGHT * 1.0, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.9452054794520548, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.8767123287671232);
        TUBE.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.8767123287671232, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.6986301369863014, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.6986301369863014);
        TUBE.lineTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.636986301369863);
        TUBE.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.636986301369863, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.3493150684931507, (double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.3493150684931507);
        TUBE.curveTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.19863013698630136, (double)IMAGE_WIDTH * 0.813953488372093, (double)IMAGE_HEIGHT * 0.07534246575342465, (double)IMAGE_WIDTH * 0.5697674418604651, (double)IMAGE_HEIGHT * 0.0547945205479452);
        TUBE.curveTo((double)IMAGE_WIDTH * 0.5697674418604651, (double)IMAGE_HEIGHT * 0.0273972602739726, (double)IMAGE_WIDTH * 0.5348837209302325, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.0);
        TUBE.curveTo((double)IMAGE_WIDTH * 0.46511627906976744, (double)IMAGE_HEIGHT * 0.0, (double)IMAGE_WIDTH * 0.43023255813953487, (double)IMAGE_HEIGHT * 0.0273972602739726, (double)IMAGE_WIDTH * 0.43023255813953487, (double)IMAGE_HEIGHT * 0.0547945205479452);
        TUBE.curveTo((double)IMAGE_WIDTH * 0.18604651162790697, (double)IMAGE_HEIGHT * 0.07534246575342465, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.19863013698630136, (double)IMAGE_WIDTH * 0.0, (double)IMAGE_HEIGHT * 0.3493150684931507);
        TUBE.closePath();
        Point2D.Double TUBE_START = new Point2D.Double(TUBE.getBounds2D().getMinX(), 0.0);
        Point2D.Double TUBE_STOP = new Point2D.Double(TUBE.getBounds2D().getMaxX(), 0.0);
        float[] TUBE_FRACTIONS = new float[]{0.0f, 0.06f, 0.07f, 0.35f, 0.36f, 0.66f, 0.67f, 0.92f, 1.0f};
        Color[] TUBE_COLORS = new Color[]{new Color(0, 0, 0, 128), new Color(0, 0, 0, 77), new Color(0, 0, 0, 75), new Color(0, 0, 0, 26), new Color(0, 0, 0, 26), new Color(0, 0, 0, 26), new Color(0, 0, 0, 26), new Color(0, 0, 0, 130), new Color(0, 0, 0, 153)};
        if (TUBE_START.distance(TUBE_STOP) > 0.0) {
            LinearGradientPaint TUBE_GRADIENT = new LinearGradientPaint(TUBE_START, TUBE_STOP, TUBE_FRACTIONS, TUBE_COLORS);
            G2.setPaint(TUBE_GRADIENT);
            G2.fill(TUBE);
        }
        GeneralPath SIDELIGHTEFFECT = new GeneralPath();
        SIDELIGHTEFFECT.setWindingRule(0);
        SIDELIGHTEFFECT.moveTo((double)IMAGE_WIDTH * 0.023255813953488372, (double)IMAGE_HEIGHT * 0.3287671232876712);
        SIDELIGHTEFFECT.curveTo((double)IMAGE_WIDTH * 0.023255813953488372, (double)IMAGE_HEIGHT * 0.3287671232876712, (double)IMAGE_WIDTH * 0.023255813953488372, (double)IMAGE_HEIGHT * 0.8356164383561644, (double)IMAGE_WIDTH * 0.023255813953488372, (double)IMAGE_HEIGHT * 0.8356164383561644);
        SIDELIGHTEFFECT.curveTo((double)IMAGE_WIDTH * 0.023255813953488372, (double)IMAGE_HEIGHT * 0.910958904109589, (double)IMAGE_WIDTH * 0.11627906976744186, (double)IMAGE_HEIGHT * 0.9657534246575342, (double)IMAGE_WIDTH * 0.2441860465116279, (double)IMAGE_HEIGHT * 0.9657534246575342);
        SIDELIGHTEFFECT.curveTo((double)IMAGE_WIDTH * 0.2441860465116279, (double)IMAGE_HEIGHT * 0.9657534246575342, (double)IMAGE_WIDTH * 0.2558139534883721, (double)IMAGE_HEIGHT * 0.9657534246575342, (double)IMAGE_WIDTH * 0.26744186046511625, (double)IMAGE_HEIGHT * 0.9657534246575342);
        SIDELIGHTEFFECT.curveTo((double)IMAGE_WIDTH * 0.1511627906976744, (double)IMAGE_HEIGHT * 0.958904109589041, (double)IMAGE_WIDTH * 0.06976744186046512, (double)IMAGE_HEIGHT * 0.9041095890410958, (double)IMAGE_WIDTH * 0.06976744186046512, (double)IMAGE_HEIGHT * 0.8356164383561644);
        SIDELIGHTEFFECT.curveTo((double)IMAGE_WIDTH * 0.06976744186046512, (double)IMAGE_HEIGHT * 0.8356164383561644, (double)IMAGE_WIDTH * 0.06976744186046512, (double)IMAGE_HEIGHT * 0.3287671232876712, (double)IMAGE_WIDTH * 0.06976744186046512, (double)IMAGE_HEIGHT * 0.3287671232876712);
        SIDELIGHTEFFECT.curveTo((double)IMAGE_WIDTH * 0.06976744186046512, (double)IMAGE_HEIGHT * 0.2602739726027397, (double)IMAGE_WIDTH * 0.1511627906976744, (double)IMAGE_HEIGHT * 0.2054794520547945, (double)IMAGE_WIDTH * 0.26744186046511625, (double)IMAGE_HEIGHT * 0.19863013698630136);
        SIDELIGHTEFFECT.curveTo((double)IMAGE_WIDTH * 0.2558139534883721, (double)IMAGE_HEIGHT * 0.19863013698630136, (double)IMAGE_WIDTH * 0.2441860465116279, (double)IMAGE_HEIGHT * 0.19863013698630136, (double)IMAGE_WIDTH * 0.2441860465116279, (double)IMAGE_HEIGHT * 0.19863013698630136);
        SIDELIGHTEFFECT.curveTo((double)IMAGE_WIDTH * 0.11627906976744186, (double)IMAGE_HEIGHT * 0.19863013698630136, (double)IMAGE_WIDTH * 0.023255813953488372, (double)IMAGE_HEIGHT * 0.2602739726027397, (double)IMAGE_WIDTH * 0.023255813953488372, (double)IMAGE_HEIGHT * 0.3287671232876712);
        SIDELIGHTEFFECT.closePath();
        Point2D.Double SIDELIGHTEFFECT_START = new Point2D.Double(SIDELIGHTEFFECT.getBounds2D().getMinX(), 0.0);
        Point2D.Double SIDELIGHTEFFECT_STOP = new Point2D.Double(SIDELIGHTEFFECT.getBounds2D().getMaxX(), 0.0);
        float[] SIDELIGHTEFFECT_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] SIDELIGHTEFFECT_COLORS = new Color[]{new Color(255, 255, 255, 127), new Color(255, 255, 255, 0)};
        if (SIDELIGHTEFFECT_START.distance(SIDELIGHTEFFECT_STOP) > 0.0) {
            LinearGradientPaint SIDELIGHTEFFECT_GRADIENT = new LinearGradientPaint(SIDELIGHTEFFECT_START, SIDELIGHTEFFECT_STOP, SIDELIGHTEFFECT_FRACTIONS, SIDELIGHTEFFECT_COLORS);
            G2.setPaint(SIDELIGHTEFFECT_GRADIENT);
            G2.fill(SIDELIGHTEFFECT);
        }
        GeneralPath STRIPELIGHTEFFECT = new GeneralPath();
        STRIPELIGHTEFFECT.setWindingRule(0);
        STRIPELIGHTEFFECT.moveTo((double)IMAGE_WIDTH * 0.13953488372093023, (double)IMAGE_HEIGHT * 0.2602739726027397);
        STRIPELIGHTEFFECT.lineTo((double)IMAGE_WIDTH * 0.8604651162790697, (double)IMAGE_HEIGHT * 0.2602739726027397);
        STRIPELIGHTEFFECT.lineTo((double)IMAGE_WIDTH * 0.8604651162790697, (double)IMAGE_HEIGHT * 0.2671232876712329);
        STRIPELIGHTEFFECT.lineTo((double)IMAGE_WIDTH * 0.13953488372093023, (double)IMAGE_HEIGHT * 0.2671232876712329);
        STRIPELIGHTEFFECT.lineTo((double)IMAGE_WIDTH * 0.13953488372093023, (double)IMAGE_HEIGHT * 0.2602739726027397);
        STRIPELIGHTEFFECT.closePath();
        Point2D.Double STRIPELIGHTEFFECT_START = new Point2D.Double(STRIPELIGHTEFFECT.getBounds2D().getMinX(), 0.0);
        Point2D.Double STRIPELIGHTEFFECT_STOP = new Point2D.Double(STRIPELIGHTEFFECT.getBounds2D().getMaxX(), 0.0);
        float[] STRIPELIGHTEFFECT_FRACTIONS = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        Color[] STRIPELIGHTEFFECT_COLORS = new Color[]{new Color(255, 255, 255, 0), new Color(255, 255, 255, 124), new Color(255, 255, 255, 127), new Color(255, 255, 255, 0)};
        if (STRIPELIGHTEFFECT_START.distance(STRIPELIGHTEFFECT_STOP) > 0.0) {
            LinearGradientPaint STRIPELIGHTEFFECT_GRADIENT = new LinearGradientPaint(STRIPELIGHTEFFECT_START, STRIPELIGHTEFFECT_STOP, STRIPELIGHTEFFECT_FRACTIONS, STRIPELIGHTEFFECT_COLORS);
            G2.setPaint(STRIPELIGHTEFFECT_GRADIENT);
            G2.fill(STRIPELIGHTEFFECT);
        }
        GeneralPath NUPSILIGHTREFLEX = new GeneralPath();
        NUPSILIGHTREFLEX.setWindingRule(0);
        NUPSILIGHTREFLEX.moveTo((double)IMAGE_WIDTH * 0.45348837209302323, (double)IMAGE_HEIGHT * 0.0410958904109589);
        NUPSILIGHTREFLEX.curveTo((double)IMAGE_WIDTH * 0.46511627906976744, (double)IMAGE_HEIGHT * 0.0273972602739726, (double)IMAGE_WIDTH * 0.47674418604651164, (double)IMAGE_HEIGHT * 0.02054794520547945, (double)IMAGE_WIDTH * 0.4883720930232558, (double)IMAGE_HEIGHT * 0.0273972602739726);
        NUPSILIGHTREFLEX.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.0273972602739726, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.03424657534246575, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.04794520547945205);
        NUPSILIGHTREFLEX.curveTo((double)IMAGE_WIDTH * 0.4883720930232558, (double)IMAGE_HEIGHT * 0.06164383561643835, (double)IMAGE_WIDTH * 0.47674418604651164, (double)IMAGE_HEIGHT * 0.0684931506849315, (double)IMAGE_WIDTH * 0.46511627906976744, (double)IMAGE_HEIGHT * 0.0684931506849315);
        NUPSILIGHTREFLEX.curveTo((double)IMAGE_WIDTH * 0.45348837209302323, (double)IMAGE_HEIGHT * 0.06164383561643835, (double)IMAGE_WIDTH * 0.4418604651162791, (double)IMAGE_HEIGHT * 0.0547945205479452, (double)IMAGE_WIDTH * 0.45348837209302323, (double)IMAGE_HEIGHT * 0.0410958904109589);
        NUPSILIGHTREFLEX.closePath();
        Point2D.Double NUPSILIGHTREFLEX_START = new Point2D.Double(0.4883720930232558 * (double)IMAGE_WIDTH, 0.0273972602739726 * (double)IMAGE_HEIGHT);
        Point2D.Double NUPSILIGHTREFLEX_STOP = new Point2D.Double(0.466812767834306 * (double)IMAGE_WIDTH, 0.0664817746422666 * (double)IMAGE_HEIGHT);
        float[] NUPSILIGHTREFLEX_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] NUPSILIGHTREFLEX_COLORS = new Color[]{new Color(255, 255, 255, 76), new Color(255, 255, 255, 0)};
        if (NUPSILIGHTREFLEX_START.distance(NUPSILIGHTREFLEX_STOP) > 0.0) {
            LinearGradientPaint NUPSILIGHTREFLEX_GRADIENT = new LinearGradientPaint(NUPSILIGHTREFLEX_START, NUPSILIGHTREFLEX_STOP, NUPSILIGHTREFLEX_FRACTIONS, NUPSILIGHTREFLEX_COLORS);
            G2.setPaint(NUPSILIGHTREFLEX_GRADIENT);
            G2.fill(NUPSILIGHTREFLEX);
        }
        GeneralPath TOPLIGHTREFLEX = new GeneralPath();
        TOPLIGHTREFLEX.setWindingRule(0);
        TOPLIGHTREFLEX.moveTo((double)IMAGE_WIDTH * 0.19767441860465115, (double)IMAGE_HEIGHT * 0.1506849315068493);
        TOPLIGHTREFLEX.curveTo((double)IMAGE_WIDTH * 0.19767441860465115, (double)IMAGE_HEIGHT * 0.1095890410958904, (double)IMAGE_WIDTH * 0.3372093023255814, (double)IMAGE_HEIGHT * 0.07534246575342465, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.07534246575342465);
        TOPLIGHTREFLEX.curveTo((double)IMAGE_WIDTH * 0.6627906976744186, (double)IMAGE_HEIGHT * 0.07534246575342465, (double)IMAGE_WIDTH * 0.8023255813953488, (double)IMAGE_HEIGHT * 0.1095890410958904, (double)IMAGE_WIDTH * 0.8023255813953488, (double)IMAGE_HEIGHT * 0.1506849315068493);
        TOPLIGHTREFLEX.curveTo((double)IMAGE_WIDTH * 0.8023255813953488, (double)IMAGE_HEIGHT * 0.18493150684931506, (double)IMAGE_WIDTH * 0.6627906976744186, (double)IMAGE_HEIGHT * 0.2191780821917808, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.2191780821917808);
        TOPLIGHTREFLEX.curveTo((double)IMAGE_WIDTH * 0.3372093023255814, (double)IMAGE_HEIGHT * 0.2191780821917808, (double)IMAGE_WIDTH * 0.19767441860465115, (double)IMAGE_HEIGHT * 0.18493150684931506, (double)IMAGE_WIDTH * 0.19767441860465115, (double)IMAGE_HEIGHT * 0.1506849315068493);
        TOPLIGHTREFLEX.closePath();
        Point2D.Double TOPLIGHTREFLEX_START = new Point2D.Double(0.0, TOPLIGHTREFLEX.getBounds2D().getMinY());
        Point2D.Double TOPLIGHTREFLEX_STOP = new Point2D.Double(0.0, TOPLIGHTREFLEX.getBounds2D().getMaxY());
        float[] TOPLIGHTREFLEX_FRACTIONS = new float[]{0.0f, 0.98f, 1.0f};
        Color[] TOPLIGHTREFLEX_COLORS = new Color[]{new Color(255, 255, 255, 127), new Color(255, 255, 255, 1), new Color(255, 255, 255, 0)};
        if (TOPLIGHTREFLEX_START.distance(TOPLIGHTREFLEX_STOP) > 0.0) {
            LinearGradientPaint TOPLIGHTREFLEX_GRADIENT = new LinearGradientPaint(TOPLIGHTREFLEX_START, TOPLIGHTREFLEX_STOP, TOPLIGHTREFLEX_FRACTIONS, TOPLIGHTREFLEX_COLORS);
            G2.setPaint(TOPLIGHTREFLEX_GRADIENT);
            G2.fill(TOPLIGHTREFLEX);
        }
        G2.dispose();
        return IMAGE;
    }

    private LinearGradientPaint createGlowGradient(int GLOW_WIDTH) {
        int GLOW_HEIGHT = (int)(1.697674418604651 * (double)GLOW_WIDTH);
        Point2D.Float GLOW_START = new Point2D.Float(0.0f, (float)GLOW_HEIGHT * 0.3219178f);
        Point2D.Float GLOW_STOP = new Point2D.Float(0.0f, (float)GLOW_HEIGHT * 0.9109589f);
        return new LinearGradientPaint(GLOW_START, GLOW_STOP, this.GLOW_FRACTIONS, this.GLOW_COLORS);
    }

    private Rectangle2D createGlowBox(int GLOW_WIDTH) {
        int GLOW_HEIGHT = (int)(1.697674418604651 * (double)GLOW_WIDTH);
        return new Rectangle2D.Float((float)GLOW_WIDTH * 0.15116279f, (float)GLOW_HEIGHT * 0.3219178f, (float)GLOW_WIDTH * 0.6976744f, (float)GLOW_HEIGHT * 0.5890411f);
    }

    private BufferedImage createHatchImage(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, (int)(1.697674418604651 * (double)WIDTH), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        G2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.2f));
        for (int x = (int)((double)IMAGE_WIDTH * 0.1627907); x <= (int)((double)IMAGE_WIDTH * 0.87209302); x += (int)((double)IMAGE_WIDTH * 0.05813953)) {
            G2.draw(new Line2D.Float(x, (float)IMAGE_HEIGHT * 0.3219178f, x, (float)IMAGE_HEIGHT * 0.9109589f));
        }
        for (int y = (int)((double)IMAGE_HEIGHT * 0.32191781); y <= (int)((double)IMAGE_HEIGHT * 0.91780822); y += (int)((double)IMAGE_HEIGHT * 0.03424658)) {
            G2.draw(new Line2D.Float((float)IMAGE_WIDTH * 0.1627907f, y, (float)IMAGE_WIDTH * 0.8604651f, y));
        }
        float[] CONTACT_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
        Color[] CONTACT_COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(1.0f, 1.0f, 1.0f, 0.3f), new Color(0.0f, 0.0f, 0.0f, 0.3f)};
        for (int x = (int)((double)IMAGE_WIDTH * 0.20930233); x < (int)((double)IMAGE_WIDTH * 0.77906977); x += (int)((double)IMAGE_WIDTH * 0.06976744)) {
            Point2D.Float contactStart = new Point2D.Float(x, 0.0f);
            Point2D.Float contactStop = new Point2D.Float((float)x + (float)IMAGE_WIDTH * 0.03488372f, 0.0f);
            LinearGradientPaint contactGradient = new LinearGradientPaint(contactStart, contactStop, CONTACT_FRACTIONS, CONTACT_COLORS);
            G2.setPaint(contactGradient);
            G2.fill(new Rectangle2D.Float(x, (float)IMAGE_HEIGHT * 0.9041096f, (float)IMAGE_WIDTH * 0.04651163f, (float)IMAGE_HEIGHT * 0.06849315f));
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage createNumber(int number, boolean active, int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, (int)(1.697674418604651 * (double)WIDTH), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath numberPath = new GeneralPath();
        switch (number) {
            case 0: {
                numberPath.moveTo((double)IMAGE_WIDTH * 0.2441860465116279, (double)IMAGE_HEIGHT * 0.5821917808219178);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.2441860465116279, (double)IMAGE_HEIGHT * 0.4383561643835616, (double)IMAGE_WIDTH * 0.36046511627906974, (double)IMAGE_HEIGHT * 0.3150684931506849, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.3150684931506849);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.6627906976744186, (double)IMAGE_HEIGHT * 0.3150684931506849, (double)IMAGE_WIDTH * 0.7790697674418605, (double)IMAGE_HEIGHT * 0.4383561643835616, (double)IMAGE_WIDTH * 0.7790697674418605, (double)IMAGE_HEIGHT * 0.5821917808219178);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.7790697674418605, (double)IMAGE_HEIGHT * 0.726027397260274, (double)IMAGE_WIDTH * 0.6627906976744186, (double)IMAGE_HEIGHT * 0.8493150684931506, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.8493150684931506);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.36046511627906974, (double)IMAGE_HEIGHT * 0.8493150684931506, (double)IMAGE_WIDTH * 0.2441860465116279, (double)IMAGE_HEIGHT * 0.726027397260274, (double)IMAGE_WIDTH * 0.2441860465116279, (double)IMAGE_HEIGHT * 0.5821917808219178);
                numberPath.closePath();
                break;
            }
            case 1: {
                numberPath.moveTo((double)IMAGE_WIDTH * 0.4883720930232558, (double)IMAGE_HEIGHT * 0.3013698630136986);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.4883720930232558, (double)IMAGE_HEIGHT * 0.2876712328767123, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.2808219178082192, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.2808219178082192);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.2808219178082192, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.2808219178082192, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.2808219178082192);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.2808219178082192, (double)IMAGE_WIDTH * 0.5232558139534884, (double)IMAGE_HEIGHT * 0.2876712328767123, (double)IMAGE_WIDTH * 0.5232558139534884, (double)IMAGE_HEIGHT * 0.3013698630136986);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.5232558139534884, (double)IMAGE_HEIGHT * 0.3013698630136986, (double)IMAGE_WIDTH * 0.5232558139534884, (double)IMAGE_HEIGHT * 0.8493150684931506, (double)IMAGE_WIDTH * 0.5232558139534884, (double)IMAGE_HEIGHT * 0.8493150684931506);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.5232558139534884, (double)IMAGE_HEIGHT * 0.863013698630137, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.8698630136986302, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.8698630136986302);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.8698630136986302, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.8698630136986302, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.8698630136986302);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8698630136986302, (double)IMAGE_WIDTH * 0.4883720930232558, (double)IMAGE_HEIGHT * 0.863013698630137, (double)IMAGE_WIDTH * 0.4883720930232558, (double)IMAGE_HEIGHT * 0.8493150684931506);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.4883720930232558, (double)IMAGE_HEIGHT * 0.8493150684931506, (double)IMAGE_WIDTH * 0.4883720930232558, (double)IMAGE_HEIGHT * 0.3013698630136986, (double)IMAGE_WIDTH * 0.4883720930232558, (double)IMAGE_HEIGHT * 0.3013698630136986);
                numberPath.closePath();
                break;
            }
            case 2: {
                numberPath.moveTo((double)IMAGE_WIDTH * 0.23255813953488372, (double)IMAGE_HEIGHT * 0.4726027397260274);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.23255813953488372, (double)IMAGE_HEIGHT * 0.4246575342465753);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.26744186046511625, (double)IMAGE_HEIGHT * 0.3904109589041096);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.3023255813953488, (double)IMAGE_HEIGHT * 0.3698630136986301);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.3488372093023256, (double)IMAGE_HEIGHT * 0.3424657534246575);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.4069767441860465, (double)IMAGE_HEIGHT * 0.3287671232876712);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.4883720930232558, (double)IMAGE_HEIGHT * 0.3150684931506849);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.5581395348837209, (double)IMAGE_HEIGHT * 0.3219178082191781);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.627906976744186, (double)IMAGE_HEIGHT * 0.3287671232876712);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7093023255813954, (double)IMAGE_HEIGHT * 0.3561643835616438);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7441860465116279, (double)IMAGE_HEIGHT * 0.3972602739726027);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7674418604651163, (double)IMAGE_HEIGHT * 0.4452054794520548);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7558139534883721, (double)IMAGE_HEIGHT * 0.4863013698630137);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.7558139534883721, (double)IMAGE_HEIGHT * 0.4863013698630137, (double)IMAGE_WIDTH * 0.7325581395348837, (double)IMAGE_HEIGHT * 0.5342465753424658, (double)IMAGE_WIDTH * 0.7325581395348837, (double)IMAGE_HEIGHT * 0.5273972602739726);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.7209302325581395, (double)IMAGE_HEIGHT * 0.5273972602739726, (double)IMAGE_WIDTH * 0.686046511627907, (double)IMAGE_HEIGHT * 0.547945205479452, (double)IMAGE_WIDTH * 0.686046511627907, (double)IMAGE_HEIGHT * 0.547945205479452);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.6162790697674418, (double)IMAGE_HEIGHT * 0.5616438356164384);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.5348837209302325, (double)IMAGE_HEIGHT * 0.5821917808219178);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.45348837209302323, (double)IMAGE_HEIGHT * 0.6027397260273972);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.36046511627906974, (double)IMAGE_HEIGHT * 0.6438356164383562);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.3023255813953488, (double)IMAGE_HEIGHT * 0.6986301369863014);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.2558139534883721, (double)IMAGE_HEIGHT * 0.7397260273972602);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.2441860465116279, (double)IMAGE_HEIGHT * 0.7945205479452054);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.23255813953488372, (double)IMAGE_HEIGHT * 0.8424657534246576);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7906976744186046, (double)IMAGE_HEIGHT * 0.8424657534246576);
                break;
            }
            case 3: {
                numberPath.moveTo((double)IMAGE_WIDTH * 0.23255813953488372, (double)IMAGE_HEIGHT * 0.3150684931506849);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7558139534883721, (double)IMAGE_HEIGHT * 0.3150684931506849);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7558139534883721, (double)IMAGE_HEIGHT * 0.3287671232876712);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.5232558139534884, (double)IMAGE_HEIGHT * 0.5068493150684932);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.5581395348837209, (double)IMAGE_HEIGHT * 0.5205479452054794);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.6046511627906976, (double)IMAGE_HEIGHT * 0.5273972602739726);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.6744186046511628, (double)IMAGE_HEIGHT * 0.5547945205479452);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7209302325581395, (double)IMAGE_HEIGHT * 0.5958904109589042);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7674418604651163, (double)IMAGE_HEIGHT * 0.6438356164383562);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7674418604651163, (double)IMAGE_HEIGHT * 0.6917808219178082);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7558139534883721, (double)IMAGE_HEIGHT * 0.7397260273972602);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7325581395348837, (double)IMAGE_HEIGHT * 0.7671232876712328);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.7325581395348837, (double)IMAGE_HEIGHT * 0.7671232876712328, (double)IMAGE_WIDTH * 0.686046511627907, (double)IMAGE_HEIGHT * 0.7945205479452054, (double)IMAGE_WIDTH * 0.6976744186046512, (double)IMAGE_HEIGHT * 0.7945205479452054);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.6976744186046512, (double)IMAGE_HEIGHT * 0.8013698630136986, (double)IMAGE_WIDTH * 0.6395348837209303, (double)IMAGE_HEIGHT * 0.821917808219178, (double)IMAGE_WIDTH * 0.6395348837209303, (double)IMAGE_HEIGHT * 0.821917808219178);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.5697674418604651, (double)IMAGE_HEIGHT * 0.8424657534246576);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.8493150684931506);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.45348837209302323, (double)IMAGE_HEIGHT * 0.8493150684931506);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.3953488372093023, (double)IMAGE_HEIGHT * 0.8424657534246576);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.3372093023255814, (double)IMAGE_HEIGHT * 0.821917808219178);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.29069767441860467, (double)IMAGE_HEIGHT * 0.8082191780821918);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.23255813953488372, (double)IMAGE_HEIGHT * 0.7671232876712328);
                break;
            }
            case 4: {
                numberPath.moveTo((double)IMAGE_WIDTH * 0.7790697674418605, (double)IMAGE_HEIGHT * 0.684931506849315);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.2441860465116279, (double)IMAGE_HEIGHT * 0.684931506849315);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.2441860465116279, (double)IMAGE_HEIGHT * 0.684931506849315, (double)IMAGE_WIDTH * 0.23255813953488372, (double)IMAGE_HEIGHT * 0.6712328767123288, (double)IMAGE_WIDTH * 0.22093023255813954, (double)IMAGE_HEIGHT * 0.678082191780822);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.22093023255813954, (double)IMAGE_HEIGHT * 0.678082191780822, (double)IMAGE_WIDTH * 0.20930232558139536, (double)IMAGE_HEIGHT * 0.6643835616438356, (double)IMAGE_WIDTH * 0.20930232558139536, (double)IMAGE_HEIGHT * 0.6643835616438356);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.6046511627906976, (double)IMAGE_HEIGHT * 0.3013698630136986);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.6046511627906976, (double)IMAGE_HEIGHT * 0.8493150684931506);
                break;
            }
            case 5: {
                numberPath.moveTo((double)IMAGE_WIDTH * 0.7093023255813954, (double)IMAGE_HEIGHT * 0.3219178082191781);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.313953488372093, (double)IMAGE_HEIGHT * 0.3219178082191781);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.26744186046511625, (double)IMAGE_HEIGHT * 0.5616438356164384);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.29069767441860467, (double)IMAGE_HEIGHT * 0.5616438356164384);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.36046511627906974, (double)IMAGE_HEIGHT * 0.5342465753424658);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.4418604651162791, (double)IMAGE_HEIGHT * 0.5205479452054794);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.5465116279069767, (double)IMAGE_HEIGHT * 0.5273972602739726);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.6162790697674418, (double)IMAGE_HEIGHT * 0.547945205479452);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.6976744186046512, (double)IMAGE_HEIGHT * 0.589041095890411);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7558139534883721, (double)IMAGE_HEIGHT * 0.6506849315068494);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7674418604651163, (double)IMAGE_HEIGHT * 0.6986301369863014);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7441860465116279, (double)IMAGE_HEIGHT * 0.7465753424657534);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7093023255813954, (double)IMAGE_HEIGHT * 0.7945205479452054);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.6395348837209303, (double)IMAGE_HEIGHT * 0.821917808219178);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.5465116279069767, (double)IMAGE_HEIGHT * 0.8424657534246576);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.47674418604651164, (double)IMAGE_HEIGHT * 0.8493150684931506);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.4069767441860465, (double)IMAGE_HEIGHT * 0.8424657534246576);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.3372093023255814, (double)IMAGE_HEIGHT * 0.821917808219178);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.26744186046511625, (double)IMAGE_HEIGHT * 0.7876712328767124);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.23255813953488372, (double)IMAGE_HEIGHT * 0.7534246575342466);
                break;
            }
            case 6: {
                numberPath.moveTo((double)IMAGE_WIDTH * 0.5232558139534884, (double)IMAGE_HEIGHT * 0.2808219178082192);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.2441860465116279, (double)IMAGE_HEIGHT * 0.6095890410958904);
                numberPath.moveTo((double)IMAGE_WIDTH * 0.22093023255813954, (double)IMAGE_HEIGHT * 0.678082191780822);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.22093023255813954, (double)IMAGE_HEIGHT * 0.5821917808219178, (double)IMAGE_WIDTH * 0.3488372093023256, (double)IMAGE_HEIGHT * 0.5136986301369864, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.5136986301369864);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.6627906976744186, (double)IMAGE_HEIGHT * 0.5136986301369864, (double)IMAGE_WIDTH * 0.7906976744186046, (double)IMAGE_HEIGHT * 0.5821917808219178, (double)IMAGE_WIDTH * 0.7906976744186046, (double)IMAGE_HEIGHT * 0.678082191780822);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.7906976744186046, (double)IMAGE_HEIGHT * 0.7671232876712328, (double)IMAGE_WIDTH * 0.6627906976744186, (double)IMAGE_HEIGHT * 0.8424657534246576, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.8424657534246576);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.3488372093023256, (double)IMAGE_HEIGHT * 0.8424657534246576, (double)IMAGE_WIDTH * 0.22093023255813954, (double)IMAGE_HEIGHT * 0.7671232876712328, (double)IMAGE_WIDTH * 0.22093023255813954, (double)IMAGE_HEIGHT * 0.678082191780822);
                numberPath.closePath();
                break;
            }
            case 7: {
                numberPath.moveTo((double)IMAGE_WIDTH * 0.22093023255813954, (double)IMAGE_HEIGHT * 0.3013698630136986);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7906976744186046, (double)IMAGE_HEIGHT * 0.2945205479452055);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.4883720930232558, (double)IMAGE_HEIGHT * 0.863013698630137);
                break;
            }
            case 8: {
                numberPath.setWindingRule(0);
                numberPath.moveTo((double)IMAGE_WIDTH * 0.20930232558139536, (double)IMAGE_HEIGHT * 0.6986301369863014);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.20930232558139536, (double)IMAGE_HEIGHT * 0.6164383561643836, (double)IMAGE_WIDTH * 0.3372093023255814, (double)IMAGE_HEIGHT * 0.547945205479452, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.547945205479452);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.6627906976744186, (double)IMAGE_HEIGHT * 0.547945205479452, (double)IMAGE_WIDTH * 0.7906976744186046, (double)IMAGE_HEIGHT * 0.6164383561643836, (double)IMAGE_WIDTH * 0.7906976744186046, (double)IMAGE_HEIGHT * 0.6986301369863014);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.7906976744186046, (double)IMAGE_HEIGHT * 0.7876712328767124, (double)IMAGE_WIDTH * 0.6627906976744186, (double)IMAGE_HEIGHT * 0.8561643835616438, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.8561643835616438);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.3372093023255814, (double)IMAGE_HEIGHT * 0.8561643835616438, (double)IMAGE_WIDTH * 0.20930232558139536, (double)IMAGE_HEIGHT * 0.7876712328767124, (double)IMAGE_WIDTH * 0.20930232558139536, (double)IMAGE_HEIGHT * 0.6986301369863014);
                numberPath.closePath();
                numberPath.moveTo((double)IMAGE_WIDTH * 0.26744186046511625, (double)IMAGE_HEIGHT * 0.4178082191780822);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.26744186046511625, (double)IMAGE_HEIGHT * 0.3493150684931507, (double)IMAGE_WIDTH * 0.37209302325581395, (double)IMAGE_HEIGHT * 0.2876712328767123, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.2876712328767123);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.6511627906976745, (double)IMAGE_HEIGHT * 0.2876712328767123, (double)IMAGE_WIDTH * 0.7558139534883721, (double)IMAGE_HEIGHT * 0.3493150684931507, (double)IMAGE_WIDTH * 0.7558139534883721, (double)IMAGE_HEIGHT * 0.4178082191780822);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.7558139534883721, (double)IMAGE_HEIGHT * 0.4863013698630137, (double)IMAGE_WIDTH * 0.6511627906976745, (double)IMAGE_HEIGHT * 0.547945205479452, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.547945205479452);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.37209302325581395, (double)IMAGE_HEIGHT * 0.547945205479452, (double)IMAGE_WIDTH * 0.26744186046511625, (double)IMAGE_HEIGHT * 0.4863013698630137, (double)IMAGE_WIDTH * 0.26744186046511625, (double)IMAGE_HEIGHT * 0.4178082191780822);
                numberPath.closePath();
                break;
            }
            case 9: {
                numberPath.moveTo((double)IMAGE_WIDTH * 0.5465116279069767, (double)IMAGE_HEIGHT * 0.863013698630137);
                numberPath.lineTo((double)IMAGE_WIDTH * 0.7906976744186046, (double)IMAGE_HEIGHT * 0.5);
                numberPath.moveTo((double)IMAGE_WIDTH * 0.23255813953488372, (double)IMAGE_HEIGHT * 0.4589041095890411);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.23255813953488372, (double)IMAGE_HEIGHT * 0.3698630136986301, (double)IMAGE_WIDTH * 0.36046511627906974, (double)IMAGE_HEIGHT * 0.2945205479452055, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.2945205479452055);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.6627906976744186, (double)IMAGE_HEIGHT * 0.2945205479452055, (double)IMAGE_WIDTH * 0.7906976744186046, (double)IMAGE_HEIGHT * 0.3698630136986301, (double)IMAGE_WIDTH * 0.7906976744186046, (double)IMAGE_HEIGHT * 0.4589041095890411);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.7906976744186046, (double)IMAGE_HEIGHT * 0.5547945205479452, (double)IMAGE_WIDTH * 0.6627906976744186, (double)IMAGE_HEIGHT * 0.6301369863013698, (double)IMAGE_WIDTH * 0.5116279069767442, (double)IMAGE_HEIGHT * 0.6301369863013698);
                numberPath.curveTo((double)IMAGE_WIDTH * 0.36046511627906974, (double)IMAGE_HEIGHT * 0.6301369863013698, (double)IMAGE_WIDTH * 0.23255813953488372, (double)IMAGE_HEIGHT * 0.5547945205479452, (double)IMAGE_WIDTH * 0.23255813953488372, (double)IMAGE_HEIGHT * 0.4589041095890411);
                numberPath.closePath();
            }
        }
        G2.translate((double)IMAGE_WIDTH * 0.05813953, (double)IMAGE_WIDTH * 0.05813953);
        if (active) {
            float width = (float)IMAGE_WIDTH * 0.13953488f;
            float STEP = (float)IMAGE_WIDTH * 0.02325581f;
            for (int i = 5; i >= 0; --i) {
                G2.setStroke(new BasicStroke(width, 1, 0));
                G2.setColor(COLOR_ARRAY[i]);
                width -= STEP;
                if (width < 0.0f) {
                    width = 0.0f;
                }
                G2.draw(numberPath);
            }
        } else {
            G2.setColor(new Color(0.2f, 0.2f, 0.2f, 0.6f));
            G2.draw(numberPath);
        }
        G2.dispose();
        return IMAGE;
    }

    private void createAllNumbers() {
        this.INACTIVE_NUMBER_ARRAY.clear();
        this.INACTIVE_NUMBER_ARRAY.add(this.createNumber(0, false, this.getPreferredSize().width));
        this.INACTIVE_NUMBER_ARRAY.add(this.createNumber(1, false, this.getPreferredSize().width));
        this.INACTIVE_NUMBER_ARRAY.add(this.createNumber(2, false, this.getPreferredSize().width));
        this.INACTIVE_NUMBER_ARRAY.add(this.createNumber(3, false, this.getPreferredSize().width));
        this.INACTIVE_NUMBER_ARRAY.add(this.createNumber(4, false, this.getPreferredSize().width));
        this.INACTIVE_NUMBER_ARRAY.add(this.createNumber(5, false, this.getPreferredSize().width));
        this.INACTIVE_NUMBER_ARRAY.add(this.createNumber(6, false, this.getPreferredSize().width));
        this.INACTIVE_NUMBER_ARRAY.add(this.createNumber(7, false, this.getPreferredSize().width));
        this.INACTIVE_NUMBER_ARRAY.add(this.createNumber(8, false, this.getPreferredSize().width));
        this.INACTIVE_NUMBER_ARRAY.add(this.createNumber(9, false, this.getPreferredSize().width));
        this.ACTIVE_NUMBER_ARRAY.clear();
        this.ACTIVE_NUMBER_ARRAY.add(this.createNumber(0, true, this.getPreferredSize().width));
        this.ACTIVE_NUMBER_ARRAY.add(this.createNumber(1, true, this.getPreferredSize().width));
        this.ACTIVE_NUMBER_ARRAY.add(this.createNumber(2, true, this.getPreferredSize().width));
        this.ACTIVE_NUMBER_ARRAY.add(this.createNumber(3, true, this.getPreferredSize().width));
        this.ACTIVE_NUMBER_ARRAY.add(this.createNumber(4, true, this.getPreferredSize().width));
        this.ACTIVE_NUMBER_ARRAY.add(this.createNumber(5, true, this.getPreferredSize().width));
        this.ACTIVE_NUMBER_ARRAY.add(this.createNumber(6, true, this.getPreferredSize().width));
        this.ACTIVE_NUMBER_ARRAY.add(this.createNumber(7, true, this.getPreferredSize().width));
        this.ACTIVE_NUMBER_ARRAY.add(this.createNumber(8, true, this.getPreferredSize().width));
        this.ACTIVE_NUMBER_ARRAY.add(this.createNumber(9, true, this.getPreferredSize().width));
    }

    private void createNumberStack() {
        if (this.number > -1) {
            this.numberStack[0] = this.number == 1 ? this.ACTIVE_NUMBER_ARRAY.get(1) : this.INACTIVE_NUMBER_ARRAY.get(1);
            this.numberStack[1] = this.number == 0 ? this.ACTIVE_NUMBER_ARRAY.get(0) : this.INACTIVE_NUMBER_ARRAY.get(0);
            this.numberStack[2] = this.number == 2 ? this.ACTIVE_NUMBER_ARRAY.get(2) : this.INACTIVE_NUMBER_ARRAY.get(2);
            this.numberStack[3] = this.number == 3 ? this.ACTIVE_NUMBER_ARRAY.get(3) : this.INACTIVE_NUMBER_ARRAY.get(3);
            this.numberStack[4] = this.number == 9 ? this.ACTIVE_NUMBER_ARRAY.get(9) : this.INACTIVE_NUMBER_ARRAY.get(9);
            this.numberStack[5] = this.number == 4 ? this.ACTIVE_NUMBER_ARRAY.get(4) : this.INACTIVE_NUMBER_ARRAY.get(4);
            this.numberStack[6] = this.number == 8 ? this.ACTIVE_NUMBER_ARRAY.get(8) : this.INACTIVE_NUMBER_ARRAY.get(8);
            this.numberStack[7] = this.number == 5 ? this.ACTIVE_NUMBER_ARRAY.get(5) : this.INACTIVE_NUMBER_ARRAY.get(5);
            this.numberStack[8] = this.number == 7 ? this.ACTIVE_NUMBER_ARRAY.get(7) : this.INACTIVE_NUMBER_ARRAY.get(7);
            this.numberStack[9] = this.number == 6 ? this.ACTIVE_NUMBER_ARRAY.get(6) : this.INACTIVE_NUMBER_ARRAY.get(6);
        } else {
            System.arraycopy(this.INACTIVE_NUMBER_ARRAY.toArray(), 0, this.numberStack, 0, 10);
        }
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        if (number < 0) {
            number = -1;
        }
        if (number > 9) {
            number = 9;
        }
        this.number = number;
        this.createNumberStack();
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent event) {
        this.setPreferredSize(event.getComponent().getSize());
        this.init();
    }

    @Override
    public void componentMoved(ComponentEvent event) {
    }

    @Override
    public void componentShown(ComponentEvent event) {
    }

    @Override
    public void componentHidden(ComponentEvent event) {
    }

    @Override
    public void setSize(Dimension dim) {
        super.setPreferredSize(new Dimension(dim.width, (int)((double)dim.width * 1.69767442)));
        super.setSize(new Dimension(dim.width, (int)((double)dim.width * 1.69767442)));
    }

    @Override
    public void setSize(int width, int height) {
        super.setPreferredSize(new Dimension(width, (int)((double)width * 1.69767442)));
        super.setSize(new Dimension(width, (int)((double)width * 1.69767442)));
    }

    @Override
    public String toString() {
        return "NixieNumber";
    }
}

