/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class MButtonUI
extends BasicButtonUI
implements ComponentListener,
PropertyChangeListener {
    private BufferedImage backgroundImage;
    private BufferedImage contentImage;
    private BufferedImage disabledContentImage;
    private BufferedImage foregroundImage;
    final AbstractButton BUTTON;

    public MButtonUI(AbstractButton BUTTON) {
        this.BUTTON = BUTTON;
        this.BUTTON.setBorderPainted(false);
        this.BUTTON.setContentAreaFilled(false);
        this.init(BUTTON.getWidth(), BUTTON.getHeight());
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        component.addComponentListener(this);
        component.addPropertyChangeListener(this);
    }

    @Override
    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        component.removeComponentListener(this);
        component.removePropertyChangeListener(this);
    }

    public static ComponentUI createUI(JComponent component) {
        return new MButtonUI((AbstractButton)component);
    }

    private void init(int WIDTH, int HEIGHT) {
        this.backgroundImage = this.create_BACKGROUND_Image(WIDTH, HEIGHT);
        this.contentImage = this.create_CONTENT_Image(WIDTH, HEIGHT, true);
        this.disabledContentImage = this.create_CONTENT_Image(WIDTH, HEIGHT, false);
        this.foregroundImage = this.create_FOREGROUND_Image(WIDTH, HEIGHT);
    }

    @Override
    public void paint(Graphics g, JComponent comp) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.drawImage((Image)this.backgroundImage, 0, 0, null);
        if (comp.isEnabled()) {
            G2.drawImage((Image)this.foregroundImage, 0, 0, null);
        }
        G2.dispose();
        super.paint(g, comp);
    }

    @Override
    protected void paintText(Graphics g, AbstractButton button, Rectangle textRect, String text) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (button.isEnabled()) {
            G2.drawImage((Image)this.contentImage, 0, 0, null);
        } else {
            G2.drawImage((Image)this.disabledContentImage, 0, 0, null);
        }
        G2.dispose();
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton button) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.drawImage((Image)this.backgroundImage, 0, 0, null);
        G2.drawImage((Image)this.foregroundImage, 0, 0, null);
        G2.dispose();
    }

    private BufferedImage create_BACKGROUND_Image(int WIDTH, int HEIGHT) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        RoundRectangle2D.Double FRAME = new RoundRectangle2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT, 12.0, 12.0);
        Point2D.Double FRAME_START = new Point2D.Double(0.0, FRAME.getBounds2D().getMinY());
        Point2D.Double FRAME_STOP = new Point2D.Double(0.0, FRAME.getBounds2D().getMaxY());
        float[] FRAME_FRACTIONS = new float[]{0.0f, 0.1f, 1.0f};
        Color[] FRAME_COLORS = new Color[]{new Color(200, 200, 200, 255), new Color(32, 32, 32, 255), new Color(32, 32, 32, 255)};
        LinearGradientPaint FRAME_GRADIENT = new LinearGradientPaint(FRAME_START, FRAME_STOP, FRAME_FRACTIONS, FRAME_COLORS);
        G2.setPaint(FRAME_GRADIENT);
        G2.fill(FRAME);
        RoundRectangle2D.Double BACKGROUND = new RoundRectangle2D.Double(FRAME.getMinX() + 1.0, FRAME.getMinY() + 1.0, ((RectangularShape)FRAME).getWidth() - 2.0, ((RectangularShape)FRAME).getHeight() - 2.0, 11.0, 11.0);
        Point2D.Double BACKGROUND_START = new Point2D.Double(0.0, BACKGROUND.getBounds2D().getMinY());
        Point2D.Double BACKGROUND_STOP = new Point2D.Double(0.0, BACKGROUND.getBounds2D().getMaxY());
        float[] BACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] BACKGROUND_COLORS = new Color[]{new Color(0, 0, 0, 255), new Color(48, 48, 48, 255)};
        LinearGradientPaint BACKGROUND_GRADIENT = new LinearGradientPaint(BACKGROUND_START, BACKGROUND_STOP, BACKGROUND_FRACTIONS, BACKGROUND_COLORS);
        G2.setPaint(BACKGROUND_GRADIENT);
        G2.fill(BACKGROUND);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_CONTENT_Image(int WIDTH, int HEIGHT, boolean ENABLED) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        if (ENABLED) {
            G2.setColor(this.BUTTON.getForeground());
        } else {
            G2.setColor(Color.DARK_GRAY);
        }
        if (!this.BUTTON.getText().isEmpty()) {
            G2.setFont(this.BUTTON.getFont().deriveFont((int)(0.1111111111111 * (double)IMAGE_WIDTH)));
            TextLayout LAYOUT_TEXT = new TextLayout(this.BUTTON.getText(), G2.getFont(), RENDER_CONTEXT);
            Rectangle2D BOUNDARY_TEXT = LAYOUT_TEXT.getBounds();
            G2.drawString(this.BUTTON.getText(), (int)(((double)IMAGE_WIDTH - BOUNDARY_TEXT.getWidth()) / 2.0), (int)(((double)IMAGE_HEIGHT - BOUNDARY_TEXT.getHeight()) / 2.0 + BOUNDARY_TEXT.getHeight() - (double)(LAYOUT_TEXT.getDescent() / 2.0f)));
        }
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_FOREGROUND_Image(int WIDTH, int HEIGHT) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Area HIGHLIGHT = new Area(new RoundRectangle2D.Double(1.0, 1.0, IMAGE_WIDTH - 2, IMAGE_HEIGHT - 2, 11.0, 11.0));
        Area PUNCH = new Area(new Ellipse2D.Double((double)IMAGE_WIDTH * -0.2063492063, (double)IMAGE_HEIGHT * 0.3928571429, (double)IMAGE_WIDTH * 1.4285714286, (double)IMAGE_HEIGHT * 1.9285714286));
        HIGHLIGHT.subtract(PUNCH);
        G2.setColor(new Color(255, 255, 255, 35));
        G2.fill(HIGHLIGHT);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public void componentResized(ComponentEvent EVENT) {
        EVENT.getComponent().setPreferredSize(new Dimension(EVENT.getComponent().getWidth(), EVENT.getComponent().getHeight()));
        EVENT.getComponent().setSize(EVENT.getComponent().getPreferredSize());
        this.init(EVENT.getComponent().getWidth(), EVENT.getComponent().getHeight());
    }

    @Override
    public void componentMoved(ComponentEvent EVENT) {
    }

    @Override
    public void componentShown(ComponentEvent EVENT) {
    }

    @Override
    public void componentHidden(ComponentEvent EVENT) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent EVENT) {
        this.init(this.BUTTON.getWidth(), this.BUTTON.getHeight());
        this.BUTTON.repaint();
    }

    public String toString() {
        return "MButtonUI";
    }
}

