/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import eu.hansolo.custom.MButtonUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.ease.TimelineEase;

public class MButton
extends JButton
implements ComponentListener,
MouseListener,
MouseMotionListener {
    private BufferedImage effectImageStandard;
    private BufferedImage effectImageClicked;
    private BufferedImage effectImage;
    private boolean mouseOver = false;
    private boolean mouseClicked = false;
    private boolean mousePressed = false;
    private boolean mouseMovedOutside = false;
    private float alpha = 0.0f;
    private final Timeline TIMELINE = new Timeline((Object)this);
    private final TimelineCallback TIMELINE_CALLBACK = new TimelineCallback(){

        public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float oldValue, float newValue) {
            if (newState == Timeline.TimelineState.IDLE) {
                MButton.this.effectImage = MButton.this.effectImageStandard;
                if (!MButton.this.mousePressed && !MButton.this.mouseOver) {
                    MButton.this.mouseMovedOutside = false;
                }
            }
        }

        public void onTimelinePulse(float oldValue, float newValue) {
        }
    };
    private static final TimelineEase STANDARD_EASING = new Spline(0.3f);
    private static final float[] EFFECT_FRACTIONS = new float[]{0.0f, 0.15f, 1.0f};
    private Color effectColor = new Color(255, 50, 0, 200);
    private Color[] effectColors = new Color[]{this.effectColor, this.effectColor, new Color(this.effectColor.getRed(), this.effectColor.getGreen(), this.effectColor.getBlue(), 0)};
    private Color effectColorPressed = new Color(50, 161, 0, 200);
    private Color[] effectColorsPressed = new Color[]{this.effectColorPressed, this.effectColorPressed, new Color(this.effectColorPressed.getRed(), this.effectColorPressed.getGreen(), this.effectColorPressed.getBlue(), 0)};

    public MButton() {
        this("MButton");
    }

    public MButton(String text) {
        super(text);
        this._init();
    }

    public MButton(Icon icon) {
        super(icon);
        this._init();
    }

    public MButton(Action action) {
        super(action);
        this._init();
    }

    private void _init() {
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setFont(new Font("Verdana", 0, 11));
        this.setForeground(new Color(0xCCCCCC));
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setPreferredSize(new Dimension(73, 23));
        this.setSize(this.getPreferredSize());
        this.TIMELINE.setEase(STANDARD_EASING);
        this.TIMELINE.addCallback(this.TIMELINE_CALLBACK);
        this.init(this.getWidth(), this.getHeight());
    }

    private void init(int WIDTH, int HEIGHT) {
        this.effectImageStandard = this.create_EFFECT_Image(WIDTH, HEIGHT, false);
        this.effectImageClicked = this.create_EFFECT_Image(WIDTH, HEIGHT, true);
        this.effectImage = this.effectImageStandard;
    }

    @Override
    protected void paintComponent(Graphics G) {
        super.paintComponent(G);
        Graphics2D G2 = (Graphics2D)G.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setComposite(AlphaComposite.getInstance(3, this.alpha));
        G2.drawImage((Image)this.effectImage, 0, 0, null);
        G2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        G2.dispose();
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float ALPHA) {
        this.alpha = ALPHA;
        this.repaint();
    }

    public Color getEffectColor() {
        return this.effectColor;
    }

    public void setEffectColor(Color EFFECT_COLOR) {
        this.effectColor = EFFECT_COLOR;
        this.effectColors = new Color[]{this.effectColor, this.effectColor, new Color(this.effectColor.getRed(), this.effectColor.getGreen(), this.effectColor.getBlue(), 0)};
        this.repaint();
    }

    public Color getEffectColorPressed() {
        return this.effectColorPressed;
    }

    public void setEffectColorPressed(Color EFFECT_COLOR_PRESSED) {
        this.effectColorPressed = EFFECT_COLOR_PRESSED;
        this.effectColorsPressed = new Color[]{this.effectColorPressed, this.effectColorPressed, new Color(this.effectColorPressed.getRed(), this.effectColorPressed.getGreen(), this.effectColorPressed.getBlue(), 0)};
        this.repaint();
    }

    @Override
    public void setUI(ButtonUI UI) {
        super.setUI(new MButtonUI(this));
    }

    @Override
    protected void setUI(ComponentUI UI) {
        super.setUI(new MButtonUI(this));
    }

    public void setUi(ComponentUI UI) {
        this.ui = new MButtonUI(this);
    }

    private BufferedImage create_EFFECT_Image(int WIDTH, int HEIGHT, boolean CLICKED) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Rectangle BOUNDS = new Rectangle(0, (int)((double)IMAGE_HEIGHT * 0.6 / 2.0), IMAGE_WIDTH, (int)((double)IMAGE_HEIGHT * 1.4));
        RadialGradientPaint GRADIENT = CLICKED ? new RadialGradientPaint(BOUNDS, EFFECT_FRACTIONS, this.effectColorsPressed, MultipleGradientPaint.CycleMethod.NO_CYCLE) : new RadialGradientPaint(BOUNDS, EFFECT_FRACTIONS, this.effectColors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        G2.setPaint(GRADIENT);
        G2.fill(BOUNDS);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public void componentResized(ComponentEvent EVENT) {
        this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        this.setSize(this.getPreferredSize());
        this.init(this.getWidth(), this.getHeight());
    }

    @Override
    public void componentMoved(ComponentEvent EVENT) {
    }

    @Override
    public void componentShown(ComponentEvent EVENT) {
    }

    @Override
    public void componentHidden(ComponentEvent EVENT) {
    }

    @Override
    public void mouseClicked(MouseEvent EVENT) {
        this.mouseClicked = true;
        this.effectImage = this.effectImageClicked;
        if (this.isEnabled()) {
            if (this.TIMELINE.getState() != Timeline.TimelineState.IDLE) {
                this.TIMELINE.abort();
            }
            this.TIMELINE.addPropertyToInterpolate("alpha", (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f));
            this.TIMELINE.setDuration(600L);
            this.TIMELINE.playReverse();
        }
    }

    @Override
    public void mousePressed(MouseEvent EVENT) {
        this.mouseClicked = true;
        this.mousePressed = true;
        this.mouseMovedOutside = false;
        if (this.TIMELINE.getState() != Timeline.TimelineState.IDLE) {
            this.TIMELINE.abort();
        }
        this.alpha = 1.0f;
        this.effectImage = this.effectImageClicked;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent EVENT) {
        if (this.isEnabled()) {
            if (this.TIMELINE.getState() != Timeline.TimelineState.IDLE) {
                this.TIMELINE.abort();
            }
            this.TIMELINE.addPropertyToInterpolate("alpha", (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f));
            this.TIMELINE.setDuration(600L);
            this.TIMELINE.playReverse();
        }
        this.repaint();
        this.mousePressed = false;
    }

    @Override
    public void mouseEntered(MouseEvent EVENT) {
        this.mouseOver = true;
        if (this.isEnabled() && this.alpha < 1.0f) {
            if (this.TIMELINE.getState() != Timeline.TimelineState.IDLE) {
                this.TIMELINE.abort();
            }
            if (!this.mousePressed) {
                this.TIMELINE.addPropertyToInterpolate("alpha", (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f));
                this.TIMELINE.setDuration(600L);
                this.TIMELINE.play();
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent EVENT) {
        this.mouseOver = false;
        if (this.isEnabled()) {
            if (this.TIMELINE.getState() != Timeline.TimelineState.IDLE && !this.mouseClicked) {
                this.TIMELINE.abort();
            }
            if (!(this.mouseClicked || this.mousePressed || this.mouseMovedOutside)) {
                this.TIMELINE.addPropertyToInterpolate("alpha", (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f));
                this.TIMELINE.setDuration(600L);
                this.TIMELINE.playReverse();
            }
            this.mouseClicked = false;
            this.mouseMovedOutside = this.mousePressed;
        }
    }

    @Override
    public void mouseDragged(MouseEvent EVENT) {
    }

    @Override
    public void mouseMoved(MouseEvent EVENT) {
    }

    @Override
    public String toString() {
        return "MButton";
    }
}

