/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import eu.hansolo.custom.FlipChar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Timer;

public enum GlobalTimer implements ActionListener
{
    INSTANCE;

    private static final ActionEvent FLIP_EVENT;
    private static final ActionEvent FLIP_SEQUENCE_EVENT;
    private Timer flipTimer = new Timer(120, this);
    private Timer flipSequenceTimer = new Timer(10, this);
    private int currentSequence = 0;
    private Set<FlipChar> componentSet = new HashSet<FlipChar>(32);

    public void startTimer() {
        this.flipTimer.start();
    }

    public void stopTimer() {
        this.flipTimer.stop();
    }

    public void addComponent(FlipChar component) {
        this.componentSet.add(component);
    }

    public void removeComponent(FlipChar component) {
        this.componentSet.remove(component);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.flipTimer)) {
            for (FlipChar component : this.componentSet) {
                component.actionPerformed(FLIP_EVENT);
            }
            this.flipSequenceTimer.start();
        }
        if (event.getSource().equals(this.flipSequenceTimer)) {
            if (this.currentSequence == 10) {
                this.currentSequence = 0;
                this.flipSequenceTimer.stop();
            }
            for (FlipChar component : this.componentSet) {
                component.actionPerformed(FLIP_SEQUENCE_EVENT);
            }
            ++this.currentSequence;
        }
    }

    static {
        FLIP_EVENT = new ActionEvent("flip", 1001, "flip");
        FLIP_SEQUENCE_EVENT = new ActionEvent("flipSequence", 1001, "flipSequence");
    }
}

