/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import eu.hansolo.custom.FlipImages;
import eu.hansolo.custom.GlobalTimer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class FlipChar
extends JComponent
implements ActionListener {
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 45, 62);
    private String character = " ";
    private static final String PROPERTY_CHARACTER = "character";
    private BufferedImage backgroundImage = null;
    private BufferedImage foregroundImage = null;
    private final BasicStroke THIN_STROKE = new BasicStroke(0.5f);
    private char currentChar = (char)32;
    private char lastChar = (char)32;
    private Font font;
    private BufferedImage flipSequenceImage = null;
    private volatile int currentFlipSequenceImage = 0;
    private boolean reachedChar = false;
    private boolean flipComplete = false;
    private Color fontColor;
    private final Rectangle2D CLIP;
    private final Rectangle2D TOP_CLIP;
    private final Rectangle2D BOTTOM_CLIP;
    private final Point2D TOP_FONT_GRADIENT_START;
    private final Point2D TOP_FONT_GRADIENT_STOP;
    private final Point2D BOTTOM_FONT_GRADIENT_START;
    private final Point2D BOTTOM_FONT_GRADIENT_STOP;
    private final float[] TOP_FONT_GRADIENT_FRACTIONS = new float[]{0.0f, 1.0f};
    private Color[] topFontGradientColors = new Color[]{new Color(16776871), new Color(13421428)};
    private final float[] BOTTOM_FONT_GRADIENT_FRACTIONS = new float[]{0.0f, 1.0f};
    private Color[] bottomFontGradientColors = new Color[]{new Color(13421428), new Color(16776871)};
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            boolean SQUARE = FlipChar.this.getWidth() == FlipChar.this.getHeight();
            int SIZE = FlipChar.this.getWidth() <= FlipChar.this.getHeight() ? FlipChar.this.getWidth() : FlipChar.this.getHeight();
            Container parent = FlipChar.this.getParent();
            if (parent != null && parent.getLayout() == null) {
                if (SIZE < FlipChar.this.getMinimumSize().width || SIZE < FlipChar.this.getMinimumSize().height) {
                    FlipChar.this.setSize(FlipChar.this.getMinimumSize().width, FlipChar.this.getMinimumSize().height);
                } else if (SQUARE) {
                    FlipChar.this.setSize(SIZE, SIZE);
                } else {
                    FlipChar.this.setSize(FlipChar.this.getWidth(), FlipChar.this.getHeight());
                }
            } else if (SIZE < FlipChar.this.getMinimumSize().width || SIZE < FlipChar.this.getMinimumSize().height) {
                FlipChar.this.setPreferredSize(FlipChar.this.getMinimumSize());
            } else if (SQUARE) {
                FlipChar.this.setPreferredSize(new Dimension(SIZE, SIZE));
            } else {
                FlipChar.this.setPreferredSize(new Dimension(FlipChar.this.getWidth(), FlipChar.this.getHeight()));
            }
            FlipChar.this.calcInnerBounds();
            if (SQUARE) {
                FlipChar.this.init(((FlipChar)FlipChar.this).INNER_BOUNDS.width, ((FlipChar)FlipChar.this).INNER_BOUNDS.width);
            } else {
                FlipChar.this.init(((FlipChar)FlipChar.this).INNER_BOUNDS.width, ((FlipChar)FlipChar.this).INNER_BOUNDS.height);
            }
            FlipChar.this.revalidate();
            FlipChar.this.repaint(FlipChar.this.INNER_BOUNDS);
        }
    };

    public FlipChar() {
        this.addComponentListener(this.COMPONENT_LISTENER);
        GlobalTimer.INSTANCE.addComponent(this);
        this.fontColor = new Color(16776871);
        this.CLIP = new Rectangle2D.Double();
        this.TOP_CLIP = new Rectangle2D.Double();
        this.BOTTOM_CLIP = new Rectangle2D.Double();
        this.TOP_FONT_GRADIENT_START = new Point2D.Double();
        this.TOP_FONT_GRADIENT_STOP = new Point2D.Double();
        this.BOTTOM_FONT_GRADIENT_START = new Point2D.Double();
        this.BOTTOM_FONT_GRADIENT_STOP = new Point2D.Double();
        this.init(this.getWidth(), this.getHeight());
    }

    private void init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return;
        }
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
        }
        this.backgroundImage = this.createBackgroundImage(WIDTH, HEIGHT);
        if (this.foregroundImage != null) {
            this.foregroundImage.flush();
        }
        this.foregroundImage = this.createForegroundImage(WIDTH, HEIGHT);
        this.font = FlipImages.INSTANCE.getFont().deriveFont(0.6451613f * (float)HEIGHT).deriveFont(1);
        FlipImages.INSTANCE.recreateImages(WIDTH, HEIGHT);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.drawImage((Image)this.backgroundImage, 0, 0, this);
        this.CLIP.setRect(G2.getClipBounds());
        G2.setClip(this.TOP_CLIP);
        LinearGradientPaint TOP_FONT_GRADIENT = new LinearGradientPaint(this.TOP_FONT_GRADIENT_START, this.TOP_FONT_GRADIENT_STOP, this.TOP_FONT_GRADIENT_FRACTIONS, this.topFontGradientColors);
        G2.setPaint(TOP_FONT_GRADIENT);
        G2.setFont(this.font);
        FontMetrics metrics = G2.getFontMetrics();
        Rectangle2D charBounds = metrics.getStringBounds(Character.toString(this.currentChar), G2);
        G2.translate((double)this.getWidth() * 0.1111111111111111, (double)this.getHeight() * 0.078);
        G2.drawString(Character.toString(this.currentChar), (float)((this.TOP_CLIP.getWidth() - charBounds.getWidth()) / 2.0), (float)(this.TOP_CLIP.getHeight() + (double)((float)metrics.getHeight() / 2.0f) - (double)metrics.getDescent()));
        G2.translate((double)(-this.getWidth()) * 0.1111111111111111, (double)(-this.getHeight()) * 0.078);
        G2.setClip(this.BOTTOM_CLIP);
        LinearGradientPaint BOTTOM_FONT_GRADIENT = new LinearGradientPaint(this.BOTTOM_FONT_GRADIENT_START, this.BOTTOM_FONT_GRADIENT_STOP, this.BOTTOM_FONT_GRADIENT_FRACTIONS, this.bottomFontGradientColors);
        G2.setPaint(BOTTOM_FONT_GRADIENT);
        G2.setFont(this.font);
        metrics = G2.getFontMetrics();
        if (!this.flipComplete) {
            charBounds = metrics.getStringBounds(Character.toString(this.lastChar), G2);
            G2.translate((double)this.getWidth() * 0.1111111111111111, (double)this.getHeight() * 0.49);
            G2.drawString(Character.toString(this.lastChar), (float)((this.BOTTOM_CLIP.getWidth() - charBounds.getWidth()) / 2.0), (float)metrics.getHeight() / 2.0f - (float)metrics.getDescent());
            G2.translate((double)(-this.getWidth()) * 0.1111111111111111, (double)(-this.getHeight()) * 0.49);
        } else {
            charBounds = metrics.getStringBounds(Character.toString(this.currentChar), G2);
            G2.translate((double)this.getWidth() * 0.1111111111111111, (double)this.getHeight() * 0.49);
            G2.drawString(Character.toString(this.currentChar), (float)((this.BOTTOM_CLIP.getWidth() - charBounds.getWidth()) / 2.0), (float)metrics.getHeight() / 2.0f - (float)metrics.getDescent());
            G2.translate((double)(-this.getWidth()) * 0.1111111111111111, (double)(-this.getHeight()) * 0.49);
        }
        G2.setClip(this.CLIP);
        G2.drawImage((Image)this.foregroundImage, 0, 0, this);
        if (this.flipSequenceImage != null) {
            G2.drawImage((Image)this.flipSequenceImage, 0, 0, this);
        }
        G2.dispose();
    }

    public String getCharacter() {
        return this.character;
    }

    public void setCharacter(String CHARACTER) {
        if (CHARACTER.isEmpty()) {
            return;
        }
        String oldCharacter = this.character;
        this.character = CHARACTER;
        this.firePropertyChange(PROPERTY_CHARACTER, oldCharacter, CHARACTER);
        if (this.currentChar != this.character.charAt(0)) {
            this.reachedChar = false;
            this.flipComplete = false;
        }
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color FONT_COLOR) {
        this.fontColor = FONT_COLOR;
        float HUE = Color.RGBtoHSB(FONT_COLOR.getRed(), FONT_COLOR.getGreen(), FONT_COLOR.getBlue(), null)[0];
        if (FONT_COLOR.getRed() != FONT_COLOR.getGreen() && FONT_COLOR.getRed() != FONT_COLOR.getBlue()) {
            this.topFontGradientColors = new Color[]{Color.getHSBColor(HUE, 0.35f, 1.0f), Color.getHSBColor(HUE, 0.43f, 0.8f)};
            this.bottomFontGradientColors = new Color[]{Color.getHSBColor(HUE, 0.43f, 0.8f), Color.getHSBColor(HUE, 0.35f, 1.0f)};
        } else {
            this.topFontGradientColors = new Color[]{FONT_COLOR, FONT_COLOR};
            this.bottomFontGradientColors = new Color[]{FONT_COLOR, FONT_COLOR};
        }
        this.repaint(this.INNER_BOUNDS);
    }

    private BufferedImage createBackgroundImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 1);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Point2D.Float START_BACKGROUND = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float STOP_BACKGROUND = new Point2D.Float(0.0f, HEIGHT);
        float[] FRACTIONS_BACKGROUND = new float[]{0.0f, 1.0f};
        Color[] COLORS_BACKGROUND = new Color[]{new Color(5460557), new Color(3883319)};
        LinearGradientPaint GRADIENT_BACKGROUND = new LinearGradientPaint(START_BACKGROUND, STOP_BACKGROUND, FRACTIONS_BACKGROUND, COLORS_BACKGROUND);
        G2.setPaint(GRADIENT_BACKGROUND);
        G2.fill(new Rectangle2D.Float(0.0f, 0.0f, WIDTH, HEIGHT));
        Point2D.Double START_HIGHLIGHT = new Point2D.Double(0.0, 0.0322580645 * (double)HEIGHT);
        Point2D.Double STOP_HIGHLIGHT = new Point2D.Double(0.0, 0.9677419355 * (double)HEIGHT);
        float[] FRACTIONS_HIGHLIGHT = new float[]{0.0f, 0.03f, 0.97f, 1.0f};
        Color[] COLORS_HIGHLIGHT = new Color[]{new Color(1841424), new Color(4078386), new Color(4078386), new Color(9669504)};
        LinearGradientPaint GRADIENT_HIGHLIGHT = new LinearGradientPaint(START_HIGHLIGHT, STOP_HIGHLIGHT, FRACTIONS_HIGHLIGHT, COLORS_HIGHLIGHT);
        G2.setPaint(GRADIENT_HIGHLIGHT);
        G2.fill(new Rectangle2D.Double(0.0444444444 * (double)WIDTH, 0.0322580645 * (double)HEIGHT, 0.9111111111 * (double)WIDTH, 0.935483871 * (double)HEIGHT));
        Point2D.Double START_INNER_BACKGROUND = new Point2D.Double(0.0, 0.0483870968 * (double)HEIGHT);
        Point2D.Double STOP_INNER_BACKGROUND = new Point2D.Double(0.0, 0.9516129032 * (double)HEIGHT);
        float[] FRACTIONS_INNER_BACKGROUND = new float[]{0.0f, 1.0f};
        Color[] COLORS_INNER_BACKGROUND = new Color[]{new Color(4078386), new Color(2303264)};
        LinearGradientPaint GRADIENT_INNER_BACKGROUND = new LinearGradientPaint(START_INNER_BACKGROUND, STOP_INNER_BACKGROUND, FRACTIONS_INNER_BACKGROUND, COLORS_INNER_BACKGROUND);
        G2.setPaint(GRADIENT_INNER_BACKGROUND);
        G2.fill(new Rectangle2D.Double(0.0666666667 * (double)WIDTH, 0.0483870968 * (double)HEIGHT, 0.8666666667 * (double)WIDTH, 0.9032258065 * (double)HEIGHT));
        G2.translate((double)this.getWidth() * 0.1111111111111111, (double)this.getHeight() * 0.08064516129032258);
        GeneralPath TOP = new GeneralPath();
        TOP.moveTo(0.0, (double)HEIGHT * 0.4032258065 * 0.12);
        TOP.quadTo(0.0, 0.0, (double)HEIGHT * 0.4032258065 * 0.12, 0.0);
        TOP.lineTo((double)WIDTH * 0.77777777777 * 0.9142857142857143, 0.0);
        TOP.quadTo((double)WIDTH * 0.77777777777, 0.0, (double)WIDTH * 0.77777777777, (double)HEIGHT * 0.4032258065 * 0.12);
        TOP.lineTo((double)WIDTH * 0.77777777777, (double)HEIGHT * 0.4032258065 * 0.76);
        TOP.lineTo((double)WIDTH * 0.77777777777 * 0.9714285714285714, (double)HEIGHT * 0.4032258065 * 0.76);
        TOP.lineTo((double)WIDTH * 0.77777777777 * 0.9714285714285714, (double)HEIGHT * 0.4032258065);
        TOP.lineTo((double)WIDTH * 0.77777777777 * 0.02857142857142857, (double)HEIGHT * 0.4032258065);
        TOP.lineTo((double)WIDTH * 0.77777777777 * 0.02857142857142857, (double)HEIGHT * 0.4032258065 * 0.76);
        TOP.lineTo(0.0, (double)HEIGHT * 0.4032258065 * 0.76);
        TOP.closePath();
        Point2D.Double TOP_START = new Point2D.Double(0.0, TOP.getBounds2D().getMinY());
        Point2D.Double TOP_STOP = new Point2D.Double(0.0, TOP.getBounds2D().getMaxY());
        float[] TOP_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] TOP_COLORS = new Color[]{new Color(5197908), new Color(4079683)};
        LinearGradientPaint TOP_GRADIENT = new LinearGradientPaint(TOP_START, TOP_STOP, TOP_FRACTIONS, TOP_COLORS);
        G2.setPaint(TOP_GRADIENT);
        G2.fill(TOP);
        G2.translate((double)(-this.getWidth()) * 0.1111111111111111, (double)(-this.getHeight()) * 0.08064516129032258);
        G2.translate((double)this.getWidth() * 0.1111111111111111, (double)this.getHeight() * 0.5161290322580645);
        GeneralPath BOTTOM = new GeneralPath();
        BOTTOM.moveTo((double)WIDTH * 0.77777777777 * 0.02857142857142857, 0.0);
        BOTTOM.lineTo((double)WIDTH * 0.77777777777 * 0.9714285714285714, 0.0);
        BOTTOM.lineTo((double)WIDTH * 0.77777777777 * 0.9714285714285714, (double)HEIGHT * 0.4032258065 * 0.24);
        BOTTOM.lineTo((double)WIDTH * 0.77777777777, (double)HEIGHT * 0.4032258065 * 0.24);
        BOTTOM.lineTo((double)WIDTH * 0.77777777777, (double)HEIGHT * 0.4032258065 * 0.88);
        BOTTOM.quadTo((double)WIDTH * 0.77777777777, (double)HEIGHT * 0.4032258065, (double)WIDTH * 0.77777777777 * 0.9142857142857143, (double)HEIGHT * 0.4032258065);
        BOTTOM.lineTo((double)WIDTH * 0.77777777777 * 0.08571428571428572, (double)HEIGHT * 0.4032258065);
        BOTTOM.quadTo(0.0, (double)HEIGHT * 0.4032258065, 0.0, (double)HEIGHT * 0.4032258065 * 0.88);
        BOTTOM.lineTo(0.0, (double)HEIGHT * 0.4032258065 * 0.24);
        BOTTOM.lineTo((double)WIDTH * 0.77777777777 * 0.02857142857142857, (double)HEIGHT * 0.4032258065 * 0.24);
        BOTTOM.closePath();
        Point2D.Double BOTTOM_START = new Point2D.Double(0.0, BOTTOM.getBounds2D().getMinY());
        Point2D.Double BOTTOM_STOP = new Point2D.Double(0.0, BOTTOM.getBounds2D().getMaxY());
        float[] BOTTOM_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] BOTTOM_COLORS = new Color[]{new Color(3882048), new Color(5000529)};
        LinearGradientPaint BOTTOM_GRADIENT = new LinearGradientPaint(BOTTOM_START, BOTTOM_STOP, BOTTOM_FRACTIONS, BOTTOM_COLORS);
        G2.setPaint(BOTTOM_GRADIENT);
        G2.fill(BOTTOM);
        G2.translate((double)(-this.getWidth()) * 0.1111111111111111, (double)(-this.getHeight()) * 0.5161290322580645);
        this.TOP_CLIP.setRect((double)WIDTH * 0.1111111111111111, (double)HEIGHT * 0.08064516129032258, TOP.getBounds2D().getWidth(), TOP.getBounds2D().getHeight());
        this.BOTTOM_CLIP.setRect((double)WIDTH * 0.1111111111111111, (double)HEIGHT * 0.5161290322580645, BOTTOM.getBounds2D().getWidth(), BOTTOM.getBounds2D().getHeight());
        this.TOP_FONT_GRADIENT_START.setLocation(0.0, this.TOP_CLIP.getHeight() * 0.4 + this.TOP_CLIP.getMinY());
        this.TOP_FONT_GRADIENT_STOP.setLocation(0.0, this.TOP_CLIP.getMaxY());
        this.BOTTOM_FONT_GRADIENT_START.setLocation(0.0, this.BOTTOM_CLIP.getMinY());
        this.BOTTOM_FONT_GRADIENT_STOP.setLocation(0.0, this.BOTTOM_CLIP.getHeight() * 0.6 + this.BOTTOM_CLIP.getMinY());
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage createForegroundImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        G2.setStroke(this.THIN_STROKE);
        G2.setColor(new Color(0x999999));
        G2.draw(new Line2D.Double(0.1333333333 * (double)WIDTH, 0.4838709677 * (double)HEIGHT, 0.84444444 * (double)WIDTH, 0.4838709677 * (double)HEIGHT));
        G2.setColor(Color.BLACK);
        G2.draw(new Line2D.Double(0.1333333333 * (double)WIDTH, 0.5 * (double)HEIGHT, 0.84444444 * (double)WIDTH, 0.5 * (double)HEIGHT));
        Point2D.Double SIDE_BAR_START = new Point2D.Double(0.0, 0.4193548387 * (double)HEIGHT);
        Point2D.Double SIDE_BAR_STOP = new Point2D.Double(0.0, 0.6290322581 * (double)HEIGHT);
        float[] SIDE_BAR_FRACTIONS = new float[]{0.0f, 0.05f, 0.15f, 0.85f, 0.95f, 1.0f};
        Color[] SIDE_BAR_COLORS = new Color[]{new Color(4868421), new Color(0x787876), new Color(4672584), new Color(5459780), new Color(8089960), new Color(5655619)};
        LinearGradientPaint SIDE_BAR_GRADIENT = new LinearGradientPaint(SIDE_BAR_START, SIDE_BAR_STOP, SIDE_BAR_FRACTIONS, SIDE_BAR_COLORS);
        G2.setPaint(SIDE_BAR_GRADIENT);
        G2.draw(new Line2D.Double(0.1111111111 * (double)WIDTH, 0.3870967742 * (double)HEIGHT, 0.1111111111 * (double)WIDTH, 0.5967741935 * (double)HEIGHT));
        G2.draw(new Line2D.Double(0.8666666667 * (double)WIDTH, 0.3870967742 * (double)HEIGHT, 0.8666666667 * (double)WIDTH, 0.5967741935 * (double)HEIGHT));
        G2.dispose();
        return IMAGE;
    }

    private void calcInnerBounds() {
        Insets INSETS = this.getInsets();
        this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, this.getWidth() - INSETS.left - INSETS.right, this.getHeight() - INSETS.top - INSETS.bottom);
    }

    private Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(45, 62);
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        super.setPreferredSize(DIM);
        this.calcInnerBounds();
        this.init(DIM.width, DIM.height);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        super.setSize(WIDTH, HEIGHT);
        this.calcInnerBounds();
        this.init(WIDTH, HEIGHT);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setSize(Dimension DIM) {
        super.setSize(DIM);
        this.calcInnerBounds();
        this.init(DIM.width, DIM.height);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        super.setBounds(BOUNDS);
        this.calcInnerBounds();
        this.init(BOUNDS.width, BOUNDS.height);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        super.setBounds(X, Y, WIDTH, HEIGHT);
        this.calcInnerBounds();
        this.init(WIDTH, HEIGHT);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent EVENT) {
        if (EVENT.getActionCommand().equals("flip") && !this.reachedChar) {
            this.lastChar = this.currentChar;
            this.currentChar = (char)(this.currentChar + '\u0001');
            if (this.currentChar > '`') {
                this.currentChar = (char)32;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FlipChar.this.repaint(FlipChar.this.INNER_BOUNDS);
                }
            });
            this.flipComplete = false;
            if (this.currentChar == this.character.charAt(0)) {
                this.reachedChar = true;
            }
        }
        if (EVENT.getActionCommand().equals("flipSequence") && !this.flipComplete) {
            if (this.currentFlipSequenceImage == 9) {
                this.currentFlipSequenceImage = 0;
                this.flipSequenceImage = null;
                this.flipComplete = true;
                this.repaint(this.INNER_BOUNDS);
            } else {
                this.flipSequenceImage = FlipImages.INSTANCE.getFlipImageArray()[this.currentFlipSequenceImage];
                ++this.currentFlipSequenceImage;
                this.repaint(this.INNER_BOUNDS);
            }
        }
    }
}

