/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import eu.hansolo.custom.Theme;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.ease.Linear;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.ease.TimelineEase;

public class Counter
extends JComponent
implements ComponentListener {
    protected static final String INC_PROPERTY = "inc";
    protected static final String DEC_PROPERTY = "dec";
    protected static final String ZERO_PROPERTY = "zero";
    private boolean zero = true;
    private int maxValue = 10;
    private boolean incFired = true;
    private boolean decFired = false;
    private int fireIncrementThreshold = 0;
    private int fireDecrementThreshold = 0;
    private Theme theme;
    private Color backgroundColor;
    private BufferedImage backgroundImage;
    private final ArrayList<BufferedImage> DIGIT_STACK = new ArrayList(10);
    private BufferedImage lenseImage;
    private BufferedImage stackImage;
    private final Point POS;
    private final Rectangle CLIP;
    private final Rectangle DIGIT_CLIP;
    private long switchTime = 500L;
    private int offset0 = 0;
    private int offset1 = 0;
    private int oldOffsetIncrement = 0;
    private int offsetIncrement = 0;
    private int oldOffsetDecrement = 0;
    private int offsetDecrement = 0;
    private final Timeline TIMELINE_INCREMENT;
    private final Timeline TIMELINE_DECREMENT;
    private final TimelineCallback TIMELINE_INCREMENT_CALLBACK;
    private final TimelineCallback TIMELINE_DECREMENT_CALLBACK;
    private final Linear LINEAR_EASING;
    private final Spline SPLINE_EASING;

    public Counter() {
        this.theme = Theme.BRIGHT;
        this.backgroundColor = Color.RED;
        this.POS = new Point(0, 0);
        this.CLIP = new Rectangle(0, 0, 44, 110);
        this.DIGIT_CLIP = new Rectangle(2, 2, 40, 106);
        this.TIMELINE_INCREMENT = new Timeline((Object)this);
        this.TIMELINE_DECREMENT = new Timeline((Object)this);
        this.TIMELINE_INCREMENT_CALLBACK = new TimelineCallback(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float oldValue, float newValue) {
                if (newState == Timeline.TimelineState.DONE) {
                    Counter.this.setOffsetIncrement(((BufferedImage)Counter.this.DIGIT_STACK.get(0)).getHeight());
                    Counter.this.repaint();
                }
            }

            public void onTimelinePulse(float oldValue, float newValue) {
                if (Counter.this.offset0 >= Counter.this.fireIncrementThreshold && Counter.this.offset0 < Counter.this.fireIncrementThreshold + 10 && !Counter.this.incFired) {
                    Counter.this.firePropertyChange(Counter.ZERO_PROPERTY, false, true);
                    Counter.this.firePropertyChange(Counter.INC_PROPERTY, false, true);
                    Counter.this.incFired = true;
                    Counter.this.zero = true;
                }
                if (Counter.this.offset1 >= Counter.this.fireIncrementThreshold && Counter.this.offset1 < Counter.this.fireIncrementThreshold + 10 && !Counter.this.incFired) {
                    Counter.this.firePropertyChange(Counter.ZERO_PROPERTY, false, true);
                    Counter.this.firePropertyChange(Counter.INC_PROPERTY, false, true);
                    Counter.this.incFired = true;
                    Counter.this.zero = true;
                }
                Counter.this.repaint();
            }
        };
        this.TIMELINE_DECREMENT_CALLBACK = new TimelineCallback(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float oldValue, float newValue) {
                if (newState == Timeline.TimelineState.DONE) {
                    Counter.this.setOffsetDecrement(((BufferedImage)Counter.this.DIGIT_STACK.get(0)).getHeight());
                    Counter.this.repaint();
                }
            }

            public void onTimelinePulse(float oldValue, float newValue) {
                if (Counter.this.offset0 <= Counter.this.fireDecrementThreshold + ((BufferedImage)Counter.this.DIGIT_STACK.get(0)).getHeight() && Counter.this.offset0 > Counter.this.fireDecrementThreshold + ((BufferedImage)Counter.this.DIGIT_STACK.get(0)).getHeight() - 10) {
                    Counter.this.firePropertyChange(Counter.ZERO_PROPERTY, false, true);
                    Counter.this.zero = true;
                }
                if (Counter.this.offset1 <= Counter.this.fireDecrementThreshold + ((BufferedImage)Counter.this.DIGIT_STACK.get(0)).getHeight() && Counter.this.offset1 > Counter.this.fireDecrementThreshold + ((BufferedImage)Counter.this.DIGIT_STACK.get(0)).getHeight() - 10) {
                    Counter.this.firePropertyChange(Counter.ZERO_PROPERTY, false, true);
                    Counter.this.zero = true;
                }
                if (Counter.this.offset0 <= Counter.this.fireDecrementThreshold && Counter.this.offset0 > Counter.this.fireDecrementThreshold - 10 && !Counter.this.decFired) {
                    Counter.this.firePropertyChange(Counter.DEC_PROPERTY, false, true);
                    Counter.this.decFired = true;
                }
                if (Counter.this.offset1 <= Counter.this.fireDecrementThreshold && Counter.this.offset1 > Counter.this.fireDecrementThreshold - 10 && !Counter.this.decFired) {
                    Counter.this.firePropertyChange(Counter.DEC_PROPERTY, false, true);
                    Counter.this.decFired = true;
                }
                Counter.this.repaint();
            }
        };
        this.TIMELINE_INCREMENT.addCallback(this.TIMELINE_INCREMENT_CALLBACK);
        this.TIMELINE_DECREMENT.addCallback(this.TIMELINE_DECREMENT_CALLBACK);
        this.LINEAR_EASING = new Linear();
        this.SPLINE_EASING = new Spline(0.9f);
        this.addComponentListener(this);
        this.setMinimumSize(new Dimension(22, 55));
        this.setPreferredSize(new Dimension(44, 110));
        this.setSize(this.getPreferredSize());
        this.init(this.getWidth(), this.getHeight());
    }

    private void init(int WIDTH, int HEIGHT) {
        this.backgroundImage = this.create_BACKGROUND_Image(WIDTH);
        this.DIGIT_STACK.clear();
        for (int i = 0; i < this.maxValue; ++i) {
            this.DIGIT_STACK.add(this.create_DIGIT_Image(WIDTH, i));
        }
        this.lenseImage = this.create_LENSE_Image(WIDTH);
        this.stackImage = this.create_STACK_Image(WIDTH);
        this.POS.setLocation(0, -this.stackImage.getHeight() - this.stackImage.getHeight() + this.backgroundImage.getHeight());
        this.offset0 = (int)((double)this.stackImage.getHeight() - (double)this.backgroundImage.getHeight() * 0.3);
        this.offset1 = (int)((double)(this.stackImage.getHeight() + this.stackImage.getHeight()) - (double)this.backgroundImage.getHeight() * 0.3);
        this.fireIncrementThreshold = (int)((double)(this.stackImage.getHeight() + this.stackImage.getHeight()) - (double)this.backgroundImage.getHeight() * 0.3) - this.DIGIT_STACK.get(0).getHeight();
        this.fireDecrementThreshold = (int)((double)(this.stackImage.getHeight() + this.stackImage.getHeight()) - (double)this.backgroundImage.getHeight() * 0.3);
        this.CLIP.setBounds(this.backgroundImage.getMinX(), this.backgroundImage.getMinY(), this.backgroundImage.getWidth(), this.backgroundImage.getHeight());
        this.DIGIT_CLIP.setBounds(this.backgroundImage.getMinX() + 2, this.backgroundImage.getMinY() + 2, this.backgroundImage.getWidth() - 4, this.backgroundImage.getHeight() - 4);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setClip(this.CLIP);
        G2.drawImage((Image)this.backgroundImage, 0, 0, null);
        G2.setClip(this.DIGIT_CLIP);
        G2.drawImage((Image)this.stackImage, 0, this.POS.y + this.offset0, null);
        G2.drawImage((Image)this.stackImage, 0, this.POS.y + this.offset1, null);
        G2.setClip(this.CLIP);
        G2.drawImage((Image)this.lenseImage, 0, 0, null);
        G2.dispose();
    }

    public void increment() {
        if (this.TIMELINE_INCREMENT.getState() != Timeline.TimelineState.IDLE) {
            this.TIMELINE_INCREMENT.abort();
            this.setOffsetIncrement(this.DIGIT_STACK.get(0).getHeight());
            this.repaint();
        }
        this.TIMELINE_INCREMENT.addPropertyToInterpolate("offsetIncrement", (Object)0, (Object)this.DIGIT_STACK.get(0).getHeight());
        if (this.switchTime < 350L) {
            this.TIMELINE_INCREMENT.setEase((TimelineEase)this.LINEAR_EASING);
        } else {
            this.TIMELINE_INCREMENT.setEase((TimelineEase)this.SPLINE_EASING);
        }
        this.zero = false;
        this.TIMELINE_INCREMENT.setDuration(this.switchTime);
        this.TIMELINE_INCREMENT.play();
    }

    public void decrement() {
        if (this.TIMELINE_DECREMENT.getState() != Timeline.TimelineState.IDLE) {
            this.TIMELINE_DECREMENT.abort();
            this.setOffsetDecrement(this.DIGIT_STACK.get(0).getHeight());
            this.repaint();
        }
        this.TIMELINE_DECREMENT.addPropertyToInterpolate("offsetDecrement", (Object)0, (Object)this.DIGIT_STACK.get(0).getHeight());
        if (this.switchTime < 350L) {
            this.TIMELINE_DECREMENT.setEase((TimelineEase)this.LINEAR_EASING);
        } else {
            this.TIMELINE_DECREMENT.setEase((TimelineEase)this.SPLINE_EASING);
        }
        this.zero = false;
        this.TIMELINE_DECREMENT.setDuration(this.switchTime);
        this.TIMELINE_DECREMENT.play();
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme THEME) {
        this.theme = THEME;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color BACKGROUND_COLOR) {
        this.backgroundColor = BACKGROUND_COLOR;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public int getOffsetIncrement() {
        return this.offsetIncrement;
    }

    public void setOffsetIncrement(int OFFSET_INCREMENT) {
        this.oldOffsetIncrement = OFFSET_INCREMENT == 0 ? 0 : this.offsetIncrement;
        this.offsetIncrement = OFFSET_INCREMENT;
        this.offset0 += this.offsetIncrement - this.oldOffsetIncrement;
        this.offset1 += this.offsetIncrement - this.oldOffsetIncrement;
        if (this.POS.y + this.offset0 >= this.backgroundImage.getHeight()) {
            this.offset0 -= this.stackImage.getHeight() + this.stackImage.getHeight();
            this.incFired = false;
        }
        if (this.POS.y + this.offset1 >= this.backgroundImage.getHeight()) {
            this.offset1 -= this.stackImage.getHeight() + this.stackImage.getHeight();
            this.incFired = false;
        }
    }

    public int getOffsetDecrement() {
        return this.offsetDecrement;
    }

    public void setOffsetDecrement(int OFFSET_DECREMENT) {
        this.oldOffsetDecrement = OFFSET_DECREMENT == 0 ? 0 : this.offsetDecrement;
        this.offsetDecrement = OFFSET_DECREMENT;
        this.offset0 -= this.offsetDecrement - this.oldOffsetDecrement;
        this.offset1 -= this.offsetDecrement - this.oldOffsetDecrement;
        if (this.POS.y + this.offset0 <= -this.stackImage.getHeight()) {
            this.offset0 += this.stackImage.getHeight() + this.stackImage.getHeight();
            this.decFired = false;
        }
        if (this.POS.y + this.offset1 <= -this.stackImage.getHeight()) {
            this.offset1 += this.stackImage.getHeight() + this.stackImage.getHeight();
            this.decFired = false;
        }
    }

    public long getSwitchTime() {
        return this.switchTime;
    }

    public void setSwitchTime(long SWITCH_TIME) {
        this.switchTime = SWITCH_TIME;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int MAX_VALUE) {
        this.maxValue = MAX_VALUE > 10 ? 10 : MAX_VALUE;
        this.maxValue = MAX_VALUE < 3 ? 3 : MAX_VALUE;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public boolean isZero() {
        return this.zero;
    }

    public void reset() {
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    private BufferedImage create_BACKGROUND_Image(int WIDTH) {
        Color FILL_COLOR_BACKGROUND;
        if (WIDTH <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, (int)(2.5 * (double)WIDTH), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        RoundRectangle2D.Double FRAME = new RoundRectangle2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT, 11.0, 11.0);
        Point2D.Double FRAME_START = new Point2D.Double(0.0, FRAME.getBounds2D().getMinY());
        Point2D.Double FRAME_STOP = new Point2D.Double(0.0, FRAME.getBounds2D().getMaxY());
        float[] FRAME_FRACTIONS = new float[]{0.0f, 0.03f, 0.17f, 0.28f, 0.51f, 0.71f, 0.82f, 0.96f, 0.99f, 1.0f};
        Color[] FRAME_COLORS = new Color[]{new Color(41, 44, 41, 255), new Color(41, 40, 41, 255), new Color(49, 48, 49, 255), new Color(49, 44, 49, 255), new Color(49, 48, 49, 255), new Color(49, 44, 49, 255), new Color(49, 48, 49, 255), new Color(41, 44, 41, 255), new Color(41, 48, 49, 255), new Color(41, 48, 49, 255)};
        LinearGradientPaint FRAME_GRADIENT = new LinearGradientPaint(FRAME_START, FRAME_STOP, FRAME_FRACTIONS, FRAME_COLORS);
        G2.setPaint(FRAME_GRADIENT);
        G2.fill(FRAME);
        RoundRectangle2D.Double INNER_BACKGROUND = new RoundRectangle2D.Double(1.0, 1.0, IMAGE_WIDTH - 2, IMAGE_HEIGHT - 2, 10.0, 10.0);
        Point2D.Double INNER_BACKGROUND_START = new Point2D.Double(0.0, INNER_BACKGROUND.getBounds2D().getMinY());
        Point2D.Double INNER_BACKGROUND_STOP = new Point2D.Double(0.0, INNER_BACKGROUND.getBounds2D().getMaxY());
        float[] INNER_BACKGROUND_FRACTIONS = new float[]{0.0f, 0.48f, 1.0f};
        Color[] INNER_BACKGROUND_COLORS = new Color[]{new Color(0, 0, 0, 255), new Color(107, 105, 99, 255), new Color(0, 0, 0, 255)};
        LinearGradientPaint INNER_BACKGROUND_GRADIENT = new LinearGradientPaint(INNER_BACKGROUND_START, INNER_BACKGROUND_STOP, INNER_BACKGROUND_FRACTIONS, INNER_BACKGROUND_COLORS);
        G2.setPaint(INNER_BACKGROUND_GRADIENT);
        G2.fill(INNER_BACKGROUND);
        RoundRectangle2D.Double BACKGROUND = new RoundRectangle2D.Double(2.0, 2.0, IMAGE_WIDTH - 4, IMAGE_HEIGHT - 4, 9.0, 9.0);
        switch (this.theme) {
            case BRIGHT: {
                FILL_COLOR_BACKGROUND = new Color(16382970);
                break;
            }
            case DARK: {
                FILL_COLOR_BACKGROUND = new Color(3224633);
                break;
            }
            case CUSTOM: {
                FILL_COLOR_BACKGROUND = this.getBackgroundColor();
                break;
            }
            default: {
                FILL_COLOR_BACKGROUND = new Color(16382970);
            }
        }
        G2.setColor(FILL_COLOR_BACKGROUND);
        G2.fill(BACKGROUND);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_DIGIT_Image(int WIDTH, int DIGIT) {
        Color TEXT_COLOR;
        Color SHADOW_COLOR;
        if (WIDTH <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        Font FONT = new Font("Monospaced", 1, (int)((double)WIDTH * 1.0454545455));
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        TextLayout TEXT_LAYOUT = new TextLayout(Integer.toString(DIGIT), FONT, RENDER_CONTEXT);
        Rectangle2D.Double TEXT_BOUNDARY = new Rectangle2D.Double(TEXT_LAYOUT.getBounds().getMinX(), TEXT_LAYOUT.getBounds().getMinY(), TEXT_LAYOUT.getBounds().getWidth(), TEXT_LAYOUT.getBounds().getHeight() + (double)(TEXT_LAYOUT.getDescent() / 2.0f));
        Point2D.Double TEXT_POS = new Point2D.Double(((double)IMAGE_WIDTH - ((RectangularShape)TEXT_BOUNDARY).getWidth()) / 2.0, ((double)IMAGE_HEIGHT - ((RectangularShape)TEXT_BOUNDARY).getHeight()) / 2.0 + ((RectangularShape)TEXT_BOUNDARY).getHeight() - (double)(TEXT_LAYOUT.getDescent() / 3.0f));
        switch (this.theme) {
            case BRIGHT: {
                SHADOW_COLOR = Color.WHITE;
                TEXT_COLOR = Color.BLACK;
                break;
            }
            case DARK: {
                SHADOW_COLOR = Color.BLACK;
                TEXT_COLOR = Color.WHITE;
                break;
            }
            case CUSTOM: {
                if (this.getLuminance(this.getBackgroundColor()) > 128.0) {
                    SHADOW_COLOR = Color.WHITE;
                    TEXT_COLOR = Color.BLACK;
                    break;
                }
                SHADOW_COLOR = Color.BLACK;
                TEXT_COLOR = Color.WHITE;
                break;
            }
            default: {
                SHADOW_COLOR = Color.WHITE;
                TEXT_COLOR = Color.BLACK;
            }
        }
        G2.setFont(FONT);
        G2.setColor(SHADOW_COLOR);
        G2.drawString(Integer.toString(DIGIT), (int)((Point2D)TEXT_POS).getX() + 1, (int)((Point2D)TEXT_POS).getY() + 1);
        G2.setColor(TEXT_COLOR);
        G2.drawString(Integer.toString(DIGIT), (int)((Point2D)TEXT_POS).getX(), (int)((Point2D)TEXT_POS).getY());
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_LENSE_Image(int WIDTH) {
        Color[] GLASS_COLORS;
        if (WIDTH <= 0) {
            return null;
        }
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, (int)(2.5 * (double)WIDTH), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        RoundRectangle2D.Double ROLL_SHADOW = new RoundRectangle2D.Double(1.0, 1.0, IMAGE_WIDTH - 2, IMAGE_HEIGHT - 2, 10.0, 10.0);
        Point2D.Double ROLL_SHADOW_START = new Point2D.Double(0.0, ROLL_SHADOW.getBounds2D().getMinY());
        Point2D.Double ROLL_SHADOW_STOP = new Point2D.Double(0.0, ROLL_SHADOW.getBounds2D().getMaxY());
        float[] ROLL_SHADOW_FRACTIONS = new float[]{0.0f, 0.07f, 0.0701f, 0.14f, 0.1401f, 0.22f, 0.23f, 0.28f, 0.49f, 0.4901f, 0.69f, 0.7f, 0.75f, 0.7501f, 0.85f, 0.92f, 0.93f, 0.99f, 1.0f};
        Color[] ROLL_SHADOW_COLORS = new Color[]{new Color(0, 0, 0, 255), new Color(0, 0, 0, 216), new Color(0, 0, 0, 211), new Color(0, 0, 0, 153), new Color(0, 0, 0, 147), new Color(0, 0, 0, 56), new Color(21, 21, 21, 51), new Color(255, 255, 255, 40), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 4), new Color(23, 23, 23, 51), new Color(0, 0, 0, 55), new Color(0, 0, 0, 147), new Color(0, 0, 0, 211), new Color(0, 0, 0, 216), new Color(0, 0, 0, 252), new Color(0, 0, 0, 255)};
        LinearGradientPaint ROLL_SHADOW_GRADIENT = new LinearGradientPaint(ROLL_SHADOW_START, ROLL_SHADOW_STOP, ROLL_SHADOW_FRACTIONS, ROLL_SHADOW_COLORS);
        G2.setPaint(ROLL_SHADOW_GRADIENT);
        G2.fill(ROLL_SHADOW);
        Rectangle2D.Double GLASS = new Rectangle2D.Double(0.0, (double)IMAGE_HEIGHT * 0.3, IMAGE_WIDTH, (double)IMAGE_HEIGHT * 0.4);
        Point2D.Double GLASS_START = new Point2D.Double(0.0, ((Rectangle2D)GLASS).getBounds2D().getMinY());
        Point2D.Double GLASS_STOP = new Point2D.Double(0.0, ((Rectangle2D)GLASS).getBounds2D().getMaxY());
        float[] GLASS_FRACTIONS = new float[]{0.0f, 0.06f, 0.49f, 0.4901f, 0.5f, 1.0f};
        switch (this.theme) {
            case BRIGHT: {
                GLASS_COLORS = new Color[]{new Color(204, 204, 204, 102), new Color(0, 0, 0, 94), new Color(0, 0, 0, 38), new Color(0, 0, 0, 38), new Color(0, 0, 0, 76), new Color(0, 0, 0, 76)};
                break;
            }
            case DARK: {
                GLASS_COLORS = new Color[]{new Color(204, 204, 204, 102), new Color(0, 0, 0, 94), new Color(0, 0, 0, 38), new Color(0, 0, 0, 38), new Color(0, 0, 0, 76), new Color(0, 0, 0, 76)};
                break;
            }
            case CUSTOM: {
                if (this.getLuminance(this.getBackgroundColor()) > 128.0) {
                    GLASS_COLORS = new Color[]{new Color(204, 204, 204, 102), new Color(0, 0, 0, 94), new Color(0, 0, 0, 38), new Color(0, 0, 0, 38), new Color(0, 0, 0, 76), new Color(0, 0, 0, 76)};
                    break;
                }
                GLASS_COLORS = new Color[]{new Color(204, 204, 204, 102), new Color(0, 0, 0, 94), new Color(0, 0, 0, 38), new Color(0, 0, 0, 38), new Color(0, 0, 0, 76), new Color(0, 0, 0, 76)};
                break;
            }
            default: {
                GLASS_COLORS = new Color[]{new Color(204, 204, 204, 102), new Color(0, 0, 0, 94), new Color(0, 0, 0, 38), new Color(0, 0, 0, 38), new Color(0, 0, 0, 76), new Color(0, 0, 0, 76)};
            }
        }
        LinearGradientPaint GLASS_GRADIENT = new LinearGradientPaint(GLASS_START, GLASS_STOP, GLASS_FRACTIONS, GLASS_COLORS);
        G2.setPaint(GLASS_GRADIENT);
        G2.fill(GLASS);
        Color STROKE_COLOR_GLASS_FRAME = new Color(0x898989);
        G2.setColor(STROKE_COLOR_GLASS_FRAME);
        G2.setStroke(new BasicStroke(1.0f, 0, 0));
        G2.drawLine(0, (int)GLASS.getMinY(), IMAGE_WIDTH, (int)GLASS.getMinY());
        G2.drawLine(0, (int)GLASS.getMaxY(), IMAGE_WIDTH, (int)GLASS.getMaxY());
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_STACK_Image(int WIDTH) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, this.DIGIT_STACK.get(0).getHeight() * this.maxValue, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = this.maxValue - 1; i > -1; --i) {
            G2.drawImage((Image)this.DIGIT_STACK.get(i), 0, 0, null);
            G2.translate(0, this.DIGIT_STACK.get(i).getHeight());
        }
        G2.dispose();
        return IMAGE;
    }

    private double getLuminance(Color COLOR) {
        double RED = COLOR.getRed();
        double GREEN = COLOR.getGreen();
        double BLUE = COLOR.getBlue();
        return RED * 0.3 + GREEN * 0.59 + BLUE * 0.11;
    }

    @Override
    public void componentResized(ComponentEvent EVENT) {
        if (this.getWidth() < this.getMinimumSize().width || this.getHeight() < this.getMinimumSize().height) {
            this.setSize(this.getMinimumSize());
        }
        if (this.getHeight() != (int)((double)this.getWidth() * 2.5)) {
            this.setSize((int)((double)this.getHeight() / 2.5), this.getHeight());
        } else {
            this.setSize(this.getWidth(), (int)((double)this.getWidth() * 2.5));
        }
        this.init(this.getWidth(), this.getHeight());
    }

    @Override
    public void componentMoved(ComponentEvent EVENT) {
    }

    @Override
    public void componentShown(ComponentEvent EVENT) {
    }

    @Override
    public void componentHidden(ComponentEvent EVENT) {
    }

    @Override
    public String toString() {
        return "Counter";
    }
}

