/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.git;

import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import griffon.util.BuildSettingsHolder;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import groovy.util.ConfigObject;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProviderUserInfo;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;

public class GitManager {
    private static final String KEY_USERNAME = ".username";
    private static final String KEY_PASSWORD = ".password";
    private static final String KEY_PASSPHRASE = ".passphrase";
    private static final String KEY_PREFIX = "git.repositories.";
    private final ConfigObject config;
    private Git git;

    public GitManager() throws IOException {
        this(BuildSettingsHolder.getSettings().getConfig());
    }

    public GitManager(ConfigObject config) throws IOException {
        this.config = config == null || config.isEmpty() ? BuildSettingsHolder.getSettings().getConfig() : config;
        this.initIfNeeded();
    }

    public void readyPush() {
        SshSessionFactory.setInstance((SshSessionFactory)new MyJschConfigSessionFactory());
    }

    public Git git() throws IOException {
        if (null == this.git) {
            this.git = Git.open((File)new File(".git"));
        }
        return this.git;
    }

    public void close() {
        if (null != this.git) {
            this.git.getRepository().close();
            this.git = null;
        }
    }

    public PersonIdent getAuthor() {
        return this.personIdentFor("author");
    }

    public PersonIdent getCommitter() {
        return this.personIdentFor("committer");
    }

    private PersonIdent personIdentFor(String key) {
        String name = (String)this.getConfigValue("git." + key + ".name", null);
        String email = (String)this.getConfigValue("git." + key + ".email", null);
        if (GriffonNameUtils.isBlank((String)name) || GriffonNameUtils.isBlank((String)email)) {
            try {
                StoredConfig storedConfig = this.git().getRepository().getConfig();
                storedConfig.load();
                name = storedConfig.getString("user", null, "name");
                email = storedConfig.getString("user", null, "email");
            }
            catch (IOException e) {
            }
            catch (ConfigInvalidException e) {
                // empty catch block
            }
        }
        if (!GriffonNameUtils.isBlank((String)name) && !GriffonNameUtils.isBlank((String)email)) {
            return new PersonIdent(name, email);
        }
        return null;
    }

    private Object getConfigValue(String key, Object defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        Map map = this.config.flatten(new LinkedHashMap());
        value = map.get(key);
        return value != null ? value : defaultValue;
    }

    private void initIfNeeded() throws IOException {
        try {
            this.git();
        }
        catch (IOException e) {
            File basedir = new File(".");
            InitCommand init = Git.init();
            init.setDirectory(basedir);
            init.call();
            System.out.println("Initialized Git repository in " + basedir.getAbsolutePath() + "git");
            this.addIgnoreFile(basedir);
        }
    }

    private void addIgnoreFile(File basedir) throws IOException {
        File gitignore = new File(basedir, ".gitignore");
        DefaultGroovyMethods.setText((File)gitignore, (String)"target\n");
        AddCommand add = this.git().add();
        add.addFilepattern(gitignore.getName());
        try {
            add.call();
        }
        catch (NoFilepatternException e1) {
            // empty catch block
        }
    }

    public CredentialsProvider getCredentialsProvider(String repository) {
        String username = this.getUsername(repository);
        String password = this.getPassword(repository);
        String passphrase = this.getPassphrase(repository);
        if (GriffonNameUtils.isBlank((String)username) || GriffonNameUtils.isBlank((String)password)) {
            return null;
        }
        return new ExtendedCredentialsProvider(username, password, passphrase);
    }

    private String getUsername(String repository) {
        return ConfigUtils.getConfigValueAsString((Map)this.config, (String)(KEY_PREFIX + repository + KEY_USERNAME), null);
    }

    private String getPassword(String repository) {
        return ConfigUtils.getConfigValueAsString((Map)this.config, (String)(KEY_PREFIX + repository + KEY_PASSWORD), null);
    }

    private String getPassphrase(String repository) {
        return ConfigUtils.getConfigValueAsString((Map)this.config, (String)(KEY_PREFIX + repository + KEY_PASSPHRASE), null);
    }

    private static class ExtendedCredentialsProviderUserInfo
    extends CredentialsProviderUserInfo {
        private CredentialsProvider credentialsProvider;

        public ExtendedCredentialsProviderUserInfo(Session session, CredentialsProvider credentialsProvider) {
            super(session, credentialsProvider);
            this.credentialsProvider = credentialsProvider;
        }

        public boolean promptPassphrase(String msg) {
            return !GriffonNameUtils.isBlank((String)this.getCredentials().getPassphrase());
        }

        public String getPassphrase() {
            return this.getCredentials().getPassphrase();
        }

        private ExtendedCredentialsProvider getCredentials() {
            return (ExtendedCredentialsProvider)this.credentialsProvider;
        }
    }

    private static class MyJschConfigSessionFactory
    extends JschConfigSessionFactory {
        private CredentialsProvider credentialsProvider;

        private MyJschConfigSessionFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
            this.credentialsProvider = credentialsProvider;
            try {
                RemoteSession remoteSession = super.getSession(uri, credentialsProvider, fs, tms);
                return remoteSession;
            }
            finally {
                this.credentialsProvider = null;
            }
        }

        protected void configure(OpenSshConfig.Host host, Session session) {
            if (this.credentialsProvider instanceof ExtendedCredentialsProvider) {
                session.setUserInfo((UserInfo)new ExtendedCredentialsProviderUserInfo(session, this.credentialsProvider));
            }
        }
    }

    private static class ExtendedCredentialsProvider
    extends UsernamePasswordCredentialsProvider {
        private String passphrase;

        public ExtendedCredentialsProvider(String username, String password, String passphrase) {
            super(username, password);
            this.passphrase = passphrase;
        }

        public String getPassphrase() {
            return this.passphrase;
        }
    }
}

