/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import net.miginfocom.swing.MigLayout;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.swing.JMapPane;
import org.geotools.swing.MapLayerTable;
import org.geotools.swing.MapPane;
import org.geotools.swing.action.InfoAction;
import org.geotools.swing.action.NoToolAction;
import org.geotools.swing.action.PanAction;
import org.geotools.swing.action.ResetAction;
import org.geotools.swing.action.ZoomInAction;
import org.geotools.swing.action.ZoomOutAction;
import org.geotools.swing.control.JMapStatusBar;

public class JMapViewer
extends JComponent {
    public static final String TOOLBAR_INFO_BUTTON_NAME = "ToolbarInfoButton";
    public static final String TOOLBAR_PAN_BUTTON_NAME = "ToolbarPanButton";
    public static final String TOOLBAR_POINTER_BUTTON_NAME = "ToolbarPointerButton";
    public static final String TOOLBAR_RESET_BUTTON_NAME = "ToolbarResetButton";
    public static final String TOOLBAR_ZOOMIN_BUTTON_NAME = "ToolbarZoomInButton";
    public static final String TOOLBAR_ZOOMOUT_BUTTON_NAME = "ToolbarZoomOutButton";
    private Set<Tool> toolSet = EnumSet.allOf(Tool.class);
    private JMapPane mapPane;
    private MapLayerTable mapLayerTable;
    private JToolBar toolBar;
    private JMapStatusBar statusBar;
    private boolean showToolBar = true;
    private boolean showStatusBar = true;
    private boolean showLayerTable = false;
    private boolean uiSet;

    public JMapViewer() {
        this(null);
    }

    public JMapViewer(MapContent content) {
        this.mapPane = new JMapPane(content);
        this.mapPane.setBackground(Color.WHITE);
        this.mapPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.mapPane.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JMapViewer.this.mapPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            }

            @Override
            public void focusLost(FocusEvent e) {
                JMapViewer.this.mapPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            }
        });
        this.mapPane.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JMapViewer.this.mapPane.requestFocusInWindow();
            }
        });
    }

    public void setShowToolBar(boolean enabled) {
        if (enabled) {
            this.toolSet = EnumSet.allOf(Tool.class);
        } else {
            this.toolSet.clear();
        }
        this.showToolBar = enabled;
    }

    public void enableTool(Tool ... tool) {
        if (tool == null || tool.length == 0) {
            this.setShowToolBar(false);
        } else {
            this.toolSet = EnumSet.copyOf(Arrays.asList(tool));
            this.showToolBar = true;
        }
    }

    public void setShowStatusBar(boolean enabled) {
        this.showStatusBar = enabled;
    }

    public void setShowLayerTable(boolean enabled) {
        this.showLayerTable = enabled;
    }

    @Override
    public void validate() {
        this.initComponents();
        super.validate();
    }

    public void initComponents() {
        JButton btn;
        if (this.uiSet) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (!this.toolSet.isEmpty()) {
            sb.append("[]");
        }
        sb.append("[grow]");
        if (this.showStatusBar) {
            sb.append("[min!]");
        }
        this.setLayout((LayoutManager)new MigLayout("wrap 1, insets 0", "[grow]", sb.toString()));
        this.toolBar = new JToolBar();
        this.toolBar.setOrientation(0);
        this.toolBar.setFloatable(false);
        ButtonGroup cursorToolGrp = new ButtonGroup();
        if (this.toolSet.contains((Object)Tool.POINTER)) {
            btn = new JButton((Action)new NoToolAction((MapPane)this.mapPane));
            btn.setName(TOOLBAR_POINTER_BUTTON_NAME);
            this.toolBar.add(btn);
            cursorToolGrp.add(btn);
        }
        if (this.toolSet.contains((Object)Tool.ZOOM)) {
            btn = new JButton((Action)new ZoomInAction((MapPane)this.mapPane));
            btn.setName(TOOLBAR_ZOOMIN_BUTTON_NAME);
            this.toolBar.add(btn);
            cursorToolGrp.add(btn);
            btn = new JButton((Action)new ZoomOutAction((MapPane)this.mapPane));
            btn.setName(TOOLBAR_ZOOMOUT_BUTTON_NAME);
            this.toolBar.add(btn);
            cursorToolGrp.add(btn);
            this.toolBar.addSeparator();
        }
        if (this.toolSet.contains((Object)Tool.PAN)) {
            btn = new JButton((Action)new PanAction((MapPane)this.mapPane));
            btn.setName(TOOLBAR_PAN_BUTTON_NAME);
            this.toolBar.add(btn);
            cursorToolGrp.add(btn);
            this.toolBar.addSeparator();
        }
        if (this.toolSet.contains((Object)Tool.INFO)) {
            btn = new JButton((Action)new InfoAction((MapPane)this.mapPane));
            btn.setName(TOOLBAR_INFO_BUTTON_NAME);
            this.toolBar.add(btn);
            this.toolBar.addSeparator();
        }
        if (this.toolSet.contains((Object)Tool.RESET)) {
            btn = new JButton((Action)new ResetAction((MapPane)this.mapPane));
            btn.setName(TOOLBAR_RESET_BUTTON_NAME);
            this.toolBar.add(btn);
        }
        if (this.showToolBar) {
            this.add((Component)this.toolBar, "grow");
        }
        this.mapLayerTable = new MapLayerTable((MapPane)this.mapPane);
        if (this.showLayerTable) {
            this.mapLayerTable.setPreferredSize(new Dimension(200, -1));
            JSplitPane splitPane = new JSplitPane(1, false, (Component)this.mapLayerTable, (Component)this.mapPane);
            this.add((Component)splitPane, "grow");
        } else {
            this.add((Component)this.mapPane, "grow");
        }
        this.statusBar = JMapStatusBar.createDefaultStatusBar((MapPane)this.mapPane);
        if (this.showStatusBar) {
            this.add((Component)this.statusBar, "grow");
        }
        this.uiSet = true;
    }

    public MapContent getMapContent() {
        return this.mapPane.getMapContent();
    }

    public void setMapContent(MapContent content) {
        if (content == null) {
            throw new IllegalArgumentException("map content must not be null");
        }
        this.mapPane.setMapContent(content);
    }

    public JMapPane getMapPane() {
        return this.mapPane;
    }

    public MapLayerTable getMapLayerTable() {
        return this.mapLayerTable;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JMapStatusBar getStatusBar() {
        return this.statusBar;
    }

    public boolean isShowToolBar() {
        return this.showToolBar;
    }

    public boolean isShowStatusBar() {
        return this.showStatusBar;
    }

    public boolean isShowLayerTable() {
        return this.showLayerTable;
    }

    public GTRenderer getRenderer() {
        return this.mapPane.getRenderer();
    }

    public void setRenderer(GTRenderer renderer) {
        this.mapPane.setRenderer(renderer);
    }

    public static enum Tool {
        POINTER,
        INFO,
        PAN,
        RESET,
        ZOOM;

    }
}

