/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.fontawesome;

import griffon.plugins.fontawesome.FontAwesome;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;

public class FontAwesomeIcon
implements Icon {
    private static final String AWESOME_SET = "META-INF/resources/webjars/font-awesome/3.1.1/font/fontawesome-webfont.ttf";
    private static final Font awesome;
    private static final Object LOCK;
    private int size;
    private BufferedImage buffer;
    private FontAwesome id;
    private Color color = Color.BLACK;
    private Font font;

    public FontAwesomeIcon(FontAwesome id) {
        this.id = id;
        this.setSize(16);
    }

    public FontAwesomeIcon(String description) {
        this(FontAwesome.findByDescription(description));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Object object = LOCK;
        synchronized (object) {
            if (this.buffer == null) {
                this.buffer = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics2D g2 = (Graphics2D)this.buffer.getGraphics();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setFont(this.font);
                g2.setColor(this.color);
                int sy = this.size - this.size / 4 + this.size / 16;
                g2.drawString(String.valueOf(this.id.getCode()), 0, sy);
                g2.dispose();
            }
            g.drawImage(this.buffer, x, y, null);
        }
    }

    public int getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int size) {
        if (size > 0) {
            this.size = size;
            this.font = awesome.deriveFont(0, size);
            Object object = LOCK;
            synchronized (object) {
                this.buffer = null;
            }
        }
    }

    public Color getColor() {
        return this.color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColor(Color color) {
        this.color = color;
        Object object = LOCK;
        synchronized (object) {
            this.buffer = null;
        }
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    static {
        LOCK = new Object[0];
        try {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(AWESOME_SET);
            awesome = Font.createFont(0, stream);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(awesome);
            stream.close();
        }
        catch (FontFormatException ffe) {
            throw new RuntimeException(ffe);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

