/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.utils;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.jvnet.flamingo.utils.AbstractFilter;

public class ColorShiftFilter
extends AbstractFilter {
    int rShift;
    int gShift;
    int bShift;
    double hueShiftAmount;

    public ColorShiftFilter(Color shiftColor, double shiftAmount) {
        this.rShift = shiftColor.getRed();
        this.gShift = shiftColor.getGreen();
        this.bShift = shiftColor.getBlue();
        this.hueShiftAmount = shiftAmount;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int[] pixels = new int[width * height];
        this.getPixels(src, 0, 0, width, height, pixels);
        this.shiftColor(pixels);
        this.setPixels(dst, 0, 0, width, height, pixels);
        return dst;
    }

    private void shiftColor(int[] pixels) {
        for (int i = 0; i < pixels.length; ++i) {
            int argb = pixels[i];
            int r = argb >>> 16 & 0xFF;
            int g = argb >>> 8 & 0xFF;
            int b = argb >>> 0 & 0xFF;
            int nr = (int)(this.hueShiftAmount * (double)this.rShift + (1.0 - this.hueShiftAmount) * (double)r);
            int ng = (int)(this.hueShiftAmount * (double)this.gShift + (1.0 - this.hueShiftAmount) * (double)g);
            int nb = (int)(this.hueShiftAmount * (double)this.bShift + (1.0 - this.hueShiftAmount) * (double)b);
            pixels[i] = argb & 0xFF000000 | nr << 16 | ng << 8 | nb;
        }
    }
}

