/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.svg;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import javax.swing.event.EventListenerList;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.util.EventDispatcher;
import org.jvnet.flamingo.common.AsynchronousLoadListener;
import org.jvnet.flamingo.common.AsynchronousLoading;
import org.jvnet.flamingo.common.icon.ResizableIcon;
import org.jvnet.flamingo.svg.SvgBatikIcon;

public class SvgBatikResizableIcon
extends SvgBatikIcon
implements ResizableIcon,
AsynchronousLoading {
    private Dimension initialDim;
    protected EventListenerList listenerList = new EventListenerList();
    static EventDispatcher.Dispatcher asyncCompletedDispatcher = new EventDispatcher.Dispatcher(){

        public void dispatch(Object listener, Object event) {
            ((AsynchronousLoadListener)listener).completed((Boolean)event);
        }
    };

    protected static InputStream constructFromZipStream(InputStream zippedStream) throws IOException {
        int len;
        GZIPInputStream gis = new GZIPInputStream(zippedStream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        while ((len = gis.read(buf)) != -1) {
            baos.write(buf, 0, len);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static SvgBatikResizableIcon getSvgIcon(URL location, Dimension initialDim) {
        try {
            return new SvgBatikResizableIcon(location.openStream(), initialDim);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static SvgBatikResizableIcon getSvgIcon(InputStream inputStream, Dimension initialDim) {
        if (inputStream == null) {
            return null;
        }
        try {
            return new SvgBatikResizableIcon(inputStream, initialDim);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static SvgBatikResizableIcon getSvgzIcon(URL location, Dimension initialDim) {
        try {
            return new SvgBatikResizableIcon(SvgBatikResizableIcon.constructFromZipStream(location.openStream()), initialDim);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static SvgBatikResizableIcon getSvgzIcon(InputStream inputStream, Dimension initialDim) {
        try {
            return new SvgBatikResizableIcon(SvgBatikResizableIcon.constructFromZipStream(inputStream), initialDim);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private SvgBatikResizableIcon(InputStream inputStream, Dimension initialDim) throws IOException {
        super(inputStream, initialDim.width, initialDim.height);
        this.initialDim = initialDim;
        this.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingCompleted(GVTTreeRendererEvent e) {
                SvgBatikResizableIcon.this.fireAsyncCompleted(true);
            }

            public void gvtRenderingFailed(GVTTreeRendererEvent arg0) {
                SvgBatikResizableIcon.this.fireAsyncCompleted(false);
            }
        });
    }

    public void revertToOriginalDimension() {
        this.setPreferredSize(this.initialDim);
    }

    @Override
    public void setDimension(Dimension dim) {
        this.setPreferredSize(dim);
    }

    public void setHeight(int height) {
        this.setPreferredSize(new Dimension(height, height));
    }

    public void setWidth(int width) {
        this.setPreferredSize(new Dimension(width, width));
    }

    @Override
    public void addAsynchronousLoadListener(AsynchronousLoadListener l) {
        this.listenerList.add(AsynchronousLoadListener.class, l);
    }

    @Override
    public void removeAsynchronousLoadListener(AsynchronousLoadListener l) {
        this.listenerList.remove(AsynchronousLoadListener.class, l);
    }

    @Override
    protected boolean renderGVTTree(int renderWidth, int renderHeight) {
        boolean cached = super.renderGVTTree(renderWidth, renderHeight);
        if (cached) {
            this.fireAsyncCompleted(true);
        }
        return cached;
    }

    protected void fireAsyncCompleted(Boolean event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AsynchronousLoadListener.class) continue;
            ((AsynchronousLoadListener)listeners[i + 1]).completed(event);
        }
    }

    @Override
    public synchronized boolean isLoading() {
        BufferedImage image = (BufferedImage)this.cachedImages.get(this.getIconWidth() + ":" + this.getIconHeight());
        return image == null;
    }
}

