/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.slider.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.jvnet.flamingo.slider.FlexiRangeModel;
import org.jvnet.flamingo.slider.JFlexiSlider;
import org.jvnet.flamingo.slider.ui.FlexiSliderUI;

public class BasicFlexiSliderUI
extends FlexiSliderUI {
    protected JFlexiSlider flexiSlider;
    protected JLabel[] controlPointLabels;
    protected JSlider slider;
    protected CellRendererPane sliderRendererPane;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    protected ChangeListener flexiSliderChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicFlexiSliderUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.flexiSlider = (JFlexiSlider)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
        c.setBorder(new EmptyBorder(1, 1, 1, 1));
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.flexiSlider = null;
    }

    public void installDefaults() {
    }

    public void installComponents() {
        int controlPointCount = this.flexiSlider.getControlPointCount();
        this.controlPointLabels = new JLabel[controlPointCount];
        for (int i = 0; i < controlPointCount; ++i) {
            this.controlPointLabels[i] = new JLabel(this.flexiSlider.getControlPointText(i));
            this.controlPointLabels[i].setIcon(this.flexiSlider.getControlPointIcon(i));
            this.flexiSlider.add(this.controlPointLabels[i]);
        }
        this.slider = new JSlider(1);
        this.slider.setFocusable(false);
        this.sliderRendererPane = new CellRendererPane();
        this.flexiSlider.add(this.sliderRendererPane);
    }

    public void installListeners() {
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BasicFlexiSliderUI.this.flexiSlider.getModel().setValueIsAdjusting(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                BasicFlexiSliderUI.this.flexiSlider.getModel().setValueIsAdjusting(true);
                int y = e.getY();
                FlexiRangeModel.Value modelValue = BasicFlexiSliderUI.this.sliderValueToModelValue(y);
                BasicFlexiSliderUI.this.flexiSlider.setValue(modelValue);
                BasicFlexiSliderUI.this.slider.setValue(BasicFlexiSliderUI.this.modelValueToSliderValue(modelValue));
            }
        };
        this.flexiSlider.addMouseListener(this.mouseListener);
        this.mouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                BasicFlexiSliderUI.this.flexiSlider.getModel().setValueIsAdjusting(true);
                int y = e.getY();
                FlexiRangeModel.Value modelValue = BasicFlexiSliderUI.this.sliderValueToModelValue(y);
                if (modelValue == null) {
                    return;
                }
                BasicFlexiSliderUI.this.flexiSlider.setValue(modelValue);
                BasicFlexiSliderUI.this.slider.setValue(BasicFlexiSliderUI.this.modelValueToSliderValue(modelValue));
            }
        };
        this.flexiSlider.addMouseMotionListener(this.mouseMotionListener);
        this.flexiSliderChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BasicFlexiSliderUI.this.flexiSlider.repaint();
            }
        };
        this.flexiSlider.getModel().addChangeListener(this.flexiSliderChangeListener);
    }

    public void uninstallDefaults() {
        for (JLabel label : this.controlPointLabels) {
            this.flexiSlider.remove(label);
        }
        this.controlPointLabels = null;
        this.flexiSlider.remove(this.sliderRendererPane);
        this.sliderRendererPane = null;
    }

    public void uninstallComponents() {
    }

    public void uninstallListeners() {
        this.flexiSlider.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        this.flexiSlider.removeMouseMotionListener(this.mouseMotionListener);
        this.mouseMotionListener = null;
        this.flexiSlider.getModel().removeChangeListener(this.flexiSliderChangeListener);
        this.flexiSliderChangeListener = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this.paintSlider(g);
    }

    protected void paintSlider(Graphics g) {
        Rectangle sliderBounds = this.sliderRendererPane.getBounds();
        this.sliderRendererPane.paintComponent(g, this.slider, this.flexiSlider, sliderBounds.x, sliderBounds.y, sliderBounds.width, sliderBounds.height, true);
    }

    protected int modelValueToSliderValue(FlexiRangeModel.Value modelValue) {
        if (modelValue == null) {
            return 0;
        }
        FlexiRangeModel.Range range = modelValue.range;
        FlexiRangeModel model = this.flexiSlider.getModel();
        for (int i = 0; i < model.getRangeCount(); ++i) {
            if (!range.equals(model.getRange(i))) continue;
            int rangeStartLoc = this.controlPointLabels[i].getY();
            rangeStartLoc = i != 0 ? (rangeStartLoc += this.controlPointLabels[i].getHeight() / 2) : (rangeStartLoc += this.controlPointLabels[i].getHeight());
            int rangeEndLoc = this.controlPointLabels[i + 1].getY();
            if (i != model.getRangeCount() - 1) {
                rangeEndLoc += this.controlPointLabels[i + 1].getHeight() / 2;
            }
            Insets ins = this.flexiSlider.getInsets();
            int result = (rangeStartLoc -= ins.top) + (int)(modelValue.rangeFraction * (double)((rangeEndLoc -= ins.top) - rangeStartLoc));
            return result;
        }
        return 0;
    }

    protected FlexiRangeModel.Value sliderValueToModelValue(int sliderValue) {
        FlexiRangeModel model = this.flexiSlider.getModel();
        for (int i = 0; i < model.getRangeCount(); ++i) {
            FlexiRangeModel.Range currRange = model.getRange(i);
            int startSliderValue = this.modelValueToSliderValue(new FlexiRangeModel.Value(currRange, 0.0));
            int endSliderValue = this.modelValueToSliderValue(new FlexiRangeModel.Value(currRange, 1.0));
            if (sliderValue < endSliderValue || sliderValue > startSliderValue) continue;
            if (currRange.isDiscrete()) {
                int deltaStart = startSliderValue - sliderValue;
                int deltaEnd = sliderValue - endSliderValue;
                if (deltaStart < deltaEnd) {
                    return new FlexiRangeModel.Value(currRange, 0.0);
                }
                return new FlexiRangeModel.Value(currRange, 1.0);
            }
            return new FlexiRangeModel.Value(currRange, (double)(startSliderValue - sliderValue) / (double)(startSliderValue - endSliderValue));
        }
        return null;
    }

    protected LayoutManager createLayoutManager() {
        return new FlexiSliderLayout();
    }

    protected class FlexiSliderLayout
    implements LayoutManager {
        protected FlexiSliderLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int width = 0;
            int height = 0;
            Insets ins = c.getInsets();
            JFlexiSlider flexiSlider = (JFlexiSlider)c;
            int controlPointCount = flexiSlider.getControlPointCount();
            for (int i = 0; i < controlPointCount; ++i) {
                height += BasicFlexiSliderUI.this.controlPointLabels[i].getPreferredSize().height;
            }
            height += 4 * (controlPointCount - 1);
            int maxLabelWidth = 0;
            for (int i = 0; i < controlPointCount; ++i) {
                maxLabelWidth = Math.max(maxLabelWidth, BasicFlexiSliderUI.this.controlPointLabels[i].getPreferredSize().width);
            }
            width = BasicFlexiSliderUI.this.slider.getPreferredSize().width + 4 + maxLabelWidth;
            return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            Insets ins = c.getInsets();
            int width = c.getWidth();
            int height = c.getHeight();
            JFlexiSlider flexiSlider = (JFlexiSlider)c;
            FlexiRangeModel model = flexiSlider.getModel();
            int rangeCount = model.getRangeCount();
            int prefHeight = this.preferredLayoutSize((Container)c).height;
            int extraHeight = height - prefHeight;
            double totalContiguousWeight = 0.0;
            for (int i = 0; i < rangeCount; ++i) {
                FlexiRangeModel.Range range = model.getRange(i);
                if (range.isDiscrete()) continue;
                totalContiguousWeight += range.getWeight();
            }
            int bumpY = totalContiguousWeight == 0.0 || (double)extraHeight < 0.0 ? extraHeight / rangeCount : 0;
            int labelX = BasicFlexiSliderUI.this.slider.getPreferredSize().width + ins.left + 4;
            int currentY = height - ins.bottom - BasicFlexiSliderUI.this.controlPointLabels[0].getPreferredSize().height;
            BasicFlexiSliderUI.this.controlPointLabels[0].setBounds(labelX, currentY, width - labelX - ins.left - ins.right, BasicFlexiSliderUI.this.controlPointLabels[0].getPreferredSize().height);
            for (int i = 0; i < rangeCount; ++i) {
                FlexiRangeModel.Range range = model.getRange(i);
                JLabel endLabel = BasicFlexiSliderUI.this.controlPointLabels[i + 1];
                if (range.isDiscrete()) {
                    int deltaY = endLabel.getPreferredSize().height + 4 + bumpY;
                    BasicFlexiSliderUI.this.controlPointLabels[i + 1].setBounds(labelX, currentY -= deltaY, width - labelX - ins.left - ins.right, endLabel.getPreferredSize().height);
                    continue;
                }
                double rangeWeight = range.getWeight();
                int currBump = 0;
                if ((double)bumpY < 0.0) {
                    currBump = bumpY;
                } else {
                    currBump = (int)((double)extraHeight * rangeWeight / totalContiguousWeight);
                    totalContiguousWeight -= rangeWeight;
                    extraHeight -= currBump;
                }
                int deltaY = endLabel.getPreferredSize().height + 4 + currBump;
                BasicFlexiSliderUI.this.controlPointLabels[i + 1].setBounds(labelX, currentY -= deltaY, width - labelX - ins.left - ins.right, endLabel.getPreferredSize().height);
            }
            int firstLabelCenter = BasicFlexiSliderUI.this.controlPointLabels[0].getY() + BasicFlexiSliderUI.this.controlPointLabels[0].getHeight();
            int lastLabelCenter = BasicFlexiSliderUI.this.controlPointLabels[rangeCount].getY();
            int sliderHeight = firstLabelCenter - lastLabelCenter;
            BasicFlexiSliderUI.this.sliderRendererPane.setBounds(ins.left, lastLabelCenter, BasicFlexiSliderUI.this.slider.getPreferredSize().width, sliderHeight);
            BasicFlexiSliderUI.this.slider.setMinimum(0);
            BasicFlexiSliderUI.this.slider.setMaximum(sliderHeight - 1);
            BasicFlexiSliderUI.this.slider.setInverted(true);
            BasicFlexiSliderUI.this.slider.setValue(BasicFlexiSliderUI.this.modelValueToSliderValue(flexiSlider.getValue()));
        }
    }
}

