/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.ui.appmenu;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.UIManager;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.CommandButtonDisplayState;
import org.jvnet.flamingo.common.CommandButtonLayoutManager;
import org.jvnet.flamingo.common.JCommandButton;
import org.jvnet.flamingo.common.icon.EmptyResizableIcon;
import org.jvnet.flamingo.common.icon.ResizableIcon;
import org.jvnet.flamingo.common.ui.BasicCommandButtonUI;
import org.jvnet.flamingo.ribbon.ui.appmenu.BasicRibbonApplicationMenuButtonUI;

public class JRibbonApplicationMenuButton
extends JCommandButton {
    public static final String uiClassID = "RibbonApplicationMenuButtonUI";
    private static final CommandButtonDisplayState APP_MENU_BUTTON_STATE = new CommandButtonDisplayState("Ribbon Application Menu Button", 24){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton commandButton) {
            return new CommandButtonLayoutManager(){

                @Override
                public int getPreferredIconSize() {
                    return 24;
                }

                @Override
                public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(AbstractCommandButton commandButton, Graphics g) {
                    CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
                    result.actionClickArea = new Rectangle(0, 0, 0, 0);
                    result.popupClickArea = new Rectangle(0, 0, commandButton.getWidth(), commandButton.getHeight());
                    result.popupActionRect = new Rectangle(0, 0, 0, 0);
                    ResizableIcon icon = commandButton.getIcon();
                    result.iconRect = new Rectangle((commandButton.getWidth() - icon.getIconWidth()) / 2, (commandButton.getHeight() - icon.getIconHeight()) / 2, icon.getIconWidth(), icon.getIconHeight());
                    result.isTextInActionArea = false;
                    return result;
                }

                @Override
                public Dimension getPreferredSize(AbstractCommandButton commandButton) {
                    return new Dimension(40, 40);
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                }

                @Override
                public Point getKeyTipAnchorCenterPoint(AbstractCommandButton commandButton) {
                    return new Point(commandButton.getWidth() / 2, commandButton.getHeight() / 2);
                }
            };
        }

        @Override
        public CommandButtonDisplayState.CommandButtonSeparatorOrientation getSeparatorOrientation() {
            return CommandButtonDisplayState.CommandButtonSeparatorOrientation.VERTICAL;
        }
    };

    public JRibbonApplicationMenuButton() {
        super("", new EmptyResizableIcon(16));
        this.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        this.setDisplayState(APP_MENU_BUTTON_STATE);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((BasicCommandButtonUI)UIManager.getUI(this));
        } else {
            this.setUI(BasicRibbonApplicationMenuButtonUI.createUI(this));
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }
}

