/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.jvnet.flamingo.ribbon.AbstractRibbonBand;
import org.jvnet.flamingo.ribbon.resize.IconRibbonBandResizePolicy;
import org.jvnet.flamingo.ribbon.resize.RibbonBandResizePolicy;
import org.jvnet.flamingo.ribbon.ui.AbstractBandControlPanelUI;
import org.jvnet.flamingo.ribbon.ui.BasicRibbonBandUI;
import org.jvnet.flamingo.ribbon.ui.JFlowBandControlPanel;

public class BasicFlowBandControlPanelUI
extends AbstractBandControlPanelUI {
    public static ComponentUI createUI(JComponent c) {
        return new BasicFlowBandControlPanelUI();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new FlowControlPanelLayout();
    }

    private class FlowControlPanelLayout
    implements LayoutManager {
        private FlowControlPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int buttonHeight = BasicFlowBandControlPanelUI.this.dummy.getPreferredSize().height;
            Insets ins = c.getInsets();
            return new Dimension(c.getWidth(), buttonHeight + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            JFlowBandControlPanel flowBandControlPanel = (JFlowBandControlPanel)c;
            AbstractRibbonBand ribbonBand = flowBandControlPanel.getRibbonBand();
            RibbonBandResizePolicy currentResizePolicy = ribbonBand.getCurrentResizePolicy();
            if (currentResizePolicy == null) {
                return;
            }
            Insets ins = c.getInsets();
            int x = ins.left;
            int gap = BasicFlowBandControlPanelUI.this.getLayoutGap();
            int availableHeight = c.getHeight() - ins.top - ins.bottom;
            if (SwingUtilities.getAncestorOfClass(BasicRibbonBandUI.CollapsedButtonPopupPanel.class, c) != null) {
                List<RibbonBandResizePolicy> resizePolicies = ribbonBand.getResizePolicies();
                resizePolicies.get(0).install(availableHeight, gap);
            } else {
                if (currentResizePolicy instanceof IconRibbonBandResizePolicy) {
                    return;
                }
                currentResizePolicy.install(availableHeight, gap);
            }
            int maxHeight = 0;
            int rowCount = 1;
            for (JComponent flowComponent : flowBandControlPanel.getFlowComponents()) {
                Dimension prefSize = flowComponent.getPreferredSize();
                if (x + prefSize.width > c.getWidth() - ins.right) {
                    x = ins.left;
                    ++rowCount;
                }
                x += prefSize.width + gap;
                maxHeight = Math.max(maxHeight, prefSize.height);
            }
            int vGap = (availableHeight - rowCount * maxHeight) / rowCount;
            if (vGap < 0) {
                vGap = 2;
                maxHeight = (availableHeight - vGap * (rowCount - 1)) / rowCount;
            }
            int y = ins.top + vGap / 2;
            x = ins.left;
            int rowIndex = 0;
            for (JComponent flowComponent : flowBandControlPanel.getFlowComponents()) {
                Dimension prefSize = flowComponent.getPreferredSize();
                if (x + prefSize.width > c.getWidth() - ins.right) {
                    x = ins.left;
                    y += maxHeight + vGap;
                    ++rowIndex;
                }
                int height = Math.min(maxHeight, prefSize.height);
                flowComponent.setBounds(x, y + (maxHeight - height) / 2, prefSize.width, height);
                flowComponent.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", rowIndex == 0);
                flowComponent.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", rowIndex > 0 && rowIndex < rowCount - 1);
                flowComponent.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", rowIndex == rowCount - 1);
                x += prefSize.width + gap;
            }
        }
    }
}

