/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jvnet.flamingo.common.RichTooltip;
import org.jvnet.flamingo.common.icon.ResizableIcon;
import org.jvnet.flamingo.ribbon.RibbonTask;
import org.jvnet.flamingo.ribbon.resize.RibbonBandResizePolicy;
import org.jvnet.flamingo.ribbon.ui.AbstractBandControlPanel;
import org.jvnet.flamingo.ribbon.ui.BasicRibbonBandUI;
import org.jvnet.flamingo.ribbon.ui.RibbonBandUI;

public abstract class AbstractRibbonBand<T extends AbstractBandControlPanel>
extends JComponent {
    public static final String uiClassID = "RibbonBandUI";
    RibbonTask ribbonTask;
    private String title;
    private ActionListener expandActionListener;
    protected T controlPanel;
    private AbstractRibbonBand popupRibbonBand;
    private ResizableIcon icon;
    private RibbonBandResizePolicy currResizePolicy;
    protected List<RibbonBandResizePolicy> resizePolicies;
    private String expandButtonKeyTip;
    private RichTooltip expandButtonRichTooltip;
    private String collapsedStateKeyTip;

    public AbstractRibbonBand(String title, ResizableIcon icon, ActionListener expandActionListener, T controlPanel) {
        this.title = title;
        this.icon = icon;
        this.expandActionListener = expandActionListener;
        this.controlPanel = controlPanel;
        ((AbstractBandControlPanel)this.controlPanel).setRibbonBand(this);
        this.add((Component)this.controlPanel);
        this.updateUI();
    }

    public abstract AbstractRibbonBand<T> cloneBand();

    @Override
    public RibbonBandUI getUI() {
        return (RibbonBandUI)this.ui;
    }

    public void setUI(RibbonBandUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((RibbonBandUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicRibbonBandUI());
        }
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public String getTitle() {
        return this.title;
    }

    public ResizableIcon getIcon() {
        return this.icon;
    }

    public void setTitle(String title) {
        String old = this.title;
        this.title = title;
        this.firePropertyChange("title", old, this.title);
    }

    public ActionListener getExpandActionListener() {
        return this.expandActionListener;
    }

    public T getControlPanel() {
        return this.controlPanel;
    }

    public void setControlPanel(T controlPanel) {
        if (controlPanel == null) {
            this.remove((Component)this.controlPanel);
        } else {
            this.add((Component)controlPanel);
        }
        this.controlPanel = controlPanel;
    }

    public AbstractRibbonBand getPopupRibbonBand() {
        return this.popupRibbonBand;
    }

    public void setPopupRibbonBand(AbstractRibbonBand popupRibbonBand) {
        this.popupRibbonBand = popupRibbonBand;
    }

    public RibbonBandResizePolicy getCurrentResizePolicy() {
        return this.currResizePolicy;
    }

    public void setCurrentResizePolicy(RibbonBandResizePolicy resizePolicy) {
        this.currResizePolicy = resizePolicy;
    }

    public List<RibbonBandResizePolicy> getResizePolicies() {
        return Collections.unmodifiableList(this.resizePolicies);
    }

    public void setResizePolicies(List<RibbonBandResizePolicy> resizePolicies) {
        this.resizePolicies = Collections.unmodifiableList(resizePolicies);
    }

    public String getExpandButtonKeyTip() {
        return this.expandButtonKeyTip;
    }

    public void setExpandButtonKeyTip(String expandButtonKeyTip) {
        String old = this.expandButtonKeyTip;
        this.expandButtonKeyTip = expandButtonKeyTip;
        this.firePropertyChange("expandButtonKeyTip", old, this.expandButtonKeyTip);
    }

    public RichTooltip getExpandButtonRichTooltip() {
        return this.expandButtonRichTooltip;
    }

    public void setExpandButtonRichTooltip(RichTooltip expandButtonRichTooltip) {
        RichTooltip old = this.expandButtonRichTooltip;
        this.expandButtonRichTooltip = expandButtonRichTooltip;
        this.firePropertyChange("expandButtonRichTooltip", old, this.expandButtonRichTooltip);
    }

    public String getCollapsedStateKeyTip() {
        return this.collapsedStateKeyTip;
    }

    public void setCollapsedStateKeyTip(String collapsedStateKeyTip) {
        String old = this.collapsedStateKeyTip;
        this.collapsedStateKeyTip = collapsedStateKeyTip;
        this.firePropertyChange("collapsedStateKeyTip", old, this.collapsedStateKeyTip);
    }

    void setRibbonTask(RibbonTask ribbonTask) {
        if (this.ribbonTask != null) {
            throw new IllegalArgumentException("Ribbon band cannot be added to more than one ribbon task");
        }
        this.ribbonTask = ribbonTask;
    }
}

