/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;
import org.jvnet.flamingo.common.AsynchronousLoadListener;
import org.jvnet.flamingo.common.AsynchronousLoading;
import org.jvnet.flamingo.common.icon.Ico;
import org.jvnet.flamingo.utils.FlamingoUtilities;

abstract class IcoWrapperIcon
implements Icon,
AsynchronousLoading {
    protected InputStream icoInputStream;
    protected Map<Integer, BufferedImage> icoPlaneMap;
    protected Map<String, BufferedImage> cachedImages;
    protected int width;
    protected int height;
    protected EventListenerList listenerList = new EventListenerList();

    public IcoWrapperIcon(InputStream inputStream, int w, int h) {
        this.icoInputStream = inputStream;
        this.width = w;
        this.height = h;
        this.listenerList = new EventListenerList();
        this.cachedImages = new LinkedHashMap<String, BufferedImage>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
                return this.size() > 5;
            }
        };
        this.renderImage(this.width, this.height);
    }

    @Override
    public void addAsynchronousLoadListener(AsynchronousLoadListener l) {
        this.listenerList.add(AsynchronousLoadListener.class, l);
    }

    @Override
    public void removeAsynchronousLoadListener(AsynchronousLoadListener l) {
        this.listenerList.remove(AsynchronousLoadListener.class, l);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        BufferedImage image = this.cachedImages.get(this.getIconWidth() + ":" + this.getIconHeight());
        if (image != null) {
            int dx = (this.width - image.getWidth()) / 2;
            int dy = (this.height - image.getHeight()) / 2;
            g.drawImage(image, x + dx, y + dy, null);
        }
    }

    public synchronized void setPreferredSize(Dimension dim) {
        if (dim.width == this.width && dim.height == this.height) {
            return;
        }
        this.width = dim.width;
        this.height = dim.height;
        this.renderImage(this.width, this.height);
    }

    protected synchronized void renderImage(final int renderWidth, final int renderHeight) {
        String key = renderWidth + ":" + renderHeight;
        if (this.cachedImages.containsKey(key)) {
            this.fireAsyncCompleted(true);
            return;
        }
        SwingWorker<BufferedImage, Void> worker = new SwingWorker<BufferedImage, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected BufferedImage doInBackground() throws Exception {
                float scaleY;
                BufferedImage bestMatchPlane;
                InputStream inputStream = IcoWrapperIcon.this.icoInputStream;
                synchronized (inputStream) {
                    if (IcoWrapperIcon.this.icoPlaneMap == null) {
                        Ico ico = new Ico(IcoWrapperIcon.this.icoInputStream);
                        IcoWrapperIcon.this.icoPlaneMap = new TreeMap<Integer, BufferedImage>();
                        HashSet<Integer> widths = new HashSet<Integer>();
                        for (int i = 0; i < ico.getNumImages(); ++i) {
                            BufferedImage icoPlane = ico.getImage(i);
                            widths.add(icoPlane.getWidth());
                        }
                        Iterator i$ = widths.iterator();
                        while (i$.hasNext()) {
                            int width = (Integer)i$.next();
                            BufferedImage bestMatch = null;
                            int bestColorCount = -1;
                            for (int i = 0; i < ico.getNumImages(); ++i) {
                                BufferedImage icoPlane = ico.getImage(i);
                                if (icoPlane.getWidth() != width) continue;
                                int icoPlaneColorCount = ico.getNumColors(i);
                                if (icoPlaneColorCount == 0) {
                                    bestMatch = icoPlane;
                                    bestColorCount = 0;
                                    continue;
                                }
                                if (bestColorCount == 0 || icoPlaneColorCount <= bestColorCount) continue;
                                bestMatch = icoPlane;
                                bestColorCount = icoPlaneColorCount;
                            }
                            IcoWrapperIcon.this.icoPlaneMap.put(width, bestMatch);
                        }
                    }
                }
                int indexOfBestMatch = -1;
                int bestMatchWidth = -1;
                for (Map.Entry<Integer, BufferedImage> icoPlaneMapEntry : IcoWrapperIcon.this.icoPlaneMap.entrySet()) {
                    BufferedImage icoPlane = icoPlaneMapEntry.getValue();
                    int icoPlaneWidth = icoPlane.getWidth();
                    if (icoPlaneWidth <= renderWidth) continue;
                    if (bestMatchWidth < 0) {
                        bestMatchWidth = icoPlaneWidth;
                        continue;
                    }
                    if (bestMatchWidth <= icoPlaneWidth) continue;
                    bestMatchWidth = icoPlaneWidth;
                }
                if (indexOfBestMatch < 0) {
                    for (Map.Entry<Integer, BufferedImage> icoPlaneMapEntry : IcoWrapperIcon.this.icoPlaneMap.entrySet()) {
                        BufferedImage icoPlane = icoPlaneMapEntry.getValue();
                        int icoPlaneWidth = icoPlane.getWidth();
                        if (icoPlaneWidth <= bestMatchWidth) continue;
                        bestMatchWidth = icoPlaneWidth;
                    }
                }
                BufferedImage result = bestMatchPlane = IcoWrapperIcon.this.icoPlaneMap.get(bestMatchWidth);
                float scaleX = (float)bestMatchPlane.getWidth() / (float)renderWidth;
                float scale = Math.max(scaleX, scaleY = (float)bestMatchPlane.getHeight() / (float)renderHeight);
                if (scale > 1.0f) {
                    int finalWidth = (int)((float)bestMatchPlane.getWidth() / scale);
                    result = FlamingoUtilities.createThumbnail(bestMatchPlane, finalWidth);
                }
                return result;
            }

            @Override
            protected void done() {
                try {
                    BufferedImage bufferedImage = (BufferedImage)this.get();
                    IcoWrapperIcon.this.cachedImages.put(renderWidth + ":" + renderHeight, bufferedImage);
                    IcoWrapperIcon.this.fireAsyncCompleted(true);
                }
                catch (Exception exc) {
                    IcoWrapperIcon.this.fireAsyncCompleted(false);
                }
            }
        };
        worker.execute();
    }

    protected void fireAsyncCompleted(Boolean event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AsynchronousLoadListener.class) continue;
            ((AsynchronousLoadListener)listeners[i + 1]).completed(event);
        }
    }

    @Override
    public synchronized boolean isLoading() {
        BufferedImage image = this.cachedImages.get(this.getIconWidth() + ":" + this.getIconHeight());
        return image == null;
    }
}

