/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.bcb.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import org.jvnet.flamingo.bcb.JBreadcrumbBar;
import org.jvnet.flamingo.bcb.ui.BreadcrumbBarUI;
import org.jvnet.flamingo.bcb.ui.BreadcrumbParticle;
import org.jvnet.flamingo.bcb.ui.ChoicesSelector;
import org.jvnet.flamingo.bcb.ui.ChoicesSelectorUI;

public class BasicChoicesSelectorUI
extends ChoicesSelectorUI {
    protected ChoicesSelector choicesSelector;
    protected FocusListener baseFocusListener;
    protected MouseListener baseMouseListener;
    protected KeyListener baseKeyListener;
    protected PopupMenuListener basePopupMenuListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicChoicesSelectorUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.choicesSelector = (ChoicesSelector)c;
        this.installDefaults(this.choicesSelector);
        this.installComponents(this.choicesSelector);
        this.installListeners(this.choicesSelector);
        c.setLayout(this.createLayoutManager());
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners((ChoicesSelector)c);
        this.uninstallComponents((ChoicesSelector)c);
        this.uninstallDefaults((ChoicesSelector)c);
        this.choicesSelector = null;
    }

    protected void installDefaults(ChoicesSelector selector) {
        selector.setFont(selector.getOwnerBar().getFont());
        selector.setCursor(Cursor.getPredefinedCursor(12));
        selector.setFocusable(true);
        selector.setOpaque(false);
        selector.setForeground(selector.getOwnerBar().getForeground());
    }

    protected void installComponents(ChoicesSelector selector) {
    }

    protected void installListeners(final ChoicesSelector selector) {
        this.baseMouseListener = new MouseAdapter(){

            private boolean showPopup(ChoicesSelector sel) {
                return sel.getOwnerBar().getUI().popup(selector.getIndex());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                boolean hasPopup;
                selector.getModel().setPressed(true);
                selector.getModel().setSelected(true);
                BasicChoicesSelectorUI.this.synchronizeWithParticle();
                selector.repaint();
                JBreadcrumbBar bar = selector.getOwnerBar();
                int index = bar.getUI().getPopupInitiatorIndex();
                if (index < 0 && !(hasPopup = this.showPopup(selector))) {
                    selector.getModel().setSelected(false);
                    selector.repaint();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                selector.getModel().setRollover(true);
                BasicChoicesSelectorUI.this.synchronizeWithParticle();
                selector.getOwnerBar().repaint();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JBreadcrumbBar bar = selector.getOwnerBar();
                        int index = bar.getUI().getPopupInitiatorIndex();
                        if (index >= 0 && selector.getIndex() != index) {
                            bar.getUI().hidePopup();
                            selector.getModel().setSelected(true);
                            BasicChoicesSelectorUI.this.synchronizeWithParticle();
                            if (!this.showPopup(selector)) {
                                selector.getModel().setSelected(false);
                                BasicChoicesSelectorUI.this.synchronizeWithParticle();
                            }
                        }
                    }
                });
            }

            @Override
            public void mouseExited(MouseEvent e) {
                selector.getModel().setRollover(false);
                BasicChoicesSelectorUI.this.synchronizeWithParticle();
                selector.getOwnerBar().repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                selector.getModel().setPressed(false);
                BasicChoicesSelectorUI.this.synchronizeWithParticle();
                selector.getOwnerBar().repaint();
            }
        };
        selector.addMouseListener(this.baseMouseListener);
        this.baseKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (selector.getModel().isArmed() && e.getKeyCode() == 40 || e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                    selector.getModel().setSelected(true);
                    selector.repaint();
                    if (!selector.getOwnerBar().getUI().popup(selector.getIndex())) {
                        selector.getModel().setSelected(false);
                        selector.repaint();
                    }
                }
            }
        };
        selector.addKeyListener(this.baseKeyListener);
        this.basePopupMenuListener = new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                selector.getModel().setSelected(false);
                selector.getModel().setRollover(false);
                BasicChoicesSelectorUI.this.synchronizeWithParticle();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                selector.getModel().setSelected(false);
                selector.getModel().setRollover(false);
                BasicChoicesSelectorUI.this.synchronizeWithParticle();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        };
        selector.getOwnerBar().getUI().getPopup().addPopupMenuListener(this.basePopupMenuListener);
    }

    protected void uninstallDefaults(ChoicesSelector selector) {
    }

    protected void uninstallComponents(ChoicesSelector selector) {
    }

    protected void uninstallListeners(ChoicesSelector selector) {
        selector.removeKeyListener(this.baseKeyListener);
        this.baseKeyListener = null;
        selector.removeMouseListener(this.baseMouseListener);
        this.baseMouseListener = null;
        selector.getOwnerBar().getUI().getPopup().removePopupMenuListener(this.basePopupMenuListener);
        this.basePopupMenuListener = null;
    }

    protected BreadcrumbParticle synchronizeWithParticle() {
        JBreadcrumbBar bar = this.choicesSelector.getOwnerBar();
        BreadcrumbBarUI barUI = bar.getUI();
        BreadcrumbParticle particle = barUI.getParticle(this.choicesSelector.getIndex());
        if (particle != null) {
            particle.getModel().setArmed(this.choicesSelector.getModel().isArmed());
            particle.getModel().setSelected(this.choicesSelector.getModel().isSelected());
            particle.getModel().setRollover(this.choicesSelector.getModel().isRollover());
            particle.getModel().setPressed(this.choicesSelector.getModel().isPressed());
            this.choicesSelector.getOwnerBar().repaint();
        }
        return particle;
    }

    protected LayoutManager createLayoutManager() {
        return new ChoicesSelectorLayout();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        JBreadcrumbBar bar = this.choicesSelector.getOwnerBar();
        BreadcrumbBarUI barUI = bar.getUI();
        BreadcrumbParticle particle = barUI.getParticle(this.choicesSelector.getIndex());
        this.paintBackground(graphics, c, particle);
        this.paintForeground(graphics, c);
        graphics.dispose();
    }

    protected void paintBackground(Graphics2D graphics, JComponent c, BreadcrumbParticle particle) {
        boolean toMark;
        ChoicesSelector selector = (ChoicesSelector)c;
        boolean bl = toMark = selector.getModel().isArmed() || selector.getModel().isRollover() || selector.getModel().isSelected() || selector.getModel().isPressed();
        if (!toMark) {
            return;
        }
        int width = c.getWidth();
        Color boxColor = this.choicesSelector.getForeground();
        graphics.setColor(boxColor);
        graphics.drawRect(0, 0, width - 2, width - 1);
    }

    protected void paintForeground(Graphics2D graphics, JComponent c) {
        ChoicesSelector selector = (ChoicesSelector)c;
        if (selector.getModel().isSelected() || selector.getModel().isPressed()) {
            this.paintPressedState(graphics, c);
        } else {
            this.paintRegularState(graphics, c);
        }
    }

    protected void paintRegularState(Graphics2D graphics, JComponent c) {
        int width = c.getWidth();
        graphics.setColor(this.choicesSelector.getForeground());
        graphics.fillPolygon(new int[]{3 * width / 8, 5 * width / 8, 3 * width / 8}, new int[]{width / 4, width / 2, 3 * width / 4}, 3);
    }

    protected void paintPressedState(Graphics2D graphics, JComponent c) {
        int width = c.getWidth();
        graphics.rotate(1.5707963267948966, (double)width / 2.0, (double)width / 2.0);
        graphics.setColor(this.choicesSelector.getForeground());
        graphics.fillPolygon(new int[]{3 * width / 8, 5 * width / 8, 3 * width / 8}, new int[]{width / 4, width / 2, 3 * width / 4}, 3);
    }

    protected static class ChoicesSelectorLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(15, 16);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
        }
    }
}

