/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import org.jvnet.flamingo.common.icon.ResizableIcon;

public class ArrowResizableIcon
implements ResizableIcon {
    private Dimension initialDim;
    protected int width;
    protected int height;
    protected int direction;

    public ArrowResizableIcon(Dimension initialDim, int direction) {
        this.initialDim = initialDim;
        this.width = initialDim.width;
        this.height = initialDim.height;
        this.direction = direction;
    }

    public ArrowResizableIcon(int initialDim, int direction) {
        this(new Dimension(initialDim, initialDim), direction);
    }

    public void revertToOriginalDimension() {
        this.width = this.initialDim.width;
        this.height = this.initialDim.height;
    }

    @Override
    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D graphics = (Graphics2D)g.create();
        Color arrowColor = c.isEnabled() ? Color.black : Color.gray;
        graphics.setColor(arrowColor);
        float strokeWidth = (float)this.width / 8.0f;
        if (strokeWidth < 1.0f) {
            strokeWidth = 1.0f;
        }
        BasicStroke stroke = new BasicStroke(strokeWidth, 0, 0);
        graphics.setStroke(stroke);
        graphics.translate(x, y);
        GeneralPath gp = new GeneralPath();
        switch (this.direction) {
            case 5: {
                gp.moveTo(0.0f, 2.0f);
                gp.lineTo(0.5f * (float)(this.width - 1), this.height - 2);
                gp.lineTo(this.width - 1, 2.0f);
                break;
            }
            case 1: {
                gp.moveTo(0.0f, this.height - 2);
                gp.lineTo(0.5f * (float)(this.width - 1), 2.0f);
                gp.lineTo(this.width - 1, this.height - 2);
                break;
            }
            case 3: {
                gp.moveTo(2.0f, 0.0f);
                gp.lineTo(this.width - 2, 0.5f * (float)(this.height - 1));
                gp.lineTo(2.0f, this.height - 1);
                break;
            }
            case 7: {
                gp.moveTo(this.width - 2, 0.0f);
                gp.lineTo(2.0f, 0.5f * (float)(this.height - 1));
                gp.lineTo(this.width - 2, this.height - 1);
            }
        }
        if (this.width < 9) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.draw(gp);
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.draw(gp);
        graphics.dispose();
    }
}

