/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.ui;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import org.jvnet.flamingo.ribbon.JRibbon;
import org.jvnet.flamingo.ribbon.ui.JRibbonTaskToggleButton;
import org.jvnet.flamingo.utils.ColorShiftFilter;
import org.jvnet.flamingo.utils.FlamingoUtilities;
import org.jvnet.flamingo.utils.RenderingUtils;

public class BasicRibbonTaskToggleButtonUI
extends BasicToggleButtonUI {
    protected CellRendererPane buttonRendererPane;
    protected JToggleButton rendererButton;
    protected JRibbonTaskToggleButton toggleTabButton;

    public static ComponentUI createUI(JComponent c) {
        return new BasicRibbonTaskToggleButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.toggleTabButton = (JRibbonTaskToggleButton)c;
        super.installUI(c);
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        Border border;
        super.installDefaults(b);
        Font f = b.getFont();
        if (f == null || f instanceof UIResource) {
            b.setFont(FlamingoUtilities.getFont(null, "Ribbon.font", "Button.font", "Panel.font"));
        }
        if ((border = b.getBorder()) == null || border instanceof UIResource) {
            Border toInstall = UIManager.getBorder("RibbonTaskToggleButton.border");
            if (toInstall == null) {
                toInstall = new BorderUIResource.EmptyBorderUIResource(1, 12, 1, 12);
            }
            b.setBorder(toInstall);
        }
        this.buttonRendererPane = new CellRendererPane();
        b.add(this.buttonRendererPane);
        this.rendererButton = new JToggleButton("");
        b.setRolloverEnabled(true);
        b.setOpaque(false);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        b.remove(this.buttonRendererPane);
        this.buttonRendererPane = null;
        this.rendererButton = null;
        super.uninstallDefaults(b);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        RenderingUtils.installDesktopHints(g2d);
        this.paintButtonBackground(g2d, new Rectangle(0, 0, c.getWidth(), c.getHeight() + 10));
        this.paintText(g2d);
        g2d.dispose();
    }

    protected void paintText(Graphics g) {
        int strWidth;
        FontMetrics fm = g.getFontMetrics();
        String toPaint = this.toggleTabButton.getText();
        int fullInsets = this.toggleTabButton.getInsets().left;
        int pw = this.getPreferredSize((JComponent)this.toggleTabButton).width;
        int mw = this.getMinimumSize((JComponent)this.toggleTabButton).width;
        int w = this.toggleTabButton.getWidth();
        int h = this.toggleTabButton.getHeight();
        int insets = fullInsets - (pw - w) * (fullInsets - 2) / (pw - mw);
        Rectangle textRect = new Rectangle(insets, 1 + (h - fm.getHeight()) / 2, w - 2 * insets, fm.getHeight());
        while (toPaint.length() != 0 && (strWidth = fm.stringWidth(toPaint)) > textRect.width) {
            toPaint = toPaint.substring(0, toPaint.length() - 1);
        }
        BasicGraphicsUtils.drawString(g, toPaint, -1, textRect.x, textRect.y + fm.getAscent());
    }

    protected void paintButtonBackground(Graphics graphics, Rectangle toFill) {
        JRibbon ribbon = (JRibbon)SwingUtilities.getAncestorOfClass(JRibbon.class, this.toggleTabButton);
        this.buttonRendererPane.setBounds(toFill.x, toFill.y, toFill.width, toFill.height);
        ButtonModel model = this.rendererButton.getModel();
        model.setEnabled(this.toggleTabButton.isEnabled());
        model.setSelected(false);
        boolean displayAsSelected = this.toggleTabButton.isSelected() && (!ribbon.isMinimized() || FlamingoUtilities.isShowingMinimizedRibbonInPopup(ribbon));
        model.setRollover(displayAsSelected || this.toggleTabButton.getModel().isRollover());
        model.setPressed(false);
        if (model.isRollover()) {
            boolean isContextualTask;
            Graphics2D g2d = (Graphics2D)graphics.create();
            if (!this.toggleTabButton.isSelected()) {
                g2d.setComposite(AlphaComposite.SrcOver.derive(0.4f));
            }
            g2d.translate(toFill.x, toFill.y);
            boolean bl = isContextualTask = this.toggleTabButton.getContextualGroupHueColor() != null;
            if (!isContextualTask) {
                Shape clip = g2d.getClip();
                g2d.clip(FlamingoUtilities.getRibbonTaskToggleButtonOutline(toFill.width, toFill.height, 2.0f));
                this.buttonRendererPane.paintComponent(g2d, this.rendererButton, this.toggleTabButton, toFill.x - toFill.width / 2, toFill.y - toFill.height / 2, 2 * toFill.width, 2 * toFill.height, true);
                g2d.setColor(FlamingoUtilities.getBorderColor().darker());
                g2d.setClip(clip);
                g2d.draw(FlamingoUtilities.getRibbonTaskToggleButtonOutline(toFill.width, toFill.height + 1, 2.0f));
            } else {
                BufferedImage offscreen = FlamingoUtilities.getBlankImage(toFill.width, toFill.height);
                Graphics2D offscreenGraphics = offscreen.createGraphics();
                Shape clip = g2d.getClip();
                offscreenGraphics.clip(FlamingoUtilities.getRibbonTaskToggleButtonOutline(toFill.width, toFill.height, 2.0f));
                this.buttonRendererPane.paintComponent(offscreenGraphics, this.rendererButton, this.toggleTabButton, toFill.x - toFill.width / 2, toFill.y - toFill.height / 2, 2 * toFill.width, 2 * toFill.height, true);
                offscreenGraphics.setColor(FlamingoUtilities.getBorderColor().darker());
                offscreenGraphics.setClip(clip);
                offscreenGraphics.draw(FlamingoUtilities.getRibbonTaskToggleButtonOutline(toFill.width, toFill.height + 1, 2.0f));
                offscreenGraphics.dispose();
                ColorShiftFilter filter = new ColorShiftFilter(this.toggleTabButton.getContextualGroupHueColor(), 0.25);
                BufferedImage colorized = filter.filter(offscreen, null);
                g2d.drawImage((Image)colorized, 0, 0, null);
            }
            g2d.dispose();
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Icon icon = b.getIcon();
        String text = b.getText();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(b, fm, text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : b.getIconTextGap());
        Rectangle r = iconR.union(textR);
        Insets insets = b.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Icon icon = b.getIcon();
        String text = "Www";
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(b, fm, text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : b.getIconTextGap());
        Rectangle r = iconR.union(textR);
        Insets insets = b.getInsets();
        r.width += 4;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }
}

