/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.CommandButtonDisplayState;
import org.jvnet.flamingo.ribbon.AbstractRibbonBand;
import org.jvnet.flamingo.ribbon.JRibbonComponent;
import org.jvnet.flamingo.ribbon.RibbonElementPriority;
import org.jvnet.flamingo.ribbon.resize.IconRibbonBandResizePolicy;
import org.jvnet.flamingo.ribbon.resize.RibbonBandResizePolicy;
import org.jvnet.flamingo.ribbon.ui.AbstractBandControlPanelUI;
import org.jvnet.flamingo.ribbon.ui.BasicRibbonBandUI;
import org.jvnet.flamingo.ribbon.ui.JBandControlPanel;
import org.jvnet.flamingo.ribbon.ui.JRibbonGallery;

public class BasicBandControlPanelUI
extends AbstractBandControlPanelUI {
    private JSeparator[] groupSeparators;
    private JLabel[] groupLabels;
    protected JBandControlPanel.GroupStartedListener groupStartedListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicBandControlPanelUI();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new ControlPanelLayout();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.groupStartedListener = new JBandControlPanel.GroupStartedListener(){

            @Override
            public void groupStarted(JBandControlPanel.GroupStartedEvent gse) {
                BasicBandControlPanelUI.this.syncGroupHeaders();
            }
        };
        ((JBandControlPanel)this.controlPanel).addGroupStartedListener(this.groupStartedListener);
    }

    @Override
    protected void uninstallListeners() {
        ((JBandControlPanel)this.controlPanel).removeGroupStartedListener(this.groupStartedListener);
        this.groupStartedListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.syncGroupHeaders();
    }

    @Override
    protected void uninstallComponents() {
        if (this.groupSeparators != null) {
            for (JComponent jComponent : this.groupSeparators) {
                this.controlPanel.remove(jComponent);
            }
        }
        if (this.groupLabels != null) {
            for (JComponent jComponent : this.groupLabels) {
                if (jComponent == null) continue;
                this.controlPanel.remove(jComponent);
            }
        }
        super.uninstallComponents();
    }

    protected void syncGroupHeaders() {
        int i;
        int groupCount;
        if (this.groupSeparators != null) {
            for (JComponent jComponent : this.groupSeparators) {
                this.controlPanel.remove(jComponent);
            }
        }
        if (this.groupLabels != null) {
            for (JComponent jComponent : this.groupLabels) {
                if (jComponent == null) continue;
                this.controlPanel.remove(jComponent);
            }
        }
        if ((groupCount = ((JBandControlPanel)this.controlPanel).getControlPanelGroupCount()) > 1) {
            this.groupSeparators = new JSeparator[groupCount - 1];
            for (i = 0; i < groupCount - 1; ++i) {
                this.groupSeparators[i] = new JSeparator(1);
                this.controlPanel.add(this.groupSeparators[i]);
            }
        }
        if (groupCount > 0) {
            this.groupLabels = new JLabel[groupCount];
            for (i = 0; i < groupCount; ++i) {
                String title = ((JBandControlPanel)this.controlPanel).getControlPanelGroupTitle(i);
                if (title == null) continue;
                this.groupLabels[i] = new JLabel(title);
                this.controlPanel.add(this.groupLabels[i]);
            }
        }
    }

    private class ControlPanelLayout
    implements LayoutManager {
        private ControlPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int buttonHeight = BasicBandControlPanelUI.this.dummy.getPreferredSize().height;
            Insets ins = c.getInsets();
            return new Dimension(c.getWidth(), buttonHeight + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            AbstractRibbonBand ribbonBand = ((JBandControlPanel)c).getRibbonBand();
            RibbonBandResizePolicy currentResizePolicy = ribbonBand.getCurrentResizePolicy();
            if (currentResizePolicy == null) {
                return;
            }
            Insets ins = c.getInsets();
            int gap = BasicBandControlPanelUI.this.getLayoutGap();
            int x = ins.left + gap / 2;
            int availableHeight = c.getHeight() - ins.top - ins.bottom;
            if (SwingUtilities.getAncestorOfClass(BasicRibbonBandUI.CollapsedButtonPopupPanel.class, c) != null) {
                List<RibbonBandResizePolicy> resizePolicies = ribbonBand.getResizePolicies();
                resizePolicies.get(0).install(availableHeight, gap);
            } else {
                if (currentResizePolicy instanceof IconRibbonBandResizePolicy) {
                    return;
                }
                currentResizePolicy.install(availableHeight, gap);
            }
            int controlPanelGroupIndex = 0;
            for (JBandControlPanel.ControlPanelGroup controlPanelGroup : ((JBandControlPanel)BasicBandControlPanelUI.this.controlPanel).getControlPanelGroups()) {
                boolean isCoreContent;
                if (controlPanelGroupIndex > 0) {
                    int prefW = ((BasicBandControlPanelUI)BasicBandControlPanelUI.this).groupSeparators[controlPanelGroupIndex - 1].getPreferredSize().width;
                    BasicBandControlPanelUI.this.groupSeparators[controlPanelGroupIndex - 1].setBounds(x - gap + (gap - prefW) / 2, ins.top, prefW, availableHeight);
                }
                if (isCoreContent = controlPanelGroup.isCoreContent()) {
                    int startingRow;
                    int singleRowHeight = availableHeight / 3;
                    boolean hasTitle = controlPanelGroup.getGroupTitle() != null;
                    int maxWidthInCurrColumn = 0;
                    if (hasTitle) {
                        JLabel titleLabel = BasicBandControlPanelUI.this.groupLabels[controlPanelGroupIndex];
                        int pw = titleLabel.getPreferredSize().width;
                        int titleLabelHeight = Math.min(singleRowHeight - gap / 4, titleLabel.getPreferredSize().height);
                        int yNudge = singleRowHeight - titleLabelHeight;
                        int baseline = titleLabel.getBaseline(pw, titleLabelHeight);
                        titleLabel.setBounds(x + gap, ins.top + yNudge - titleLabelHeight + baseline, pw, titleLabelHeight);
                        maxWidthInCurrColumn = gap + pw;
                    }
                    List<JRibbonComponent> ribbonComps = controlPanelGroup.getRibbonComps();
                    Map<JRibbonComponent, Integer> ribbonCompRowSpans = controlPanelGroup.getRibbonCompsRowSpans();
                    ArrayList<JRibbonComponent> currColumn = new ArrayList<JRibbonComponent>();
                    int rowIndex = startingRow = hasTitle ? 1 : 0;
                    for (int i = 0; i < ribbonComps.size(); ++i) {
                        JRibbonComponent coreComp = ribbonComps.get(i);
                        int prefWidth = coreComp.getPreferredSize().width;
                        int rowSpan = ribbonCompRowSpans.get(coreComp);
                        int nextRowIndex = rowIndex + rowSpan;
                        if (nextRowIndex > 3) {
                            x += maxWidthInCurrColumn;
                            x += gap;
                            maxWidthInCurrColumn = 0;
                            rowIndex = startingRow;
                        }
                        int compHeight = Math.min(rowSpan * singleRowHeight - gap / 4, coreComp.getPreferredSize().height);
                        int yNudge = rowSpan * singleRowHeight - compHeight;
                        int y = rowIndex * singleRowHeight + ins.top;
                        coreComp.setBounds(x, y + yNudge, prefWidth, compHeight);
                        maxWidthInCurrColumn = Math.max(maxWidthInCurrColumn, prefWidth);
                        currColumn.add(coreComp);
                        coreComp.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", rowIndex == 0);
                        coreComp.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", rowIndex > 0 && rowIndex < 2);
                        coreComp.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", rowIndex == 2);
                        for (JRibbonComponent comp : currColumn) {
                            Rectangle bounds = comp.getBounds();
                            comp.setBounds(bounds.x, bounds.y, maxWidthInCurrColumn, bounds.height);
                        }
                        rowIndex += rowSpan;
                    }
                    if (rowIndex > 0 && rowIndex <= 3) {
                        x += maxWidthInCurrColumn;
                        x += gap;
                    }
                } else {
                    for (RibbonElementPriority elementPriority : RibbonElementPriority.values()) {
                        for (JRibbonGallery gallery : controlPanelGroup.getRibbonGalleries(elementPriority)) {
                            int pw = gallery.getPreferredWidth(gallery.getDisplayPriority(), availableHeight);
                            gallery.setBounds(x, ins.top, pw, availableHeight);
                            x += pw;
                            x += gap;
                        }
                    }
                    HashMap buttonMap = new HashMap();
                    for (RibbonElementPriority elementPriority : RibbonElementPriority.values()) {
                        for (AbstractCommandButton commandButton : controlPanelGroup.getRibbonButtons(elementPriority)) {
                            CommandButtonDisplayState state = commandButton.getDisplayState();
                            if (buttonMap.get(state) == null) {
                                buttonMap.put(state, new ArrayList());
                            }
                            ((List)buttonMap.get(state)).add(commandButton);
                        }
                    }
                    List bigs = (List)buttonMap.get(CommandButtonDisplayState.BIG);
                    if (bigs != null) {
                        for (AbstractCommandButton bigButton : bigs) {
                            bigButton.setBounds(x, ins.top, bigButton.getPreferredSize().width, availableHeight);
                            bigButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", Boolean.FALSE);
                            bigButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", Boolean.FALSE);
                            bigButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", Boolean.FALSE);
                            x += bigButton.getWidth();
                            x += gap;
                        }
                    }
                    int index3 = 0;
                    int maxWidth3 = 0;
                    List mediums = (List)buttonMap.get(CommandButtonDisplayState.MEDIUM);
                    if (mediums != null) {
                        for (AbstractCommandButton mediumButton : mediums) {
                            int medWidth = mediumButton.getPreferredSize().width;
                            maxWidth3 = Math.max(maxWidth3, medWidth);
                            mediumButton.setBounds(x, ins.top + index3 * availableHeight / 3, medWidth, availableHeight / 3 - 1);
                            mediumButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", index3 == 0);
                            mediumButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", index3 == 1);
                            mediumButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", index3 == 2);
                            if (++index3 != 3) continue;
                            index3 = 0;
                            x += maxWidth3;
                            x += gap;
                            maxWidth3 = 0;
                        }
                    }
                    x += maxWidth3;
                    if (maxWidth3 > 0) {
                        x += gap;
                    }
                    index3 = 0;
                    maxWidth3 = 0;
                    List smalls = (List)buttonMap.get(CommandButtonDisplayState.SMALL);
                    if (smalls != null) {
                        for (AbstractCommandButton smallButton : smalls) {
                            int lowWidth = smallButton.getPreferredSize().width;
                            maxWidth3 = Math.max(maxWidth3, lowWidth);
                            smallButton.setBounds(x, ins.top + index3 * availableHeight / 3, lowWidth, availableHeight / 3 - 1);
                            smallButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", index3 == 0);
                            smallButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", index3 == 1);
                            smallButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", index3 == 2);
                            if (++index3 != 3) continue;
                            index3 = 0;
                            x += maxWidth3;
                            x += gap;
                            maxWidth3 = 0;
                        }
                    }
                    if (index3 < 3) {
                        x += maxWidth3;
                    }
                    x += gap;
                }
                ++controlPanelGroupIndex;
            }
        }
    }
}

