/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.ribbon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jvnet.flamingo.ribbon.RibbonApplicationMenuEntryFooter;
import org.jvnet.flamingo.ribbon.RibbonApplicationMenuEntryPrimary;

public class RibbonApplicationMenu {
    private boolean isFrozen;
    private List<RibbonApplicationMenuEntryPrimary> primaryEntries = new ArrayList<RibbonApplicationMenuEntryPrimary>();
    private List<RibbonApplicationMenuEntryFooter> footerEntries = new ArrayList<RibbonApplicationMenuEntryFooter>();

    public synchronized void addMenuEntry(RibbonApplicationMenuEntryPrimary entry) {
        if (this.isFrozen) {
            throw new IllegalStateException("Cannot add menu entries after the menu has been set on the ribbon");
        }
        this.primaryEntries.add(entry);
    }

    public List<RibbonApplicationMenuEntryPrimary> getPrimaryEntries() {
        return Collections.unmodifiableList(this.primaryEntries);
    }

    public synchronized void addFooterEntry(RibbonApplicationMenuEntryFooter entry) {
        if (this.isFrozen) {
            throw new IllegalStateException("Cannot add footer entries after the menu has been set on the ribbon");
        }
        this.footerEntries.add(entry);
    }

    public List<RibbonApplicationMenuEntryFooter> getFooterEntries() {
        return Collections.unmodifiableList(this.footerEntries);
    }

    synchronized void setFrozen() {
        this.isFrozen = true;
    }
}

