/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common.ui;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.JCommandButtonPanel;
import org.jvnet.flamingo.common.popup.JCommandPopupMenu;
import org.jvnet.flamingo.common.ui.BasicCommandButtonPanelUI;
import org.jvnet.flamingo.common.ui.BasicPopupPanelUI;
import org.jvnet.flamingo.utils.FlamingoUtilities;

public class BasicCommandPopupMenuUI
extends BasicPopupPanelUI {
    protected JCommandPopupMenu popupMenu;
    protected ChangeListener popupMenuChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicCommandPopupMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.popupMenu = (JCommandPopupMenu)c;
        super.installUI(this.popupMenu);
        this.popupMenu.setLayout(this.createLayoutManager());
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.syncComponents();
    }

    protected void syncComponents() {
        List<Component> menuComponents;
        if (this.popupMenu.hasCommandButtonPanel()) {
            ScrollableCommandButtonPanel iconPanel = this.createScrollableButtonPanel();
            this.popupMenu.add(iconPanel);
        }
        if ((menuComponents = this.popupMenu.getMenuComponents()) != null) {
            for (Component menuComponent : menuComponents) {
                this.popupMenu.add(menuComponent);
            }
        }
    }

    protected ScrollableCommandButtonPanel createScrollableButtonPanel() {
        return new ScrollableCommandButtonPanel(this.popupMenu.getMainButtonPanel(), this.popupMenu.getMaxButtonColumns(), this.popupMenu.getMaxVisibleButtonRows());
    }

    @Override
    protected void uninstallComponents() {
        this.popupMenu.removeAll();
        super.uninstallComponents();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.popupMenuChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BasicCommandPopupMenuUI.this.popupMenu.removeAll();
                BasicCommandPopupMenuUI.this.syncComponents();
            }
        };
        this.popupMenu.addChangeListener(this.popupMenuChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.popupMenu.removeChangeListener(this.popupMenuChangeListener);
        this.popupMenuChangeListener = null;
        super.uninstallListeners();
    }

    protected LayoutManager createLayoutManager() {
        return new PopupMenuLayoutManager();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintIconGutterBackground(g);
        this.paintIconGutterSeparator(g);
    }

    protected void paintIconGutterSeparator(Graphics g) {
        CellRendererPane buttonRendererPane = new CellRendererPane();
        JSeparator rendererSeparator = new JSeparator(1);
        buttonRendererPane.setBounds(0, 0, this.popupMenu.getWidth(), this.popupMenu.getHeight());
        buttonRendererPane.paintComponent(g, rendererSeparator, this.popupMenu, 26, 2, 2, this.popupMenu.getHeight() - 4, true);
    }

    protected void paintIconGutterBackground(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.clipRect(0, 0, 28, this.popupMenu.getHeight());
        AffineTransform at = AffineTransform.getTranslateInstance(0.0, this.popupMenu.getHeight());
        at.rotate(-1.5707963267948966);
        g2d.transform(at);
        g2d.setComposite(AlphaComposite.SrcOver.derive(0.7f));
        FlamingoUtilities.renderSurface(g2d, this.popupMenu, new Rectangle(0, 0, this.popupMenu.getHeight(), 50), false, false, false);
        g2d.dispose();
    }

    protected static class PopupMenuLayoutManager
    implements LayoutManager {
        protected PopupMenuLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int height = 0;
            int width = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Dimension pref = parent.getComponent(i).getPreferredSize();
                height += pref.height;
                width = Math.max(width, pref.width);
            }
            Insets ins = parent.getInsets();
            return new Dimension(width + ins.left + ins.right, height + ins.top + ins.bottom);
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets ins = parent.getInsets();
            int bottomY = parent.getHeight() - ins.bottom;
            boolean hasMainPanel = ((JCommandPopupMenu)parent).hasCommandButtonPanel();
            int lastMenuIndex = hasMainPanel ? 1 : 0;
            for (int i = parent.getComponentCount() - 1; i >= lastMenuIndex; --i) {
                Component comp = parent.getComponent(i);
                Dimension pref = comp.getPreferredSize();
                int topY = bottomY - pref.height;
                comp.setBounds(ins.left, topY, parent.getWidth() - ins.left - ins.right, bottomY - topY);
                bottomY = topY;
            }
            if (hasMainPanel) {
                Component mainButtonPanelComp = parent.getComponent(0);
                mainButtonPanelComp.setBounds(ins.left, ins.top, parent.getWidth() - ins.left - ins.right, bottomY - ins.top);
                mainButtonPanelComp.invalidate();
                mainButtonPanelComp.validate();
                mainButtonPanelComp.doLayout();
            }
        }
    }

    protected static class ScrollableCommandButtonPanel
    extends JComponent {
        protected Dimension maxDimension;
        protected JCommandButtonPanel iconPanel;
        protected int maxVisibleButtonRows;
        protected JScrollPane scroll;

        public ScrollableCommandButtonPanel(JCommandButtonPanel iconPanel, int maxButtonColumns, int maxVisibleButtonRows) {
            this.iconPanel = iconPanel;
            this.iconPanel.setMaxButtonColumns(maxButtonColumns);
            this.maxVisibleButtonRows = maxVisibleButtonRows;
            int maxButtonWidth = 0;
            int maxButtonHeight = 0;
            int groupCount = iconPanel.getGroupCount();
            for (int i = 0; i < groupCount; ++i) {
                for (AbstractCommandButton button : iconPanel.getGroupButtons(i)) {
                    maxButtonWidth = Math.max(maxButtonWidth, button.getPreferredSize().width);
                    maxButtonHeight = Math.max(maxButtonHeight, button.getPreferredSize().height);
                }
            }
            this.updateMaxDimension();
            this.scroll = new JScrollPane(this.iconPanel, 22, 31);
            this.scroll.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.iconPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.scroll.setOpaque(false);
            this.scroll.getViewport().setOpaque(false);
            this.setLayout(new IconPopupLayout());
            this.add(this.scroll);
            this.setBorder(new Border(){

                @Override
                public Insets getBorderInsets(Component c) {
                    return new Insets(0, 0, 1, 0);
                }

                @Override
                public boolean isBorderOpaque() {
                    return true;
                }

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    g.setColor(FlamingoUtilities.getBorderColor());
                    g.drawLine(x, y + height - 1, x + width, y + height - 1);
                }
            });
        }

        public void updateMaxDimension() {
            if (this.iconPanel == null) {
                return;
            }
            this.iconPanel.setPreferredSize(null);
            Dimension prefIconPanelDim = this.iconPanel.getPreferredSize();
            BasicCommandButtonPanelUI panelUI = (BasicCommandButtonPanelUI)this.iconPanel.getUI();
            int titlePanelCount = this.iconPanel.isToShowGroupLabels() ? 1 : 0;
            this.maxDimension = new Dimension(prefIconPanelDim.width, panelUI.getPreferredHeight(this.maxVisibleButtonRows, titlePanelCount));
            this.setPreferredSize(null);
        }

        protected class IconPopupLayout
        implements LayoutManager {
            protected IconPopupLayout() {
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public void layoutContainer(Container parent) {
                Insets insets = parent.getInsets();
                int left = insets.left;
                int right = insets.right;
                int top = insets.top;
                int bottom = insets.bottom;
                ScrollableCommandButtonPanel.this.scroll.setBounds(left, top, parent.getWidth() - left - right, parent.getHeight() - top - bottom);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return this.preferredLayoutSize(parent);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Insets insets = parent.getInsets();
                int left = insets.left;
                int right = insets.right;
                int top = insets.top;
                int bottom = insets.bottom;
                Dimension controlPanelDim = ScrollableCommandButtonPanel.this.iconPanel.getPreferredSize();
                if (controlPanelDim == null) {
                    controlPanelDim = new Dimension(0, 0);
                }
                int w = Math.min(controlPanelDim.width, ScrollableCommandButtonPanel.this.maxDimension.width) + left + right;
                int h = Math.min(controlPanelDim.height, ScrollableCommandButtonPanel.this.maxDimension.height) + top + bottom;
                if (h == ScrollableCommandButtonPanel.this.maxDimension.height + top + bottom) {
                    int scrollBarWidth = UIManager.getInt("ScrollBar.width");
                    if (scrollBarWidth == 0) {
                        scrollBarWidth = new JScrollBar((int)1).getPreferredSize().width;
                    }
                    w += scrollBarWidth;
                }
                return new Dimension(w, h);
            }
        }
    }
}

