/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.common;

import org.jvnet.flamingo.common.AbstractCommandButton;
import org.jvnet.flamingo.common.CommandButtonLayoutManager;
import org.jvnet.flamingo.common.ui.CommandButtonLayoutManagerBig;
import org.jvnet.flamingo.common.ui.CommandButtonLayoutManagerCustom;
import org.jvnet.flamingo.common.ui.CommandButtonLayoutManagerMedium;
import org.jvnet.flamingo.common.ui.CommandButtonLayoutManagerSmall;
import org.jvnet.flamingo.common.ui.CommandButtonLayoutManagerTile;

public abstract class CommandButtonDisplayState {
    public static final CommandButtonDisplayState FIT_TO_ICON = new CommandButtonDisplayState("Fit to icon", -1){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton commandButton) {
            return new CommandButtonLayoutManagerCustom(commandButton);
        }

        @Override
        public CommandButtonSeparatorOrientation getSeparatorOrientation() {
            return CommandButtonSeparatorOrientation.HORIZONTAL;
        }
    };
    public static final CommandButtonDisplayState BIG = new CommandButtonDisplayState("Big", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton commandButton) {
            return new CommandButtonLayoutManagerBig(commandButton);
        }

        @Override
        public CommandButtonSeparatorOrientation getSeparatorOrientation() {
            return CommandButtonSeparatorOrientation.HORIZONTAL;
        }
    };
    public static final CommandButtonDisplayState TILE = new CommandButtonDisplayState("Tile", 32){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton arg0) {
            return new CommandButtonLayoutManagerTile();
        }

        @Override
        public CommandButtonSeparatorOrientation getSeparatorOrientation() {
            return CommandButtonSeparatorOrientation.VERTICAL;
        }
    };
    public static final CommandButtonDisplayState MEDIUM = new CommandButtonDisplayState("Medium", 16){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton arg0) {
            return new CommandButtonLayoutManagerMedium();
        }

        @Override
        public CommandButtonSeparatorOrientation getSeparatorOrientation() {
            return CommandButtonSeparatorOrientation.VERTICAL;
        }
    };
    public static final CommandButtonDisplayState SMALL = new CommandButtonDisplayState("Small", 16){

        @Override
        public CommandButtonLayoutManager createLayoutManager(AbstractCommandButton arg0) {
            return new CommandButtonLayoutManagerSmall();
        }

        @Override
        public CommandButtonSeparatorOrientation getSeparatorOrientation() {
            return CommandButtonSeparatorOrientation.VERTICAL;
        }
    };
    int preferredIconSize;
    String displayName;

    protected CommandButtonDisplayState(String displayName, int preferredIconSize) {
        this.displayName = displayName;
        this.preferredIconSize = preferredIconSize;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getPreferredIconSize() {
        return this.preferredIconSize;
    }

    public abstract CommandButtonLayoutManager createLayoutManager(AbstractCommandButton var1);

    public abstract CommandButtonSeparatorOrientation getSeparatorOrientation();

    public String toString() {
        return this.getDisplayName();
    }

    public static enum CommandButtonSeparatorOrientation {
        VERTICAL,
        HORIZONTAL;

    }
}

