/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.bcb.ui;

import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;
import org.jvnet.flamingo.bcb.BreadcrumbBarModel;
import org.jvnet.flamingo.bcb.BreadcrumbItem;
import org.jvnet.flamingo.bcb.JBreadcrumbBar;
import org.jvnet.flamingo.bcb.ui.BasicBreadcrumbParticleUI;

public class BreadcrumbParticle<T>
extends JLabel
implements JBreadcrumbBar.BreadcrumbBarElement {
    private BreadcrumbItem<T> item = null;
    private ButtonModel model;
    protected JBreadcrumbBar<T> bar;
    public static final String uiClassID = "BreadcrumbParticleUI";

    public BreadcrumbParticle(JBreadcrumbBar<T> bar, BreadcrumbItem<T> bi, int width) {
        this.bar = bar;
        this.setText(bi.getKey());
        this.setIcon(bi.getIcon());
        this.setFocusable(true);
        this.item = bi;
        this.setHorizontalAlignment(10);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.model = new DefaultButtonModel();
        this.updateUI();
    }

    @Override
    public int getIndex() {
        return this.item.getIndex();
    }

    public void onSelection() {
        BreadcrumbBarModel<T> barModel = this.bar.getModel();
        int itemIndex = barModel.indexOf(this.item);
        int toLeave = itemIndex < 0 ? 0 : itemIndex + 1;
        barModel.setCumulative(true);
        while (barModel.getItemCount() > toLeave) {
            barModel.removeLast();
        }
        barModel.setCumulative(false);
    }

    @Override
    public void setUI(LabelUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((LabelUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicBreadcrumbParticleUI());
        }
    }

    @Override
    public LabelUI getUI() {
        return (LabelUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public JBreadcrumbBar getBar() {
        return this.bar;
    }

    public ButtonModel getModel() {
        return this.model;
    }
}

