/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.flamingo.bcb.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import org.jvnet.flamingo.bcb.ui.ScrollablePopup;

public class BasicScrollablePopupUI
extends BasicPopupMenuUI {
    protected JMenuItem scrollDown;
    protected JMenuItem scrollUp = this.createScroller(true);
    protected boolean isScrolling = false;
    protected boolean isPressed = false;
    protected MenuKeyListener menuKeyListener;
    protected MouseWheelListener baseMouseWheelListener;
    protected static final BasicScrollablePopupUI INSTANCE = new BasicScrollablePopupUI();

    public BasicScrollablePopupUI() {
        this.scrollDown = this.createScroller(false);
    }

    public static ComponentUI createUI(JComponent c) {
        return INSTANCE;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installComponents();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallComponents();
        super.uninstallUI(c);
    }

    protected void installComponents() {
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.baseMouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                boolean canScroll;
                boolean hasScrollers = BasicScrollablePopupUI.this.hasScrollers();
                if (!hasScrollers) {
                    return;
                }
                boolean isScrollUp = e.getWheelRotation() < 0;
                boolean bl = canScroll = isScrollUp && BasicScrollablePopupUI.this.scrollUp.isEnabled() || !isScrollUp && BasicScrollablePopupUI.this.scrollDown.isEnabled();
                if (canScroll) {
                    BasicScrollablePopupUI.this.scroll(isScrollUp);
                }
            }
        };
        this.popupMenu.addMouseWheelListener(this.baseMouseWheelListener);
    }

    @Override
    protected void uninstallDefaults() {
    }

    protected void uninstallComponents() {
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.popupMenu.removeMouseWheelListener(this.baseMouseWheelListener);
        this.baseMouseWheelListener = null;
    }

    protected JMenuItem createScroller(final boolean up) {
        JMenuItem scroller = new JMenuItem(""){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                BasicScrollablePopupUI.this.paintArrow(g, this.getWidth(), this.getHeight(), this.isEnabled() ? this.getForeground() : Color.lightGray, up);
            }

            @Override
            public void menuSelectionChanged(boolean isIncluded) {
                super.menuSelectionChanged(isIncluded);
                if (isIncluded) {
                    BasicScrollablePopupUI.this.scrollAction(this);
                } else {
                    BasicScrollablePopupUI.this.isPressed = false;
                }
            }
        };
        scroller.setEnabled(false);
        scroller.addMenuKeyListener(this.getMenuListener());
        scroller.setOpaque(false);
        scroller.setBorder(BorderFactory.createEmptyBorder());
        scroller.setSize(new Dimension(0, 16));
        scroller.setPreferredSize(new Dimension(0, 16));
        return scroller;
    }

    private void paintArrow(Graphics g, int w, int h, Color color, boolean up) {
        int[] nArray;
        g.setColor(color);
        int[] xs = new int[]{w / 2 - 4, w / 2 + 4, w / 2};
        if (up) {
            int[] nArray2 = new int[3];
            nArray2[0] = h / 2 + 2;
            nArray2[1] = h / 2 + 2;
            nArray = nArray2;
            nArray2[2] = h / 2 - 2;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = h / 2 - 2;
            nArray3[1] = h / 2 - 2;
            nArray = nArray3;
            nArray3[2] = h / 2 + 2;
        }
        int[] ys = nArray;
        g.fillPolygon(xs, ys, 3);
    }

    protected void scrollAction(Object source) {
        if (!(source instanceof AbstractButton)) {
            return;
        }
        AbstractButton b = (AbstractButton)source;
        if (!b.isEnabled()) {
            return;
        }
        final boolean up = b.equals(this.scrollUp);
        this.isPressed = true;
        Timer timer = new Timer(200, new ActionListener(){
            int i = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                Timer src = (Timer)e.getSource();
                if (!BasicScrollablePopupUI.this.isPressed) {
                    src.stop();
                    BasicScrollablePopupUI.this.isScrolling = false;
                    return;
                }
                BasicScrollablePopupUI.this.isPressed = BasicScrollablePopupUI.this.scroll(up);
                if (this.i > 3) {
                    src.setDelay(Math.max(50, src.getDelay() - 30));
                }
                ++this.i;
            }
        });
        timer.setRepeats(true);
        if (this.isScrolling) {
            return;
        }
        this.isScrolling = true;
        timer.start();
    }

    public void scrollTo(int ind, boolean select) {
        ScrollablePopup scrollablePopup = (ScrollablePopup)this.popupMenu;
        if (!this.hasScrollers()) {
            scrollablePopup.setSelected(scrollablePopup.getComponent(ind));
            return;
        }
        int scrollTo = ind;
        if (ind + scrollablePopup.getMaxSize() > scrollablePopup.getActions().size()) {
            ind = scrollablePopup.getActions().size() - scrollablePopup.getMaxSize();
        }
        this.scrollUp.setEnabled(ind != 0);
        JMenuItem itemToSel = null;
        for (int i = 1; i < scrollablePopup.getMaxSize() + 1 && ind < scrollablePopup.getActions().size(); ++i) {
            JMenuItem item = (JMenuItem)scrollablePopup.getComponent(i);
            if (ind == scrollTo) {
                itemToSel = item;
            }
            Action action = scrollablePopup.getActions().get(ind++);
            item.setAction(action);
            item.setFont(scrollablePopup.getFont());
        }
        this.scrollDown.setEnabled(ind < scrollablePopup.getActions().size());
        if (select && itemToSel != null) {
            scrollablePopup.setSelected(itemToSel);
        }
        Thread.yield();
        scrollablePopup.repaint();
    }

    private boolean scroll(boolean up) {
        int delta;
        ScrollablePopup scrollablePopup = (ScrollablePopup)this.popupMenu;
        JMenuItem first = (JMenuItem)scrollablePopup.getComponent(1);
        int ind = scrollablePopup.getActions().indexOf(first.getAction());
        int n = delta = up ? -1 : 1;
        if ((ind += delta) < 0) {
            this.scrollUp.setEnabled(false);
            return false;
        }
        this.scrollUp.setEnabled(true);
        for (int i = 1; i < scrollablePopup.getMaxSize() + 1 && ind < scrollablePopup.getActions().size(); ++i) {
            JMenuItem item = (JMenuItem)scrollablePopup.getComponent(i);
            Action action = scrollablePopup.getActions().get(ind++);
            item.setAction(action);
            item.setFont(scrollablePopup.getFont());
            if (!Boolean.TRUE.equals(action.getValue("ScrollablePopup.selected"))) continue;
            scrollablePopup.setSelected(item);
        }
        boolean stopNow = ind == scrollablePopup.getActions().size();
        this.scrollDown.setEnabled(!stopNow);
        return !stopNow;
    }

    protected MenuKeyListener getMenuListener() {
        if (this.menuKeyListener == null) {
            this.menuKeyListener = new MenuKeyListener(){

                @Override
                public void menuKeyPressed(MenuKeyEvent e) {
                    MenuSelectionManager msm = MenuSelectionManager.defaultManager();
                    MenuElement[] path = msm.getSelectedPath();
                    if (path[path.length - 1].equals(BasicScrollablePopupUI.this.scrollDown) && e.getKeyCode() == 40) {
                        BasicScrollablePopupUI.this.popupMenu.setSelected(BasicScrollablePopupUI.this.scrollDown);
                        BasicScrollablePopupUI.this.scrollDown.requestFocus();
                    }
                }

                @Override
                public void menuKeyReleased(MenuKeyEvent e) {
                }

                @Override
                public void menuKeyTyped(MenuKeyEvent e) {
                }
            };
        }
        return this.menuKeyListener;
    }

    public boolean hasScrollers() {
        return this.scrollUp.getParent() == this.popupMenu;
    }

    public JMenuItem getScrollDown() {
        return this.scrollDown;
    }

    public JMenuItem getScrollUp() {
        return this.scrollUp;
    }

    public void addScrollers() {
        if (!this.hasScrollers()) {
            this.popupMenu.add(this.scrollDown);
            this.scrollDown.setEnabled(true);
            this.popupMenu.insert(this.scrollUp, 0);
        }
    }
}

