/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.ehcache;

import griffon.plugins.ehcache.EhcacheProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import net.sf.ehcache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEhcacheProvider
implements EhcacheProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEhcacheProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withEhcache(Closure<R> closure) {
        return this.withEhcache(DEFAULT, closure);
    }

    @Override
    public <R> R withEhcache(String cacheManagerName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)cacheManagerName)) {
            cacheManagerName = DEFAULT;
        }
        if (closure != null) {
            CacheManager cm = this.getCacheManager(cacheManagerName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on cacheManager '" + cacheManagerName + "'");
            }
            return (R)closure.call(new Object[]{cacheManagerName, cm});
        }
        return null;
    }

    @Override
    public <R> R withEhcache(CallableWithArgs<R> callable) {
        return this.withEhcache(DEFAULT, callable);
    }

    @Override
    public <R> R withEhcache(String cacheManagerName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)cacheManagerName)) {
            cacheManagerName = DEFAULT;
        }
        if (callable != null) {
            CacheManager cm = this.getCacheManager(cacheManagerName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on cacheManager '" + cacheManagerName + "'");
            }
            callable.setArgs(new Object[]{cacheManagerName, cm});
            return (R)callable.call();
        }
        return null;
    }

    protected abstract CacheManager getCacheManager(String var1);
}

