/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import griffon.plugins.ehcache.EhcacheAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.EhcacheAwareHandler;
import lombok.core.util.ErrorMessages;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseUtil;
import lombok.eclipse.handlers.ast.EclipseType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class HandleEhcacheAware
extends EclipseAnnotationHandler<EhcacheAware> {
    private final EclipseEhcacheAwareHandler handler = new EclipseEhcacheAwareHandler();

    public void handle(AnnotationValues<EhcacheAware> annotation, Annotation source, EclipseNode annotationNode) {
        EclipseType type = EclipseType.typeOf((EclipseNode)annotationNode, (ASTNode)source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(EhcacheAware.class));
            return;
        }
        EclipseUtil.addInterface((TypeDeclaration)type.get(), (String)"griffon.plugins.ehcache.EhcacheContributionHandler", (Annotation)source);
        this.handler.addEhcacheProviderField(type);
        this.handler.addEhcacheProviderAccessors(type);
        this.handler.addEhcacheContributionMethods(type);
        type.editor().rebuild();
    }

    private static class EclipseEhcacheAwareHandler
    extends EhcacheAwareHandler<EclipseType> {
        private EclipseEhcacheAwareHandler() {
        }
    }
}

