/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import griffon.plugins.ebean.EbeanAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.EbeanAwareHandler;
import lombok.core.util.ErrorMessages;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseUtil;
import lombok.eclipse.handlers.ast.EclipseType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class HandleEbeanAware
extends EclipseAnnotationHandler<EbeanAware> {
    private final EclipseEbeanAwareHandler handler = new EclipseEbeanAwareHandler();

    public void handle(AnnotationValues<EbeanAware> annotation, Annotation source, EclipseNode annotationNode) {
        EclipseType type = EclipseType.typeOf((EclipseNode)annotationNode, (ASTNode)source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(EbeanAware.class));
            return;
        }
        EclipseUtil.addInterface((TypeDeclaration)type.get(), (String)"griffon.plugins.ebean.EbeanContributionHandler", (Annotation)source);
        this.handler.addEbeanProviderField(type);
        this.handler.addEbeanProviderAccessors(type);
        this.handler.addEbeanContributionMethods(type);
        type.editor().rebuild();
    }

    private static class EclipseEbeanAwareHandler
    extends EbeanAwareHandler<EclipseType> {
        private EclipseEbeanAwareHandler() {
        }
    }
}

