/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.ebean;

import com.avaje.ebean.EbeanServer;
import griffon.plugins.ebean.EbeanProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEbeanProvider
implements EbeanProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEbeanProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withEbean(Closure<R> closure) {
        return this.withEbean(DEFAULT, closure);
    }

    @Override
    public <R> R withEbean(String ebeanServerName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)ebeanServerName)) {
            ebeanServerName = DEFAULT;
        }
        if (closure != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on ebeanServer '" + ebeanServerName + "'");
            }
            return (R)closure.call(new Object[]{ebeanServerName, this.getEbeanServer(ebeanServerName)});
        }
        return null;
    }

    @Override
    public <R> R withEbean(CallableWithArgs<R> callable) {
        return this.withEbean(DEFAULT, callable);
    }

    @Override
    public <R> R withEbean(String ebeanServerName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)ebeanServerName)) {
            ebeanServerName = DEFAULT;
        }
        if (callable != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on ebeanServer '" + ebeanServerName + "'");
            }
            callable.setArgs(new Object[]{ebeanServerName, this.getEbeanServer(ebeanServerName)});
            return (R)callable.call();
        }
        return null;
    }

    protected abstract EbeanServer getEbeanServer(String var1);
}

