/*
 * Copyright 2009-2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ package com.canoo.griffon.factory.dockable.action

import bibliothek.gui.dock.common.action.CRadioButton
import bibliothek.gui.dock.common.action.CRadioGroup
import java.lang.ref.SoftReference

/**
 * @author Alexander Klein
 */
class CRadioButtonFactory extends CDecorateableActionFactory {
    WeakHashMap<String, SoftReference<CRadioGroup>> groups = [:] as WeakHashMap

    CRadioButtonFactory() {
        super(CRadioButton)
    }

    @Override
    createInstance(Map attributes) {
        def action = new ClosureCRadioButton()
        def group = attributes.remove('group')
        if (group instanceof String) {
            CRadioGroup radioGroup = groups[group]?.get()
            if (!radioGroup) {
                radioGroup = new CRadioGroup()
                groups[group] = new SoftReference<CRadioGroup>(radioGroup)
            }
            radioGroup.add(action)
        } else if (group instanceof CRadioGroup)
            group.add(action)

        if (attributes.get("closure") instanceof Closure) {
            Closure closure = (Closure) attributes.remove("closure")
            action.setChanged(closure)
        }
        return action
    }
}

class ClosureCRadioButton extends CRadioButton {
    Closure changed

    @Override
    protected void changed() {
        this.changed.call(this)
    }
}

