/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.dialogs;

import ca.odell.glazedlists.swing.EventComboBoxModel;
import griffon.core.GriffonController;
import griffon.plugins.actions.ActionManager;
import griffon.plugins.dialogs.FinderController;
import griffon.plugins.dialogs.FinderModel;
import griffon.plugins.i18n.MessageSourceHolder;
import griffon.util.GriffonNameUtils;
import griffon.util.RunnableWithArgs;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.codehaus.griffon.runtime.core.AbstractGriffonView;

public class FinderView
extends AbstractGriffonView {
    private FinderController controller;
    private FinderModel model;
    private JComponent content;
    private JButton findNextButton;

    public void setController(FinderController controller) {
        this.controller = controller;
    }

    public void setModel(FinderModel model) {
        this.model = model;
    }

    public FinderController getController() {
        return this.controller;
    }

    public FinderModel getModel() {
        return this.model;
    }

    public void mvcGroupInit(Map<String, Object> args) {
        this.execInsideUISync(new Runnable(){

            @Override
            public void run() {
                FinderView.this.getBuilder().setVariable("content", (Object)FinderView.this.buildContent());
            }
        });
    }

    private JComponent buildContent() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.buildFindRow(panel);
        this.buildReplaceRow(panel);
        this.buildOptionsRow(panel);
        this.buildButtonsRow(panel);
        String actionKey = "HideAction";
        panel.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), actionKey);
        panel.getActionMap().put(actionKey, ActionManager.getInstance().actionFor((GriffonController)this.controller, "hide"));
        return panel;
    }

    private void buildFindRow(JPanel container) {
        container.add((Component)new JLabel(this.msg("application.dialog.Finder.find", "Find:")), "right, gapx 5");
        JComboBox findComboBox = new JComboBox(new EventComboBoxModel(this.model.getRecentFinds()));
        findComboBox.setEditable(true);
        ComboBoxUpdater findComboBoxUpdater = new ComboBoxUpdater(findComboBox, new RunnableWithArgs(){

            public void run(Object[] args) {
                FinderView.this.model.setToFind((String)args[0]);
            }
        });
        findComboBox.getEditor().getEditorComponent().addKeyListener(findComboBoxUpdater);
        container.add(findComboBox, "wmin 500, left, grow, push, wrap");
    }

    private void buildReplaceRow(JPanel container) {
        container.add((Component)new JLabel(this.msg("application.dialog.Finder.replace", "Replace:")), "right, gapx 5");
        JComboBox replaceComboBox = new JComboBox(new EventComboBoxModel(this.model.getRecentReplacements()));
        replaceComboBox.setEditable(true);
        ComboBoxUpdater replaceComboBoxComboBoxUpdater = new ComboBoxUpdater(replaceComboBox, new RunnableWithArgs(){

            public void run(Object[] args) {
                FinderView.this.model.setReplaceWith((String)args[0]);
            }
        });
        replaceComboBox.getEditor().getEditorComponent().addKeyListener(replaceComboBoxComboBoxUpdater);
        container.add(replaceComboBox, "wmin 500, left, grow, push, wrap");
    }

    private void buildOptionsRow(JPanel container) {
        JPanel options = new JPanel((LayoutManager)new MigLayout("insets 0"));
        final JLabel output = new JLabel();
        options.add((Component)output, "left, width 120:120:");
        this.model.addPropertyChangeListener("output", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                output.setText(FinderView.this.model.getOutput());
            }
        });
        final JCheckBox regex = new JCheckBox(this.msg("'application.dialog.Finder.regex", "Regular expression"));
        options.add((Component)regex, "right");
        regex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FinderView.this.model.setRegex(regex.isSelected());
            }
        });
        final JCheckBox matchcase = new JCheckBox(this.msg("'application.dialog.Finder.matchcase", "Match case"));
        options.add((Component)matchcase, "right");
        matchcase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FinderView.this.model.setMatchCase(matchcase.isSelected());
            }
        });
        final JCheckBox wholeWord = new JCheckBox(this.msg("'application.dialog.Finder.wholeWord", "Whole word"));
        options.add((Component)wholeWord, "right, gap");
        wholeWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FinderView.this.model.setWholeWord(wholeWord.isSelected());
            }
        });
        container.add((Component)options, "span 2, right, grow, wrap");
    }

    private void buildButtonsRow(JPanel container) {
        final Action findPreviousAction = this.actionFor("findPrevious");
        final Action findNextAction = this.actionFor("findNext");
        final Action replaceAction = this.actionFor("replace");
        final Action replaceAllAction = this.actionFor("replaceAll");
        findPreviousAction.setEnabled(false);
        findNextAction.setEnabled(false);
        replaceAction.setEnabled(false);
        replaceAllAction.setEnabled(false);
        this.model.addPropertyChangeListener("toFind", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                findPreviousAction.setEnabled(!GriffonNameUtils.isBlank((String)FinderView.this.model.getToFind()));
                findNextAction.setEnabled(!GriffonNameUtils.isBlank((String)FinderView.this.model.getToFind()));
            }
        });
        this.model.addPropertyChangeListener("replaceWith", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                replaceAction.setEnabled(!GriffonNameUtils.isBlank((String)FinderView.this.model.getToFind()) && !GriffonNameUtils.isBlank((String)FinderView.this.model.getReplaceWith()));
                replaceAllAction.setEnabled(!GriffonNameUtils.isBlank((String)FinderView.this.model.getToFind()) && !GriffonNameUtils.isBlank((String)FinderView.this.model.getReplaceWith()));
            }
        });
        JPanel buttons = new JPanel((LayoutManager)new MigLayout("insets 0"));
        buttons.add((Component)new JButton(replaceAllAction), "left");
        buttons.add((Component)new JButton(replaceAction), "left, push, gap");
        buttons.add((Component)new JButton(findPreviousAction), "right");
        this.findNextButton = new JButton(findNextAction);
        buttons.add((Component)this.findNextButton, "right");
        container.add((Component)buttons, "span2, grow");
        this.getBuilder().setVariable("findNextButton", (Object)this.findNextButton);
    }

    private Action actionFor(String actionName) {
        return ActionManager.getInstance().actionFor((GriffonController)this.controller, actionName);
    }

    private String msg(String key, String defaultMessage) {
        return MessageSourceHolder.getInstance().getMessageSource().getMessage(key, defaultMessage);
    }

    private String msg(String key, Object[] args, String defaultMessage) {
        return MessageSourceHolder.getInstance().getMessageSource().getMessage(key, args, defaultMessage);
    }

    private class ComboBoxUpdater
    extends KeyAdapter
    implements ItemListener {
        private final JComboBox comboBox;
        private final RunnableWithArgs block;

        public ComboBoxUpdater(JComboBox comboBox, RunnableWithArgs block) {
            this.comboBox = comboBox;
            this.block = block;
            this.comboBox.addItemListener(this);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            this.update(keyEvent);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.update(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.update(keyEvent);
        }

        private void update(KeyEvent keyEvent) {
            String text = ((JTextComponent)this.comboBox.getEditor().getEditorComponent()).getText();
            this.block.run(new Object[]{text});
            FinderView.this.model.setEnterTyped(keyEvent.getKeyCode() == 10);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                String text = (String)itemEvent.getItem();
                this.block.run(new Object[]{text});
                FinderView.this.model.setEnterTyped(false);
            }
        }
    }
}

