/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.dialogs;

import griffon.plugins.dialogs.FinderController;
import griffon.plugins.dialogs.FinderModel;
import griffon.plugins.dialogs.Searcher;
import griffon.util.ApplicationHolder;
import griffon.util.GriffonNameUtils;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.codehaus.griffon.runtime.search.JTextComponentSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Finder {
    private static final String FINDER_GROUP_NAME = "finder";
    private static final Finder INSTANCE;
    private static final Logger LOG;
    private final Map<Class, Class> searcherClassRegistry = new LinkedHashMap<Class, Class>();
    private final Map<Class<? extends Searcher>, Searcher> searcherInstanceCache = new LinkedHashMap<Class<? extends Searcher>, Searcher>();

    public static Finder getInstance() {
        return INSTANCE;
    }

    private Finder() {
        this.registerSearcher(JTextComponent.class, JTextComponentSearcher.class);
        this.loadSearchers();
    }

    public void registerSearcher(Class type, Class searcherClass) {
        if (type != null && searcherClass != null) {
            this.searcherClassRegistry.put(type, searcherClass);
            this.searcherInstanceCache.remove(type);
        }
    }

    public Searcher searcherFor(JComponent subject) {
        if (subject == null) {
            throw new IllegalArgumentException("The component to search over is null!");
        }
        for (Class<?> type = subject.getClass(); type != null; type = type.getSuperclass()) {
            Searcher searcher = this.searcherInstanceCache.get(type);
            if (searcher != null) {
                return searcher;
            }
            if (!this.searcherClassRegistry.containsKey(type)) continue;
            try {
                searcher = (Searcher)this.searcherClassRegistry.get(type).newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            this.searcherInstanceCache.put(type, searcher);
            return searcher;
        }
        throw new IllegalArgumentException("Could not find a suitable " + Searcher.class.getName() + " implementation for " + subject.getClass().getName());
    }

    public void findIt(JComponent subject) {
        this.initialize(subject);
        this.finderController().show();
    }

    public void findPrevious(JComponent subject) {
        this.initialize(subject);
        if (GriffonNameUtils.isBlank((String)this.finderModel().getToFind())) {
            this.finderController().show();
        } else {
            this.finderController().findPrevious();
        }
    }

    public void findNext(JComponent subject) {
        this.initialize(subject);
        if (GriffonNameUtils.isBlank((String)this.finderModel().getToFind())) {
            this.finderController().show();
        } else {
            this.finderController().findNext();
        }
    }

    public void replace(JComponent subject) {
        this.initialize(subject);
        if (GriffonNameUtils.isBlank((String)this.finderModel().getReplaceWith())) {
            this.finderController().show();
        } else {
            this.finderController().replace();
        }
    }

    public void replaceAll(JComponent subject) {
        this.initialize(subject);
        if (GriffonNameUtils.isBlank((String)this.finderModel().getReplaceWith())) {
            this.finderController().show();
        } else {
            this.finderController().replaceAll();
        }
    }

    private void initialize(JComponent subject) {
        if (ApplicationHolder.getApplication().getGroups().get(FINDER_GROUP_NAME) == null) {
            ApplicationHolder.getApplication().createMVCGroup(FINDER_GROUP_NAME);
        }
        this.finderModel().setSubject(subject);
    }

    private FinderController finderController() {
        return (FinderController)((Object)ApplicationHolder.getApplication().getControllers().get(FINDER_GROUP_NAME));
    }

    private FinderModel finderModel() {
        return (FinderModel)((Object)ApplicationHolder.getApplication().getModels().get(FINDER_GROUP_NAME));
    }

    private void loadSearchers() {
        try {
            Enumeration<URL> urls = Finder.class.getClassLoader().getResources("META-INF/services" + Searcher.class.getName());
            ConfigSlurper slurper = new ConfigSlurper();
            while (urls.hasMoreElements()) {
                this.processURL(urls.nextElement(), slurper);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void processURL(URL url, ConfigSlurper slurper) {
        Properties p = new Properties();
        try {
            p.load(url.openStream());
        }
        catch (IOException e) {
            return;
        }
        ConfigObject config = slurper.parse(p);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading Searcher definitions from " + url);
        }
        for (Object key : config.keySet()) {
            String type = key.toString();
            String className = (String)config.get((Object)type);
            try {
                this.registerSearcher(Class.forName(type), Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    static {
        LOG = LoggerFactory.getLogger(Finder.class);
        INSTANCE = new Finder();
    }
}

