/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.dialogs;

import griffon.plugins.dialogs.AbstractDialogModel;
import griffon.swing.SwingGriffonApplication;
import groovy.util.FactoryBuilderSupport;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.codehaus.griffon.runtime.core.AbstractGriffonController;

public class DialogController
extends AbstractGriffonController {
    private AbstractDialogModel model;
    private FactoryBuilderSupport builder;
    protected JDialog dialog;

    public void setModel(AbstractDialogModel model) {
        this.model = model;
    }

    public void setBuilder(FactoryBuilderSupport builder) {
        this.builder = builder;
    }

    public AbstractDialogModel getModel() {
        return this.model;
    }

    public FactoryBuilderSupport getBuilder() {
        return this.builder;
    }

    public void show() {
        this.show((Window)null);
    }

    public void show(ActionEvent event) {
        this.show((Window)null);
    }

    public void show(final Window owner) {
        this.execInsideUIAsync(new Runnable(){

            @Override
            public void run() {
                boolean created = false;
                Window window = owner;
                if (window == null) {
                    List windows = ((SwingGriffonApplication)DialogController.this.getApp()).getWindowManager().getWindows();
                    for (Window w : windows) {
                        if (!w.isFocused()) continue;
                        window = w;
                        break;
                    }
                }
                if (DialogController.this.dialog == null || DialogController.this.dialog.getOwner() != window) {
                    DialogController.this.dialog = DialogController.this.createDialog(window);
                    created = true;
                }
                if (created || DialogController.this.model.isCenter() && window != null) {
                    DialogController.this.placeDialog(window, DialogController.this.dialog);
                }
                DialogController.this.displayDialog(DialogController.this.dialog);
            }
        });
    }

    public void hide() {
        this.hide(null);
    }

    public void hide(ActionEvent event) {
        this.execInsideUIAsync(new Runnable(){

            @Override
            public void run() {
                if (DialogController.this.dialog != null) {
                    DialogController.this.dialog.setVisible(false);
                    DialogController.this.dialog.dispose();
                }
                DialogController.this.dialog = null;
            }
        });
    }

    protected JDialog createDialog(Window window) {
        JDialog dialog = new JDialog(window, this.model.getTitle());
        dialog.setResizable(this.model.isResizable());
        dialog.setModal(this.model.isModal());
        dialog.getContentPane().add((JComponent)this.builder.getVariable("content"));
        if (this.model.getWidth() > 0 && this.model.getHeight() > 0) {
            dialog.setPreferredSize(new Dimension(this.model.getWidth(), this.model.getHeight()));
        }
        dialog.pack();
        return dialog;
    }

    protected void placeDialog(Window window, JDialog dialog) {
        int x = window.getX() + (window.getWidth() - dialog.getWidth()) / 2;
        int y = window.getY() + (window.getHeight() - dialog.getHeight()) / 2;
        dialog.setLocation(x, y);
    }

    protected void displayDialog(JDialog dialog) {
        dialog.setVisible(true);
    }
}

