/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.search;

import griffon.plugins.dialogs.Searcher;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.codehaus.griffon.runtime.search.RegExReplaceInfo;

public class JTextComponentSearcher
implements Searcher {
    @Override
    public boolean find(JComponent subject, String text, boolean forward, boolean matchCase, boolean wholeWord, boolean regex) throws PatternSyntaxException {
        JTextComponent component = (JTextComponent)subject;
        Caret c = component.getCaret();
        int start = forward ? Math.max(c.getDot(), c.getMark()) : Math.min(c.getDot(), c.getMark());
        String findIn = this.getFindInText(component, start, forward);
        if (findIn == null || findIn.length() == 0) {
            return false;
        }
        if (!regex) {
            int pos = this.getNextMatchPos(text, findIn, forward, matchCase, wholeWord);
            findIn = null;
            if (pos != -1) {
                c.setSelectionVisible(true);
                pos = forward ? start + pos : pos;
                this.selectAndPossiblyCenter(component, pos, pos + text.length());
                return true;
            }
        } else {
            Point regExPos = this.getNextMatchPosRegEx(text, findIn, forward, matchCase, wholeWord);
            findIn = null;
            if (regExPos != null) {
                c.setSelectionVisible(true);
                if (forward) {
                    regExPos.translate(start, start);
                }
                this.selectAndPossiblyCenter(component, regExPos.x, regExPos.y);
                return true;
            }
        }
        return false;
    }

    protected String getFindInText(JTextComponent component, int start, boolean forward) {
        String findIn = null;
        if (forward) {
            try {
                findIn = component.getText(start, component.getDocument().getLength() - start);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        } else {
            try {
                findIn = component.getText(0, start);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        return findIn;
    }

    protected List getMatches(Matcher m, String replaceStr) {
        ArrayList<Object> matches = new ArrayList<Object>();
        while (m.find()) {
            Point loc = new Point(m.start(), m.end());
            if (replaceStr == null) {
                matches.add(loc);
                continue;
            }
            matches.add(new RegExReplaceInfo(m.group(0), loc.x, loc.y, this.getReplacementText(m, replaceStr)));
        }
        return matches;
    }

    public final int getNextMatchPos(String searchFor, String searchIn, boolean forward, boolean matchCase, boolean wholeWord) {
        if (!matchCase) {
            return this.getNextMatchPosImpl(searchFor.toLowerCase(), searchIn.toLowerCase(), forward, matchCase, wholeWord);
        }
        return this.getNextMatchPosImpl(searchFor, searchIn, forward, matchCase, wholeWord);
    }

    protected final int getNextMatchPosImpl(String searchFor, String searchIn, boolean goForward, boolean matchCase, boolean wholeWord) {
        if (wholeWord) {
            int len = searchFor.length();
            int temp = goForward ? 0 : searchIn.length();
            int tempChange = goForward ? 1 : -1;
            while ((temp = goForward ? searchIn.indexOf(searchFor, temp) : searchIn.lastIndexOf(searchFor, temp)) != -1) {
                if (this.isWholeWord(searchIn, temp, len)) {
                    return temp;
                }
                temp += tempChange;
            }
            return temp;
        }
        return goForward ? searchIn.indexOf(searchFor) : searchIn.lastIndexOf(searchFor);
    }

    public Point getNextMatchPosRegEx(String regEx, CharSequence searchIn, boolean goForward, boolean matchCase, boolean wholeWord) {
        return (Point)this.getNextMatchPosRegExImpl(regEx, searchIn, goForward, matchCase, wholeWord, null);
    }

    protected Object getNextMatchPosRegExImpl(String regEx, CharSequence searchIn, boolean goForward, boolean matchCase, boolean wholeWord, String replaceStr) {
        int flags = 8;
        Pattern pattern = Pattern.compile(regEx, flags |= matchCase ? 0 : 66);
        Matcher m = pattern.matcher(searchIn);
        if (goForward) {
            if (!wholeWord) {
                if (m.find()) {
                    if (replaceStr == null) {
                        return new Point(m.start(), m.end());
                    }
                    return new RegExReplaceInfo(m.group(0), m.start(), m.end(), this.getReplacementText(m, replaceStr));
                }
            } else {
                while (m.find()) {
                    Point loc = new Point(m.start(), m.end());
                    if (!this.isWholeWord(searchIn, loc.x, loc.y - loc.x)) continue;
                    if (replaceStr == null) {
                        return loc;
                    }
                    return new RegExReplaceInfo(m.group(0), loc.x, loc.y, this.getReplacementText(m, replaceStr));
                }
            }
        } else {
            int pos;
            List matches = this.getMatches(m, replaceStr);
            if (matches.isEmpty()) {
                return null;
            }
            if (!wholeWord) {
                if (replaceStr == null) {
                    return matches.get(pos);
                }
                return matches.get(pos);
            }
            for (pos = matches.size() - 1; pos >= 0; --pos) {
                int y;
                Object matchObj = matches.get(pos);
                if (replaceStr == null) {
                    Point loc = (Point)matchObj;
                    if (!this.isWholeWord(searchIn, loc.x, loc.y - loc.x)) continue;
                    return matchObj;
                }
                RegExReplaceInfo info = (RegExReplaceInfo)matchObj;
                int x = info.getStartIndex();
                if (!this.isWholeWord(searchIn, x, (y = info.getEndIndex()) - x)) continue;
                return matchObj;
            }
        }
        return null;
    }

    protected RegExReplaceInfo getRegExReplaceInfo(String regEx, String searchIn, boolean goForward, boolean matchCase, boolean wholeWord, String replacement) {
        if (replacement == null) {
            replacement = "";
        }
        return (RegExReplaceInfo)this.getNextMatchPosRegExImpl(regEx, searchIn, goForward, matchCase, wholeWord, replacement);
    }

    public String getReplacementText(Matcher m, CharSequence template) {
        int cursor = 0;
        StringBuffer result = new StringBuffer();
        while (cursor < template.length()) {
            char nextChar = template.charAt(cursor);
            if (nextChar == '\\') {
                nextChar = template.charAt(++cursor);
                switch (nextChar) {
                    case 'n': {
                        nextChar = '\n';
                        break;
                    }
                    case 't': {
                        nextChar = '\t';
                    }
                }
                result.append(nextChar);
                ++cursor;
                continue;
            }
            if (nextChar == '$') {
                int nextDigit;
                int refNum;
                if ((refNum = template.charAt(++cursor) - 48) < 0 || refNum > 9) {
                    throw new IndexOutOfBoundsException("No group " + template.charAt(cursor));
                }
                ++cursor;
                boolean done = false;
                while (!done && cursor < template.length() && (nextDigit = template.charAt(cursor) - 48) >= 0 && nextDigit <= 9) {
                    int newRefNum = refNum * 10 + nextDigit;
                    if (m.groupCount() < newRefNum) {
                        done = true;
                        continue;
                    }
                    refNum = newRefNum;
                    ++cursor;
                }
                if (m.group(refNum) == null) continue;
                result.append(m.group(refNum));
                continue;
            }
            result.append(nextChar);
            ++cursor;
        }
        return result.toString();
    }

    private final boolean isWholeWord(CharSequence searchIn, int offset, int len) {
        boolean wsAfter;
        boolean wsBefore;
        try {
            wsBefore = !Character.isLetterOrDigit(searchIn.charAt(offset - 1));
        }
        catch (IndexOutOfBoundsException e) {
            wsBefore = true;
        }
        try {
            wsAfter = !Character.isLetterOrDigit(searchIn.charAt(offset + len));
        }
        catch (IndexOutOfBoundsException e) {
            wsAfter = true;
        }
        return wsBefore && wsAfter;
    }

    protected int makeMarkAndDotEqual(JTextComponent component, boolean forward) {
        Caret c = component.getCaret();
        int val = forward ? Math.min(c.getDot(), c.getMark()) : Math.max(c.getDot(), c.getMark());
        c.setDot(val);
        return val;
    }

    protected boolean regexReplace(JComponent subject, String toFind, String replaceWith, boolean forward, boolean matchCase, boolean wholeWord) throws PatternSyntaxException {
        JTextComponent component = (JTextComponent)subject;
        Caret c = component.getCaret();
        int start = this.makeMarkAndDotEqual(component, forward);
        String findIn = this.getFindInText(component, start, forward);
        if (findIn == null) {
            return false;
        }
        RegExReplaceInfo info = this.getRegExReplaceInfo(toFind, findIn, forward, matchCase, wholeWord, replaceWith);
        findIn = null;
        if (info != null) {
            c.setSelectionVisible(true);
            int matchStart = info.getStartIndex();
            int matchEnd = info.getEndIndex();
            if (forward) {
                matchStart += start;
                matchEnd += start;
            }
            this.selectAndPossiblyCenter(component, matchStart, matchEnd);
            component.replaceSelection(info.getReplacement());
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(JComponent subject, String toFind, String replaceWith, boolean forward, boolean matchCase, boolean wholeWord, boolean regex) throws PatternSyntaxException {
        JTextComponent component = (JTextComponent)subject;
        if (regex) {
            return this.regexReplace(component, toFind, replaceWith, forward, matchCase, wholeWord);
        }
        this.makeMarkAndDotEqual(component, forward);
        if (this.find(component, toFind, forward, matchCase, wholeWord, false)) {
            component.replaceSelection(replaceWith);
            return true;
        }
        return false;
    }

    @Override
    public int replaceAll(JComponent subject, String toFind, String replaceWith, boolean matchCase, boolean wholeWord, boolean regex) throws PatternSyntaxException {
        JTextComponent component = (JTextComponent)subject;
        int count = 0;
        if (regex) {
            if (replaceWith == null) {
                replaceWith = "";
            }
            int oldOffs = component.getCaretPosition();
            component.setCaretPosition(0);
            int flags = 8;
            Pattern p = Pattern.compile(toFind, flags |= matchCase ? 0 : 66);
            while (this.find(component, toFind, true, matchCase, wholeWord, true)) {
                Matcher m = p.matcher(component.getSelectedText());
                String replacement = this.getReplacementText(m, replaceWith);
                component.replaceSelection(replacement);
                ++count;
            }
            if (count == 0) {
                component.setCaretPosition(oldOffs);
            }
        } else {
            component.setCaretPosition(0);
            while (this.find(component, toFind, true, matchCase, wholeWord, false)) {
                component.replaceSelection(replaceWith);
                ++count;
            }
        }
        return count;
    }

    private void selectAndPossiblyCenter(JTextComponent component, int start, int end) {
        component.setSelectionStart(start);
        component.setSelectionEnd(end);
        Rectangle r = null;
        try {
            r = component.modelToView(start);
            if (r == null) {
                return;
            }
            if (end != start) {
                r = r.union(component.modelToView(end));
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            component.setSelectionStart(start);
            component.setSelectionEnd(end);
            return;
        }
        Rectangle visible = component.getVisibleRect();
        if (visible.contains(r)) {
            component.setSelectionStart(start);
            component.setSelectionEnd(end);
            return;
        }
        visible.x = r.x - (visible.width - r.width) / 2;
        visible.y = r.y - (visible.height - r.height) / 2;
        Rectangle bounds = component.getBounds();
        Insets i = component.getInsets();
        bounds.x = i.left;
        bounds.y = i.top;
        bounds.width -= i.left + i.right;
        bounds.height -= i.top + i.bottom;
        if (visible.x < bounds.x) {
            visible.x = bounds.x;
        }
        if (visible.x + visible.width > bounds.x + bounds.width) {
            visible.x = bounds.x + bounds.width - visible.width;
        }
        if (visible.y < bounds.y) {
            visible.y = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            visible.y = bounds.y + bounds.height - visible.height;
        }
        component.scrollRectToVisible(visible);
    }
}

