/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.dialogs;

import griffon.plugins.dialogs.DialogController;
import griffon.plugins.dialogs.Finder;
import griffon.plugins.dialogs.FinderModel;
import griffon.plugins.dialogs.Searcher;
import griffon.plugins.i18n.MessageSourceHolder;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JDialog;

public class FinderController
extends DialogController {
    private static final String KEY_NOT_FOUND = ".notfound";
    private static final String KEY_NOTHING = ".nothing";
    private static final String KEY_MATCHES = ".matches";
    private static final String MSG_NOT_FOUND = "Not found";
    private static final String MSG_NOTHING = "Nothing";
    private static final String MSG_REPLACED = " replaced";

    public void findPrevious() {
        this.findPrevious(null);
    }

    public void findPrevious(ActionEvent event) {
        this.model().setOutput("");
        this.model().updateRecentFinds();
        Searcher searcher = Finder.getInstance().searcherFor(this.model().getSubject());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("FindPrevious toFind: " + this.model().getToFind() + ", matchCase: " + this.model().isMatchCase() + ", wholeWord: " + this.model().isWholeWord() + ", regex: " + this.model().isRegex());
        }
        boolean found = searcher.find(this.model().getSubject(), this.model().getToFind(), false, this.model().isMatchCase(), this.model().isWholeWord(), this.model().isRegex());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Found " + found);
        }
        if (!found) {
            this.model().setOutput(this.msg(Finder.class.getName() + KEY_NOT_FOUND, MSG_NOT_FOUND));
        }
    }

    public void findNext() {
        this.findNext(null);
    }

    public void findNext(ActionEvent event) {
        this.model().setOutput("");
        this.model().updateRecentFinds();
        Searcher searcher = Finder.getInstance().searcherFor(this.model().getSubject());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("FindNext toFind: " + this.model().getToFind() + ", matchCase: " + this.model().isMatchCase() + ", wholeWord: " + this.model().isWholeWord() + ", regex: " + this.model().isRegex());
        }
        boolean found = searcher.find(this.model().getSubject(), this.model().getToFind(), true, this.model().isMatchCase(), this.model().isWholeWord(), this.model().isRegex());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Found " + found);
        }
        if (!found) {
            this.model().setOutput(this.msg(Finder.class.getName() + KEY_NOT_FOUND, MSG_NOT_FOUND));
        } else if (this.model().isEnterTyped()) {
            this.hide();
        }
    }

    public void replace() {
        this.replace(null);
    }

    public void replace(ActionEvent event) {
        this.model().setOutput("");
        this.model().updateRecentFinds();
        this.model().updateRecentReplacements();
        Searcher searcher = Finder.getInstance().searcherFor(this.model().getSubject());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Replace toFind: " + this.model().getToFind() + ", replaceWith: " + this.model().getReplaceWith() + ", matchCase: " + this.model().isMatchCase() + ", wholeWord: " + this.model().isWholeWord() + ", regex: " + this.model().isRegex());
        }
        boolean replaced = searcher.replace(this.model().getSubject(), this.model().getToFind(), this.model().getReplaceWith(), true, this.model().isMatchCase(), this.model().isWholeWord(), this.model().isRegex());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Replace " + replaced);
        }
        if (!replaced) {
            this.model().setOutput(this.msg(Finder.class.getName() + KEY_NOT_FOUND, MSG_NOT_FOUND));
        }
    }

    public void replaceAll() {
        this.replaceAll(null);
    }

    public void replaceAll(ActionEvent event) {
        this.model().setOutput("");
        this.model().updateRecentFinds();
        this.model().updateRecentReplacements();
        Searcher searcher = Finder.getInstance().searcherFor(this.model().getSubject());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("ReplaceAll toFind: " + this.model().getToFind() + ", replaceWith: " + this.model().getReplaceWith() + ", matchCase: " + this.model().isMatchCase() + ", wholeWord: " + this.model().isWholeWord() + ", regex: " + this.model().isRegex());
        }
        int matches = searcher.replaceAll(this.model().getSubject(), this.model().getToFind(), this.model().getReplaceWith(), this.model().isMatchCase(), this.model().isWholeWord(), this.model().isRegex());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("ReplaceAll " + matches + " matches");
        }
        if (matches == 0) {
            this.model().setOutput(this.msg(Finder.class.getName() + KEY_NOTHING, MSG_NOTHING));
        } else {
            this.model().setOutput(this.msg(Finder.class.getName() + KEY_MATCHES, new Object[]{matches}, matches + MSG_REPLACED));
        }
    }

    @Override
    protected JDialog createDialog(Window window) {
        JDialog dialog = super.createDialog(window);
        dialog.setName("finder");
        JButton findNextButton = (JButton)this.getBuilder().getVariable("findNextButton");
        dialog.getRootPane().setDefaultButton(findNextButton);
        return dialog;
    }

    @Override
    protected void displayDialog(JDialog dialog) {
        JButton findNextButton = (JButton)this.getBuilder().getVariable("findNextButton");
        findNextButton.getModel().setArmed(true);
        super.displayDialog(dialog);
    }

    private FinderModel model() {
        return (FinderModel)this.getModel();
    }

    private String msg(String key, String defaultMessage) {
        return MessageSourceHolder.getInstance().getMessageSource().getMessage(key, defaultMessage);
    }

    private String msg(String key, Object[] args, String defaultMessage) {
        return MessageSourceHolder.getInstance().getMessageSource().getMessage(key, args, defaultMessage);
    }
}

