/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.dialogs;

import griffon.javafx.JavaFXApplication;
import griffon.javafx.WindowManager;
import griffon.plugins.dialogs.AbstractDialogModel;
import groovy.util.FactoryBuilderSupport;
import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.codehaus.griffon.runtime.core.AbstractGriffonController;

public abstract class AbstractDialogController
extends AbstractGriffonController {
    private AbstractDialogModel model;
    private FactoryBuilderSupport builder;
    private static final String CONTENT = "content";
    protected Stage dialog;

    public void setModel(AbstractDialogModel model) {
        this.model = model;
    }

    public void setBuilder(FactoryBuilderSupport builder) {
        this.builder = builder;
    }

    public AbstractDialogModel getModel() {
        return this.model;
    }

    public FactoryBuilderSupport getBuilder() {
        return this.builder;
    }

    public void show() {
        this.show(null);
    }

    public void show(final Window owner) {
        this.execInsideUISync(new Runnable(){

            @Override
            public void run() {
                Window window = owner;
                if (window == null) {
                    Collection windows = AbstractDialogController.this.windowManager().getWindows();
                    for (Window w : windows) {
                        if (!w.isFocused()) continue;
                        window = w;
                        break;
                    }
                }
                if (AbstractDialogController.this.dialog == null || AbstractDialogController.this.dialog.getOwner() != window) {
                    if (AbstractDialogController.this.dialog != null) {
                        AbstractDialogController.this.windowManager().hide((Window)AbstractDialogController.this.dialog);
                    }
                    AbstractDialogController.this.dialog = AbstractDialogController.this.createDialog(window);
                }
                AbstractDialogController.this.windowManager().show((Window)AbstractDialogController.this.dialog);
            }
        });
    }

    private WindowManager windowManager() {
        return ((JavaFXApplication)this.getApp()).getWindowManager();
    }

    public void hide() {
        this.execInsideUISync(new Runnable(){

            @Override
            public void run() {
                AbstractDialogController.this.windowManager().hide((Window)AbstractDialogController.this.dialog);
                AbstractDialogController.this.dialog = null;
            }
        });
    }

    protected Stage createDialog(Window owner) {
        this.dialog = new Stage();
        if (null != owner) {
            this.dialog.initOwner(owner);
        }
        this.dialog.initModality(this.model.getModality());
        this.dialog.initStyle(this.model.getStageStyle());
        this.dialog.setWidth(this.model.getWidth());
        this.dialog.setHeight(this.model.getHeight());
        this.dialog.titleProperty().bind((ObservableValue)this.model.titleProperty());
        this.dialog.resizableProperty().bind((ObservableValue)this.model.resizableProperty());
        this.dialog.setScene((Scene)this.builder.getVariable(CONTENT));
        this.dialog.sizeToScene();
        return this.dialog;
    }
}

