/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.db4o;

import com.db4o.ObjectContainer;
import griffon.plugins.db4o.Db4oProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDb4oProvider
implements Db4oProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDb4oProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withDb4o(Closure<R> closure) {
        return this.withDb4o(DEFAULT, closure);
    }

    @Override
    public <R> R withDb4o(String dataSourceName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)dataSourceName)) {
            dataSourceName = DEFAULT;
        }
        if (closure != null) {
            ObjectContainer container = this.getObjectContainer(dataSourceName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on dataSourceName '" + dataSourceName + "'");
            }
            return (R)closure.call(new Object[]{dataSourceName, container});
        }
        return null;
    }

    @Override
    public <R> R withDb4o(CallableWithArgs<R> callable) {
        return this.withDb4o(DEFAULT, callable);
    }

    @Override
    public <R> R withDb4o(String dataSourceName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)dataSourceName)) {
            dataSourceName = DEFAULT;
        }
        if (callable != null) {
            ObjectContainer container = this.getObjectContainer(dataSourceName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on dataSourceName '" + dataSourceName + "'");
            }
            callable.setArgs(new Object[]{dataSourceName, container});
            return (R)callable.call();
        }
        return null;
    }

    protected abstract ObjectContainer getObjectContainer(String var1);
}

