/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import griffon.plugins.datasource.DataSourceAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.DataSourceAwareHandler;
import lombok.core.util.ErrorMessages;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseUtil;
import lombok.eclipse.handlers.ast.EclipseType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class HandleDataSourceAware
extends EclipseAnnotationHandler<DataSourceAware> {
    private final EclipseDataSourceAwareHandler handler = new EclipseDataSourceAwareHandler();

    public void handle(AnnotationValues<DataSourceAware> annotation, Annotation source, EclipseNode annotationNode) {
        EclipseType type = EclipseType.typeOf((EclipseNode)annotationNode, (ASTNode)source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(DataSourceAware.class));
            return;
        }
        EclipseUtil.addInterface((TypeDeclaration)type.get(), (String)"griffon.plugins.datasource.DataSourceContributionHandler", (Annotation)source);
        this.handler.addDataSourceProviderField(type);
        this.handler.addDataSourceProviderAccessors(type);
        this.handler.addDataSourceContributionMethods(type);
        type.editor().rebuild();
    }

    private static class EclipseDataSourceAwareHandler
    extends DataSourceAwareHandler<EclipseType> {
        private EclipseDataSourceAwareHandler() {
        }
    }
}

