/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.datasource;

import griffon.exceptions.GriffonException;
import griffon.plugins.datasource.DataSourceProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import groovy.sql.Sql;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSourceProvider
implements DataSourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataSourceProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withSql(Closure<R> closure) {
        return this.withSql(DEFAULT, closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withSql(String dataSourceName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)dataSourceName)) {
            dataSourceName = DEFAULT;
        }
        if (closure != null) {
            DataSource ds = this.getDataSource(dataSourceName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on dataSource '" + dataSourceName + "'");
            }
            Connection connection = null;
            try {
                connection = ds.getConnection();
            }
            catch (SQLException e) {
                throw new GriffonException((Throwable)e);
            }
            try {
                Object object = closure.call(new Object[]{dataSourceName, new Sql(connection)});
                return (R)object;
            }
            finally {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new GriffonException((Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public <R> R withSql(CallableWithArgs<R> callable) {
        return this.withSql(DEFAULT, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withSql(String dataSourceName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)dataSourceName)) {
            dataSourceName = DEFAULT;
        }
        if (callable != null) {
            DataSource ds = this.getDataSource(dataSourceName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on dataSource '" + dataSourceName + "'");
            }
            Connection connection = null;
            try {
                connection = ds.getConnection();
            }
            catch (SQLException e) {
                throw new GriffonException((Throwable)e);
            }
            try {
                callable.setArgs(new Object[]{dataSourceName, new Sql(connection)});
                Object object = callable.call();
                return (R)object;
            }
            finally {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new GriffonException((Throwable)e);
                }
            }
        }
        return null;
    }

    protected abstract DataSource getDataSource(String var1);
}

