/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.misc;

import java.util.NoSuchElementException;
import org.antlr.runtime.misc.FastQueue;

public abstract class LookaheadStream<T>
extends FastQueue<T> {
    public static final int UNINITIALIZED_EOF_ELEMENT_INDEX = Integer.MAX_VALUE;
    protected int currentElementIndex = 0;
    protected T prevElement;
    public T eof = null;
    protected int lastMarker;
    protected int markDepth = 0;

    @Override
    public void reset() {
        super.reset();
        this.currentElementIndex = 0;
        this.p = 0;
        this.prevElement = null;
    }

    public abstract T nextElement();

    public abstract boolean isEOF(T var1);

    @Override
    public T remove() {
        Object t = this.elementAt(0);
        ++this.p;
        if (this.p == this.data.size() && this.markDepth == 0) {
            this.clear();
        }
        return t;
    }

    public void consume() {
        this.syncAhead(1);
        this.prevElement = this.remove();
        ++this.currentElementIndex;
    }

    protected void syncAhead(int n) {
        int n2 = this.p + n - 1 - this.data.size() + 1;
        if (n2 > 0) {
            this.fill(n2);
        }
    }

    public void fill(int n) {
        for (int i = 1; i <= n; ++i) {
            T t = this.nextElement();
            if (this.isEOF(t)) {
                this.eof = t;
            }
            this.data.add(t);
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("streams are of unknown size");
    }

    public T LT(int n) {
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            return this.LB(-n);
        }
        this.syncAhead(n);
        if (this.p + n - 1 > this.data.size()) {
            return this.eof;
        }
        return this.elementAt(n - 1);
    }

    public int index() {
        return this.currentElementIndex;
    }

    public int mark() {
        ++this.markDepth;
        this.lastMarker = this.p;
        return this.lastMarker;
    }

    public void release(int n) {
    }

    public void rewind(int n) {
        --this.markDepth;
        this.seek(n);
    }

    public void rewind() {
        this.seek(this.lastMarker);
    }

    public void seek(int n) {
        this.p = n;
    }

    protected T LB(int n) {
        if (n == 1) {
            return this.prevElement;
        }
        throw new NoSuchElementException("can't look backwards more than one token in this stream");
    }
}

