/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;

public class DebugTokenStream
implements TokenStream {
    protected DebugEventListener dbg;
    public TokenStream input;
    protected boolean initialStreamState = true;
    protected int lastMarker;

    public DebugTokenStream(TokenStream tokenStream, DebugEventListener debugEventListener) {
        this.input = tokenStream;
        this.setDebugListener(debugEventListener);
        tokenStream.LT(1);
    }

    public void setDebugListener(DebugEventListener debugEventListener) {
        this.dbg = debugEventListener;
    }

    @Override
    public void consume() {
        if (this.initialStreamState) {
            this.consumeInitialHiddenTokens();
        }
        int n = this.input.index();
        Token token = this.input.LT(1);
        this.input.consume();
        int n2 = this.input.index();
        this.dbg.consumeToken(token);
        if (n2 > n + 1) {
            for (int i = n + 1; i < n2; ++i) {
                this.dbg.consumeHiddenToken(this.input.get(i));
            }
        }
    }

    protected void consumeInitialHiddenTokens() {
        int n = this.input.index();
        for (int i = 0; i < n; ++i) {
            this.dbg.consumeHiddenToken(this.input.get(i));
        }
        this.initialStreamState = false;
    }

    @Override
    public Token LT(int n) {
        if (this.initialStreamState) {
            this.consumeInitialHiddenTokens();
        }
        this.dbg.LT(n, this.input.LT(n));
        return this.input.LT(n);
    }

    @Override
    public int LA(int n) {
        if (this.initialStreamState) {
            this.consumeInitialHiddenTokens();
        }
        this.dbg.LT(n, this.input.LT(n));
        return this.input.LA(n);
    }

    @Override
    public Token get(int n) {
        return this.input.get(n);
    }

    @Override
    public int mark() {
        this.lastMarker = this.input.mark();
        this.dbg.mark(this.lastMarker);
        return this.lastMarker;
    }

    @Override
    public int index() {
        return this.input.index();
    }

    @Override
    public int range() {
        return this.input.range();
    }

    @Override
    public void rewind(int n) {
        this.dbg.rewind(n);
        this.input.rewind(n);
    }

    @Override
    public void rewind() {
        this.dbg.rewind();
        this.input.rewind(this.lastMarker);
    }

    @Override
    public void release(int n) {
    }

    @Override
    public void seek(int n) {
        this.input.seek(n);
    }

    @Override
    public int size() {
        return this.input.size();
    }

    @Override
    public TokenSource getTokenSource() {
        return this.input.getTokenSource();
    }

    @Override
    public String getSourceName() {
        return this.getTokenSource().getSourceName();
    }

    public String toString() {
        return this.input.toString();
    }

    @Override
    public String toString(int n, int n2) {
        return this.input.toString(n, n2);
    }

    @Override
    public String toString(Token token, Token token2) {
        return this.input.toString(token, token2);
    }
}

