/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class BufferedTokenStream
implements TokenStream {
    protected TokenSource tokenSource;
    protected List<Token> tokens = new ArrayList<Token>(100);
    protected int lastMarker;
    protected int p = -1;
    protected int range = -1;

    public BufferedTokenStream() {
    }

    public BufferedTokenStream(TokenSource tokenSource) {
        this.tokenSource = tokenSource;
    }

    @Override
    public TokenSource getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public int index() {
        return this.p;
    }

    @Override
    public int range() {
        return this.range;
    }

    @Override
    public int mark() {
        if (this.p == -1) {
            this.setup();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    @Override
    public void release(int n) {
    }

    @Override
    public void rewind(int n) {
        this.seek(n);
    }

    @Override
    public void rewind() {
        this.seek(this.lastMarker);
    }

    public void reset() {
        this.p = 0;
        this.lastMarker = 0;
    }

    @Override
    public void seek(int n) {
        this.p = n;
    }

    @Override
    public int size() {
        return this.tokens.size();
    }

    @Override
    public void consume() {
        if (this.p == -1) {
            this.setup();
        }
        ++this.p;
        this.sync(this.p);
    }

    protected void sync(int n) {
        int n2 = n - this.tokens.size() + 1;
        if (n2 > 0) {
            this.fetch(n2);
        }
    }

    protected void fetch(int n) {
        for (int i = 1; i <= n; ++i) {
            Token token = this.tokenSource.nextToken();
            token.setTokenIndex(this.tokens.size());
            this.tokens.add(token);
            if (token.getType() == -1) break;
        }
    }

    @Override
    public Token get(int n) {
        if (n < 0 || n >= this.tokens.size()) {
            throw new NoSuchElementException("token index " + n + " out of range 0.." + (this.tokens.size() - 1));
        }
        return this.tokens.get(n);
    }

    public List get(int n, int n2) {
        Token token;
        if (n < 0 || n2 < 0) {
            return null;
        }
        if (this.p == -1) {
            this.setup();
        }
        ArrayList<Token> arrayList = new ArrayList<Token>();
        if (n2 >= this.tokens.size()) {
            n2 = this.tokens.size() - 1;
        }
        for (int i = n; i <= n2 && (token = this.tokens.get(i)).getType() != -1; ++i) {
            arrayList.add(token);
        }
        return arrayList;
    }

    @Override
    public int LA(int n) {
        return this.LT(n).getType();
    }

    protected Token LB(int n) {
        if (this.p - n < 0) {
            return null;
        }
        return this.tokens.get(this.p - n);
    }

    @Override
    public Token LT(int n) {
        if (this.p == -1) {
            this.setup();
        }
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            return this.LB(-n);
        }
        int n2 = this.p + n - 1;
        this.sync(n2);
        if (n2 >= this.tokens.size()) {
            return this.tokens.get(this.tokens.size() - 1);
        }
        if (n2 > this.range) {
            this.range = n2;
        }
        return this.tokens.get(n2);
    }

    protected void setup() {
        this.sync(0);
        this.p = 0;
    }

    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = tokenSource;
        this.tokens.clear();
        this.p = -1;
    }

    public List getTokens() {
        return this.tokens;
    }

    public List getTokens(int n, int n2) {
        return this.getTokens(n, n2, (BitSet)null);
    }

    public List getTokens(int n, int n2, BitSet bitSet) {
        if (this.p == -1) {
            this.setup();
        }
        if (n2 >= this.tokens.size()) {
            n2 = this.tokens.size() - 1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > n2) {
            return null;
        }
        ArrayList<Token> arrayList = new ArrayList<Token>();
        for (int i = n; i <= n2; ++i) {
            Token token = this.tokens.get(i);
            if (bitSet != null && !bitSet.member(token.getType())) continue;
            arrayList.add(token);
        }
        if (arrayList.size() == 0) {
            arrayList = null;
        }
        return arrayList;
    }

    public List getTokens(int n, int n2, List list) {
        return this.getTokens(n, n2, new BitSet(list));
    }

    public List getTokens(int n, int n2, int n3) {
        return this.getTokens(n, n2, BitSet.of(n3));
    }

    @Override
    public String getSourceName() {
        return this.tokenSource.getSourceName();
    }

    public String toString() {
        if (this.p == -1) {
            this.setup();
        }
        this.fill();
        return this.toString(0, this.tokens.size() - 1);
    }

    @Override
    public String toString(int n, int n2) {
        Token token;
        if (n < 0 || n2 < 0) {
            return null;
        }
        if (this.p == -1) {
            this.setup();
        }
        if (n2 >= this.tokens.size()) {
            n2 = this.tokens.size() - 1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i <= n2 && (token = this.tokens.get(i)).getType() != -1; ++i) {
            stringBuffer.append(token.getText());
        }
        return stringBuffer.toString();
    }

    @Override
    public String toString(Token token, Token token2) {
        if (token != null && token2 != null) {
            return this.toString(token.getTokenIndex(), token2.getTokenIndex());
        }
        return null;
    }

    public void fill() {
        if (this.p == -1) {
            this.setup();
        }
        if (this.tokens.get(this.p).getType() == -1) {
            return;
        }
        int n = this.p + 1;
        this.sync(n);
        while (this.tokens.get(n).getType() != -1) {
            this.sync(++n);
        }
    }
}

